/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.owner;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.owner.ElementOwnerImpl;
import com.intellij.database.schemaEditor.owner.Id;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementMatcherImpl
implements ElementMatcher {
    @Nullable
    private final ElementOwnerImpl myOriginalOwner;
    private final ChildProvider myChildProvider;
    private final AtomicInteger myCounter = new AtomicInteger();
    private final Set<ElementOwnerImpl> myOwners = Collections.synchronizedSet(ContainerUtil.createWeakSet());
    private final MultiMap<Id<?>, Id<?>> myCachedChildrenIds = new MultiMap<Id<?>, Id<?>>(CollectionFactory.createConcurrentWeakMap()){

        @NotNull
        protected Collection<Id<?>> createCollection() {
            Set<Id<?>> set = Collections.synchronizedSet(ContainerUtil.createWeakSet());
            if (set == null) {
                1.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/owner/ElementMatcherImpl$1", "createCollection"));
        }
    };

    public ElementMatcherImpl(boolean withOriginal, @Nullable ChildProvider childProvider) {
        this.myOriginalOwner = withOriginal ? this.createOwner() : null;
        this.myChildProvider = childProvider;
    }

    int allocateId() {
        return this.myCounter.getAndIncrement();
    }

    @NotNull
    public ElementOwnerImpl createOwner() {
        ElementOwnerImpl res2 = new ElementOwnerImpl(this, this.myOriginalOwner);
        this.addOwner(res2);
        ElementOwnerImpl elementOwnerImpl = res2;
        if (elementOwnerImpl == null) {
            ElementMatcherImpl.$$$reportNull$$$0(0);
        }
        return elementOwnerImpl;
    }

    public void removeOwner(@NotNull ElementOwner owner) {
        if (owner == null) {
            ElementMatcherImpl.$$$reportNull$$$0(1);
        }
        this.myOwners.remove(owner);
    }

    private void addOwner(@NotNull ElementOwnerImpl owner) {
        if (owner == null) {
            ElementMatcherImpl.$$$reportNull$$$0(2);
        }
        this.myOwners.add(owner);
    }

    @Nullable
    public ElementOwner getOriginalOwner() {
        return this.myOriginalOwner;
    }

    @Nullable
    public ElementOwnerImpl getOwner(@NotNull BasicElement e) {
        if (e == null) {
            ElementMatcherImpl.$$$reportNull$$$0(3);
        }
        return (ElementOwnerImpl)ContainerUtil.find(this.myOwners, o -> o.findIdentity(e) != null);
    }

    void cache(@NotNull Id<?> id) {
        if (id == null) {
            ElementMatcherImpl.$$$reportNull$$$0(4);
        }
        this.myCachedChildrenIds.getModifiable(id);
        Id<?> parent = id.getParentId();
        if (parent != null) {
            this.myCachedChildrenIds.putValue(parent, id);
        }
    }

    Iterable<Id<?>> getCachedIds() {
        return this.myCachedChildrenIds.keySet();
    }

    Iterable<Id<?>> getCachedChildren(Id<?> id) {
        return this.myCachedChildrenIds.get(id);
    }

    protected static boolean isNull(BasicElement res2) {
        return res2 == null || res2 instanceof BasicModElement && ((BasicModElement)res2).isDropped();
    }

    @Nullable
    public ElementIdentity<?> getParent(@NotNull ElementIdentity<?> identity) {
        Id<?> id;
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(5);
        }
        if ((id = ElementMatcherImpl.asId(identity)) == null) {
            if (identity instanceof MultiElementIdentity) {
                MultiElementIdentity mi = (MultiElementIdentity)identity;
                JBIterable parents = JBIterable.from(mi.getIdentities()).map(this::getParent);
                return MultiElementIdentity.asSingleIdentityFiltered(parents.unique());
            }
            return null;
        }
        return id.getParentId();
    }

    @Nullable
    public <E extends BasicElement> E findElement(@NotNull ElementIdentity<E> id) {
        if (id == null) {
            ElementMatcherImpl.$$$reportNull$$$0(6);
        }
        for (ElementOwnerImpl owner : this.myOwners) {
            E element = owner.findElement(id);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    <P extends BasicElement, E extends BasicElement> Iterable<E> getObjectChildren(@NotNull P original, @NotNull ElementIdentity<P> identity, @NotNull BasicMetaObject<E> childMeta) {
        if (original == null) {
            ElementMatcherImpl.$$$reportNull$$$0(7);
        }
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(8);
        }
        if (childMeta == null) {
            ElementMatcherImpl.$$$reportNull$$$0(9);
        }
        if (this.myChildProvider == null) {
            Family family = BasicMetaUtils.getFamily(original, childMeta);
            Object object = family == null ? JBIterable.empty() : family;
            if (object == null) {
                ElementMatcherImpl.$$$reportNull$$$0(10);
            }
            return object;
        }
        Iterable<E> iterable = this.myChildProvider.getChildren(original, identity, childMeta);
        if (iterable == null) {
            ElementMatcherImpl.$$$reportNull$$$0(11);
        }
        return iterable;
    }

    Set<ElementOwnerImpl> getOwners() {
        return this.myOwners;
    }

    @NotNull
    public <S extends BasicElement, T extends BasicElement> Id<T> createInlineRef(@NotNull ElementIdentity<S> parentId, @NotNull BasicMetaReference<S, T> ref, @NotNull BasicMetaObject<T> meta) {
        if (parentId == null) {
            ElementMatcherImpl.$$$reportNull$$$0(12);
        }
        if (ref == null) {
            ElementMatcherImpl.$$$reportNull$$$0(13);
        }
        if (meta == null) {
            ElementMatcherImpl.$$$reportNull$$$0(14);
        }
        return new Id<T>(ElementMatcherImpl.asId(parentId), this, ref, meta, this.allocateId());
    }

    @Nullable
    public <E extends BasicElement> BasicMetaReference<?, E> getInlineMetaRef(@NotNull ElementIdentity<E> identity) {
        Id<E> id;
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(15);
        }
        return (id = ElementMatcherImpl.asId(identity)) != null ? id.getInlined() : null;
    }

    @Nullable
    public BasicMetaObject<?> getMetaParent(@Nullable BasicMetaObject<?> meta) {
        return this.myChildProvider == null ? (meta == null ? null : meta.getParent()) : this.myChildProvider.getParent(meta);
    }

    @NotNull
    public Iterable<BasicMetaObject<?>> getMetaChildren(@Nullable BasicMetaObject<?> meta) {
        JBIterable jBIterable = this.myChildProvider == null ? JBIterable.of((Object[])(meta == null ? null : meta.children)) : this.myChildProvider.getChildren(meta);
        if (jBIterable == null) {
            ElementMatcherImpl.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    public <E extends BasicElement> Id<E> create(@Nullable ElementIdentity<?> parent, @NotNull BasicMetaObject<E> meta) {
        if (meta == null) {
            ElementMatcherImpl.$$$reportNull$$$0(17);
        }
        return new Id<E>(ElementMatcherImpl.asId(parent), this, meta, this.allocateId());
    }

    @Nullable
    public <E extends BasicElement> E find(@NotNull ElementOwner base, @NotNull ElementIdentity<E> identity) {
        if (base == null) {
            ElementMatcherImpl.$$$reportNull$$$0(18);
        }
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(19);
        }
        return (E)base.find(identity);
    }

    @Nullable
    static <E extends BasicElement> Id<E> asId(@Nullable ElementIdentity<E> identity) {
        return (Id)ObjectUtils.tryCast(identity, Id.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 14, 15, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/owner/ElementMatcherImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childMeta";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOwner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/owner/ElementMatcherImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeOwner";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addOwner";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getObjectChildren";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createInlineRef";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInlineMetaRef";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 14, 15, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }

    public static interface ChildProvider {
        @NotNull
        public <P extends BasicElement, E extends BasicElement> Iterable<E> getChildren(@NotNull P var1, @NotNull ElementIdentity<P> var2, @NotNull BasicMetaObject<E> var3);

        @NotNull
        public Iterable<BasicMetaObject<?>> getChildren(@Nullable BasicMetaObject<?> var1);

        @Nullable
        public BasicMetaObject<?> getParent(@Nullable BasicMetaObject<?> var1);
    }
}

