/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseViewService;
import com.intellij.database.view.structure.DvForestActionService;
import com.intellij.database.view.structure.DvForestActionServiceImpl$adjustDataSourcePaths$;
import com.intellij.database.view.structure.DvForestActionServiceImpl$moveForestNodes$;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.forest.DvArm;
import com.intellij.database.view.structure.forest.DvBushRef;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForest;
import com.intellij.database.view.structure.forest.DvForestRootFolder;
import com.intellij.database.view.structure.forest.DvForestService;
import com.intellij.database.view.structure.forest.DvNiceFolder;
import com.intellij.database.view.structure.forest.ShiftDirection;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u00182\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0 H\u0016J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0016H\u0002J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0012H\u0002J\u001e\u0010+\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\u001e\u0010/\u001a\u00020\u001e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020&0 2\u0006\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u00020\u001e2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u00101\u001a\u000202H\u0002J\u001e\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u00162\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001607H\u0002J\u001e\u00108\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u00182\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001607H\u0002J$\u00109\u001a\u00020\u001e2\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120;0 2\u0006\u00101\u001a\u000202H\u0002J$\u0010<\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u00162\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120;07H\u0002J$\u0010=\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u00182\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120;07H\u0002J\u0016\u0010>\u001a\u00020\u001c2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.07H\u0002J \u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020\u0018H\u0002J\u0016\u0010D\u001a\u00020\u001e2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00120;H\u0002J\u001e\u0010F\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020&0 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006H"}, d2={"Lcom/intellij/database/view/structure/DvForestActionServiceImpl;", "Lcom/intellij/database/view/structure/DvForestActionService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "forestService", "Lcom/intellij/database/view/structure/forest/DvForestService;", "getForestService", "()Lcom/intellij/database/view/structure/forest/DvForestService;", "structureService", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "getStructureService", "()Lcom/intellij/database/view/structure/DvTreeStructureService;", "forest", "Lcom/intellij/database/view/structure/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "getForest", "()Lcom/intellij/database/view/structure/forest/DvForest;", "createNewFolder", "Lcom/intellij/database/view/structure/forest/DvNiceFolder;", "parent", "Lcom/intellij/database/view/structure/forest/DvFolder;", "name", "", "focus", "", "deleteFolders", "", "foldersToDelete", "", "resurrectFolders", "foldersToResurrect", "moveForestNodes", "targetFolder", "nodesToMove", "Lcom/intellij/database/model/basic/BasicNode;", "moveFolder", "folderToMove", "moveDataSource", "dataSourceToMove", "checkForLoops", "movingFolders", "", "Lcom/intellij/database/view/structure/forest/DvArm;", "shiftNodes", "nodes", "direction", "Lcom/intellij/database/view/structure/forest/ShiftDirection;", "shiftFolders", "foldersToShift", "shiftFoldersLevelUp", "currentParent", "", "shiftFoldersLevelDown", "shiftBushes", "bushesToShift", "Lcom/intellij/database/view/structure/forest/DvBushRef;", "shiftBushesLevelUp", "shiftBushesLevelDown", "positionsAreHuggerMugger", "renameFolder", "folder", "newName", "adjustDataSourcePaths", "startWithFolder", "adjustBushPath", "br", "notifyThatTheTreeWasChanged", "nodesToSelect", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestActionServiceImpl.kt\ncom/intellij/database/view/structure/DvForestActionServiceImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n30#2,2:314\n30#2,2:316\n30#2,2:388\n1056#3:318\n1056#3:319\n1740#3,3:321\n808#3,11:324\n1740#3,3:335\n808#3,11:338\n1617#3,9:349\n1869#3:358\n1870#3:360\n1626#3:361\n1740#3,3:362\n1740#3,3:365\n1740#3,3:368\n1740#3,3:371\n1740#3,3:374\n1740#3,3:377\n1740#3,3:380\n1740#3,3:383\n1761#3,3:390\n1011#3,2:393\n1761#3,3:395\n1011#3,2:398\n477#4:320\n477#4:387\n1#5:359\n1#5:386\n*S KotlinDebug\n*F\n+ 1 DvForestActionServiceImpl.kt\ncom/intellij/database/view/structure/DvForestActionServiceImpl\n*L\n19#1:314,2\n22#1:316,2\n310#1:388,2\n40#1:318\n55#1:319\n132#1:321,3\n133#1:324,11\n136#1:335,3\n137#1:338,11\n137#1:349,9\n137#1:358\n137#1:360\n137#1:361\n185#1:362,3\n186#1:365,3\n204#1:368,3\n205#1:371,3\n251#1:374,3\n252#1:377,3\n268#1:380,3\n269#1:383,3\n154#1:390,3\n155#1:393,2\n219#1:395,3\n220#1:398,2\n68#1:320\n293#1:387\n137#1:359\n*E\n"})
public final class DvForestActionServiceImpl
implements DvForestActionService {
    @NotNull
    private final Project project;

    public DvForestActionServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DvForestService getForestService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvForestService)object;
    }

    private final DvTreeStructureService getStructureService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvTreeStructureService)object;
    }

    private final DvForest<DataSourceNode> getForest() {
        return this.getForestService().getForest();
    }

    @NotNull
    public DvNiceFolder createNewFolder(@NotNull DvFolder parent, @NotNull String name, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DvNiceFolder newFolder = (DvNiceFolder)DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.createNewFolder$lambda$0(parent, name), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, SetsKt.setOf((Object)newFolder));
        return newFolder;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteFolders(@NotNull Collection<DvNiceFolder> foldersToDelete, boolean focus) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(foldersToDelete, (String)"foldersToDelete");
        Iterable iterable = foldersToDelete;
        boolean $i$f$sortedBy = false;
        List sortedFolders = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DvNiceFolder it = (DvNiceFolder)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf((it.getLevel() << 24) + it.getOrderId());
                it = (DvNiceFolder)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf((it.getLevel() << 24) + it.getOrderId()));
            }
        }));
        DvForest forest = this.getForestService().getForest();
        DvForest.modifyTree$default((DvForest)forest, (boolean)false, () -> DvForestActionServiceImpl.deleteFolders$lambda$1(sortedFolders), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    public void resurrectFolders(@NotNull Collection<DvNiceFolder> foldersToResurrect, boolean focus) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(foldersToResurrect, (String)"foldersToResurrect");
        Iterable iterable = foldersToResurrect;
        boolean $i$f$sortedBy = false;
        List sortedFolders = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DvNiceFolder it = (DvNiceFolder)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOrderId());
                it = (DvNiceFolder)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrderId()));
            }
        }));
        DvForest forest = this.getForestService().getForest();
        DvForest.modifyTree$default((DvForest)forest, (boolean)false, () -> DvForestActionServiceImpl.resurrectFolders$lambda$1(sortedFolders), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, sortedFolders);
    }

    public void moveForestNodes(@NotNull DvFolder targetFolder, @NotNull Collection<? extends BasicNode> nodesToMove) {
        boolean hasLoops;
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter(nodesToMove, (String)"nodesToMove");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)nodesToMove);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)moveForestNodes$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Set movingFolders = SequencesKt.toSet((Sequence)sequence);
        if (!((Collection)movingFolders).isEmpty() && (hasLoops = this.checkForLoops(targetFolder, movingFolders))) {
            return;
        }
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.moveForestNodes$lambda$0(nodesToMove, this, targetFolder), (int)1, null);
        this.notifyThatTheTreeWasChanged(true, nodesToMove);
    }

    private final void moveFolder(DvFolder targetFolder, DvNiceFolder folderToMove) {
        DvFolder oldParent = folderToMove.getParent();
        if (Intrinsics.areEqual((Object)oldParent, (Object)targetFolder)) {
            return;
        }
        oldParent.excludeFolder(folderToMove, true);
        folderToMove.assignParent(targetFolder);
        DvFolder.resurrectFolder$default((DvFolder)targetFolder, (DvNiceFolder)folderToMove, (boolean)false, (int)0, (int)4, null);
        boolean bl = Intrinsics.areEqual((Object)folderToMove.getParent(), (Object)targetFolder);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = targetFolder.getInnerFolders().contains(folderToMove);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    private final void moveDataSource(DvFolder targetFolder, DataSourceNode dataSourceToMove) {
        block9: {
            String string;
            boolean bl;
            DvBushRef dvBushRef = this.getForest().getBushRef((BasicUniqueBush)dataSourceToMove);
            if (dvBushRef == null) {
                return;
            }
            DvBushRef bushRef = dvBushRef;
            DvFolder oldParent = bushRef.getParent();
            if (Intrinsics.areEqual((Object)oldParent, (Object)targetFolder)) {
                return;
            }
            oldParent.excludeBushRef(bushRef, false);
            boolean bl2 = bl = !oldParent.getInnerBushRefList().contains(bushRef);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bushRef.assignParent(targetFolder);
            DvFolder.resurrectBushRef$default((DvFolder)targetFolder, (DvBushRef)bushRef, (boolean)false, (int)0, (int)4, null);
            bl = Intrinsics.areEqual((Object)bushRef.getParent(), (Object)targetFolder);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            bl = targetFolder.getInnerBushRefList().contains(bushRef);
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            RawDataSource rawDataSource = dataSourceToMove.dataSource;
            AbstractDataSource ds = rawDataSource instanceof AbstractDataSource ? (AbstractDataSource)rawDataSource : null;
            DvFolder dvFolder = targetFolder;
            if (dvFolder instanceof DvNiceFolder) {
                string = ((DvNiceFolder)targetFolder).getPath();
            } else if (dvFolder instanceof DvForestRootFolder) {
                string = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String newPath = string;
            AbstractDataSource abstractDataSource = ds;
            if (abstractDataSource == null) break block9;
            abstractDataSource.setGroupName(newPath);
        }
    }

    private final boolean checkForLoops(DvFolder targetFolder, Set<? extends DvArm> movingFolders) {
        List targetPath = this.getForest().getInternalTree().pathToRoot((Object)targetFolder);
        for (DvArm node : targetPath) {
            if (!movingFolders.contains(node)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void shiftNodes(@NotNull Collection<? extends BasicNode> nodes, @NotNull ShiftDirection direction) {
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$filterIsInstanceTo;
        Collection destination$iv$iv;
        Object element$iv2;
        block13: {
            BasicNode it;
            boolean bl2;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block12: {
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
                if (nodes.isEmpty()) {
                    return;
                }
                $this$all$iv = nodes;
                $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        it = (BasicNode)element$iv2;
                        boolean bl3 = false;
                        if (it instanceof DvNiceFolder) continue;
                        bl2 = false;
                        break block12;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                Iterable $this$filterIsInstance$iv = nodes;
                boolean $i$f$filterIsInstance = false;
                element$iv2 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof DvNiceFolder)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List folders = (List)destination$iv$iv;
                this.shiftFolders(folders, direction);
            }
            $this$all$iv = nodes;
            $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    it = (BasicNode)element$iv2;
                    boolean bl4 = false;
                    if (it instanceof DataSourceNode) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable $this$filterIsInstance$iv = nodes;
            boolean $i$f$filterIsInstance = false;
            element$iv2 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DataSourceNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DvBushRef it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                DataSourceNode it = (DataSourceNode)element$iv$iv;
                boolean bl6 = false;
                if (this.getForest().getBushRef((BasicUniqueBush)it) == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List bushes = (List)destination$iv$iv;
            this.shiftBushes(bushes, direction);
        }
        this.notifyThatTheTreeWasChanged(true, nodes);
    }

    private final void shiftFolders(Collection<DvNiceFolder> foldersToShift, ShiftDirection direction) {
        ArrayList<DvNiceFolder> folders = new ArrayList<DvNiceFolder>(foldersToShift);
        int n = folders.size();
        if (n == 0) {
            return;
        }
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.shiftFolders$lambda$0(folders, n, this, direction), (int)1, null);
    }

    private final void shiftFoldersLevelUp(DvNiceFolder currentParent, List<DvNiceFolder> foldersToShift) {
        boolean bl;
        DvFolder granny;
        block11: {
            boolean $this$all$iv2;
            DvNiceFolder it;
            boolean $i$f$all2;
            block10: {
                granny = currentParent.getParent();
                granny.fixFoldersPositions();
                int newPosition = currentParent.getPosition() + 1;
                for (DvNiceFolder f : CollectionsKt.asReversed(foldersToShift)) {
                    currentParent.excludeFolder(f, true);
                }
                Iterator<Object> iterator = ((Iterable)foldersToShift).iterator();
                int f = 0;
                while (iterator.hasNext()) {
                    int index = f++;
                    DvNiceFolder f2 = (DvNiceFolder)iterator.next();
                    f2.assignParent(granny);
                    granny.resurrectFolder(f2, false, newPosition + index);
                }
                Iterable $this$all$iv2 = foldersToShift;
                $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (DvNiceFolder)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)granny)) continue;
                        v0 = false;
                        break block10;
                    }
                    v0 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$all2);
            }
            Iterable $this$all$iv3 = foldersToShift;
            $i$f$all2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v1 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvNiceFolder)element$iv;
                    boolean bl3 = false;
                    if (granny.getInnerFolders().contains(it)) continue;
                    v1 = false;
                    break block11;
                }
                v1 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.adjustDataSourcePaths(granny);
    }

    private final void shiftFoldersLevelDown(DvFolder currentParent, List<DvNiceFolder> foldersToShift) {
        boolean bl;
        DvNiceFolder newParent;
        block13: {
            boolean $this$all$iv2;
            DvNiceFolder it;
            boolean $i$f$all2;
            block12: {
                boolean bl2;
                if (foldersToShift.isEmpty()) {
                    return;
                }
                int newParentPosition = ((DvNiceFolder)CollectionsKt.first(foldersToShift)).getPosition() - 1;
                boolean bl3 = bl2 = newParentPosition >= 0;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                newParent = (DvNiceFolder)currentParent.getInnerFolders().get(newParentPosition);
                for (DvNiceFolder f : CollectionsKt.asReversed(foldersToShift)) {
                    currentParent.excludeFolder(f, true);
                }
                for (DvNiceFolder f : foldersToShift) {
                    f.assignParent((DvFolder)newParent);
                    DvFolder.resurrectFolder$default((DvFolder)((DvFolder)newParent), (DvNiceFolder)f, (boolean)false, (int)0, (int)4, null);
                }
                Iterable $this$all$iv2 = foldersToShift;
                $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    v1 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (DvNiceFolder)element$iv;
                        boolean bl4 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)newParent)) continue;
                        v1 = false;
                        break block12;
                    }
                    v1 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$all2);
            }
            Iterable $this$all$iv3 = foldersToShift;
            $i$f$all2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v2 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvNiceFolder)element$iv;
                    boolean bl5 = false;
                    if (newParent.getInnerFolders().contains(it)) continue;
                    v2 = false;
                    break block13;
                }
                v2 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.adjustDataSourcePaths((DvFolder)newParent);
    }

    private final void shiftBushes(Collection<DvBushRef<DataSourceNode>> bushesToShift, ShiftDirection direction) {
        ArrayList<DvBushRef<DataSourceNode>> bushes = new ArrayList<DvBushRef<DataSourceNode>>(bushesToShift);
        int n = bushes.size();
        if (n == 0) {
            return;
        }
        DvFolder parent = ((DvBushRef)CollectionsKt.first((List)bushes)).getParent();
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.shiftBushes$lambda$0(parent, n, bushes, this, direction), (int)1, null);
    }

    private final void shiftBushesLevelUp(DvNiceFolder currentParent, List<DvBushRef<DataSourceNode>> bushesToShift) {
        boolean bl;
        block13: {
            boolean $this$all$iv2;
            DvBushRef it;
            boolean $i$f$all2;
            DvFolder granny;
            block12: {
                granny = currentParent.getParent();
                granny.fixBushesPositions();
                boolean insert = granny.getHasInnerBushRefs();
                for (DvBushRef b : CollectionsKt.asReversed(bushesToShift)) {
                    currentParent.excludeBushRef(b, false);
                }
                Iterator<Object> iterator = ((Iterable)bushesToShift).iterator();
                int b = 0;
                while (iterator.hasNext()) {
                    int index = b++;
                    DvBushRef b2 = (DvBushRef)iterator.next();
                    b2.assignParent(granny);
                    if (insert) {
                        granny.resurrectBushRef(b2, false, index);
                        continue;
                    }
                    DvFolder.resurrectBushRef$default((DvFolder)granny, (DvBushRef)b2, (boolean)false, (int)0, (int)4, null);
                }
                Iterable $this$all$iv2 = bushesToShift;
                $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (DvBushRef)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)granny)) continue;
                        v0 = false;
                        break block12;
                    }
                    v0 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$all2);
            }
            Iterable $this$all$iv3 = bushesToShift;
            $i$f$all2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v1 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvBushRef)element$iv;
                    boolean bl3 = false;
                    if (granny.getInnerBushRefList().contains(it)) continue;
                    v1 = false;
                    break block13;
                }
                v1 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String $i$f$all = "Assertion failed";
            throw new AssertionError((Object)$i$f$all);
        }
        for (DvBushRef<DataSourceNode> b : bushesToShift) {
            this.adjustBushPath(b);
        }
    }

    private final void shiftBushesLevelDown(DvFolder currentParent, List<DvBushRef<DataSourceNode>> bushesToShift) {
        boolean bl;
        block13: {
            boolean $this$all$iv22;
            DvBushRef it;
            DvNiceFolder newParent;
            block12: {
                if (bushesToShift.isEmpty()) {
                    return;
                }
                DvNiceFolder dvNiceFolder = (DvNiceFolder)CollectionsKt.lastOrNull((List)currentParent.getInnerFolders());
                if (dvNiceFolder == null) {
                    return;
                }
                newParent = dvNiceFolder;
                for (DvBushRef dvBushRef : CollectionsKt.asReversed(bushesToShift)) {
                    currentParent.excludeBushRef(dvBushRef, false);
                }
                for (DvBushRef dvBushRef : bushesToShift) {
                    dvBushRef.assignParent((DvFolder)newParent);
                    DvFolder.resurrectBushRef$default((DvFolder)((DvFolder)newParent), (DvBushRef)dvBushRef, (boolean)false, (int)0, (int)4, null);
                }
                Iterable $this$all$iv22 = bushesToShift;
                boolean string = false;
                if ($this$all$iv22 instanceof Collection && ((Collection)$this$all$iv22).isEmpty()) {
                    v1 = true;
                } else {
                    for (Object element$iv : $this$all$iv22) {
                        it = (DvBushRef)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)newParent)) continue;
                        v1 = false;
                        break block12;
                    }
                    v1 = $this$all$iv22 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv22) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Iterable $this$all$iv3 = bushesToShift;
            boolean bl2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v2 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvBushRef)element$iv;
                    boolean bl3 = false;
                    if (newParent.getInnerBushRefList().contains(it)) continue;
                    v2 = false;
                    break block13;
                }
                v2 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    private final boolean positionsAreHuggerMugger(List<? extends DvArm> nodes) {
        int n = nodes.size();
        if (n < 2) {
            return false;
        }
        Iterator iterator = ((Iterable)nodes).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        DvArm it = (DvArm)iterator.next();
        boolean bl = false;
        int n2 = it.getPosition();
        while (iterator.hasNext()) {
            DvArm it22 = (DvArm)iterator.next();
            $i$a$-minOf-DvForestActionServiceImpl$positionsAreHuggerMugger$min$1 = false;
            int it22 = it22.getPosition();
            if (n2 <= it22) continue;
            n2 = it22;
        }
        int min = n2;
        Iterator iterator2 = ((Iterable)nodes).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        DvArm it2 = (DvArm)iterator2.next();
        boolean bl2 = false;
        int n3 = it2.getPosition();
        while (iterator2.hasNext()) {
            DvArm it3 = (DvArm)iterator2.next();
            $i$a$-maxOf-DvForestActionServiceImpl$positionsAreHuggerMugger$max$1 = false;
            int n4 = it3.getPosition();
            if (n3 >= n4) continue;
            n3 = n4;
        }
        int max = n3;
        return max - min + 1 != n;
    }

    public void renameFolder(@NotNull DvNiceFolder folder, @NotNull String newName, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.renameFolder$lambda$0(folder, newName, this), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, SetsKt.setOf((Object)folder));
    }

    private final void adjustDataSourcePaths(DvFolder startWithFolder) {
        Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)this.getForest().getInternalTree().traverseBreadthFirst((Object)startWithFolder));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)adjustDataSourcePaths$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List bushRefs = SequencesKt.toList((Sequence)sequence);
        for (DvBushRef br : bushRefs) {
            this.adjustBushPath((DvBushRef<DataSourceNode>)br);
        }
    }

    private final void adjustBushPath(DvBushRef<DataSourceNode> br) {
        block0: {
            AbstractDataSource ds;
            DataSourceNode dsn;
            String path = br.getParent().getPath();
            DataSourceNode dataSourceNode = dsn = (DataSourceNode)br.getBush();
            RawDataSource rawDataSource = dataSourceNode != null ? dataSourceNode.dataSource : null;
            AbstractDataSource abstractDataSource = ds = rawDataSource instanceof AbstractDataSource ? (AbstractDataSource)rawDataSource : null;
            if (abstractDataSource == null) break block0;
            abstractDataSource.setGroupName(path);
        }
    }

    private final void notifyThatTheTreeWasChanged(boolean focus, Collection<? extends BasicNode> nodesToSelect) {
        this.getStructureService().onFoldersChanged();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DatabaseViewService> serviceClass$iv = DatabaseViewService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((DatabaseViewService)object).refreshTree(focus, nodesToSelect);
    }

    private static final DvNiceFolder createNewFolder$lambda$0(DvFolder $parent, String $name) {
        return $parent.createNewInnerFolder($name);
    }

    private static final Unit deleteFolders$lambda$1(List $sortedFolders) {
        for (DvNiceFolder f : CollectionsKt.asReversed((List)$sortedFolders)) {
            DvFolder p = f.getParent();
            p.excludeFolder(f, false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit resurrectFolders$lambda$1(List $sortedFolders) {
        for (DvNiceFolder f : $sortedFolders) {
            DvFolder p = f.getParent();
            DvFolder.resurrectFolder$default((DvFolder)p, (DvNiceFolder)f, (boolean)true, (int)0, (int)4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveForestNodes$lambda$0(Collection $nodesToMove, DvForestActionServiceImpl this$0, DvFolder $targetFolder) {
        for (BasicNode node : $nodesToMove) {
            BasicNode basicNode = node;
            if (basicNode instanceof DvNiceFolder) {
                this$0.moveFolder($targetFolder, (DvNiceFolder)node);
                continue;
            }
            if (!(basicNode instanceof DataSourceNode)) continue;
            this$0.moveDataSource($targetFolder, (DataSourceNode)node);
        }
        return Unit.INSTANCE;
    }

    private static final Unit shiftFolders$lambda$0(ArrayList $folders, int $n, DvForestActionServiceImpl this$0, ShiftDirection $direction) {
        DvFolder parent = ((DvNiceFolder)CollectionsKt.first((List)$folders)).getParent();
        parent.fixFoldersPositions();
        if ($n >= 2) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = $folders;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DvNiceFolder it = (DvNiceFolder)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getParent(), (Object)parent))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Unit.INSTANCE;
            }
            List $this$sortBy$iv = $folders;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DvNiceFolder it = (DvNiceFolder)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPosition());
                        it = (DvNiceFolder)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition()));
                    }
                });
            }
            if (this$0.positionsAreHuggerMugger($folders)) {
                return Unit.INSTANCE;
            }
        }
        int familySize = parent.getInnerFolders().size();
        int firstPosition = ((DvNiceFolder)CollectionsKt.first((List)$folders)).getPosition();
        int lastPosition = ((DvNiceFolder)CollectionsKt.last((List)$folders)).getPosition();
        int n = WhenMappings.$EnumSwitchMapping$0[$direction.ordinal()];
        if (n == 1 && firstPosition >= 1) {
            parent.shiftInnerFolders(firstPosition, $n, $direction);
        } else if (n == 2 && lastPosition < familySize - 1) {
            parent.shiftInnerFolders(firstPosition, $n, $direction);
        } else if (n == 3 && parent instanceof DvNiceFolder) {
            this$0.shiftFoldersLevelUp((DvNiceFolder)parent, $folders);
        } else if (n == 4 && firstPosition > 0) {
            this$0.shiftFoldersLevelDown(parent, $folders);
        }
        return Unit.INSTANCE;
    }

    private static final Unit shiftBushes$lambda$0(DvFolder $parent, int $n, ArrayList $bushes, DvForestActionServiceImpl this$0, ShiftDirection $direction) {
        $parent.fixBushesPositions();
        if ($n >= 2) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = $bushes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DvBushRef it = (DvBushRef)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getParent(), (Object)$parent))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Unit.INSTANCE;
            }
            List $this$sortBy$iv = $bushes;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DvBushRef it = (DvBushRef)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPosition());
                        it = (DvBushRef)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition()));
                    }
                });
            }
            if (this$0.positionsAreHuggerMugger($bushes)) {
                return Unit.INSTANCE;
            }
        }
        int familySize = $parent.getInnerBushRefList().size();
        int firstPosition = ((DvBushRef)CollectionsKt.first((List)$bushes)).getPosition();
        int lastPosition = ((DvBushRef)CollectionsKt.last((List)$bushes)).getPosition();
        int n = WhenMappings.$EnumSwitchMapping$0[$direction.ordinal()];
        if (n == 1 && firstPosition >= 1) {
            $parent.shiftInnerBushes(firstPosition, $n, $direction);
        } else if (n == 2 && lastPosition < familySize - 1) {
            $parent.shiftInnerBushes(firstPosition, $n, $direction);
        } else if (n == 3 && $parent instanceof DvNiceFolder) {
            this$0.shiftBushesLevelUp((DvNiceFolder)$parent, $bushes);
        } else if (n == 4 && $parent.getHasInnerFolders()) {
            this$0.shiftBushesLevelDown($parent, $bushes);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renameFolder$lambda$0(DvNiceFolder $folder, String $newName, DvForestActionServiceImpl this$0) {
        $folder.rename($newName);
        this$0.adjustDataSourcePaths((DvFolder)$folder);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShiftDirection.values().length];
            try {
                nArray[ShiftDirection.shiftSiblingsUp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShiftDirection.shiftSiblingsDown.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShiftDirection.shiftLevelUp.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShiftDirection.shiftLevelDown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

