/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl.settings;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.diagnostic.EditMemorySettingsService;
import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.util.ui.RestartDialogImpl;
import com.jetbrains.python.PyBundle;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/pycharm/community/ide/impl/settings/MemoryUsageConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "<init>", "()V", "UNKNOWN_MEMORY_VALUE", "", "MIN_VALUE", "MAX_VALUE", "option", "Lcom/intellij/diagnostic/VMOptions$MemoryKind;", "initialHeapSize", "newHeapSize", "", "newHeapSizeField", "Lcom/intellij/ui/components/JBTextField;", "memoryWidgetCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "initialMemoryWidgetValue", "", "Ljava/lang/Boolean;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "isModified", "apply", "", "reset", "saveNewHeapSize", "getInitialHeapSize", "isInDebugMode", "Companion", "intellij.pycharm.community.ide.impl"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMemoryUsageConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryUsageConfigurable.kt\ncom/intellij/pycharm/community/ide/impl/settings/MemoryUsageConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,135:1\n1#2:136\n13805#3:137\n13806#3:140\n30#4,2:138\n*S KotlinDebug\n*F\n+ 1 MemoryUsageConfigurable.kt\ncom/intellij/pycharm/community/ide/impl/settings/MemoryUsageConfigurable\n*L\n72#1:137\n72#1:140\n73#1:138,2\n*E\n"})
public final class MemoryUsageConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int UNKNOWN_MEMORY_VALUE;
    private final int MIN_VALUE;
    private final int MAX_VALUE;
    @NotNull
    private final VMOptions.MemoryKind option;
    private final int initialHeapSize;
    @NotNull
    private String newHeapSize;
    private JBTextField newHeapSizeField;
    @Nullable
    private JBCheckBox memoryWidgetCheckbox;
    @Nullable
    private Boolean initialMemoryWidgetValue;
    public static final int $stable = 8;
    @NotNull
    private static final String MEMORY_USAGE_SETTINGS_ID = "pycharm.memory.usage.settings";
    @NotNull
    private static final String MEMORY_USAGE_SETTINGS_HELP_TOPIC = "increase.memory.heap";

    public MemoryUsageConfigurable() {
        String string = PyBundle.message((String)"settings.memory.group.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, MEMORY_USAGE_SETTINGS_HELP_TOPIC, MEMORY_USAGE_SETTINGS_ID);
        this.UNKNOWN_MEMORY_VALUE = -1;
        this.MIN_VALUE = 256;
        this.MAX_VALUE = 1000000;
        this.option = VMOptions.MemoryKind.HEAP;
        this.initialHeapSize = this.getInitialHeapSize();
        this.newHeapSize = String.valueOf(this.initialHeapSize);
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> MemoryUsageConfigurable.createPanel$lambda$0(this, arg_0));
    }

    public boolean isModified() {
        boolean bl;
        Boolean bl2 = this.initialMemoryWidgetValue;
        if (bl2 != null) {
            boolean initial = bl2;
            boolean bl3 = false;
            JBCheckBox jBCheckBox = this.memoryWidgetCheckbox;
            boolean bl4 = jBCheckBox != null ? initial == jBCheckBox.isSelected() : false;
            bl = !bl4;
        } else {
            bl = false;
        }
        boolean memoryWidgetModified = bl;
        return memoryWidgetModified || !Intrinsics.areEqual((Object)String.valueOf(this.initialHeapSize), (Object)this.newHeapSize);
    }

    public void apply() {
        super.apply();
        if (this.isModified() && !this.isInDebugMode()) {
            this.saveNewHeapSize();
            RestartDialogImpl.Companion.showRestartRequired$default((RestartDialogImpl.Companion)RestartDialogImpl.Companion, (boolean)false, (boolean)false, (int)3, null);
        }
    }

    public void reset() {
        block1: {
            super.reset();
            this.newHeapSize = String.valueOf(this.initialHeapSize);
            JBTextField jBTextField = this.newHeapSizeField;
            if (jBTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"newHeapSizeField");
                jBTextField = null;
            }
            jBTextField.setText(this.newHeapSize);
            JBCheckBox jBCheckBox = this.memoryWidgetCheckbox;
            if (jBCheckBox == null) break block1;
            Boolean bl = this.initialMemoryWidgetValue;
            jBCheckBox.setSelected(bl != null ? bl : false);
        }
    }

    private final void saveNewHeapSize() throws ConfigurationException {
        if (this.isInDebugMode()) {
            return;
        }
        try {
            int newSize = Integer.parseInt(this.newHeapSize);
            EditMemorySettingsService.getInstance().save(this.option, newSize);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), OptionsBundle.message((String)"cannot.save.settings.default.dialog.title", (Object[])new Object[0]));
        }
    }

    private final int getInitialHeapSize() {
        if (this.isInDebugMode()) {
            return this.UNKNOWN_MEMORY_VALUE;
        }
        return VMOptions.readOption((VMOptions.MemoryKind)this.option, (boolean)true);
    }

    private final boolean isInDebugMode() {
        return !VMOptions.canWriteOptions();
    }

    private static final Unit createPanel$lambda$0(MemoryUsageConfigurable this$0, Panel $this$panel) {
        Object v3;
        StatusBarWidgetSettings statusBarWidgetSettings;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            String string = PyBundle.message((String)"settings.memory.heap.size.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Row row = $this$panel.row(string, arg_0 -> MemoryUsageConfigurable.createPanel$lambda$0$0(this$0, arg_0)).topGap(TopGap.MEDIUM);
            String string2 = PyBundle.message((String)"settings.memory.heap.size.row.comment", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Row.rowComment$default((Row)row, (String)string2, (int)0, null, (int)6, null);
            Panel.row$default((Panel)$this$panel, null, MemoryUsageConfigurable::createPanel$lambda$0$1, (int)1, null);
            statusBarWidgetSettings = StatusBarWidgetSettings.Companion.getInstance();
            Iterable iterable = StatusBarWidgetFactory.EP_NAME.getExtensionList();
            for (Object t : iterable) {
                StatusBarWidgetFactory it = (StatusBarWidgetFactory)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"Memory")) continue;
                v3 = t;
                break block2;
            }
            v3 = null;
        }
        StatusBarWidgetFactory memoryWidgetFactory = v3;
        if (memoryWidgetFactory != null) {
            this$0.initialMemoryWidgetValue = StatusBarWidgetSettings.Companion.getInstance().isEnabled(memoryWidgetFactory);
            Row row = Panel.row$default((Panel)$this$panel, null, arg_0 -> MemoryUsageConfigurable.createPanel$lambda$0$3(this$0, statusBarWidgetSettings, memoryWidgetFactory, arg_0), (int)1, null).topGap(TopGap.MEDIUM);
            String string = PyBundle.message((String)"settings.memory.indicator.row.comment", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Row.rowComment$default((Row)row, (String)string, (int)0, null, (int)6, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(MemoryUsageConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.newHeapSizeField = (JBTextField)TextFieldKt.columns((Cell)TextFieldKt.text((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(this$0.MIN_VALUE, this$0.MAX_VALUE), null, (int)2, null), (String)String.valueOf(this$0.initialHeapSize)), (int)7).gap(RightGap.SMALL).focused().onChanged(arg_0 -> MemoryUsageConfigurable.createPanel$lambda$0$0$0(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$0(MemoryUsageConfigurable this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.newHeapSize = string;
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{"AllIcons.General.Warning"};
        String string = PyBundle.message((String)"settings.memory.heap.size.restarting.warn.label", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(MemoryUsageConfigurable this$0, StatusBarWidgetSettings $statusBarWidgetSettings, StatusBarWidgetFactory $memoryWidgetFactory, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyBundle.message((String)"settings.memory.indicator.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Boolean bl = this$0.initialMemoryWidgetValue;
        this$0.memoryWidgetCheckbox = (JBCheckBox)ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)(bl != null ? bl : false)).onChanged(arg_0 -> MemoryUsageConfigurable.createPanel$lambda$0$3$0($statusBarWidgetSettings, $memoryWidgetFactory, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0(StatusBarWidgetSettings $statusBarWidgetSettings, StatusBarWidgetFactory $memoryWidgetFactory, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean newMemoryWidgetValue = it.isSelected();
        $statusBarWidgetSettings.setEnabled($memoryWidgetFactory, newMemoryWidgetValue);
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)project);
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<StatusBarWidgetsManager> serviceClass$iv = StatusBarWidgetsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((StatusBarWidgetsManager)object).updateWidget($memoryWidgetFactory);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/pycharm/community/ide/impl/settings/MemoryUsageConfigurable$Companion;", "", "<init>", "()V", "MEMORY_USAGE_SETTINGS_ID", "", "MEMORY_USAGE_SETTINGS_HELP_TOPIC", "intellij.pycharm.community.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

