/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixer;
import com.intellij.ml.inline.completion.java.features.correctness.JavaCorrectnessImportClassFix;
import com.intellij.ml.inline.completion.java.features.correctness.JavaSuggestionEnricherKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J4\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015JD\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J(\u0010\u001d\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J6\u0010\"\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J4\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/ml/inline/completion/java/features/JavaImportFixer;", "Lcom/intellij/ml/inline/completion/features/autoimport/ImportFixer;", "<init>", "()V", "fix", "", "file", "Lcom/intellij/psi/PsiFile;", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "runAutoImport", "context", "Lcom/intellij/ml/inline/completion/features/autoimport/ImportFixer$ImportContext;", "invokeAutoImport", "suggestionRanges", "", "allowAmbiguousImports", "", "applyFixesAndFormat", "importFixes", "Lcom/intellij/ml/inline/completion/java/features/correctness/JavaCorrectnessImportClassFix;", "pointers", "Lcom/intellij/psi/SmartPsiFileRange;", "format", "pointer", "moveCaretBetweenBraces", "lineNumber", "", "fileDocument", "Lcom/intellij/openapi/editor/Document;", "applyImports", "findElements", "myImportClassFix", "intellij.fullLine.java"})
@SourceDebugExtension(value={"SMAP\nJavaImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaImportFixer.kt\ncom/intellij/ml/inline/completion/java/features/JavaImportFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1563#2:191\n1634#2,3:192\n3301#2,10:195\n1869#2,2:205\n1563#2:207\n1634#2,3:208\n1374#2:212\n1460#2,2:213\n808#2,11:215\n1563#2:226\n1634#2,3:227\n1462#2,3:230\n774#2:233\n865#2,2:234\n1869#2,2:236\n1#3:211\n*S KotlinDebug\n*F\n+ 1 JavaImportFixer.kt\ncom/intellij/ml/inline/completion/java/features/JavaImportFixer\n*L\n56#1:191\n56#1:192,3\n162#1:195,10\n163#1:205,2\n172#1:207\n172#1:208,3\n181#1:212\n181#1:213,2\n184#1:215,11\n185#1:226\n185#1:227,3\n181#1:230,3\n187#1:233\n187#1:234,2\n85#1:236,2\n*E\n"})
public final class JavaImportFixer
implements ImportFixer {
    @TestOnly
    public final void fix(@NotNull PsiFile file, @NotNull TextRange suggestionRange, @NotNull Project project, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List fixes = (List)ApplicationManager.getApplication().executeOnPooledThread(() -> JavaImportFixer.fix$lambda$0(this, file, suggestionRange, project, editor2)).get();
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file, suggestionRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        SmartPsiFileRange pointer = smartPsiFileRange;
        ImportFixer.ImportContext importContext = new ImportFixer.ImportContext(null, null);
        Intrinsics.checkNotNull((Object)fixes);
        this.applyFixesAndFormat(project, editor2, importContext, fixes, CollectionsKt.listOf((Object)pointer), true);
    }

    @Override
    public void runAutoImport(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull TextRange suggestionRange, @NotNull ImportFixer.ImportContext context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.invokeAutoImport(file, editor2, CollectionsKt.listOf((Object)suggestionRange), context, true);
    }

    /*
     * WARNING - void declaration
     */
    public final void invokeAutoImport(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull List<? extends TextRange> suggestionRanges, @NotNull ImportFixer.ImportContext context, boolean allowAmbiguousImports) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(suggestionRanges, (String)"suggestionRanges");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(file instanceof PsiJavaFile) || suggestionRanges.isEmpty()) {
            return;
        }
        Project project = ((PsiJavaFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document fileDocument = file.getViewProvider().getDocument();
        long initialStamp = fileDocument.getModificationStamp();
        Iterable $this$map$iv = suggestionRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SmartPointerManager.getInstance((Project)project2).createSmartPsiFileRangePointer(file, (TextRange)it));
        }
        List pointers = (List)destination$iv$iv;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.applyFixesAndFormat(project2, editor2, context, CollectionsKt.emptyList(), pointers, allowAmbiguousImports);
            return;
        }
        ReadAction.nonBlocking(() -> JavaImportFixer.invokeAutoImport$lambda$1(this, file, suggestionRanges, project2, editor2)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> JavaImportFixer.invokeAutoImport$lambda$3(arg_0 -> JavaImportFixer.invokeAutoImport$lambda$2(this, project2, editor2, context, pointers, allowAmbiguousImports, arg_0), arg_0)).expireWhen(() -> JavaImportFixer.invokeAutoImport$lambda$4(fileDocument, initialStamp)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final void applyFixesAndFormat(Project project, Editor editor2, ImportFixer.ImportContext context, List<JavaCorrectnessImportClassFix> importFixes, List<? extends SmartPsiFileRange> pointers, boolean allowAmbiguousImports) {
        PsiFile psiFile2 = ((SmartPsiFileRange)CollectionsKt.first(pointers)).getContainingFile();
        if (psiFile2 == null) {
            return;
        }
        PsiFile file = psiFile2;
        CommandProcessor.getInstance().executeCommand(project, () -> JavaImportFixer.applyFixesAndFormat$lambda$0(this, project, file, editor2, importFixes, allowAmbiguousImports, pointers), context.getCommandName(), context.getCommandGroup());
    }

    private final void format(Project project, Editor editor2, SmartPsiFileRange pointer) {
        ApplicationManager.getApplication().runWriteAction(() -> JavaImportFixer.format$lambda$0(pointer, project, editor2, this));
    }

    private final void moveCaretBetweenBraces(Editor editor2, SmartPsiFileRange pointer, int lineNumber, Document fileDocument) {
        PsiElement nextElement;
        PsiElement psiElement;
        PsiElement previousElement;
        int offset = editor2.getCaretModel().getOffset();
        PsiFile psiFile2 = pointer.getContainingFile();
        Object element = psiFile2 != null ? psiFile2.findElementAt(offset) : null;
        PsiElement psiElement2 = element;
        IElementType elementType = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null;
        PsiElement psiElement3 = previousElement = Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) ? element : PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (previousElement != null) {
            previousElement = PsiTreeUtil.getDeepestLast((PsiElement)previousElement);
            ASTNode aSTNode = previousElement.getNode();
            Object object = elementType = aSTNode != null ? aSTNode.getElementType() : null;
            if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.RBRACE) && lineNumber != fileDocument.getLineNumber(previousElement.getTextRange().getEndOffset())) {
                ASTNode aSTNode2 = previousElement.getNode();
                elementType = aSTNode2 != null ? aSTNode2.getElementType() : null;
                PsiElement psiElement4 = previousElement = Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) ? previousElement : PsiTreeUtil.skipWhitespacesBackward((PsiElement)previousElement);
                if (previousElement != null) {
                    previousElement = PsiTreeUtil.getDeepestLast((PsiElement)previousElement);
                    ASTNode aSTNode3 = previousElement.getNode();
                    Object object2 = elementType = aSTNode3 != null ? aSTNode3.getElementType() : null;
                    if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) && lineNumber == fileDocument.getLineNumber(previousElement.getTextRange().getEndOffset())) {
                        TextRange textRange = previousElement.getTextRange();
                        editor2.getCaretModel().moveToOffset(textRange != null ? textRange.getEndOffset() : offset);
                        return;
                    }
                }
            }
        }
        IElementType iElementType = (psiElement = (nextElement = element)) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : (elementType = null);
        if (!Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE)) {
            nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        }
        if (nextElement == null) {
            return;
        }
        nextElement = PsiTreeUtil.getDeepestFirst((PsiElement)nextElement);
        ASTNode aSTNode = nextElement.getNode();
        Object object = elementType = aSTNode != null ? aSTNode.getElementType() : null;
        if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) && lineNumber == fileDocument.getLineNumber(nextElement.getTextRange().getEndOffset())) {
            TextRange textRange = nextElement.getTextRange();
            editor2.getCaretModel().moveToOffset(textRange != null ? textRange.getEndOffset() : offset);
        }
    }

    private final void applyImports(Project project, PsiFile file, Editor editor2, List<JavaCorrectnessImportClassFix> importFixes, boolean allowAmbiguousImports) {
        block3: {
            JavaCorrectnessImportClassFix it;
            Iterable $this$partition$iv = importFixes;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                it = (JavaCorrectnessImportClassFix)((Object)element$iv);
                boolean bl = false;
                boolean bl2 = it.getClassesToImport(true).size() == 1 ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List autoImports = (List)pair.component1();
            List ambiguousImports = (List)pair.component2();
            Iterable $this$forEach$iv = autoImports;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JavaCorrectnessImportClassFix)((Object)element$iv);
                boolean bl = false;
                it.invoke(project, editor2, file);
            }
            if (!allowAmbiguousImports) break block3;
            JavaCorrectnessImportClassFix javaCorrectnessImportClassFix = (JavaCorrectnessImportClassFix)((Object)CollectionsKt.firstOrNull((List)ambiguousImports));
            if (javaCorrectnessImportClassFix != null) {
                javaCorrectnessImportClassFix.invoke(project, editor2, file);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaCorrectnessImportClassFix> findElements(PsiFile file, List<? extends TextRange> suggestionRanges, Project project, Editor editor2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = suggestionRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.myImportClassFix(file, (TextRange)it, project, editor2));
        }
        List it = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaCorrectnessImportClassFix> myImportClassFix(PsiFile file, TextRange suggestionRange, Project project, Editor editor2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        List<PsiElement> targetElements = JavaSuggestionEnricherKt.findTargetElements(file, suggestionRange);
        Iterable $this$flatMap$iv = targetElements;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            PsiElement element = (PsiElement)element$iv$iv;
            boolean bl = false;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).onRange(JavaSuggestionEnricherKt.createExtendedTextRange(suggestionRange, file));
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"onRange(...)");
            Iterable iterable2 = (Iterable)syntaxTraverser;
            boolean $i$f$filterIsInstance = false;
            void var17_17 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof PsiJavaCodeReferenceElement)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new JavaCorrectnessImportClassFix((PsiJavaCodeReferenceElement)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JavaCorrectnessImportClassFix it = (JavaCorrectnessImportClassFix)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.isAvailable(project, editor2, file)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List fix$lambda$0(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        return (List)ReadAction.compute(() -> JavaImportFixer.fix$lambda$0$0(this$0, $file, $suggestionRange, $project, $editor));
    }

    private static final List fix$lambda$0$0(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        return this$0.myImportClassFix($file, $suggestionRange, $project, $editor);
    }

    private static final List invokeAutoImport$lambda$1(JavaImportFixer this$0, PsiFile $file, List $suggestionRanges, Project $project, Editor $editor) {
        return this$0.findElements($file, $suggestionRanges, $project, $editor);
    }

    private static final Unit invokeAutoImport$lambda$2(JavaImportFixer this$0, Project $project, Editor $editor, ImportFixer.ImportContext $context, List $pointers, boolean $allowAmbiguousImports, List fixes) {
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        this$0.applyFixesAndFormat($project, $editor, $context, fixes, $pointers, $allowAmbiguousImports);
        return Unit.INSTANCE;
    }

    private static final void invokeAutoImport$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean invokeAutoImport$lambda$4(Document $fileDocument, long $initialStamp) {
        return $fileDocument.getModificationStamp() != $initialStamp;
    }

    private static final void applyFixesAndFormat$lambda$0(JavaImportFixer this$0, Project $project, PsiFile $file, Editor $editor, List $importFixes, boolean $allowAmbiguousImports, List $pointers) {
        this$0.applyImports($project, $file, $editor, $importFixes, $allowAmbiguousImports);
        Iterable $this$forEach$iv = $pointers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SmartPsiFileRange it = (SmartPsiFileRange)element$iv;
            boolean bl = false;
            this$0.format($project, $editor, it);
        }
    }

    private static final void format$lambda$0(SmartPsiFileRange $pointer, Project $project, Editor $editor, JavaImportFixer this$0) {
        PsiFile psiFile2 = $pointer.getContainingFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getFileDocument()) == null) {
            return;
        }
        PsiFile fileDocument = psiFile2;
        PsiDocumentManager.getInstance((Project)$project).commitDocument((Document)fileDocument);
        PsiFile psiFile3 = $pointer.getContainingFile();
        if (psiFile3 == null) {
            return;
        }
        PsiFile file = psiFile3;
        int lineNumber = fileDocument.getLineNumber($editor.getCaretModel().getOffset());
        Segment segment = $pointer.getRange();
        if (segment == null) {
            return;
        }
        Segment segment2 = segment;
        List<PsiElement> psiElements = JavaSuggestionEnricherKt.findTargetElements(file, new TextRange(segment2.getStartOffset(), segment2.getEndOffset()));
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getSettings((Project)$project).getCommonSettings((Language)JavaLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        for (PsiElement psiElement : psiElements) {
            if (!Registry.Companion.is("full.line.java.force.format") && (commonSettings.CLASS_BRACE_STYLE == 1 || !(psiElement instanceof PsiClass)) && (commonSettings.METHOD_BRACE_STYLE == 1 || !(psiElement instanceof PsiMethod))) continue;
            CodeStyleManager.getInstance((Project)$project).reformat(psiElement);
        }
        this$0.moveCaretBetweenBraces($editor, $pointer, lineNumber, (Document)fileDocument);
    }
}

