/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.point;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.render.point.NamedShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.TinyPointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.CircleGlyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.Glyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.Glyphs;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ0\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/point/PointShapeSvg;", "", "()V", "create", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimObject;", "shape", "Lorg/jetbrains/letsPlot/core/plot/base/render/point/PointShape;", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "fatten", "", "verticallyAligned", "", "createNamedShape", "Lorg/jetbrains/letsPlot/core/plot/base/render/point/NamedShape;", "size", "createSlimGlyph", "Lorg/jetbrains/letsPlot/core/plot/base/render/point/symbol/Glyph;", "stroke", "createTinyDotShape", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPointShapeSvg.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointShapeSvg.kt\norg/jetbrains/letsPlot/core/plot/base/render/point/PointShapeSvg\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class PointShapeSvg {
    @NotNull
    public static final PointShapeSvg INSTANCE = new PointShapeSvg();

    private PointShapeSvg() {
    }

    @NotNull
    public final SvgSlimObject create(@NotNull PointShape shape, @NotNull DoubleVector location2, @NotNull DataPointAesthetics p, double fatten, boolean verticallyAligned) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (Intrinsics.areEqual((Object)shape, (Object)TinyPointShape.INSTANCE)) {
            return this.createTinyDotShape(location2, p);
        }
        if (shape instanceof NamedShape) {
            double size2 = shape.size(p, fatten);
            double d = size2;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                boolean bl = false;
                String string = "Invalid point size: " + size2;
                throw new IllegalStateException(string.toString());
            }
            return this.createNamedShape((NamedShape)shape, location2, size2, p, verticallyAligned);
        }
        throw new IllegalArgumentException("Unsupported point shape code " + shape.getCode() + ' ' + Reflection.getOrCreateKotlinClass(shape.getClass()).getSimpleName());
    }

    public static /* synthetic */ SvgSlimObject create$default(PointShapeSvg pointShapeSvg, PointShape pointShape, DoubleVector doubleVector, DataPointAesthetics dataPointAesthetics, double d, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return pointShapeSvg.create(pointShape, doubleVector, dataPointAesthetics, d, bl);
    }

    private final SvgSlimObject createTinyDotShape(DoubleVector location2, DataPointAesthetics p) {
        SvgSlimShape r = SvgSlimElements.INSTANCE.rect(location2.getX() - 0.5, location2.getY() - 0.5, 1.0, 1.0);
        Color color = p.color();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        double alpha = AestheticsUtil.INSTANCE.alpha(color2, p);
        r.setFill(color2, alpha);
        r.setStrokeWidth(0.0);
        return r;
    }

    private final SvgSlimObject createNamedShape(NamedShape shape, DoubleVector location2, double size2, DataPointAesthetics p, boolean verticallyAligned) {
        SvgTransform svgTransform;
        double stroke2 = shape.strokeWidth(p);
        Glyph glyph = this.createSlimGlyph(shape, location2, size2, stroke2, verticallyAligned);
        Double angle = p.finiteOrNull(Aes.Companion.getANGLE());
        if (glyph instanceof CircleGlyph) {
            svgTransform = null;
        } else {
            Double d = angle;
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                svgTransform = new SvgTransformBuilder().rotate(it, location2).build();
            } else {
                svgTransform = null;
            }
        }
        SvgTransform transform2 = svgTransform;
        AestheticsUtil.INSTANCE.decorate(glyph, shape.isFilled(), shape.isSolid(), p, stroke2, transform2);
        return glyph;
    }

    private final Glyph createSlimGlyph(NamedShape shape, DoubleVector location2, double size2, double stroke2, boolean verticallyAligned) {
        switch (WhenMappings.$EnumSwitchMapping$0[shape.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return Glyphs.INSTANCE.square(location2, size2);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Glyphs.INSTANCE.circle(location2, size2);
            }
            case 9: 
            case 10: 
            case 11: {
                return Glyphs.INSTANCE.triangleUp(location2, size2, stroke2, !verticallyAligned);
            }
            case 12: 
            case 13: {
                return Glyphs.INSTANCE.triangleDown(location2, size2, stroke2, !verticallyAligned);
            }
            case 14: 
            case 15: 
            case 16: {
                return Glyphs.INSTANCE.diamond(location2, size2);
            }
            case 17: {
                return Glyphs.INSTANCE.stickPlus(location2, size2);
            }
            case 18: {
                return Glyphs.INSTANCE.stickCross(location2, size2);
            }
            case 19: {
                return Glyphs.INSTANCE.stickSquareCross(location2, size2);
            }
            case 20: {
                return Glyphs.INSTANCE.stickStar(location2, size2);
            }
            case 21: {
                return Glyphs.INSTANCE.stickDiamondPlus(location2, size2);
            }
            case 22: {
                return Glyphs.INSTANCE.stickCirclePlus(location2, size2, stroke2);
            }
            case 23: {
                return Glyphs.INSTANCE.stickTriangleUpDown(location2, size2, stroke2);
            }
            case 24: {
                return Glyphs.INSTANCE.stickSquarePlus(location2, size2, stroke2);
            }
            case 25: {
                return Glyphs.INSTANCE.stickCircleCross(location2, size2, stroke2);
            }
            case 26: {
                return Glyphs.INSTANCE.stickSquareTriangleUp(location2, size2, stroke2);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NamedShape.values().length];
            try {
                nArray[NamedShape.STICK_SQUARE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.SOLID_SQUARE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.FILLED_SQUARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_CIRCLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.SOLID_CIRCLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.SOLID_CIRCLE_2.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.BULLET.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.FILLED_CIRCLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_TRIANGLE_UP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.SOLID_TRIANGLE_UP.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.FILLED_TRIANGLE_UP.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_TRIANGLE_DOWN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.FILLED_TRIANGLE_DOWN.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_DIAMOND.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.SOLID_DIAMOND.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.FILLED_DIAMOND.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_PLUS.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_CROSS.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_SQUARE_CROSS.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_STAR.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_DIAMOND_PLUS.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_CIRCLE_PLUS.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_TRIANGLE_UP_DOWN.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_SQUARE_PLUS.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_CIRCLE_CROSS.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamedShape.STICK_SQUARE_TRIANGLE_UP.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

