/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 36666941610043L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(805818360 - 13570, -805818360 + -9218, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(805818360 - 13569, -805818360 + -11542, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 128751649016387L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.P();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1414376370 + 7386, 1414376370 - 774, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1414376370 + 7387, -1414376370 + -3409, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1414376370 + 7384, -1414376370 + -14322, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 93787100797661L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.P();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23273), -2100003540 + -((char)-8805), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23274), -2100003540 + -((char)-4981), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23275), -2100003540 + -((char)-27318), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23276), -2100003540 + -((char)-13311), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23277), -2100003540 + -((char)-2155), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23278), 2100003540 + (char)-2896, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23276), -2100003540 + -((char)-13311), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2100003540 + -((char)-23279), -2100003540 + -((char)-6467), (int)l2));
            if (ActionTimestamp.P() == null) {
                SshAgentIpcService.P(new int[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 82580423072727L;
                    nArray = SshAgentIpcService.P();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 102228093507371L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = SshAgentIpcService.P();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5348), -718001460 + -((char)-14073), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5344), -718001460 + -((char)-21009), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5347), -718001460 + -((char)-6736), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5344), -718001460 + -((char)-21009), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5350), -718132530 - -((char)-436), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5348), -718001460 + -((char)-14073), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5344), -718001460 + -((char)-21009), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5349), -718132530 - -((char)-9862), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5348), -718001460 + -((char)-14073), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5344), -718001460 + -((char)-21009), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5336), -718001460 + -((char)-14949), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5344), -718001460 + -((char)-21009), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5335), -718001460 + -((char)-15449), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5344), -718001460 + -((char)-21009), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5350), -718132530 - -((char)-436), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5348), -718001460 + -((char)-14073), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5344), -718001460 + -((char)-21009), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-718132530 - -((char)-5338), 718132530 - (char)-7889, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 134285336466634L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1110949320 + (char)-3208, -1111080390 - -((char)-544), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 105568978168848L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1317908850 + (char)-10199, 1317908850 + (char)-6688, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "{\u00cdM\u00e1\u000b\u0006\u00f5\u0011\u00b0Z\u0085\u0081\u00c7\u00d6F\u00b2=K0\u0014\u0083.R\u009b\u00f3\u008b\u0097%~\u00da\u0099E\u0086\u00b7\u00af\u0015\u00edy-\u00c7";
                        var4_3 = "{\u00cdM\u00e1\u000b\u0006\u00f5\u0011\u00b0Z\u0085\u0081\u00c7\u00d6F\u00b2=K0\u0014\u0083.R\u009b\u00f3\u008b\u0097%~\u00da\u0099E\u0086\u00b7\u00af\u0015\u00edy-\u00c7".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 89;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 39;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 94;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 96;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 97;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 43;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 116;
                                        break;
                                    }
                                    default: {
                                        v11 = 85;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFE58A) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 80;
                            case 1 -> 121;
                            case 2 -> 20;
                            case 3 -> 212;
                            case 4 -> 114;
                            case 5 -> 101;
                            case 6 -> 127;
                            case 7 -> 60;
                            case 8 -> 216;
                            case 9 -> 133;
                            case 10 -> 208;
                            case 11 -> 97;
                            case 12 -> 211;
                            case 13 -> 202;
                            case 14 -> 84;
                            case 15 -> 238;
                            case 16 -> 149;
                            case 17 -> 251;
                            case 18 -> 243;
                            case 19 -> 145;
                            case 20 -> 111;
                            case 21 -> 26;
                            case 22 -> 134;
                            case 23 -> 87;
                            case 24 -> 166;
                            case 25 -> 173;
                            case 26 -> 46;
                            case 27 -> 155;
                            case 28 -> 164;
                            case 29 -> 226;
                            case 30 -> 38;
                            case 31 -> 183;
                            case 32 -> 219;
                            case 33 -> 108;
                            case 34 -> 130;
                            case 35 -> 209;
                            case 36 -> 83;
                            case 37 -> 137;
                            case 38 -> 144;
                            case 39 -> 241;
                            case 40 -> 157;
                            case 41 -> 113;
                            case 42 -> 27;
                            case 43 -> 36;
                            case 44 -> 71;
                            case 45 -> 236;
                            case 46 -> 63;
                            case 47 -> 105;
                            case 48 -> 148;
                            case 49 -> 5;
                            case 50 -> 89;
                            case 51 -> 22;
                            case 52 -> 185;
                            case 53 -> 95;
                            case 54 -> 152;
                            case 55 -> 184;
                            case 56 -> 154;
                            case 57 -> 18;
                            case 58 -> 147;
                            case 59 -> 218;
                            case 60 -> 224;
                            case 61 -> 247;
                            case 62 -> 141;
                            case 63 -> 9;
                            case 64 -> 195;
                            case 65 -> 30;
                            case 66 -> 146;
                            case 67 -> 170;
                            case 68 -> 4;
                            case 69 -> 229;
                            case 70 -> 54;
                            case 71 -> 42;
                            case 72 -> 41;
                            case 73 -> 76;
                            case 74 -> 50;
                            case 75 -> 190;
                            case 76 -> 181;
                            case 77 -> 7;
                            case 78 -> 162;
                            case 79 -> 75;
                            case 80 -> 165;
                            case 81 -> 40;
                            case 82 -> 189;
                            case 83 -> 23;
                            case 84 -> 37;
                            case 85 -> 44;
                            case 86 -> 8;
                            case 87 -> 222;
                            case 88 -> 171;
                            case 89 -> 192;
                            case 90 -> 159;
                            case 91 -> 117;
                            case 92 -> 179;
                            case 93 -> 85;
                            case 94 -> 66;
                            case 95 -> 107;
                            case 96 -> 32;
                            case 97 -> 92;
                            case 98 -> 182;
                            case 99 -> 77;
                            case 100 -> 78;
                            case 101 -> 25;
                            case 102 -> 110;
                            case 103 -> 73;
                            case 104 -> 21;
                            case 105 -> 252;
                            case 106 -> 204;
                            case 107 -> 62;
                            case 108 -> 6;
                            case 109 -> 129;
                            case 110 -> 161;
                            case 111 -> 231;
                            case 112 -> 237;
                            case 113 -> 29;
                            case 114 -> 33;
                            case 115 -> 235;
                            case 116 -> 206;
                            case 117 -> 177;
                            case 118 -> 115;
                            case 119 -> 61;
                            case 120 -> 90;
                            case 121 -> 234;
                            case 122 -> 72;
                            case 123 -> 167;
                            case 124 -> 214;
                            case 125 -> 109;
                            case 126 -> 142;
                            case 127 -> 52;
                            case 128 -> 28;
                            case 129 -> 172;
                            case 130 -> 135;
                            case 131 -> 239;
                            case 132 -> 201;
                            case 133 -> 163;
                            case 134 -> 47;
                            case 135 -> 65;
                            case 136 -> 248;
                            case 137 -> 160;
                            case 138 -> 81;
                            case 139 -> 136;
                            case 140 -> 138;
                            case 141 -> 39;
                            case 142 -> 86;
                            case 143 -> 187;
                            case 144 -> 57;
                            case 145 -> 233;
                            case 146 -> 12;
                            case 147 -> 143;
                            case 148 -> 31;
                            case 149 -> 240;
                            case 150 -> 140;
                            case 151 -> 186;
                            case 152 -> 88;
                            case 153 -> 122;
                            case 154 -> 254;
                            case 155 -> 174;
                            case 156 -> 103;
                            case 157 -> 100;
                            case 158 -> 191;
                            case 159 -> 58;
                            case 160 -> 53;
                            case 161 -> 0;
                            case 162 -> 221;
                            case 163 -> 150;
                            case 164 -> 96;
                            case 165 -> 203;
                            case 166 -> 70;
                            case 167 -> 242;
                            case 168 -> 67;
                            case 169 -> 69;
                            case 170 -> 82;
                            case 171 -> 249;
                            case 172 -> 188;
                            case 173 -> 112;
                            case 174 -> 56;
                            case 175 -> 156;
                            case 176 -> 34;
                            case 177 -> 126;
                            case 178 -> 255;
                            case 179 -> 91;
                            case 180 -> 51;
                            case 181 -> 245;
                            case 182 -> 213;
                            case 183 -> 131;
                            case 184 -> 198;
                            case 185 -> 106;
                            case 186 -> 207;
                            case 187 -> 253;
                            case 188 -> 11;
                            case 189 -> 10;
                            case 190 -> 228;
                            case 191 -> 16;
                            case 192 -> 158;
                            case 193 -> 169;
                            case 194 -> 153;
                            case 195 -> 199;
                            case 196 -> 215;
                            case 197 -> 132;
                            case 198 -> 45;
                            case 199 -> 14;
                            case 200 -> 55;
                            case 201 -> 17;
                            case 202 -> 225;
                            case 203 -> 49;
                            case 204 -> 220;
                            case 205 -> 98;
                            case 206 -> 2;
                            case 207 -> 118;
                            case 208 -> 217;
                            case 209 -> 68;
                            case 210 -> 178;
                            case 211 -> 250;
                            case 212 -> 102;
                            case 213 -> 43;
                            case 214 -> 3;
                            case 215 -> 24;
                            case 216 -> 13;
                            case 217 -> 120;
                            case 218 -> 123;
                            case 219 -> 246;
                            case 220 -> 35;
                            case 221 -> 119;
                            case 222 -> 244;
                            case 223 -> 48;
                            case 224 -> 99;
                            case 225 -> 193;
                            case 226 -> 19;
                            case 227 -> 205;
                            case 228 -> 223;
                            case 229 -> 194;
                            case 230 -> 151;
                            case 231 -> 59;
                            case 232 -> 93;
                            case 233 -> 196;
                            case 234 -> 79;
                            case 235 -> 176;
                            case 236 -> 15;
                            case 237 -> 197;
                            case 238 -> 64;
                            case 239 -> 128;
                            case 240 -> 232;
                            case 241 -> 1;
                            case 242 -> 230;
                            case 243 -> 124;
                            case 244 -> 180;
                            case 245 -> 210;
                            case 246 -> 139;
                            case 247 -> 104;
                            case 248 -> 116;
                            case 249 -> 125;
                            case 250 -> 168;
                            case 251 -> 200;
                            case 252 -> 94;
                            case 253 -> 175;
                            case 254 -> 74;
                            default -> 227;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray == null) {
                ActionTimestamp.P(new String[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 21236851106071L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.P();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1762236150 - -((char)-1332), -1762236150 - -((char)-20753), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1762236150 - -((char)-1336), -1762236150 - -((char)-24105), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1762236150 - -((char)-1345), -1762236150 - -((char)-9612), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1762236150 - -((char)-1332), -1762236150 - -((char)-20753), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1762236150 - -((char)-1336), -1762236150 - -((char)-24105), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1762236150 - -((char)-1340), -1762236150 - -((char)-12628), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 42910014065809L;
                        int[] nArray2 = SshAgentIpcService.P();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1004127270 + -((char)-4719), -1004258340 - -((char)-14975), (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1004127270 + -((char)-4720), 1004258340 - (char)-5813, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 14204992391637L;
                int[] nArray2 = SshAgentIpcService.P();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6502, 1535616120 - (char)-23235, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6506, 1535616120 - (char)-15787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6507, -1535616120 - -((char)-18545), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6506, 1535616120 - (char)-15787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6500, 1535616120 - (char)-4972, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6502, 1535616120 - (char)-23235, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6506, 1535616120 - (char)-15787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6522, 1535616120 - (char)-15170, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6502, 1535616120 - (char)-23235, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6506, 1535616120 - (char)-15787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6521, 1535485050 + (char)-1850, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6502, 1535616120 - (char)-23235, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6506, 1535616120 - (char)-15787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1535485050 + (char)-6520, -1535485050 + -((char)-7475), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 47286596359081L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.P();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5680), -993641670 - -((char)-5619), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5684), -993641670 - -((char)-731), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5703), 993510600 + (char)-11507, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5696), 993641670 - (char)-12609, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5680), -993641670 - -((char)-5619), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5684), -993641670 - -((char)-731), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5697), 993510600 + (char)-16022, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5680), -993641670 - -((char)-5619), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5684), -993641670 - -((char)-731), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5698), 993641670 - (char)-12506, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5680), -993641670 - -((char)-5619), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5684), -993641670 - -((char)-731), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5699), -993641670 - -((char)-1554), (int)l2));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5680), -993641670 - -((char)-5619), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5684), -993641670 - -((char)-731), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5644), -993510600 + -((char)-2295), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-993510600 + -((char)-5645), -993510600 + -((char)-7378), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "5\u00d0\u0084\u00a4\u00c6&06\u0014\u00b8)\r|\t\u00b5f^U\u0012:\u0017\u0096\u00ad\u009f\u0013*-\u0001?\u0006\u0014\u00db\u00a0\u00c5(K\u0018\u00cd)\u00c3LRv\u000f\u00e6\u00b0x\u0089*\u0086\u00f5\u00cf\u009a\u0089u[\u00a9\u0010\u0088\u0081\u00c9\tN\u00dc-C\u00e4\b\u00c1aU\u0005\u008c\u00d9\u00b3\u0085P\b\u00f9\u0094\u001d]\u00a7?\u001a\u00f7\u0014\u00c6\u00b4\u00baT\u0092\u00b8 h\u00f3\tE\u00c03\u00f4\u0090\u00d5\u00d9&\u0086\u001c\u0005\u009cM\u00b1\u0017\u0010\u001e\u0006t\u00f7TE\u00b1Od\u001d<w%\u00154\u001f\u00c6ro\u00f6\u001e\tQ\u00ae?\u0012\u0017\u00c7waL\u0010\u00cb`\u00aa\u0013\u00b9k&\u00c6M\u00da\u00f0\u0004\u00e3Enw\ta\u00d0\u001e\u00d3\u00d1=AX\u00ab\u0010~\u00a1\u001c+ol\u00fc&\u0016\u00c6\u009b\u0087\u008e5\u00c3y?wM\u00d1s\u008c\\\u00f3\u00b5\u00fb\u00d7\u00ee\u00a3\u0099\u0012\u00b3;\"\u00b5\u0081\u0080i\u00d0\u00d9i\u00ec5\u0015\u0087\f\u0004*I\u009fl}: \u0080\u00e8K\u0088\u0004\f\u00d8\u00cc\u00a7-9\u00c1kbo\u00b9\u00ea\u0090\u00cb\u001f\u00fc\u009f|\u0005\u00bd\u00a1\b\u00ab\u00fbW\u00b0\u00ee\u00823@\f\u00f4{\u00ac\u00bb\u008c\u0081\u0091'\u0092\u00aeY\u008eF\u00bfX\u00c5\u00df\u00a1\r4\u00b6&\u0090\u00c5\u008dj\u00df\u00d2\u00a4\u00f2!\u009b\u00bd8%\u00f0\u00e5\u00ff\u008f\u0084\u00db\u0081\u00a6\u00a1!\u00d2\u00d7\u0016l\u0097\u0007\u00b5\u007f\u00b0\u0097\u0080Q\u0083\u0013\u0090\u00d2\u0091\u00ee\u000eu\u00db?\u00caj\u00cb\u00bc\u0093\u00c8\u00b7B\u00abu@&\u000e=\u00f1@\u001fC~_\u0015P\u0099\u00edaI\u009c\u00fd1D\u00ab>\u0084-\u00cf`\u00c0\u0010\nZ\u00ff\u00ed\u00df/\u00a2a\u0007\u00bf\u000b\u0018\u00181\u00d7?\f\u00e7\u0096\\\u0094\u008a\u0015\u00b4\u00a2\u00a4\u0083\u008a\u00ee\u00bd\u00b7)P\u00ecc\u00d8M\u00b0\u000e\u0007\n\u00f8\u00015)\u00ac\u008e\u00a2\u000b\u00efZ\u001a\u0019\u00b7\u0093\"\u00d0\u00bb\u009d_G^?\u00d5yVET\u000eC\u00a8-4\u000e!\u00d0\u00ef\u0002\u00abjn\u0006Z\f}$\u0007\u00a4b\u00a9\u008c\u00aa\u00f7)\u0007\u008d\u009a\u00e8\u00ffev\u00c6(2f=7\u00ac\u00b7\u0084\u0083\u0014\u0017|vS\u00c8\u0000n\u00b2\u00b7\u00e6+Q1\u00dbK\"\u00bc\u00b7\u00cdj~\u0087\u001d\u0013\u009e\u00d6e+F:\r\u000fd\u0000\u00b9\u00d2\u00d4g.Z4\u00a1\u00d9\u00f1Gl\u001c\"\u0005\u00db\u0097\u00a1I\u000f\u00ce\u00b3-\u00c6qz\u00d2\u00c4\u0016\u00a2\u009c\u00aa\u0007\u0089\u00e6[\u00e2\u009d\u0006\u008eH.\u0086Pc\u00c6Z}\u000e}\u00a9\u009a\u00e7\u00b0\u00c1\u00a2\u008e\u00a5;\u00eb\u00a2\r\f\u001b\u00c5\u00c2\u008a\u008fIy\b\u00c5\u00a7\u00d5&~\u00e4\u00a1\u00f6\u0018(W,\u00aa\u00b8\u000bZ1Zv\u0096\n?O\u00119.K7\u00a9\u00eb:\u0018hI?\u00f3\u00feJ\u00df\u00fdC\u001bx8\u0096:DJ\t\u001c\u00df\u00ba\u00beB\u00c1K)R\u00a0}\u00ce\u0014\u00e2e\u000eXq\u00df\u008c\u0000\u001f\u00b7l=/f\u00be\u001a\u00ad\u0094\u001f.\u0018\u001d\u00ce[\"\u00c1\u001e\u0005K_\u00e6~o\u0003\u00db\u00c5\tj\u0010\u007f\u00d5\u00f72\u00d3\u00e2D";
                var4_3 = "5\u00d0\u0084\u00a4\u00c6&06\u0014\u00b8)\r|\t\u00b5f^U\u0012:\u0017\u0096\u00ad\u009f\u0013*-\u0001?\u0006\u0014\u00db\u00a0\u00c5(K\u0018\u00cd)\u00c3LRv\u000f\u00e6\u00b0x\u0089*\u0086\u00f5\u00cf\u009a\u0089u[\u00a9\u0010\u0088\u0081\u00c9\tN\u00dc-C\u00e4\b\u00c1aU\u0005\u008c\u00d9\u00b3\u0085P\b\u00f9\u0094\u001d]\u00a7?\u001a\u00f7\u0014\u00c6\u00b4\u00baT\u0092\u00b8 h\u00f3\tE\u00c03\u00f4\u0090\u00d5\u00d9&\u0086\u001c\u0005\u009cM\u00b1\u0017\u0010\u001e\u0006t\u00f7TE\u00b1Od\u001d<w%\u00154\u001f\u00c6ro\u00f6\u001e\tQ\u00ae?\u0012\u0017\u00c7waL\u0010\u00cb`\u00aa\u0013\u00b9k&\u00c6M\u00da\u00f0\u0004\u00e3Enw\ta\u00d0\u001e\u00d3\u00d1=AX\u00ab\u0010~\u00a1\u001c+ol\u00fc&\u0016\u00c6\u009b\u0087\u008e5\u00c3y?wM\u00d1s\u008c\\\u00f3\u00b5\u00fb\u00d7\u00ee\u00a3\u0099\u0012\u00b3;\"\u00b5\u0081\u0080i\u00d0\u00d9i\u00ec5\u0015\u0087\f\u0004*I\u009fl}: \u0080\u00e8K\u0088\u0004\f\u00d8\u00cc\u00a7-9\u00c1kbo\u00b9\u00ea\u0090\u00cb\u001f\u00fc\u009f|\u0005\u00bd\u00a1\b\u00ab\u00fbW\u00b0\u00ee\u00823@\f\u00f4{\u00ac\u00bb\u008c\u0081\u0091'\u0092\u00aeY\u008eF\u00bfX\u00c5\u00df\u00a1\r4\u00b6&\u0090\u00c5\u008dj\u00df\u00d2\u00a4\u00f2!\u009b\u00bd8%\u00f0\u00e5\u00ff\u008f\u0084\u00db\u0081\u00a6\u00a1!\u00d2\u00d7\u0016l\u0097\u0007\u00b5\u007f\u00b0\u0097\u0080Q\u0083\u0013\u0090\u00d2\u0091\u00ee\u000eu\u00db?\u00caj\u00cb\u00bc\u0093\u00c8\u00b7B\u00abu@&\u000e=\u00f1@\u001fC~_\u0015P\u0099\u00edaI\u009c\u00fd1D\u00ab>\u0084-\u00cf`\u00c0\u0010\nZ\u00ff\u00ed\u00df/\u00a2a\u0007\u00bf\u000b\u0018\u00181\u00d7?\f\u00e7\u0096\\\u0094\u008a\u0015\u00b4\u00a2\u00a4\u0083\u008a\u00ee\u00bd\u00b7)P\u00ecc\u00d8M\u00b0\u000e\u0007\n\u00f8\u00015)\u00ac\u008e\u00a2\u000b\u00efZ\u001a\u0019\u00b7\u0093\"\u00d0\u00bb\u009d_G^?\u00d5yVET\u000eC\u00a8-4\u000e!\u00d0\u00ef\u0002\u00abjn\u0006Z\f}$\u0007\u00a4b\u00a9\u008c\u00aa\u00f7)\u0007\u008d\u009a\u00e8\u00ffev\u00c6(2f=7\u00ac\u00b7\u0084\u0083\u0014\u0017|vS\u00c8\u0000n\u00b2\u00b7\u00e6+Q1\u00dbK\"\u00bc\u00b7\u00cdj~\u0087\u001d\u0013\u009e\u00d6e+F:\r\u000fd\u0000\u00b9\u00d2\u00d4g.Z4\u00a1\u00d9\u00f1Gl\u001c\"\u0005\u00db\u0097\u00a1I\u000f\u00ce\u00b3-\u00c6qz\u00d2\u00c4\u0016\u00a2\u009c\u00aa\u0007\u0089\u00e6[\u00e2\u009d\u0006\u008eH.\u0086Pc\u00c6Z}\u000e}\u00a9\u009a\u00e7\u00b0\u00c1\u00a2\u008e\u00a5;\u00eb\u00a2\r\f\u001b\u00c5\u00c2\u008a\u008fIy\b\u00c5\u00a7\u00d5&~\u00e4\u00a1\u00f6\u0018(W,\u00aa\u00b8\u000bZ1Zv\u0096\n?O\u00119.K7\u00a9\u00eb:\u0018hI?\u00f3\u00feJ\u00df\u00fdC\u001bx8\u0096:DJ\t\u001c\u00df\u00ba\u00beB\u00c1K)R\u00a0}\u00ce\u0014\u00e2e\u000eXq\u00df\u008c\u0000\u001f\u00b7l=/f\u00be\u001a\u00ad\u0094\u001f.\u0018\u001d\u00ce[\"\u00c1\u001e\u0005K_\u00e6~o\u0003\u00db\u00c5\tj\u0010\u007f\u00d5\u00f72\u00d3\u00e2D".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 54;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b3\u001f\u0000x\u00fau\u00f9\u00bd\u008aF\u00c4+\"\u00aa\u00b2\u009b\u00dc\u009cK\r\u00ab\u00a5\u0010\u0081T\u0096\u0082\u001by\u0014\u0096|\u0089\u0097\u00d8\u0089\u001d\u0098{\u008b\u00beeG\u00a2\u00e4\u00b3\u0004x\u0085\u00d4";
                    var4_3 = "\u00b3\u001f\u0000x\u00fau\u00f9\u00bd\u008aF\u00c4+\"\u00aa\u00b2\u009b\u00dc\u009cK\r\u00ab\u00a5\u0010\u0081T\u0096\u0082\u001by\u0014\u0096|\u0089\u0097\u00d8\u0089\u001d\u0098{\u008b\u00beeG\u00a2\u00e4\u00b3\u0004x\u0085\u00d4".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 126;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 70;
                            break;
                        }
                        case 1: {
                            v15 = 3;
                            break;
                        }
                        case 2: {
                            v15 = 20;
                            break;
                        }
                        case 3: {
                            v15 = 15;
                            break;
                        }
                        case 4: {
                            v15 = 10;
                            break;
                        }
                        case 5: {
                            v15 = 11;
                            break;
                        }
                        default: {
                            v15 = 119;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x2CD) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 11;
                case 1 -> 66;
                case 2 -> 222;
                case 3 -> 244;
                case 4 -> 25;
                case 5 -> 224;
                case 6 -> 233;
                case 7 -> 250;
                case 8 -> 79;
                case 9 -> 109;
                case 10 -> 1;
                case 11 -> 176;
                case 12 -> 148;
                case 13 -> 53;
                case 14 -> 133;
                case 15 -> 73;
                case 16 -> 210;
                case 17 -> 135;
                case 18 -> 26;
                case 19 -> 36;
                case 20 -> 65;
                case 21 -> 147;
                case 22 -> 156;
                case 23 -> 3;
                case 24 -> 121;
                case 25 -> 168;
                case 26 -> 97;
                case 27 -> 106;
                case 28 -> 4;
                case 29 -> 150;
                case 30 -> 101;
                case 31 -> 206;
                case 32 -> 92;
                case 33 -> 87;
                case 34 -> 241;
                case 35 -> 232;
                case 36 -> 6;
                case 37 -> 155;
                case 38 -> 167;
                case 39 -> 68;
                case 40 -> 159;
                case 41 -> 20;
                case 42 -> 247;
                case 43 -> 56;
                case 44 -> 238;
                case 45 -> 223;
                case 46 -> 51;
                case 47 -> 23;
                case 48 -> 38;
                case 49 -> 236;
                case 50 -> 248;
                case 51 -> 5;
                case 52 -> 196;
                case 53 -> 209;
                case 54 -> 100;
                case 55 -> 52;
                case 56 -> 48;
                case 57 -> 98;
                case 58 -> 88;
                case 59 -> 140;
                case 60 -> 27;
                case 61 -> 77;
                case 62 -> 13;
                case 63 -> 240;
                case 64 -> 9;
                case 65 -> 145;
                case 66 -> 96;
                case 67 -> 29;
                case 68 -> 46;
                case 69 -> 8;
                case 70 -> 39;
                case 71 -> 112;
                case 72 -> 119;
                case 73 -> 182;
                case 74 -> 193;
                case 75 -> 19;
                case 76 -> 151;
                case 77 -> 118;
                case 78 -> 59;
                case 79 -> 75;
                case 80 -> 220;
                case 81 -> 34;
                case 82 -> 130;
                case 83 -> 81;
                case 84 -> 171;
                case 85 -> 161;
                case 86 -> 225;
                case 87 -> 153;
                case 88 -> 138;
                case 89 -> 84;
                case 90 -> 110;
                case 91 -> 2;
                case 92 -> 185;
                case 93 -> 162;
                case 94 -> 163;
                case 95 -> 76;
                case 96 -> 234;
                case 97 -> 35;
                case 98 -> 58;
                case 99 -> 154;
                case 100 -> 219;
                case 101 -> 108;
                case 102 -> 177;
                case 103 -> 157;
                case 104 -> 214;
                case 105 -> 230;
                case 106 -> 200;
                case 107 -> 49;
                case 108 -> 21;
                case 109 -> 174;
                case 110 -> 190;
                case 111 -> 164;
                case 112 -> 149;
                case 113 -> 229;
                case 114 -> 115;
                case 115 -> 242;
                case 116 -> 94;
                case 117 -> 70;
                case 118 -> 254;
                case 119 -> 246;
                case 120 -> 235;
                case 121 -> 202;
                case 122 -> 218;
                case 123 -> 44;
                case 124 -> 114;
                case 125 -> 14;
                case 126 -> 181;
                case 127 -> 95;
                case 128 -> 28;
                case 129 -> 83;
                case 130 -> 152;
                case 131 -> 24;
                case 132 -> 165;
                case 133 -> 136;
                case 134 -> 62;
                case 135 -> 93;
                case 136 -> 211;
                case 137 -> 201;
                case 138 -> 183;
                case 139 -> 213;
                case 140 -> 104;
                case 141 -> 143;
                case 142 -> 255;
                case 143 -> 86;
                case 144 -> 175;
                case 145 -> 180;
                case 146 -> 243;
                case 147 -> 17;
                case 148 -> 0;
                case 149 -> 203;
                case 150 -> 42;
                case 151 -> 249;
                case 152 -> 172;
                case 153 -> 221;
                case 154 -> 85;
                case 155 -> 89;
                case 156 -> 105;
                case 157 -> 12;
                case 158 -> 252;
                case 159 -> 195;
                case 160 -> 144;
                case 161 -> 117;
                case 162 -> 169;
                case 163 -> 41;
                case 164 -> 128;
                case 165 -> 22;
                case 166 -> 191;
                case 167 -> 43;
                case 168 -> 32;
                case 169 -> 126;
                case 170 -> 226;
                case 171 -> 194;
                case 172 -> 227;
                case 173 -> 129;
                case 174 -> 188;
                case 175 -> 69;
                case 176 -> 124;
                case 177 -> 198;
                case 178 -> 47;
                case 179 -> 178;
                case 180 -> 7;
                case 181 -> 237;
                case 182 -> 74;
                case 183 -> 91;
                case 184 -> 30;
                case 185 -> 55;
                case 186 -> 71;
                case 187 -> 125;
                case 188 -> 15;
                case 189 -> 33;
                case 190 -> 18;
                case 191 -> 103;
                case 192 -> 45;
                case 193 -> 134;
                case 194 -> 199;
                case 195 -> 64;
                case 196 -> 107;
                case 197 -> 204;
                case 198 -> 160;
                case 199 -> 10;
                case 200 -> 72;
                case 201 -> 82;
                case 202 -> 16;
                case 203 -> 132;
                case 204 -> 197;
                case 205 -> 231;
                case 206 -> 127;
                case 207 -> 37;
                case 208 -> 253;
                case 209 -> 78;
                case 210 -> 137;
                case 211 -> 179;
                case 212 -> 40;
                case 213 -> 57;
                case 214 -> 239;
                case 215 -> 146;
                case 216 -> 245;
                case 217 -> 31;
                case 218 -> 131;
                case 219 -> 80;
                case 220 -> 187;
                case 221 -> 111;
                case 222 -> 166;
                case 223 -> 158;
                case 224 -> 123;
                case 225 -> 99;
                case 226 -> 50;
                case 227 -> 122;
                case 228 -> 120;
                case 229 -> 102;
                case 230 -> 208;
                case 231 -> 184;
                case 232 -> 228;
                case 233 -> 139;
                case 234 -> 217;
                case 235 -> 216;
                case 236 -> 90;
                case 237 -> 63;
                case 238 -> 205;
                case 239 -> 113;
                case 240 -> 173;
                case 241 -> 116;
                case 242 -> 207;
                case 243 -> 212;
                case 244 -> 61;
                case 245 -> 170;
                case 246 -> 142;
                case 247 -> 189;
                case 248 -> 60;
                case 249 -> 67;
                case 250 -> 54;
                case 251 -> 251;
                case 252 -> 192;
                case 253 -> 186;
                case 254 -> 141;
                default -> 215;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 47094746822180L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(430433880 - 10293, -430433880 - -14142, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 24298264045288L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.P();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1634049690 + 4180, 1634049690 + 7989, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1634049690 + 4179, -1634049690 - -6922, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1634049690 + 4178, -1634049690 + -3335, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "qb\u0088~&\t\u00cb=\u0010\u0090\u00f0E\u008d%\u00ccR\u00dcP\u001d\u00df\u009dr\u0091\u00b2~";
                    var4_3 = "qb\u0088~&\t\u00cb=\u0010\u0090\u00f0E\u008d%\u00ccR\u00dcP\u001d\u00df\u009dr\u0091\u00b2~".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 49;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00df\u00d6u\u00c0\u00c15U\u00d43\u00ec\u00db\u00f1\u00bd\u00f8\u00f2\n1\u0097p\u0012\u00df\u00ac\u001d*\u00b8\u00be\u009dTP\u0001\u0018\u00de\u00c8\u001f\u00e1\u009c\u00ea\u00b92\u0092\u0003b\u0091\r>\u00d8\u00be\u0096\u009b\u00d9\u00c7\u00c8\u00f7\u001a\u00e1?\u00cel\u00cd";
                        var4_3 = "\u00df\u00d6u\u00c0\u00c15U\u00d43\u00ec\u00db\u00f1\u00bd\u00f8\u00f2\n1\u0097p\u0012\u00df\u00ac\u001d*\u00b8\u00be\u009dTP\u0001\u0018\u00de\u00c8\u001f\u00e1\u009c\u00ea\u00b92\u0092\u0003b\u0091\r>\u00d8\u00be\u0096\u009b\u00d9\u00c7\u00c8\u00f7\u001a\u00e1?\u00cel\u00cd".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 56;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 44;
                                break;
                            }
                            case 1: {
                                v15 = 122;
                                break;
                            }
                            case 2: {
                                v15 = 58;
                                break;
                            }
                            case 3: {
                                v15 = 75;
                                break;
                            }
                            case 4: {
                                v15 = 73;
                                break;
                            }
                            case 5: {
                                v15 = 16;
                                break;
                            }
                            default: {
                                v15 = 31;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x807) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 130;
                    case 1 -> 189;
                    case 2 -> 50;
                    case 3 -> 23;
                    case 4 -> 18;
                    case 5 -> 220;
                    case 6 -> 109;
                    case 7 -> 198;
                    case 8 -> 129;
                    case 9 -> 100;
                    case 10 -> 91;
                    case 11 -> 53;
                    case 12 -> 24;
                    case 13 -> 181;
                    case 14 -> 253;
                    case 15 -> 115;
                    case 16 -> 113;
                    case 17 -> 233;
                    case 18 -> 174;
                    case 19 -> 190;
                    case 20 -> 97;
                    case 21 -> 151;
                    case 22 -> 235;
                    case 23 -> 80;
                    case 24 -> 185;
                    case 25 -> 204;
                    case 26 -> 93;
                    case 27 -> 212;
                    case 28 -> 159;
                    case 29 -> 158;
                    case 30 -> 96;
                    case 31 -> 238;
                    case 32 -> 19;
                    case 33 -> 162;
                    case 34 -> 161;
                    case 35 -> 153;
                    case 36 -> 69;
                    case 37 -> 133;
                    case 38 -> 81;
                    case 39 -> 165;
                    case 40 -> 47;
                    case 41 -> 207;
                    case 42 -> 152;
                    case 43 -> 95;
                    case 44 -> 171;
                    case 45 -> 197;
                    case 46 -> 121;
                    case 47 -> 52;
                    case 48 -> 120;
                    case 49 -> 248;
                    case 50 -> 146;
                    case 51 -> 217;
                    case 52 -> 92;
                    case 53 -> 157;
                    case 54 -> 132;
                    case 55 -> 41;
                    case 56 -> 218;
                    case 57 -> 6;
                    case 58 -> 73;
                    case 59 -> 31;
                    case 60 -> 11;
                    case 61 -> 48;
                    case 62 -> 22;
                    case 63 -> 43;
                    case 64 -> 223;
                    case 65 -> 60;
                    case 66 -> 101;
                    case 67 -> 72;
                    case 68 -> 122;
                    case 69 -> 172;
                    case 70 -> 134;
                    case 71 -> 125;
                    case 72 -> 74;
                    case 73 -> 182;
                    case 74 -> 77;
                    case 75 -> 138;
                    case 76 -> 117;
                    case 77 -> 188;
                    case 78 -> 254;
                    case 79 -> 63;
                    case 80 -> 90;
                    case 81 -> 237;
                    case 82 -> 59;
                    case 83 -> 154;
                    case 84 -> 105;
                    case 85 -> 9;
                    case 86 -> 16;
                    case 87 -> 150;
                    case 88 -> 219;
                    case 89 -> 70;
                    case 90 -> 186;
                    case 91 -> 206;
                    case 92 -> 149;
                    case 93 -> 232;
                    case 94 -> 201;
                    case 95 -> 14;
                    case 96 -> 200;
                    case 97 -> 30;
                    case 98 -> 175;
                    case 99 -> 225;
                    case 100 -> 247;
                    case 101 -> 37;
                    case 102 -> 66;
                    case 103 -> 222;
                    case 104 -> 242;
                    case 105 -> 62;
                    case 106 -> 209;
                    case 107 -> 230;
                    case 108 -> 166;
                    case 109 -> 145;
                    case 110 -> 147;
                    case 111 -> 116;
                    case 112 -> 210;
                    case 113 -> 123;
                    case 114 -> 231;
                    case 115 -> 131;
                    case 116 -> 180;
                    case 117 -> 191;
                    case 118 -> 192;
                    case 119 -> 82;
                    case 120 -> 51;
                    case 121 -> 245;
                    case 122 -> 168;
                    case 123 -> 184;
                    case 124 -> 104;
                    case 125 -> 20;
                    case 126 -> 88;
                    case 127 -> 110;
                    case 128 -> 241;
                    case 129 -> 136;
                    case 130 -> 32;
                    case 131 -> 163;
                    case 132 -> 137;
                    case 133 -> 250;
                    case 134 -> 127;
                    case 135 -> 203;
                    case 136 -> 215;
                    case 137 -> 4;
                    case 138 -> 118;
                    case 139 -> 86;
                    case 140 -> 42;
                    case 141 -> 61;
                    case 142 -> 33;
                    case 143 -> 148;
                    case 144 -> 255;
                    case 145 -> 111;
                    case 146 -> 156;
                    case 147 -> 79;
                    case 148 -> 26;
                    case 149 -> 83;
                    case 150 -> 139;
                    case 151 -> 239;
                    case 152 -> 179;
                    case 153 -> 224;
                    case 154 -> 108;
                    case 155 -> 38;
                    case 156 -> 45;
                    case 157 -> 194;
                    case 158 -> 164;
                    case 159 -> 35;
                    case 160 -> 85;
                    case 161 -> 28;
                    case 162 -> 176;
                    case 163 -> 15;
                    case 164 -> 195;
                    case 165 -> 143;
                    case 166 -> 216;
                    case 167 -> 178;
                    case 168 -> 0;
                    case 169 -> 229;
                    case 170 -> 25;
                    case 171 -> 55;
                    case 172 -> 49;
                    case 173 -> 78;
                    case 174 -> 102;
                    case 175 -> 71;
                    case 176 -> 114;
                    case 177 -> 244;
                    case 178 -> 227;
                    case 179 -> 142;
                    case 180 -> 177;
                    case 181 -> 1;
                    case 182 -> 236;
                    case 183 -> 140;
                    case 184 -> 57;
                    case 185 -> 144;
                    case 186 -> 21;
                    case 187 -> 84;
                    case 188 -> 106;
                    case 189 -> 160;
                    case 190 -> 10;
                    case 191 -> 67;
                    case 192 -> 68;
                    case 193 -> 29;
                    case 194 -> 54;
                    case 195 -> 27;
                    case 196 -> 252;
                    case 197 -> 65;
                    case 198 -> 103;
                    case 199 -> 17;
                    case 200 -> 226;
                    case 201 -> 46;
                    case 202 -> 58;
                    case 203 -> 221;
                    case 204 -> 249;
                    case 205 -> 119;
                    case 206 -> 199;
                    case 207 -> 213;
                    case 208 -> 7;
                    case 209 -> 141;
                    case 210 -> 187;
                    case 211 -> 135;
                    case 212 -> 126;
                    case 213 -> 128;
                    case 214 -> 87;
                    case 215 -> 202;
                    case 216 -> 211;
                    case 217 -> 112;
                    case 218 -> 228;
                    case 219 -> 89;
                    case 220 -> 39;
                    case 221 -> 183;
                    case 222 -> 5;
                    case 223 -> 44;
                    case 224 -> 205;
                    case 225 -> 36;
                    case 226 -> 40;
                    case 227 -> 246;
                    case 228 -> 251;
                    case 229 -> 124;
                    case 230 -> 13;
                    case 231 -> 99;
                    case 232 -> 155;
                    case 233 -> 208;
                    case 234 -> 173;
                    case 235 -> 98;
                    case 236 -> 12;
                    case 237 -> 3;
                    case 238 -> 234;
                    case 239 -> 64;
                    case 240 -> 243;
                    case 241 -> 240;
                    case 242 -> 170;
                    case 243 -> 75;
                    case 244 -> 107;
                    case 245 -> 169;
                    case 246 -> 56;
                    case 247 -> 214;
                    case 248 -> 76;
                    case 249 -> 34;
                    case 250 -> 2;
                    case 251 -> 94;
                    case 252 -> 8;
                    case 253 -> 196;
                    case 254 -> 193;
                    default -> 167;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 106277159317981L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "]Z\u0011:L\bN\u0004\tZP\u00020\u0001JS\u0018\u0016";
                    var5_4 = "]Z\u0011:L\bN\u0004\tZP\u00020\u0001JS\u0018\u0016".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 45;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 27;
                                    break;
                                }
                                case 1: {
                                    v11 = 18;
                                    break;
                                }
                                case 2: {
                                    v11 = 78;
                                    break;
                                }
                                case 3: {
                                    v11 = 121;
                                    break;
                                }
                                case 4: {
                                    v11 = 4;
                                    break;
                                }
                                case 5: {
                                    v11 = 73;
                                    break;
                                }
                                default: {
                                    v11 = 80;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 67604642821285L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "YS\u001f06\u0006L\u0004_M\u0013*\nSR\u0018*:\u0004TyS\u0011\tSR\u0018*:\u0004TuY\rTT\u0005'0\tNu^\u0002-1\u0000";
                    var5_4 = "YS\u001f06\u0006L\u0004_M\u0013*\nSR\u0018*:\u0004TyS\u0011\tSR\u0018*:\u0004TuY\rTT\u0005'0\tNu^\u0002-1\u0000".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 108;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "31yWVi'\u000631yWZc";
                        var5_4 = "31yWVi'\u000631yWZc".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 12;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 124;
                                break;
                            }
                            case 1: {
                                v15 = 81;
                                break;
                            }
                            case 2: {
                                v15 = 26;
                                break;
                            }
                            case 3: {
                                v15 = 40;
                                break;
                            }
                            case 4: {
                                v15 = 51;
                                break;
                            }
                            case 5: {
                                v15 = 11;
                                break;
                            }
                            default: {
                                v15 = 76;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 136438758980530L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-532930620 - -((char)-10197), 532930620 - (char)-23152, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 54056997560318L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00b4`\u00c0\u009d7\u0003\u00ff'\u001d\u0005\u0088(aP\u00e0\r\u00fa6\u0019\u00d9\u001a\u00ef\u00adF\u00aa\u001c\u0004{\u00d3\u0010\u001dW\"\u001eB\u0082\u008d\u00d6g\u008a^\u00e4~\u008d\u00f01\u0005$\u0003\u00f45R3Bj)o\u00f6\u00e8+\u008f\u00ce\\\u00e0\u0017o\u00a2\u00fe\u00cb\u00f7\u00921\u00bd\u0010\u00d9c\u00c6\u00fa\u001ai\u00ca\u0080v\u0007\u00f6\u00ed\u00c9\u0003\u0089\u008f\u00cc\u0002I\u00b0\u00e5\u00a0a/\u00e2'ai\u008b\u00cb";
                    var4_3 = "\u00b4`\u00c0\u009d7\u0003\u00ff'\u001d\u0005\u0088(aP\u00e0\r\u00fa6\u0019\u00d9\u001a\u00ef\u00adF\u00aa\u001c\u0004{\u00d3\u0010\u001dW\"\u001eB\u0082\u008d\u00d6g\u008a^\u00e4~\u008d\u00f01\u0005$\u0003\u00f45R3Bj)o\u00f6\u00e8+\u008f\u00ce\\\u00e0\u0017o\u00a2\u00fe\u00cb\u00f7\u00921\u00bd\u0010\u00d9c\u00c6\u00fa\u001ai\u00ca\u0080v\u0007\u00f6\u00ed\u00c9\u0003\u0089\u008f\u00cc\u0002I\u00b0\u00e5\u00a0a/\u00e2'ai\u008b\u00cb".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 49;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d6\u00c9|\u00ea\u00ae;7\u00c6\u0017\u00afwg|\u00da\u0097\u00fcL\u00f3\u00d6/\u00c3\u00ee\u00d6Q\u0015RFs\u00e3\u00f2\u00c4\u00d5F\u00b0\u00d5\u0001\u0084Y\u00bdG\u00cfz\u00f7{\u0096\u001f\u0093<\u0002\u00bd\u009e_X\u0011\u000f\u00ccpx\u0018Q\u0084#\u00a7J\u00d6\u0011n\u000b\u000bwr\u00d9\u00d98\u0012\u00c1T7\u00af\u00bc\u00b7\u00af\u000b\u00c54N\u00c5\u0014\u00b6g\u00f4\u00f67";
                        var4_3 = "\u00d6\u00c9|\u00ea\u00ae;7\u00c6\u0017\u00afwg|\u00da\u0097\u00fcL\u00f3\u00d6/\u00c3\u00ee\u00d6Q\u0015RFs\u00e3\u00f2\u00c4\u00d5F\u00b0\u00d5\u0001\u0084Y\u00bdG\u00cfz\u00f7{\u0096\u001f\u0093<\u0002\u00bd\u009e_X\u0011\u000f\u00ccpx\u0018Q\u0084#\u00a7J\u00d6\u0011n\u000b\u000bwr\u00d9\u00d98\u0012\u00c1T7\u00af\u00bc\u00b7\u00af\u000b\u00c54N\u00c5\u0014\u00b6g\u00f4\u00f67".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 91;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 96;
                                break;
                            }
                            case 1: {
                                v15 = 81;
                                break;
                            }
                            case 2: {
                                v15 = 101;
                                break;
                            }
                            case 3: {
                                v15 = 73;
                                break;
                            }
                            case 4: {
                                v15 = 41;
                                break;
                            }
                            case 5: {
                                v15 = 108;
                                break;
                            }
                            default: {
                                v15 = 32;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCC5D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 249;
                    case 1 -> 229;
                    case 2 -> 118;
                    case 3 -> 41;
                    case 4 -> 210;
                    case 5 -> 162;
                    case 6 -> 181;
                    case 7 -> 212;
                    case 8 -> 14;
                    case 9 -> 33;
                    case 10 -> 151;
                    case 11 -> 245;
                    case 12 -> 76;
                    case 13 -> 168;
                    case 14 -> 82;
                    case 15 -> 89;
                    case 16 -> 213;
                    case 17 -> 133;
                    case 18 -> 3;
                    case 19 -> 2;
                    case 20 -> 158;
                    case 21 -> 48;
                    case 22 -> 61;
                    case 23 -> 71;
                    case 24 -> 207;
                    case 25 -> 219;
                    case 26 -> 250;
                    case 27 -> 159;
                    case 28 -> 7;
                    case 29 -> 22;
                    case 30 -> 146;
                    case 31 -> 188;
                    case 32 -> 191;
                    case 33 -> 0;
                    case 34 -> 153;
                    case 35 -> 231;
                    case 36 -> 169;
                    case 37 -> 57;
                    case 38 -> 124;
                    case 39 -> 227;
                    case 40 -> 135;
                    case 41 -> 241;
                    case 42 -> 64;
                    case 43 -> 150;
                    case 44 -> 78;
                    case 45 -> 120;
                    case 46 -> 185;
                    case 47 -> 81;
                    case 48 -> 205;
                    case 49 -> 128;
                    case 50 -> 224;
                    case 51 -> 58;
                    case 52 -> 209;
                    case 53 -> 166;
                    case 54 -> 37;
                    case 55 -> 163;
                    case 56 -> 125;
                    case 57 -> 25;
                    case 58 -> 98;
                    case 59 -> 51;
                    case 60 -> 114;
                    case 61 -> 96;
                    case 62 -> 244;
                    case 63 -> 215;
                    case 64 -> 55;
                    case 65 -> 152;
                    case 66 -> 123;
                    case 67 -> 36;
                    case 68 -> 172;
                    case 69 -> 86;
                    case 70 -> 247;
                    case 71 -> 220;
                    case 72 -> 238;
                    case 73 -> 42;
                    case 74 -> 105;
                    case 75 -> 182;
                    case 76 -> 202;
                    case 77 -> 235;
                    case 78 -> 12;
                    case 79 -> 18;
                    case 80 -> 180;
                    case 81 -> 149;
                    case 82 -> 21;
                    case 83 -> 236;
                    case 84 -> 226;
                    case 85 -> 134;
                    case 86 -> 208;
                    case 87 -> 173;
                    case 88 -> 157;
                    case 89 -> 223;
                    case 90 -> 88;
                    case 91 -> 53;
                    case 92 -> 40;
                    case 93 -> 23;
                    case 94 -> 94;
                    case 95 -> 195;
                    case 96 -> 43;
                    case 97 -> 253;
                    case 98 -> 34;
                    case 99 -> 243;
                    case 100 -> 26;
                    case 101 -> 80;
                    case 102 -> 99;
                    case 103 -> 179;
                    case 104 -> 62;
                    case 105 -> 127;
                    case 106 -> 161;
                    case 107 -> 54;
                    case 108 -> 174;
                    case 109 -> 30;
                    case 110 -> 47;
                    case 111 -> 206;
                    case 112 -> 200;
                    case 113 -> 31;
                    case 114 -> 225;
                    case 115 -> 97;
                    case 116 -> 16;
                    case 117 -> 198;
                    case 118 -> 74;
                    case 119 -> 32;
                    case 120 -> 93;
                    case 121 -> 117;
                    case 122 -> 194;
                    case 123 -> 165;
                    case 124 -> 115;
                    case 125 -> 164;
                    case 126 -> 155;
                    case 127 -> 183;
                    case 128 -> 107;
                    case 129 -> 87;
                    case 130 -> 113;
                    case 131 -> 68;
                    case 132 -> 237;
                    case 133 -> 111;
                    case 134 -> 69;
                    case 135 -> 199;
                    case 136 -> 95;
                    case 137 -> 187;
                    case 138 -> 221;
                    case 139 -> 90;
                    case 140 -> 228;
                    case 141 -> 190;
                    case 142 -> 193;
                    case 143 -> 196;
                    case 144 -> 132;
                    case 145 -> 106;
                    case 146 -> 91;
                    case 147 -> 144;
                    case 148 -> 136;
                    case 149 -> 11;
                    case 150 -> 56;
                    case 151 -> 4;
                    case 152 -> 177;
                    case 153 -> 192;
                    case 154 -> 101;
                    case 155 -> 218;
                    case 156 -> 156;
                    case 157 -> 45;
                    case 158 -> 139;
                    case 159 -> 17;
                    case 160 -> 110;
                    case 161 -> 46;
                    case 162 -> 147;
                    case 163 -> 143;
                    case 164 -> 131;
                    case 165 -> 138;
                    case 166 -> 201;
                    case 167 -> 75;
                    case 168 -> 137;
                    case 169 -> 242;
                    case 170 -> 141;
                    case 171 -> 203;
                    case 172 -> 108;
                    case 173 -> 77;
                    case 174 -> 233;
                    case 175 -> 8;
                    case 176 -> 5;
                    case 177 -> 130;
                    case 178 -> 186;
                    case 179 -> 44;
                    case 180 -> 28;
                    case 181 -> 252;
                    case 182 -> 222;
                    case 183 -> 116;
                    case 184 -> 66;
                    case 185 -> 27;
                    case 186 -> 234;
                    case 187 -> 50;
                    case 188 -> 24;
                    case 189 -> 59;
                    case 190 -> 13;
                    case 191 -> 197;
                    case 192 -> 145;
                    case 193 -> 167;
                    case 194 -> 142;
                    case 195 -> 216;
                    case 196 -> 109;
                    case 197 -> 10;
                    case 198 -> 35;
                    case 199 -> 204;
                    case 200 -> 255;
                    case 201 -> 126;
                    case 202 -> 254;
                    case 203 -> 72;
                    case 204 -> 175;
                    case 205 -> 119;
                    case 206 -> 63;
                    case 207 -> 189;
                    case 208 -> 176;
                    case 209 -> 92;
                    case 210 -> 246;
                    case 211 -> 160;
                    case 212 -> 112;
                    case 213 -> 102;
                    case 214 -> 170;
                    case 215 -> 52;
                    case 216 -> 70;
                    case 217 -> 129;
                    case 218 -> 104;
                    case 219 -> 171;
                    case 220 -> 240;
                    case 221 -> 83;
                    case 222 -> 60;
                    case 223 -> 73;
                    case 224 -> 79;
                    case 225 -> 214;
                    case 226 -> 65;
                    case 227 -> 15;
                    case 228 -> 140;
                    case 229 -> 154;
                    case 230 -> 67;
                    case 231 -> 122;
                    case 232 -> 1;
                    case 233 -> 230;
                    case 234 -> 19;
                    case 235 -> 29;
                    case 236 -> 39;
                    case 237 -> 100;
                    case 238 -> 148;
                    case 239 -> 251;
                    case 240 -> 184;
                    case 241 -> 239;
                    case 242 -> 20;
                    case 243 -> 178;
                    case 244 -> 9;
                    case 245 -> 232;
                    case 246 -> 85;
                    case 247 -> 121;
                    case 248 -> 49;
                    case 249 -> 6;
                    case 250 -> 84;
                    case 251 -> 103;
                    case 252 -> 217;
                    case 253 -> 38;
                    case 254 -> 248;
                    default -> 211;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 40390600655139L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-728224920 - -937, -728224920 + -4266, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 93105858406027L;
                    int[] nArray = SshAgentIpcService.P();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(442623390 + 25370, -442623390 + -13145, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 2225627379876L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00b3\u00d0\u0010\u00cdN\u0003s\u009a^";
                var4_3 = "\u00b3\u00d0\u0010\u00cdN\u0003s\u009a^".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 86;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 12;
                                break;
                            }
                            case 1: {
                                v11 = 103;
                                break;
                            }
                            case 2: {
                                v11 = 83;
                                break;
                            }
                            case 3: {
                                v11 = 66;
                                break;
                            }
                            case 4: {
                                v11 = 7;
                                break;
                            }
                            case 5: {
                                v11 = 92;
                                break;
                            }
                            default: {
                                v11 = 108;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFAE32) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 192;
                    case 1 -> 36;
                    case 2 -> 12;
                    case 3 -> 250;
                    case 4 -> 112;
                    case 5 -> 242;
                    case 6 -> 102;
                    case 7 -> 144;
                    case 8 -> 185;
                    case 9 -> 33;
                    case 10 -> 143;
                    case 11 -> 127;
                    case 12 -> 180;
                    case 13 -> 219;
                    case 14 -> 90;
                    case 15 -> 194;
                    case 16 -> 224;
                    case 17 -> 44;
                    case 18 -> 203;
                    case 19 -> 186;
                    case 20 -> 2;
                    case 21 -> 149;
                    case 22 -> 146;
                    case 23 -> 235;
                    case 24 -> 119;
                    case 25 -> 85;
                    case 26 -> 164;
                    case 27 -> 134;
                    case 28 -> 31;
                    case 29 -> 67;
                    case 30 -> 172;
                    case 31 -> 114;
                    case 32 -> 165;
                    case 33 -> 124;
                    case 34 -> 159;
                    case 35 -> 179;
                    case 36 -> 82;
                    case 37 -> 174;
                    case 38 -> 109;
                    case 39 -> 117;
                    case 40 -> 232;
                    case 41 -> 40;
                    case 42 -> 96;
                    case 43 -> 68;
                    case 44 -> 141;
                    case 45 -> 197;
                    case 46 -> 7;
                    case 47 -> 58;
                    case 48 -> 142;
                    case 49 -> 137;
                    case 50 -> 56;
                    case 51 -> 30;
                    case 52 -> 158;
                    case 53 -> 77;
                    case 54 -> 152;
                    case 55 -> 216;
                    case 56 -> 125;
                    case 57 -> 161;
                    case 58 -> 9;
                    case 59 -> 147;
                    case 60 -> 126;
                    case 61 -> 228;
                    case 62 -> 153;
                    case 63 -> 99;
                    case 64 -> 220;
                    case 65 -> 32;
                    case 66 -> 34;
                    case 67 -> 230;
                    case 68 -> 135;
                    case 69 -> 38;
                    case 70 -> 171;
                    case 71 -> 167;
                    case 72 -> 52;
                    case 73 -> 50;
                    case 74 -> 122;
                    case 75 -> 217;
                    case 76 -> 199;
                    case 77 -> 252;
                    case 78 -> 123;
                    case 79 -> 236;
                    case 80 -> 118;
                    case 81 -> 151;
                    case 82 -> 229;
                    case 83 -> 248;
                    case 84 -> 95;
                    case 85 -> 59;
                    case 86 -> 75;
                    case 87 -> 89;
                    case 88 -> 1;
                    case 89 -> 200;
                    case 90 -> 177;
                    case 91 -> 226;
                    case 92 -> 157;
                    case 93 -> 168;
                    case 94 -> 166;
                    case 95 -> 108;
                    case 96 -> 63;
                    case 97 -> 169;
                    case 98 -> 249;
                    case 99 -> 113;
                    case 100 -> 3;
                    case 101 -> 5;
                    case 102 -> 155;
                    case 103 -> 18;
                    case 104 -> 148;
                    case 105 -> 62;
                    case 106 -> 20;
                    case 107 -> 198;
                    case 108 -> 244;
                    case 109 -> 176;
                    case 110 -> 93;
                    case 111 -> 27;
                    case 112 -> 204;
                    case 113 -> 215;
                    case 114 -> 136;
                    case 115 -> 132;
                    case 116 -> 97;
                    case 117 -> 210;
                    case 118 -> 25;
                    case 119 -> 181;
                    case 120 -> 238;
                    case 121 -> 140;
                    case 122 -> 19;
                    case 123 -> 69;
                    case 124 -> 160;
                    case 125 -> 66;
                    case 126 -> 128;
                    case 127 -> 14;
                    case 128 -> 8;
                    case 129 -> 202;
                    case 130 -> 129;
                    case 131 -> 10;
                    case 132 -> 211;
                    case 133 -> 184;
                    case 134 -> 131;
                    case 135 -> 231;
                    case 136 -> 182;
                    case 137 -> 98;
                    case 138 -> 0;
                    case 139 -> 101;
                    case 140 -> 116;
                    case 141 -> 239;
                    case 142 -> 195;
                    case 143 -> 79;
                    case 144 -> 218;
                    case 145 -> 196;
                    case 146 -> 191;
                    case 147 -> 61;
                    case 148 -> 111;
                    case 149 -> 251;
                    case 150 -> 84;
                    case 151 -> 178;
                    case 152 -> 15;
                    case 153 -> 54;
                    case 154 -> 11;
                    case 155 -> 41;
                    case 156 -> 138;
                    case 157 -> 107;
                    case 158 -> 201;
                    case 159 -> 241;
                    case 160 -> 100;
                    case 161 -> 104;
                    case 162 -> 55;
                    case 163 -> 156;
                    case 164 -> 233;
                    case 165 -> 163;
                    case 166 -> 35;
                    case 167 -> 213;
                    case 168 -> 207;
                    case 169 -> 133;
                    case 170 -> 189;
                    case 171 -> 245;
                    case 172 -> 188;
                    case 173 -> 6;
                    case 174 -> 209;
                    case 175 -> 223;
                    case 176 -> 29;
                    case 177 -> 13;
                    case 178 -> 103;
                    case 179 -> 26;
                    case 180 -> 91;
                    case 181 -> 60;
                    case 182 -> 73;
                    case 183 -> 47;
                    case 184 -> 222;
                    case 185 -> 49;
                    case 186 -> 150;
                    case 187 -> 243;
                    case 188 -> 106;
                    case 189 -> 72;
                    case 190 -> 94;
                    case 191 -> 253;
                    case 192 -> 86;
                    case 193 -> 120;
                    case 194 -> 246;
                    case 195 -> 4;
                    case 196 -> 187;
                    case 197 -> 43;
                    case 198 -> 39;
                    case 199 -> 115;
                    case 200 -> 170;
                    case 201 -> 237;
                    case 202 -> 254;
                    case 203 -> 154;
                    case 204 -> 162;
                    case 205 -> 53;
                    case 206 -> 28;
                    case 207 -> 57;
                    case 208 -> 83;
                    case 209 -> 81;
                    case 210 -> 74;
                    case 211 -> 80;
                    case 212 -> 240;
                    case 213 -> 16;
                    case 214 -> 183;
                    case 215 -> 255;
                    case 216 -> 193;
                    case 217 -> 78;
                    case 218 -> 22;
                    case 219 -> 70;
                    case 220 -> 48;
                    case 221 -> 139;
                    case 222 -> 87;
                    case 223 -> 175;
                    case 224 -> 37;
                    case 225 -> 190;
                    case 226 -> 205;
                    case 227 -> 110;
                    case 228 -> 71;
                    case 229 -> 64;
                    case 230 -> 227;
                    case 231 -> 234;
                    case 232 -> 65;
                    case 233 -> 21;
                    case 234 -> 173;
                    case 235 -> 76;
                    case 236 -> 247;
                    case 237 -> 51;
                    case 238 -> 88;
                    case 239 -> 23;
                    case 240 -> 42;
                    case 241 -> 225;
                    case 242 -> 221;
                    case 243 -> 206;
                    case 244 -> 121;
                    case 245 -> 145;
                    case 246 -> 17;
                    case 247 -> 24;
                    case 248 -> 92;
                    case 249 -> 214;
                    case 250 -> 45;
                    case 251 -> 212;
                    case 252 -> 130;
                    case 253 -> 208;
                    case 254 -> 105;
                    default -> 46;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

