/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.venvReader;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.venvReader.ResolveUtilKt;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B1\u0012\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0007J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u00120\u0011H\u0007J\f\u0010\u0013\u001a\u00060\u000ej\u0002`\u000fH\u0007J\u0012\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u00120\u0011H\u0007J\u001e\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u00120\u00112\n\u0010\u0016\u001a\u00060\u000ej\u0002`\u000fH\u0007J\u0012\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u000eH\u0007J\f\u0010\u0019\u001a\u00060\u000ej\u0002`\u000fH\u0003J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0003J\u001c\u0010\u001b\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u00122\n\u0010\u001c\u001a\u00060\u000ej\u0002`\u001dH\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0018\u0010\u001f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u00122\u0006\u0010\u001c\u001a\u00020\u000eH\u0003J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0003R$\u0010\u0002\u001a\u0018\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/venvReader/VirtualEnvReader;", "", "envs", "", "", "Lorg/jetbrains/annotations/NonNls;", "isWindows", "", "<init>", "(Ljava/util/Map;Z)V", "pythonNames", "", "binFolderName", "getVEnvRootDir", "Ljava/nio/file/Path;", "Lcom/jetbrains/python/venvReader/Directory;", "findVEnvInterpreters", "", "Lcom/jetbrains/python/PythonBinary;", "getPyenvRootDir", "findPyenvInterpreters", "findLocalInterpreters", "root", "isPyenvSdk", "path", "getPyenvVersionsDir", "tryReadLink", "findPythonInPythonRoot", "dir", "Lcom/jetbrains/python/PythonHomePath;", "getVenvRootPath", "findInterpreter", "resolveDirFromEnvOrElseGetDirInHomePath", "env", "dirName", "Companion", "intellij.python.community"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVirtualEnvReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualEnvReader.kt\ncom/jetbrains/python/venvReader/VirtualEnvReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n295#3,2:193\n*S KotlinDebug\n*F\n+ 1 VirtualEnvReader.kt\ncom/jetbrains/python/venvReader/VirtualEnvReader\n*L\n156#1:193,2\n*E\n"})
public final class VirtualEnvReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> envs;
    @NotNull
    private final Set<String> pythonNames;
    @NotNull
    private final String binFolderName;
    @NotNull
    private static final VirtualEnvReader Instance = new VirtualEnvReader(null, false, 3, null);
    @NotNull
    public static final String DEFAULT_VIRTUALENVS_DIR = ".virtualenvs";
    @NotNull
    public static final String DEFAULT_VIRTUALENV_DIRNAME = ".venv";

    public VirtualEnvReader(@NotNull Map<String, String> envs, boolean isWindows) {
        Set set;
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        this.envs = envs;
        if (isWindows) {
            Object[] objectArray = new String[]{"pypy.exe", "python.exe"};
            set = SetsKt.setOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{"pypy", "python"};
            set = SetsKt.setOf((Object[])objectArray);
        }
        this.pythonNames = set;
        this.binFolderName = isWindows ? "Scripts" : "bin";
    }

    public /* synthetic */ VirtualEnvReader(Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Map<String, String> map2 = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
            map = map2;
        }
        if ((n & 2) != 0) {
            bl = SystemInfoRt.isWindows;
        }
        this(map, bl);
    }

    @RequiresBackgroundThread
    @NotNull
    public final Path getVEnvRootDir() {
        return this.resolveDirFromEnvOrElseGetDirInHomePath("WORKON_HOME", DEFAULT_VIRTUALENVS_DIR);
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<Path> findVEnvInterpreters() {
        return this.findLocalInterpreters(this.getVEnvRootDir());
    }

    @RequiresBackgroundThread
    @NotNull
    public final Path getPyenvRootDir() {
        return this.resolveDirFromEnvOrElseGetDirInHomePath("PYENV_ROOT", ".pyenv");
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<Path> findPyenvInterpreters() {
        return this.findLocalInterpreters(this.getPyenvVersionsDir());
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<Path> findLocalInterpreters(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Path> candidates = new ArrayList<Path>();
        for (Path dir : PathsKt.listDirectoryEntries$default((Path)root, null, (int)1, null)) {
            Path it;
            if (this.findPythonInPythonRoot(dir) == null) continue;
            boolean bl = false;
            candidates.add(it);
        }
        return candidates;
    }

    @RequiresBackgroundThread
    public final boolean isPyenvSdk(@Nullable String path) {
        CharSequence charSequence = path;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        Path path2 = ResolveUtilKt.tryResolvePath(path);
        if (path2 == null) {
            return false;
        }
        Path path3 = path2;
        return this.isPyenvSdk(path3);
    }

    @RequiresBackgroundThread
    public final boolean isPyenvSdk(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = this.tryReadLink(path);
        if (path2 == null) {
            return false;
        }
        Path real = path2;
        return real.startsWith(NioPathUtil.toCanonicalPath((Path)this.getPyenvRootDir()));
    }

    @RequiresBackgroundThread
    private final Path getPyenvVersionsDir() {
        Path path = this.getPyenvRootDir().resolve("versions");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @RequiresBackgroundThread
    private final Path tryReadLink(Path path) {
        try {
            return Files.isSymbolicLink(path) ? path.toRealPath(new LinkOption[0]) : path;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @RequiresBackgroundThread
    @Nullable
    public final Path findPythonInPythonRoot(@NotNull Path dir) {
        Path path;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path bin = dir.resolve("bin");
        Intrinsics.checkNotNull((Object)bin);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isDirectory(bin, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && (path2 = this.findInterpreter(bin)) != null) {
            Path it = path2;
            boolean bl = false;
            return it;
        }
        Path scripts = dir.resolve("Scripts");
        Intrinsics.checkNotNull((Object)scripts);
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (Files.isDirectory(scripts, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && (path = this.findInterpreter(scripts)) != null) {
            Path it = path;
            boolean bl = false;
            return it;
        }
        return this.findInterpreter(dir);
    }

    @Nullable
    public final Path getVenvRootPath(@NotNull Path path) {
        Path bin;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                bin = path.getParent();
                if (bin == null) break block5;
                Path path2 = bin.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getFileName(...)");
                if (Intrinsics.areEqual((Object)((Object)path2).toString(), (Object)this.binFolderName)) break block6;
            }
            return null;
        }
        Path venv = bin.getParent();
        if (venv == null) {
            return null;
        }
        Path root = venv.getParent();
        if (root == null) {
            return null;
        }
        return root;
    }

    @RequiresBackgroundThread
    private final Path findInterpreter(Path dir) {
        Object v3;
        block6: {
            Iterable $this$firstOrNull$iv = PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                Path child = (Path)element$iv;
                boolean bl2 = false;
                String string = PathsKt.getName((Path)child).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (!this.pythonNames.contains(string)) {
                    bl = false;
                } else {
                    boolean bl3;
                    try {
                        Path path = child;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
                        bl3 = basicFileAttributes.isRegularFile();
                    }
                    catch (FileSystemException err) {
                        if (!SystemInfoRt.isWindows || !Intrinsics.areEqual(err.getClass(), FileSystemException.class)) {
                            throw err;
                        }
                        bl3 = true;
                    }
                    bl = bl3;
                }
                if (!bl) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return v3;
    }

    @RequiresBackgroundThread
    private final Path resolveDirFromEnvOrElseGetDirInHomePath(String env, String dirName) {
        Object object;
        block3: {
            block2: {
                object = this.envs.get(env);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Path path = ResolveUtilKt.tryResolvePath(it);
                object = path;
                if (path != null) break block3;
            }
            String[] stringArray = new String[]{dirName};
            Path path = Path.of(SystemProperties.getUserHome(), stringArray);
            object = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        }
        return object;
    }

    public VirtualEnvReader() {
        this(null, false, 3, null);
    }

    @NotNull
    public static final VirtualEnvReader getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/venvReader/VirtualEnvReader$Companion;", "", "<init>", "()V", "Instance", "Lcom/jetbrains/python/venvReader/VirtualEnvReader;", "getInstance$annotations", "getInstance", "()Lcom/jetbrains/python/venvReader/VirtualEnvReader;", "DEFAULT_VIRTUALENVS_DIR", "", "DEFAULT_VIRTUALENV_DIRNAME", "intellij.python.community"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VirtualEnvReader getInstance() {
            return Instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

