/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshTunnelConfiguration {
    public static final String ELEMENT_NAME = "ssh-properties";
    private final String mySshConfigId;
    private final boolean myEnabled;
    @Nullable
    private final SshConfig myPredefinedSshConfig;
    private final int myLocalPort;

    public DataSourceSshTunnelConfiguration(boolean enabled, @NotNull String sshConfigId, int localPort) {
        if (sshConfigId == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(0);
        }
        this.myEnabled = enabled;
        this.mySshConfigId = sshConfigId;
        this.myPredefinedSshConfig = null;
        this.myLocalPort = localPort;
    }

    public DataSourceSshTunnelConfiguration(@NotNull SshConfig sshConfig, int localPort) {
        if (sshConfig == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(1);
        }
        this.myEnabled = true;
        this.mySshConfigId = "";
        this.myPredefinedSshConfig = sshConfig;
        this.myLocalPort = localPort;
    }

    public int getLocalPort() {
        return this.myLocalPort;
    }

    @Nullable
    public SshConfig getSshConfig(Project project) {
        if (this.myPredefinedSshConfig != null) {
            return this.myPredefinedSshConfig;
        }
        return SshConfigManager.getInstance((Project)project).findConfigById(this.mySshConfigId);
    }

    public String getSshConfigId() {
        return this.mySshConfigId;
    }

    public void enforceCredentials(@NotNull Project project) {
        SshConfig config;
        if (project == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(2);
        }
        if ((config = this.getSshConfig(project)) == null) {
            return;
        }
        SshUiData data = new SshUiData(config);
        data.enforceEmptyCredentials();
    }

    public static boolean equal(@Nullable DataSourceSshTunnelConfiguration c1, @Nullable DataSourceSshTunnelConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    @Nullable
    public static DataSourceSshTunnelConfiguration deserialize(@Nullable Project project, @NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource dataSource) {
        SshConfig config;
        String url;
        if (xmlReader == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(4);
        }
        String proxyHost = "";
        String proxyPort = "";
        String user = "";
        String privateKeyPath = "";
        String remoteHost = "";
        String remotePort = "";
        boolean localPortIsSet = false;
        int localPort = -1;
        boolean enabled = false;
        AuthType authType = AuthType.PASSWORD;
        LocalDataSource.Storage passwordStorage = LocalDataSource.Storage.MEMORY;
        String sshConfigName = "";
        String sshConfigId = "";
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String name = xmlReader.getNodeName();
            String value = xmlReader.getValue();
            if ("proxy-host".equals(name)) {
                proxyHost = value;
            } else if ("proxy-port".equals(name)) {
                proxyPort = value;
            } else if ("secret-storage".equals(name)) {
                passwordStorage = LocalDataSource.Storage.deserialize(xmlReader.getValue());
            } else if ("user".equals(name)) {
                user = value;
            } else if ("use-password".equals(name)) {
                authType = Boolean.parseBoolean(value) ? AuthType.PASSWORD : AuthType.KEY_PAIR;
            } else if ("auth-type".equals(name)) {
                authType = (AuthType)StringUtil.parseEnum((String)value, (Enum)AuthType.PASSWORD, AuthType.class);
            } else if ("private-key-path".equals(name)) {
                privateKeyPath = value;
            } else if ("remote-host".equals(name)) {
                remoteHost = value;
            } else if ("remote-port".equals(name)) {
                remotePort = value;
            } else if ("local-port".equals(name)) {
                localPort = StringUtil.parseInt((String)value, (int)-1);
                localPortIsSet = true;
            } else if ("enabled".equals(name)) {
                enabled = Boolean.parseBoolean(value);
            } else if ("ssh-config-name".equals(name)) {
                sshConfigName = value;
            } else if ("ssh-config-id".equals(name)) {
                sshConfigId = value;
            }
            xmlReader.moveUp();
        }
        if (!StringUtil.isEmpty((String)remoteHost) && !StringUtil.isEmpty((String)remotePort) && localPort != -1 && (url = dataSource.getUrl()) != null) {
            url = url.replace(String.valueOf(localPort), remotePort);
            url = url.replace("localhost", remoteHost);
            url = url.replace("127.0.0.1", remoteHost);
            dataSource.setUrl(url);
        }
        if (!StringUtil.isEmpty((String)sshConfigId)) {
            if (!localPortIsSet) {
                config = SshConfigManager.getInstance((Project)project).findConfigById(sshConfigId);
                localPort = config == null ? -1 : config.getLocalPort();
            }
            return new DataSourceSshTunnelConfiguration(enabled, sshConfigId, localPort);
        }
        if (!StringUtil.isEmpty((String)sshConfigName) && (config = SshConfigManager.getInstance((Project)project).findConfigByName(sshConfigName)) != null) {
            if (!localPortIsSet) {
                localPort = config.getLocalPort();
            }
            return new DataSourceSshTunnelConfiguration(enabled, config.getId(), localPort);
        }
        if (DataSourceSshTunnelConfiguration.isEmpty(proxyHost, user, privateKeyPath)) {
            return null;
        }
        DatabaseCredentials credentials = DatabaseCredentials.getInstance();
        OneTimeString password = credentials.getSshPassword((DasDataSource)dataSource);
        OneTimeString passphrase = credentials.getSshPassphrase((DasDataSource)dataSource);
        SshConfigManager manager = SshConfigManager.getInstance((Project)project);
        manager.startCollectingNotifications();
        SshConfig sshConfig = manager.register(project != null, proxyHost, proxyPort, user, authType, password == null ? null : password.toString(true), passphrase == null ? null : passphrase.toString(true), passwordStorage.isPersisted(), passwordStorage.isPersisted(), privateKeyPath, null);
        manager.handleNotifications(true);
        return new DataSourceSshTunnelConfiguration(enabled, sshConfig.getId(), localPort);
    }

    public void serialize(@Nullable Project project, @NotNull HierarchicalStreamWriter serializer) {
        boolean writePort;
        if (serializer == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(5);
        }
        serializer.startNode(ELEMENT_NAME);
        LocalDataSourceSerialization.writeTag(serializer, "enabled", Boolean.toString(this.myEnabled));
        LocalDataSourceSerialization.writeTag(serializer, "ssh-config-id", this.mySshConfigId);
        boolean bl = writePort = this.myLocalPort != -1;
        if (!writePort) {
            SshConfig config = this.getSshConfig(project);
            boolean bl2 = writePort = config != null && config.getLocalPort() != -1;
        }
        if (writePort) {
            LocalDataSourceSerialization.writeTag(serializer, "local-port", String.valueOf(this.myLocalPort));
        }
        serializer.endNode();
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean equalConfiguration(@NotNull DataSourceSshTunnelConfiguration configuration) {
        if (configuration == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(6);
        }
        if (this.myEnabled != configuration.myEnabled) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.mySshConfigId), (CharSequence)StringUtil.nullize((String)configuration.mySshConfigId))) {
            return false;
        }
        if (!Objects.equals(this.myPredefinedSshConfig, configuration.myPredefinedSshConfig)) {
            return false;
        }
        return Objects.equals(this.myLocalPort, configuration.myLocalPort);
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        return StringUtil.isEmpty((String)this.mySshConfigId) && this.myPredefinedSshConfig == null && this.myLocalPort == -1;
    }

    private static boolean isEmpty(String proxyHost, String user, String privateKeyPath) {
        if (StringUtil.isNotEmpty((String)proxyHost)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)user)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)privateKeyPath);
    }

    @Nullable
    public static DataSourceSshTunnelConfiguration getEnabledSshConfiguration(@Nullable DatabaseConnectionPoint connectionPoint) {
        LocalDataSource dataSource = connectionPoint == null ? null : connectionPoint.getDataSource();
        DataSourceSshTunnelConfiguration ssh = dataSource == null ? null : dataSource.getSshConfiguration();
        return ssh != null && ssh.isEnabled() ? ssh : null;
    }

    public static boolean hasTunnel(@Nullable DatabaseConnectionPoint connectionPoint) {
        return DataSourceSshTunnelConfiguration.getEnabledSshConfiguration(connectionPoint) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfigId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enforceCredentials";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "equalConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

