/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0015\u0010\u001f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/view/structure/DvTreeFilesLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "qFolders", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/view/DataSourceNode;", "Lcom/intellij/database/view/structure/DvTreeFilesLayer$QueryFolder;", "qFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/database/view/structure/DvTreeFilesLayer$QueryFile;", "getQueryFolder", "dsn", "getQueryFile", "vFolder", "vFile", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "childrenOf", "Lkotlin/sequences/Sequence;", "childrenOfDSN", "listFilesInFolder", "folder", "isAlwaysLeaf", "", "presentableNameOf", "clearAll", "", "QueryFolder", "QueryFile", "intellij.database.core.impl"})
public final class DvTreeFilesLayer
extends DvTreeStoreyLayer {
    @NotNull
    private final WeakHashMap<DataSourceNode, QueryFolder> qFolders = new WeakHashMap();
    @NotNull
    private final WeakHashMap<VirtualFile, QueryFile> qFiles = new WeakHashMap();

    @Override
    @NotNull
    protected String getName() {
        return "Query Files";
    }

    private final QueryFolder getQueryFolder(DataSourceNode dsn) {
        QueryFolder folder = this.qFolders.get(dsn);
        if (folder == null) {
            folder = new QueryFolder(dsn);
            ((Map)this.qFolders).put(dsn, folder);
        }
        return folder;
    }

    private final QueryFile getQueryFile(QueryFolder vFolder, VirtualFile vFile) {
        QueryFile file = this.qFiles.get(vFile);
        if (file == null) {
            file = new QueryFile(vFolder, vFile);
            ((Map)this.qFiles).put(vFile, file);
        }
        return file;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof QueryFolder ? (BasicNode)((QueryFolder)node).getDsn() : (basicNode instanceof QueryFile ? (BasicNode)((QueryFile)node).getFolder() : this.baseParentOf(node));
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DataSourceNode ? this.childrenOfDSN((DataSourceNode)node) : (basicNode instanceof QueryFolder ? this.listFilesInFolder((QueryFolder)node) : this.getBase().childrenOf(node));
    }

    private final Sequence<BasicNode> childrenOfDSN(DataSourceNode dsn) {
        Sequence children = this.getBase().childrenOf(dsn);
        if (dsn.dataSource instanceof LocalDataSource) {
            QueryFolder qFolder = this.getQueryFolder(dsn);
            children = SequencesKt.plus(children, (Object)qFolder);
        }
        return children;
    }

    private final Sequence<QueryFile> listFilesInFolder(QueryFolder folder) {
        Object object = folder.getDsn().getLocalDataSource();
        if (object == null || (object = ((AbstractDataSource)((Object)object)).getUniqueId()) == null) {
            return SequencesKt.emptySequence();
        }
        Object dsId = object;
        Sequence vFiles = SequencesKt.emptySequence();
        return SequencesKt.map((Sequence)vFiles, arg_0 -> DvTreeFilesLayer.listFilesInFolder$lambda$0(this, folder, arg_0));
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof QueryFolder ? false : this.getBase().isAlwaysLeaf(node);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().presentableNameOf(node);
    }

    @Override
    public void clearAll() {
        this.qFiles.clear();
        this.qFolders.clear();
    }

    private static final QueryFile listFilesInFolder$lambda$0(DvTreeFilesLayer this$0, QueryFolder $folder, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getQueryFile($folder, it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\r\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/view/structure/DvTreeFilesLayer$QueryFile;", "Lcom/intellij/database/view/structure/DvExtraNode;", "folder", "Lcom/intellij/database/view/structure/DvTreeFilesLayer$QueryFolder;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeFilesLayer$QueryFolder;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFolder", "()Lcom/intellij/database/view/structure/DvTreeFilesLayer$QueryFolder;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "treeNodeRank", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/view/structure/DvTreeNodeRank;", "isItselfMeaningful", "", "()Z", "iconItem", "Lcom/intellij/database/view/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/view/structure/DvTreeIconItem;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getDisplayName", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.database.core.impl"})
    public static final class QueryFile
    implements DvExtraNode {
        @NotNull
        private final QueryFolder folder;
        @NotNull
        private final VirtualFile virtualFile;

        public QueryFile(@NotNull QueryFolder folder, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            this.folder = folder;
            this.virtualFile = virtualFile;
        }

        @NotNull
        public final QueryFolder getFolder() {
            return this.folder;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @Override
        @NotNull
        public DvTreeNodeRank getTreeNodeRank() {
            return DvTreeNodeRank.TL_EXTERNAL;
        }

        @Override
        public boolean isItselfMeaningful() {
            return true;
        }

        @Override
        @NotNull
        public DvTreeIconItem getIconItem() {
            return DvTreeIconItem.QUERY_FILE;
        }

        @Override
        @Nullable
        public BasicModel getModel() {
            return this.folder.getModel();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.virtualFile.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/view/structure/DvTreeFilesLayer$QueryFolder;", "Lcom/intellij/database/view/structure/DvExtraNode;", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "<init>", "(Lcom/intellij/database/view/DataSourceNode;)V", "getDsn", "()Lcom/intellij/database/view/DataSourceNode;", "treeNodeRank", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/view/structure/DvTreeNodeRank;", "isItselfMeaningful", "", "()Z", "iconItem", "Lcom/intellij/database/view/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/view/structure/DvTreeIconItem;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getDisplayName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.database.core.impl"})
    public static final class QueryFolder
    implements DvExtraNode {
        @NotNull
        private final DataSourceNode dsn;

        public QueryFolder(@NotNull DataSourceNode dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            this.dsn = dsn;
        }

        @NotNull
        public final DataSourceNode getDsn() {
            return this.dsn;
        }

        @Override
        @NotNull
        public DvTreeNodeRank getTreeNodeRank() {
            return DvTreeNodeRank.TL_SYNTHETIC;
        }

        @Override
        public boolean isItselfMeaningful() {
            return false;
        }

        @Override
        @NotNull
        public DvTreeIconItem getIconItem() {
            return DvTreeIconItem.QUERY_FOLDER;
        }

        @Override
        @Nullable
        public BasicModel getModel() {
            return this.dsn.getModel();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = DatabaseBundle.message((String)"database.view.layers.files.folder.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

