/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.OverlayUtil;

class OverlayPoints {
    private int opCode;
    private Geometry geom0;
    private Geometry geom1;
    private PrecisionModel pm;
    private GeometryFactory geometryFactory;
    private ArrayList<Point> resultList;

    public static Geometry overlay(int opCode, Geometry geom0, Geometry geom1, PrecisionModel pm) {
        OverlayPoints overlay = new OverlayPoints(opCode, geom0, geom1, pm);
        return overlay.getResult();
    }

    public OverlayPoints(int opCode, Geometry geom0, Geometry geom1, PrecisionModel pm) {
        this.opCode = opCode;
        this.geom0 = geom0;
        this.geom1 = geom1;
        this.pm = pm;
        this.geometryFactory = geom0.getFactory();
    }

    public Geometry getResult() {
        HashMap<Coordinate, Point> map0 = this.buildPointMap(this.geom0);
        HashMap<Coordinate, Point> map1 = this.buildPointMap(this.geom1);
        this.resultList = new ArrayList();
        switch (this.opCode) {
            case 1: {
                this.computeIntersection(map0, map1, this.resultList);
                break;
            }
            case 2: {
                this.computeUnion(map0, map1, this.resultList);
                break;
            }
            case 3: {
                this.computeDifference(map0, map1, this.resultList);
                break;
            }
            case 4: {
                this.computeDifference(map0, map1, this.resultList);
                this.computeDifference(map1, map0, this.resultList);
            }
        }
        if (this.resultList.isEmpty()) {
            return OverlayUtil.createEmptyResult(0, this.geometryFactory);
        }
        return this.geometryFactory.buildGeometry(this.resultList);
    }

    private void computeIntersection(Map<Coordinate, Point> map0, Map<Coordinate, Point> map1, ArrayList<Point> resultList) {
        for (Map.Entry<Coordinate, Point> entry : map0.entrySet()) {
            if (!map1.containsKey(entry.getKey())) continue;
            resultList.add(this.copyPoint(entry.getValue()));
        }
    }

    private void computeDifference(Map<Coordinate, Point> map0, Map<Coordinate, Point> map1, ArrayList<Point> resultList) {
        for (Map.Entry<Coordinate, Point> entry : map0.entrySet()) {
            if (map1.containsKey(entry.getKey())) continue;
            resultList.add(this.copyPoint(entry.getValue()));
        }
    }

    private void computeUnion(Map<Coordinate, Point> map0, Map<Coordinate, Point> map1, ArrayList<Point> resultList) {
        for (Point point : map0.values()) {
            resultList.add(this.copyPoint(point));
        }
        for (Map.Entry entry : map1.entrySet()) {
            if (map0.containsKey(entry.getKey())) continue;
            resultList.add(this.copyPoint((Point)entry.getValue()));
        }
    }

    private Point copyPoint(Point pt) {
        if (OverlayUtil.isFloating(this.pm)) {
            return (Point)pt.copy();
        }
        CoordinateSequence seq = pt.getCoordinateSequence();
        CoordinateSequence seq2 = seq.copy();
        seq2.setOrdinate(0, 0, this.pm.makePrecise(seq.getX(0)));
        seq2.setOrdinate(0, 1, this.pm.makePrecise(seq.getY(0)));
        return this.geometryFactory.createPoint(seq2);
    }

    private HashMap<Coordinate, Point> buildPointMap(Geometry geom) {
        HashMap<Coordinate, Point> map = new HashMap<Coordinate, Point>();
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Point pt;
            Coordinate p;
            Geometry elt = geom.getGeometryN(i2);
            if (!(elt instanceof Point)) {
                throw new IllegalArgumentException("Non-point geometry input to point overlay");
            }
            if (elt.isEmpty() || map.containsKey(p = OverlayPoints.roundCoord(pt = (Point)elt, this.pm))) continue;
            map.put(p, pt);
        }
        return map;
    }

    static Coordinate roundCoord(Point pt, PrecisionModel pm) {
        Coordinate p = pt.getCoordinate();
        if (OverlayUtil.isFloating(pm)) {
            return p;
        }
        Coordinate p2 = p.copy();
        pm.makePrecise(p2);
        return p2;
    }
}

