/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Out;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlValuesExtractor
extends DefaultValuesExtractor {
    protected final DasObject myDatabaseTable;

    public SqlValuesExtractor(ObjectFormatter converter, DasObject databaseTable) {
        super(converter);
        this.myDatabaseTable = databaseTable;
    }

    protected boolean isStringLiteral(@Nullable GridRow row, @Nullable GridColumn column) {
        Object value = column == null || row == null ? null : column.getValue(row);
        return this.myConverter.isStringLiteral(column, value, ObjectFormatterMode.SQL_SCRIPT);
    }

    @NotNull
    public String getNullLiteral(GridRow row, GridColumn column) {
        return "null";
    }

    @NotNull
    public String getStringValueLiteral(@Nullable GridColumn column, @NotNull String value) {
        if (value == null) {
            SqlValuesExtractor.$$$reportNull$$$0(0);
        }
        String string = this.myConverter.getStringLiteral(value, column, ObjectFormatterMode.SQL_SCRIPT);
        if (string == null) {
            SqlValuesExtractor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFileExtension() {
        return "sql";
    }

    public boolean supportsText() {
        return true;
    }

    public String getLineSeparator() {
        return "";
    }

    public abstract SqlExtractionBase startExtraction(@NotNull Out var1, @NotNull List<? extends GridColumn> var2, @NotNull String var3, @NotNull ExtractionConfig var4, int ... var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/SqlValuesExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/SqlValuesExtractor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueLiteral";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    protected static abstract class SqlExtractionBase
    extends DefaultValuesExtractor.DefaultExtraction {
        protected final DdlBuilder myDdlBuilder;

        public SqlExtractionBase(Out out, Dbms dbms, ExtractionConfig config, List<? extends GridColumn> allColumns, int[] selectedColumnIndices) {
            super(out, config, allColumns, "", selectedColumnIndices);
            this.myDdlBuilder = new DdlBuilder(out).qualifyReferences(true).withDialect(DbImplUtilCore.getDatabaseDialect((Dbms)dbms));
        }
    }
}

