/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PyTypingTypeAliasStubImpl;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.stubs.PyTypingAliasStub;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypingAliasStubType
extends CustomTargetExpressionStubType<PyTypingAliasStub> {
    private static final int STRING_LITERAL_LENGTH_THRESHOLD = 100;
    private static final Pattern TYPE_ANNOTATION_LIKE = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(\\[.*])?$");
    private static final TokenSet VALID_TYPE_ANNOTATION_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.REFERENCE_EXPRESSION, PyElementTypes.SUBSCRIPTION_EXPRESSION, PyElementTypes.TUPLE_EXPRESSION, PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.STRING_LITERAL_EXPRESSION, PyElementTypes.NONE_LITERAL_EXPRESSION, PyElementTypes.ELLIPSIS_LITERAL_EXPRESSION});

    @Override
    @Nullable
    public PyTypingAliasStub createStub(@NotNull PyTargetExpression psi) {
        PyExpression value;
        if (psi == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(0);
        }
        return (value = PyTypingAliasStubType.getAssignedValueIfTypeAliasLike(psi, true)) != null ? new PyTypingTypeAliasStubImpl(value.getText()) : null;
    }

    @Nullable
    private static PyExpression getAssignedValueIfTypeAliasLike(@NotNull PyTargetExpression target, boolean forStubCreation) {
        if (target == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(1);
        }
        if (!PyUtil.isTopLevel((PsiElement)target) && !(ScopeUtil.getScopeOwner((PsiElement)target) instanceof PyClass) || !PyTypingAliasStubType.looksLikeTypeAliasTarget(target)) {
            return null;
        }
        PyExpression value = target.findAssignedValue();
        if (value == null || forStubCreation && value instanceof PyReferenceExpression) {
            return null;
        }
        if (PyTypingAliasStubType.isExplicitTypeAlias(target) || PyTypingAliasStubType.looksLikeTypeHint(value)) {
            return value;
        }
        return null;
    }

    private static boolean looksLikeTypeAliasTarget(@NotNull PyTargetExpression target) {
        if (target == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(2);
        }
        if (target.isQualified()) {
            return false;
        }
        String name = target.getName();
        if (name == null || PyUtilCore.isSpecialName((String)name)) {
            return false;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyAssignmentStatement.class);
        if (assignment == null) {
            return false;
        }
        PyExpression[] targets = assignment.getRawTargets();
        return targets.length == 1 && targets[0] == target;
    }

    private static boolean isExplicitTypeAlias(@NotNull PyTargetExpression target) {
        PyAnnotation annotation;
        if (target == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(3);
        }
        if ((annotation = target.getAnnotation()) != null) {
            PyExpression value = annotation.getValue();
            if (value instanceof PyReferenceExpression) {
                PyReferenceExpression referenceExpression = (PyReferenceExpression)value;
                return StreamEx.of(PyResolveUtil.resolveImportedElementQNameLocally(referenceExpression)).map(QualifiedName::toString).anyMatch(name -> name.equals("typing.TypeAlias") || name.equals("typing_extensions.TypeAlias"));
            }
        } else {
            String typeHintText = StringUtil.notNullize((String)target.getTypeCommentAnnotation());
            return typeHintText.equals("TypeAlias") || typeHintText.endsWith(".TypeAlias");
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean looksLikeTypeHint(@NotNull PyExpression expression) {
        PyCallExpression call;
        if (expression == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(4);
        }
        if ((call = PyUtil.as(expression, PyCallExpression.class)) != null) {
            PyReferenceExpression callee = PyUtil.as(call.getCallee(), PyReferenceExpression.class);
            return callee != null && ("TypeVar".equals(callee.getReferencedName()) || "TypeVarTuple".equals(callee.getReferencedName()) || "ParamSpec".equals(callee.getReferencedName()));
        }
        return PyTypingAliasStubType.isSyntacticallyValidAnnotation(expression);
    }

    private static boolean isSyntacticallyValidAnnotation(@NotNull PyExpression expression) {
        if (expression == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(5);
        }
        final boolean[] illegal = new boolean[]{false};
        expression.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
                PyReferenceExpression refExpr;
                PyExpression pyExpression;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pyExpression = node.getOperand()) instanceof PyReferenceExpression && "Annotated".equals((refExpr = (PyReferenceExpression)pyExpression).getName()) && (pyExpression = node.getIndexExpression()) instanceof PyTupleExpression) {
                    PyTupleExpression tupleExpr = (PyTupleExpression)pyExpression;
                    refExpr.accept((PsiElementVisitor)this);
                    tupleExpr.getElements()[0].accept((PsiElementVisitor)this);
                } else {
                    PyReferenceExpression refExpr2;
                    pyExpression = node.getOperand();
                    if (pyExpression instanceof PyReferenceExpression && "Literal".equals((refExpr2 = (PyReferenceExpression)pyExpression).getName())) {
                        refExpr2.accept((PsiElementVisitor)this);
                    } else {
                        super.visitPySubscriptionExpression(node);
                    }
                }
            }

            public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (node.getOperator() != PyTokenTypes.OR) {
                    illegal[0] = true;
                    return;
                }
                node.getLeftExpression().accept((PsiElementVisitor)this);
                PyExpression rightExpression = node.getRightExpression();
                if (rightExpression != null) {
                    rightExpression.accept((PsiElementVisitor)this);
                }
            }

            public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
                boolean nonTrivial;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                boolean bl = nonTrivial = node.isInterpolated() || node.getStringNodes().size() != 1 || node.getTextLength() > 100 || !((PyStringElement)node.getStringElements().getFirst()).getPrefix().isEmpty() || !TYPE_ANNOTATION_LIKE.matcher(node.getStringValue()).matches();
                if (nonTrivial) {
                    illegal[0] = true;
                }
            }

            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (node.asQualifiedName() == null) {
                    illegal[0] = true;
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (element instanceof ASTDelegatePsiElement) {
                    if (!VALID_TYPE_ANNOTATION_ELEMENTS.contains(element.getNode().getElementType())) {
                        illegal[0] = true;
                        return;
                    }
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyTypingAliasStubType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPySubscriptionExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyBinaryExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyStringLiteralExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return !illegal[0];
    }

    @Override
    @Nullable
    public PyTypingAliasStub deserializeStub(@NotNull StubInputStream stream) throws IOException {
        String ref;
        if (stream == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(6);
        }
        return (ref = stream.readNameString()) != null ? new PyTypingTypeAliasStubImpl(ref) : null;
    }

    @Nullable
    public static PyExpression getAssignedValueStubLike(@NotNull PyTargetExpression target) {
        if (target == null) {
            PyTypingAliasStubType.$$$reportNull$$$0(7);
        }
        return (PyExpression)CachedValuesManager.getCachedValue((PsiElement)target, () -> {
            PyTargetExpressionStub stub = (PyTargetExpressionStub)target.getStub();
            PyExpression result = null;
            if (stub != null) {
                PyTypingAliasStub aliasStub = (PyTypingAliasStub)stub.getCustomStub(PyTypingAliasStub.class);
                String aliasText = null;
                if (aliasStub != null) {
                    aliasText = aliasStub.getText();
                } else if (stub.getInitializerType() == PyTargetExpressionStub.InitializerType.ReferenceExpression) {
                    aliasText = Objects.toString(stub.getInitializer(), null);
                }
                if (aliasText != null) {
                    result = PyUtil.createExpressionFromFragment(aliasText, (PsiElement)target.getContainingFile());
                }
            } else {
                result = PyTypingAliasStubType.getAssignedValueIfTypeAliasLike(target, false);
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyTypingAliasStubType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssignedValueIfTypeAliasLike";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "looksLikeTypeAliasTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExplicitTypeAlias";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "looksLikeTypeHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSyntacticallyValidAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deserializeStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssignedValueStubLike";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

