/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.nonModalWelcomeScreen.leftPanel;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WelcomeScreenProjectProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.ProjectCollectors;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectFilteringTree;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectPanelComponentFactory;
import com.intellij.platform.ide.nonModalWelcomeScreen.GoFileDragAndDropHandler;
import com.intellij.platform.ide.nonModalWelcomeScreen.NonModalWelcomeScreenBundle;
import com.intellij.platform.ide.nonModalWelcomeScreen.leftPanel.WelcomeScreenLeftPanelActions;
import com.intellij.platform.ide.nonModalWelcomeScreen.leftPanel.WelcomeScreenLeftPanelSelectInTarget;
import com.intellij.platform.ide.nonModalWelcomeScreen.rightTab.WelcomeScreenRightTabVirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0002J#\u0010%\u001a\u00020\u001f2\u0019\b\u0002\u0010&\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00150'\u00a2\u0006\u0002\b)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/platform/ide/nonModalWelcomeScreen/leftPanel/WelcomeScreenLeftPanel;", "Lcom/intellij/ide/projectView/impl/ProjectViewPane;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "recentProjectTreeComponent", "Ljavax/swing/JComponent;", "getTitle", "", "getId", "getIcon", "Ljavax/swing/Icon;", "isInitiallyVisible", "", "isDefaultPane", "getWeight", "", "createSelectInTarget", "Lcom/intellij/ide/SelectInTarget;", "setupDragAndDrop", "", "component", "createComponent", "getComponentToFocus", "dispose", "isWelcomeFileSelected", "ensurePaneVisible", "visible", "syncPaneVisibilityWithCurrentEditor", "searchPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "recentProjectTree", "Lcom/intellij/openapi/wm/impl/welcomeScreen/recentProjects/RecentProjectFilteringTree;", "createRecentProjectTree", "createProjectSearchField", "Lcom/intellij/ui/SearchTextField;", "separator", "customize", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Row;", "Lkotlin/ExtensionFunctionType;", "Companion", "intellij.platform.ide.nonModalWelcomeScreen"})
@StabilityInferred(parameters=0)
public final class WelcomeScreenLeftPanel
extends ProjectViewPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private JComponent recentProjectTreeComponent;
    public static final int $stable = 8;
    @NotNull
    public static final String ID = "NonModalWelcomeScreenProjectPane";

    public WelcomeScreenLeftPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.syncPaneVisibilityWithCurrentEditor();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getNewFile();
                boolean isWelcome = (virtualFile != null ? virtualFile.getFileType() : null) instanceof WelcomeScreenRightTabVirtualFile.WelcomeScreenFileType;
                if (isWelcome) {
                    this.ensurePaneVisible(true);
                    ProjectViewImpl.getInstance((Project)project).changeView(WelcomeScreenLeftPanel.ID);
                } else {
                    this.ensurePaneVisible(false);
                }
            }
        });
    }

    @NotNull
    public String getTitle() {
        return NonModalWelcomeScreenBundle.message("welcome.screen.project.view.title", new Object[0]);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public Icon getIcon() {
        return IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Folder);
    }

    public boolean isInitiallyVisible() {
        return WelcomeScreenProjectProvider.Companion.isWelcomeScreenProject(this.project) && this.isWelcomeFileSelected();
    }

    public boolean isDefaultPane(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return WelcomeScreenProjectProvider.Companion.isWelcomeScreenProject(project) && this.isWelcomeFileSelected();
    }

    public int getWeight() {
        return -10;
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new WelcomeScreenLeftPanelSelectInTarget();
    }

    private final void setupDragAndDrop(JComponent component) {
        DnDNativeTarget target2 = new DnDNativeTarget(this){
            final /* synthetic */ WelcomeScreenLeftPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean update(DnDEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!FileCopyPasteUtil.isFileListFlavorAvailable((DnDEvent)event)) {
                    return false;
                }
                event.setDropPossible(true);
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void drop(DnDEvent event) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List list = FileCopyPasteUtil.getFileListFromAttachedObject((Object)event.getAttachedObject());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFileListFromAttachedObject(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void file;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(file.toPath());
                }
                List files = (List)destination$iv$iv;
                GoFileDragAndDropHandler.INSTANCE.openFiles(WelcomeScreenLeftPanel.access$getProject$p(this.this$0), files);
            }
        };
        DnDSupport.createBuilder((JComponent)component).enableAsNativeTarget().setTargetChecker((DnDTargetChecker)target2).setDropHandler((DnDDropHandler)target2).setDisposableParent((Disposable)this).install();
    }

    @NotNull
    public JComponent createComponent() {
        JBPanel jBPanel;
        JBPanel jBPanel2;
        JBPanel $this$createComponent_u24lambda_u240 = jBPanel2 = new JBPanel((LayoutManager)new BorderLayout());
        boolean bl = false;
        $this$createComponent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        JBPanel mainPanel = jBPanel2;
        RecentProjectFilteringTree projectFilteringTree = this.createRecentProjectTree();
        JComponent jComponent = projectFilteringTree.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.setupDragAndDrop(jComponent);
        this.recentProjectTreeComponent = projectFilteringTree.getComponent();
        JBPanel $this$createComponent_u24lambda_u241 = jBPanel = new JBPanel();
        boolean bl2 = false;
        $this$createComponent_u24lambda_u241.setLayout((LayoutManager)new BoxLayout((Container)$this$createComponent_u24lambda_u241, 1));
        $this$createComponent_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
        JBPanel topPanel = jBPanel;
        topPanel.add((Component)new WelcomeScreenLeftPanelActions(this.project).createButtonsComponent());
        topPanel.add((Component)this.separator((Function1<? super Row, Unit>)((Function1)WelcomeScreenLeftPanel::createComponent$lambda$2)));
        topPanel.add((Component)this.searchPanel(projectFilteringTree));
        topPanel.add((Component)WelcomeScreenLeftPanel.separator$default(this, null, 1, null));
        mainPanel.add((Component)topPanel, (Object)"North");
        mainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)projectFilteringTree.getComponent(), (int)20, (int)31), (Object)"Center");
        return (JComponent)mainPanel;
    }

    @Nullable
    public JComponent getComponentToFocus() {
        return this.recentProjectTreeComponent;
    }

    public void dispose() {
        this.recentProjectTreeComponent = null;
        super.dispose();
    }

    private final boolean isWelcomeFileSelected() {
        VirtualFile selected;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        VirtualFile virtualFile = selected = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
        return (virtualFile != null ? virtualFile.getFileType() : null) instanceof WelcomeScreenRightTabVirtualFile.WelcomeScreenFileType;
    }

    private final void ensurePaneVisible(boolean visible) {
        ProjectView projectView = ProjectViewImpl.getInstance((Project)this.project);
        AbstractProjectViewPane existing = projectView.getProjectViewPaneById(ID);
        if (visible) {
            if (existing == null) {
                projectView.addProjectPane((AbstractProjectViewPane)this);
            }
        } else if (existing != null) {
            projectView.removeProjectPane(existing);
        }
    }

    private final void syncPaneVisibilityWithCurrentEditor() {
        this.ensurePaneVisible(this.isWelcomeFileSelected());
    }

    private final DialogPanel searchPanel(RecentProjectFilteringTree recentProjectTree) {
        return BuilderKt.panel(arg_0 -> WelcomeScreenLeftPanel.searchPanel$lambda$0(this, recentProjectTree, arg_0));
    }

    private final RecentProjectFilteringTree createRecentProjectTree() {
        RecentProjectFilteringTree recentProjectFilteringTree;
        RecentProjectFilteringTree $this$createRecentProjectTree_u24lambda_u240 = recentProjectFilteringTree = RecentProjectPanelComponentFactory.createComponent((Disposable)((Disposable)this), (List)ProjectCollectors.all, null);
        boolean bl = false;
        $this$createRecentProjectTree_u24lambda_u240.getTree().getEmptyText().setText(NonModalWelcomeScreenBundle.message("welcome.screen.no.recent.projects", new Object[0]));
        $this$createRecentProjectTree_u24lambda_u240.selectLastOpenedProject();
        return recentProjectFilteringTree;
    }

    private final SearchTextField createProjectSearchField(RecentProjectFilteringTree recentProjectTree) {
        SearchTextField searchTextField;
        SearchTextField $this$createProjectSearchField_u24lambda_u240 = searchTextField = recentProjectTree.installSearchField();
        boolean bl = false;
        if (ExperimentalUI.Companion.isNewUI()) {
            $this$createProjectSearchField_u24lambda_u240.getTextEditor().putClientProperty((Object)"JTextField.Search.Icon", (Object)AllIcons.Actions.Search);
        }
        return searchTextField;
    }

    private final DialogPanel separator(Function1<? super Row, Unit> customize) {
        return BuilderKt.panel(arg_0 -> WelcomeScreenLeftPanel.separator$lambda$1(customize, arg_0));
    }

    static /* synthetic */ DialogPanel separator$default(WelcomeScreenLeftPanel welcomeScreenLeftPanel, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = WelcomeScreenLeftPanel::separator$lambda$0;
        }
        return welcomeScreenLeftPanel.separator((Function1<? super Row, Unit>)function1);
    }

    private static final Unit createComponent$lambda$2(Row $this$separator) {
        Intrinsics.checkNotNullParameter((Object)$this$separator, (String)"$this$separator");
        $this$separator.customize(UnscaledGapsYKt.UnscaledGapsY$default((int)17, (int)0, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit searchPanel$lambda$0(WelcomeScreenLeftPanel this$0, RecentProjectFilteringTree $recentProjectTree, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> WelcomeScreenLeftPanel.searchPanel$lambda$0$0(this$0, $recentProjectTree, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit searchPanel$lambda$0$0(WelcomeScreenLeftPanel this$0, RecentProjectFilteringTree $recentProjectTree, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SearchTextField projectSearch = this$0.createProjectSearchField($recentProjectTree);
        $this$row.cell((JComponent)projectSearch).align((Align)AlignX.FILL.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps((int)4, (int)20, (int)4, (int)20));
        return Unit.INSTANCE;
    }

    private static final Unit separator$lambda$0(Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit separator$lambda$1(Function1 $customize, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $customize.invoke((Object)Panel.separator$default((Panel)$this$panel, null, (int)1, null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/ide/nonModalWelcomeScreen/leftPanel/WelcomeScreenLeftPanel$Companion;", "", "<init>", "()V", "ID", "", "intellij.platform.ide.nonModalWelcomeScreen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

