/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.builder.edges.CollapsedEdgeImpl;
import com.intellij.openapi.graph.builder.edges.SingleEdge;
import com.intellij.openapi.graph.builder.edges.SingleEdgeWrapper;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.services.GraphGroupingService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001BB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J(\u0010\r\u001a\u0004\u0018\u00010\f2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016J$\u0010\u000f\u001a\u00020\u00102\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0011\u001a\u00020\bH\u0002J$\u0010\u001a\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J8\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001d2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001fH\u0002JT\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0!2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#2\u0006\u0010$\u001a\u00020\u00102\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\f0&H\u0002JX\u0010'\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001f2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001d2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u001c\u0010)\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0002J$\u0010*\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u000e\u001a\u00020\bH\u0002J$\u0010$\u001a\u00020\u00192\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u000e\u001a\u00020\bH\u0002J6\u0010$\u001a\u00020\u00192\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u00130!H\u0002J\"\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u00130!2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\"\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u00130!2\u0006\u0010\u0011\u001a\u00020\bH\u0002J*\u00100\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u00130!2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u00101\u001a\u00020\u0010H\u0002J\u001c\u00102\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0002J,\u00103\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020-H\u0002J,\u00107\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J@\u00108\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u000e\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020\u0010H\u0002J@\u0010<\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u000e\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020\u0010H\u0002J2\u0010=\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010>\u001a\u00020\u00192\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\f0@2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0002\u00a8\u0006C"}, d2={"Lcom/intellij/openapi/graph/impl/GraphGroupingServiceImpl;", "N", "", "E", "Lcom/intellij/openapi/graph/services/GraphGroupingService;", "GraphGroupingServiceImpl", "()V", "getGroupNode", "Lcom/intellij/openapi/graph/base/Node;", "builder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "groupDescriptor", "Lcom/intellij/openapi/graph/builder/NodeGroupDescriptor;", "getGroupDescriptor", "groupNode", "isGroupOrFolderNode", "", "node", "y", "", "graph", "Lcom/intellij/openapi/graph/base/Graph;", "hierarchyManager", "Lcom/intellij/openapi/graph/view/hierarchy/HierarchyManager;", "y", "", "updateGroups", "withCollapsedEdges", "y", "", "dataMaps", "Lcom/intellij/openapi/graph/impl/builder/GraphDataMaps;", "y", "", "nodesToGroup", "", "collapseEdges", "nodeToGroupDescriptor", "Ljava/util/function/Function;", "y", "newNodes", "y", "z", "graphBuilder", "nodes2Edges", "Lcom/intellij/openapi/graph/base/Edge;", "y", "z", "y", "inEdges", "z", "y", "collapsedEdge", "Lcom/intellij/openapi/graph/builder/edges/CollapsedEdge;", "graphCollapsedEdge", "toggleGroup", "y", "realizer", "Lcom/intellij/openapi/graph/view/hierarchy/GroupNodeRealizer;", "group", "z", "groupNodesExternally", "ungroupNodesExternally", "y", "", "Lcom/intellij/openapi/graph/builder/GraphIdentifiable$Node$Identity;", "Companion", "intellij.platform.graph.impl"})
@SourceDebugExtension(value={"SMAP\nGraphGroupingServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphGroupingServiceImpl.kt\ncom/intellij/openapi/graph/impl/GraphGroupingServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,477:1\n1563#2:478\n1634#2,3:479\n1491#2:482\n1516#2,3:483\n1519#2,3:493\n774#2:496\n865#2,2:497\n1869#2,2:499\n1563#2:501\n1634#2,3:502\n1563#2:505\n1634#2,2:506\n1636#2:510\n774#2:511\n865#2,2:512\n1869#2,2:514\n774#2:516\n865#2,2:517\n1869#2,2:519\n382#3,7:486\n37#4,2:508\n*S KotlinDebug\n*F\n+ 1 GraphGroupingServiceImpl.kt\ncom/intellij/openapi/graph/impl/GraphGroupingServiceImpl\n*L\n132#1:478\n132#1:479,3\n147#1:482\n147#1:483,3\n147#1:493,3\n151#1:496\n151#1:497,2\n152#1:499,2\n157#1:501\n157#1:502,3\n166#1:505\n166#1:506,2\n166#1:510\n167#1:511\n167#1:512,2\n168#1:514,2\n172#1:516\n172#1:517,2\n180#1:519,2\n147#1:486,7\n166#1:508,2\n*E\n"})
public final class GraphGroupingServiceImpl<N, E>
implements GraphGroupingService<N, E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor>> EXTERNAL_GROUPING_KEY;

    @Nullable
    public Node getGroupNode(@NotNull GraphBuilder<N, E> builder, @Nullable NodeGroupDescriptor groupDescriptor) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return groupDescriptor == null ? null : GraphImplUtil.getGroupNode(((GraphBuilderImpl)builder).getDataMaps(), groupDescriptor);
    }

    @Nullable
    public NodeGroupDescriptor getGroupDescriptor(@NotNull GraphBuilder<N, E> builder, @Nullable Node groupNode) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return groupNode == null ? null : GraphImplUtil.getGroup(((GraphBuilderImpl)builder).getDataMaps(), groupNode);
    }

    public boolean isGroupOrFolderNode(@NotNull GraphBuilder<N, E> builder, @NotNull Node node) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return !builder.getHierarchyManager().isNormalNode(node);
    }

    private final Set<Node> y(Graph graph, HierarchyManager hierarchyManager) {
        Node[] nodeArray = graph.getNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"getNodeArray(...)");
        Set set = ArraysKt.toMutableSet((Object[])nodeArray);
        Node[] nodeArray2 = hierarchyManager.getFolderNodes(graph, false).toNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray2, (String)"toNodeArray(...)");
        for (Node node : nodeArray2) {
            Graph graph2 = hierarchyManager.getInnerGraph(node);
            Intrinsics.checkNotNullExpressionValue((Object)graph2, (String)"getInnerGraph(...)");
            set.addAll((Collection)this.y(graph2, hierarchyManager));
        }
        return set;
    }

    private final void y(GraphBuilder<N, E> graphBuilder, Node node) {
        graphBuilder.getActionExecutor().assertWriteAccess();
        Node node2 = graphBuilder.getHierarchyManager().getParentNode(node);
        if (node2 == null) {
            return;
        }
        if (graphBuilder.getHierarchyManager().isFolderNode(node2)) {
            graphBuilder.getHierarchyManager().unfoldSubgraph(node.getGraph(), GraphManager.getGraphManager().createNodeList(node));
        } else if (graphBuilder.getHierarchyManager().isGroupNode(node2)) {
            graphBuilder.getHierarchyManager().ungroupSubgraph(GraphManager.getGraphManager().createNodeList(node));
        }
    }

    public void updateGroups(@NotNull GraphBuilder<N, E> builder, boolean withCollapsedEdges) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        builder.getActionExecutor().assertWriteAccess();
        GraphDataModel graphDataModel = builder.getGraphDataModel();
        Intrinsics.checkNotNull((Object)graphDataModel, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.builder.GraphDataModel<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
        GraphDataModel graphDataModel2 = graphDataModel;
        GraphDataMaps graphDataMaps = ((GraphBuilderImpl)builder).getDataMaps();
        Intrinsics.checkNotNullExpressionValue(graphDataMaps, (String)"getDataMaps(...)");
        GraphDataMaps graphDataMaps2 = graphDataMaps;
        Set<Node> set = this.y(builder, graphDataMaps2);
        Graph2D graph2D = ((GraphBuilderImpl)builder).getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D, (String)"getGraph(...)");
        Graph graph = (Graph)graph2D;
        HierarchyManager hierarchyManager = ((GraphBuilderImpl)builder).getHierarchyManager();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchyManager, (String)"getHierarchyManager(...)");
        this.y(builder, graph, hierarchyManager, graphDataMaps2, set, withCollapsedEdges);
        if (withCollapsedEdges) {
            this.y(builder);
            this.z(builder);
        }
        Graph2D graph2D2 = ((GraphBuilderImpl)builder).getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D2, (String)"getGraph(...)");
        Graph graph2 = (Graph)graph2D2;
        HierarchyManager hierarchyManager2 = ((GraphBuilderImpl)builder).getHierarchyManager();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchyManager2, (String)"getHierarchyManager(...)");
        this.y(builder, (Collection<Node>)this.y(graph2, hierarchyManager2), withCollapsedEdges, arg_0 -> GraphGroupingServiceImpl.y(builder, graphDataModel2, this, arg_0));
    }

    private final Set<Node> y(GraphBuilder<N, E> graphBuilder, GraphDataMaps<N, E> graphDataMaps) {
        graphBuilder.getActionExecutor().assertGraphThread();
        GraphDataModel graphDataModel = graphBuilder.getGraphDataModel();
        Intrinsics.checkNotNullExpressionValue((Object)graphDataModel, (String)"getGraphDataModel(...)");
        GraphDataModel graphDataModel2 = graphDataModel;
        for (NodeGroupDescriptor nodeGroupDescriptor : graphDataModel2.getGroupNodes()) {
            GraphImplUtil.getOrCreateGroupNode(graphBuilder.getGraph(), graphBuilder.getHierarchyManager(), nodeGroupDescriptor, graphDataMaps, graphDataModel2);
        }
        Collection collection = graphDataModel2.getGroupNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getGroupNodes(...)");
        Iterable iterable = collection;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl3 = false;
        Iterator iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            Object t2 = iterator.next();
            NodeGroupDescriptor nodeGroupDescriptor = (NodeGroupDescriptor)t2;
            Collection collection3 = collection2;
            boolean bl4 = false;
            collection3.add(graphBuilder.getGroupNode(nodeGroupDescriptor));
        }
        return CollectionsKt.toSet((Iterable)((List)collection2));
    }

    private final Map<NodeGroupDescriptor, Node> y(GraphBuilder<N, E> graphBuilder, Collection<? extends Node> collection, boolean bl2, Function<Node, NodeGroupDescriptor> function) {
        Collection collection2;
        Object object;
        boolean bl3;
        Object object2;
        Object object3;
        if (!(graphBuilder instanceof GraphBuilderImpl)) {
            return MapsKt.emptyMap();
        }
        HierarchyManager hierarchyManager = ((GraphBuilderImpl)graphBuilder).getHierarchyManager();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchyManager, (String)"getHierarchyManager(...)");
        HierarchyManager hierarchyManager2 = hierarchyManager;
        GraphDataMaps graphDataMaps = ((GraphBuilderImpl)graphBuilder).getDataMaps();
        Intrinsics.checkNotNullExpressionValue(graphDataMaps, (String)"getDataMaps(...)");
        GraphDataMaps graphDataMaps2 = graphDataMaps;
        Iterable iterable = collection;
        boolean bl4 = false;
        Object object4 = iterable;
        Iterator iterator3 = new LinkedHashMap();
        boolean bl5 = false;
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            Object object5;
            object3 = iterator2.next();
            object2 = (Node)object3;
            bl3 = false;
            NodeGroupDescriptor nodeGroupDescriptor = function.apply((Node)object2);
            object = iterator3;
            NodeGroupDescriptor nodeGroupDescriptor2 = nodeGroupDescriptor;
            boolean bl6 = false;
            Object v2 = object.get(nodeGroupDescriptor2);
            if (v2 == null) {
                boolean bl7 = false;
                List list = new ArrayList();
                object.put(nodeGroupDescriptor2, list);
                object5 = list;
            } else {
                object5 = v2;
            }
            List list = (List)object5;
            list.add(object3);
        }
        Map map = iterator3;
        iterable = map.getOrDefault(null, CollectionsKt.emptyList());
        bl4 = false;
        object4 = iterable;
        iterator3 = new ArrayList();
        bl5 = false;
        iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            object3 = iterator2.next();
            object2 = (Node)object3;
            bl3 = false;
            if (!(!hierarchyManager2.isRootGraph(object2.getGraph()))) continue;
            iterator3.add(object3);
        }
        iterable = (List)((Object)iterator3);
        bl4 = false;
        for (Iterator iterator3 : iterable) {
            Node node = (Node)iterator3;
            boolean bl8 = false;
            this.y(graphBuilder, node);
        }
        Iterable iterable2 = CollectionsKt.filterNotNull((Iterable)map.keySet());
        boolean bl9 = false;
        iterator3 = iterable2;
        Collection<Object> collection32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean bl10 = false;
        object3 = iterator3.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            NodeGroupDescriptor nodeGroupDescriptor = (NodeGroupDescriptor)object2;
            collection2 = collection32;
            boolean bl11 = false;
            collection2.add(TuplesKt.to((Object)nodeGroupDescriptor, (Object)GraphImplUtil.getOrCreateGroupNode(((GraphBuilderImpl)graphBuilder).getGraph(), hierarchyManager2, nodeGroupDescriptor, graphDataMaps2, ((GraphBuilderImpl)graphBuilder).getGraphDataModel())));
        }
        iterable = (List)collection32;
        iterable2 = CollectionsKt.sortedWith((Iterable)iterable, (arg_0, arg_1) -> GraphGroupingServiceImpl.z((arg_0, arg_1) -> GraphGroupingServiceImpl.z(hierarchyManager2, arg_0, arg_1), arg_0, arg_1));
        bl9 = false;
        iterator3 = iterable2;
        collection32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        bl10 = false;
        object3 = iterator3.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            Pair pair = (Pair)object2;
            collection2 = collection32;
            boolean bl12 = false;
            Object object6 = pair.getSecond();
            GraphManager graphManager = GraphManager.getGraphManager();
            Object v3 = map.get(pair.getFirst());
            Intrinsics.checkNotNull(v3);
            object = (Collection)v3;
            boolean bl13 = false;
            Object object7 = object;
            collection2.add(TuplesKt.to((Object)object6, (Object)graphManager.createNodeList(object7.toArray(new Node[0]))));
        }
        iterable2 = (List)collection32;
        bl9 = false;
        iterator3 = iterable2;
        collection32 = new ArrayList();
        bl10 = false;
        object3 = iterator3.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            Pair pair = (Pair)object2;
            boolean bl14 = false;
            if (!(!((NodeList)pair.getSecond()).isEmpty())) continue;
            collection32.add(object2);
        }
        iterable2 = (List)collection32;
        bl9 = false;
        for (Collection<Object> collection32 : iterable2) {
            Pair pair = (Pair)collection32;
            boolean bl15 = false;
            hierarchyManager2.groupSubgraph((NodeList)pair.getSecond(), (Node)pair.getFirst());
        }
        iterable2 = iterable;
        bl9 = false;
        iterator3 = iterable2;
        collection32 = new ArrayList();
        boolean bl16 = false;
        Iterator iterator4 = iterator3.iterator();
        while (iterator4.hasNext()) {
            object2 = iterator4.next();
            Pair pair = (Pair)object2;
            boolean bl17 = false;
            Object object8 = object = GraphImplUtil.getGroup(graphDataMaps2, (Node)pair.getSecond());
            boolean bl18 = object8 != null ? object8.isClosed() : ((NodeGroupDescriptor)pair.getFirst()).isClosed();
            if (!(bl18 && hierarchyManager2.isGroupNode((Node)pair.getSecond()))) continue;
            collection32.add(object2);
        }
        iterable2 = CollectionsKt.sortedWith((Iterable)((List)collection32), (arg_0, arg_1) -> GraphGroupingServiceImpl.y((arg_0, arg_1) -> GraphGroupingServiceImpl.y(hierarchyManager2, arg_0, arg_1), arg_0, arg_1));
        bl9 = false;
        for (Collection<Object> collection32 : iterable2) {
            Pair pair = (Pair)collection32;
            boolean bl19 = false;
            Object object9 = pair.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"<get-second>(...)");
            this.z(graphBuilder, (Node)object9, ((NodeGroupDescriptor)pair.getFirst()).createGroupNodeRealizer(), (NodeGroupDescriptor)pair.getFirst(), bl2);
        }
        return MapsKt.toMap((Iterable)iterable);
    }

    private final void y(GraphBuilder<N, E> graphBuilder, Graph graph, HierarchyManager hierarchyManager, GraphDataMaps<N, E> graphDataMaps, Set<? extends Node> set, boolean bl2) {
        Set<Node> set2 = this.y(graph, hierarchyManager);
        set2.removeIf(arg_0 -> GraphGroupingServiceImpl.y(arg_0 -> GraphGroupingServiceImpl.y(set, hierarchyManager, arg_0), arg_0));
        hierarchyManager.preTraverse(arg_0 -> GraphGroupingServiceImpl.y(set2, hierarchyManager, this, graphBuilder, bl2, arg_0));
        graphBuilder.getActionExecutor().runWriteAction(() -> GraphGroupingServiceImpl.y(graphDataMaps, set2));
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            if (set2.contains(nodeCursor.node()) && graph.contains(nodeCursor.node())) {
                graph.removeNode(nodeCursor.node());
            }
            nodeCursor.next();
        }
    }

    private final void y(GraphBuilder<N, E> graphBuilder) {
        graphBuilder.getHierarchyManager().preTraverse(arg_0 -> GraphGroupingServiceImpl.y(graphBuilder, this, arg_0));
    }

    private final void z(GraphBuilder<N, E> graphBuilder, Node node) {
        graphBuilder.getActionExecutor().assertGraphThread();
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            CollapsedEdge collapsedEdge = graphBuilder.getCollapsedEdgeObject(edgeCursor.edge());
            if (collapsedEdge == null) {
                edgeCursor.next();
                continue;
            }
            graphBuilder.getActionExecutor().runWriteAction(() -> GraphGroupingServiceImpl.z(this, graphBuilder, collapsedEdge, edgeCursor));
            NodeCursor nodeCursor = graphBuilder.getHierarchyManager().getChildren(node);
            while (nodeCursor.ok()) {
                if (graphBuilder.getHierarchyManager().isFolderNode(nodeCursor.node())) {
                    Node node2 = nodeCursor.node();
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node(...)");
                    this.i(graphBuilder, node2);
                }
                nodeCursor.next();
            }
            edgeCursor.next();
        }
    }

    private final void i(GraphBuilder<N, E> graphBuilder, Node node) {
        this.y(graphBuilder, this.y(node));
        this.y(graphBuilder, this.z(node));
    }

    private final void y(GraphBuilder<N, E> graphBuilder, Map<Node, ? extends Set<Edge>> map) {
        Iterator<Map.Entry<Node, ? extends Set<Edge>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            CollapsedEdge collapsedEdge;
            Set<Edge> set = iterator.next().getValue();
            if (set.size() <= 1) continue;
            Node node = ((Edge)CollectionsKt.first((Iterable)set)).source();
            Node node2 = ((Edge)CollectionsKt.first((Iterable)set)).target();
            Intrinsics.checkNotNull((Object)node);
            Intrinsics.checkNotNull((Object)node2);
            CollapsedEdge collapsedEdge2 = (CollapsedEdge)new CollapsedEdgeImpl(node, node2, (Collection)new ArrayList());
            for (Edge edge : set) {
                Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
                Object object = GraphImplUtil.getEdgeObject(((GraphBuilderImpl)graphBuilder).getDataMaps(), edge);
                collapsedEdge = GraphImplUtil.getCollapsedEdgeObject(((GraphBuilderImpl)graphBuilder).getDataMaps(), edge);
                if (object != null) {
                    Collection collection = collapsedEdge2.getEdges();
                    Node node3 = ((GraphBuilderImpl)graphBuilder).getHierarchyManager().getRealSource(edge);
                    Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getRealSource(...)");
                    Node node4 = ((GraphBuilderImpl)graphBuilder).getHierarchyManager().getRealTarget(edge);
                    Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"getRealTarget(...)");
                    collection.add(new SingleEdgeWrapper(object, node3, node4));
                } else if (collapsedEdge != null) {
                    collapsedEdge2.getEdges().addAll(collapsedEdge.getEdges());
                }
                edge.getGraph().removeEdge(edge);
            }
            Edge edge = (Edge)graphBuilder.getActionExecutor().computeWriteAction(() -> GraphGroupingServiceImpl.y(graphBuilder, collapsedEdge2));
            Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
            Map<Edge, CollapsedEdge> map2 = ((GraphBuilderImpl)graphBuilder).getDataMaps().getCollapsedEdgeDataMap();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getCollapsedEdgeDataMap(...)");
            map2.put(edge, collapsedEdge2);
            for (Object object : collapsedEdge2.getEdges()) {
                Intrinsics.checkNotNullExpressionValue(((GraphBuilderImpl)graphBuilder).getDataMaps().getEdgeObjects2ParentCollapsedEdgesMap(), (String)"getEdgeObjects2ParentCollapsedEdgesMap(...)");
                Object object2 = object.getOriginalEdge();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl");
                collapsedEdge.put(object2, collapsedEdge2);
            }
        }
    }

    private final Map<Node, Set<Edge>> y(Node node) {
        return this.y(node, true);
    }

    private final Map<Node, Set<Edge>> z(Node node) {
        return this.y(node, false);
    }

    private final Map<Node, Set<Edge>> y(Node node, boolean bl2) {
        EdgeCursor edgeCursor;
        Map map = new HashMap();
        EdgeCursor edgeCursor2 = edgeCursor = bl2 ? node.inEdges() : node.outEdges();
        while (edgeCursor.ok()) {
            Node node2;
            Node node3 = node2 = bl2 ? edgeCursor.edge().source() : edgeCursor.edge().target();
            if (!map.containsKey(node2)) {
                map.put(node2, new HashSet());
            }
            Object v2 = map.get(node2);
            Intrinsics.checkNotNull(v2);
            Set set = (Set)v2;
            Edge edge = edgeCursor.edge();
            Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"edge(...)");
            set.add(edge);
            edgeCursor.next();
        }
        return map;
    }

    private final void z(GraphBuilder<N, E> graphBuilder) {
        graphBuilder.getActionExecutor().assertGraphThread();
        EdgeCursor edgeCursor = graphBuilder.getGraph().edges();
        while (edgeCursor.ok()) {
            CollapsedEdge collapsedEdge = graphBuilder.getCollapsedEdgeObject(edgeCursor.edge());
            if (collapsedEdge != null && collapsedEdge.getEdges().size() <= 1) {
                graphBuilder.getActionExecutor().runWriteAction(() -> GraphGroupingServiceImpl.y(this, graphBuilder, collapsedEdge, edgeCursor));
            }
            edgeCursor.next();
        }
    }

    private final void y(GraphBuilder<N, E> graphBuilder, CollapsedEdge collapsedEdge, Edge edge) {
        graphBuilder.getActionExecutor().assertWriteAccess();
        for (SingleEdge singleEdge : collapsedEdge.getEdges()) {
            Edge edge2 = graphBuilder.getHierarchyManager().createEdge(singleEdge.getSource(), singleEdge.getTarget());
            Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
            GraphDataMaps graphDataMaps = ((GraphBuilderImpl)graphBuilder).getDataMaps();
            Object object = singleEdge.getOriginalEdge();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl");
            graphDataMaps.replaceEdge(object, edge2);
        }
        edge.getGraph().removeEdge(edge);
        Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
        ((GraphBuilderImpl)graphBuilder).getDataMaps().removeEdge(edge);
    }

    public void toggleGroup(@NotNull GraphBuilder<N, E> builder, @NotNull Node groupNode, boolean withCollapsedEdges) {
        GroupNodeRealizer groupNodeRealizer;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)groupNode, (String)"groupNode");
        NodeGroupDescriptor nodeGroupDescriptor = this.getGroupDescriptor(builder, groupNode);
        NodeRealizer nodeRealizer = builder.getGraph().getRealizer(groupNode);
        GroupNodeRealizer groupNodeRealizer2 = groupNodeRealizer = nodeRealizer instanceof GroupNodeRealizer ? (GroupNodeRealizer)nodeRealizer : null;
        if (builder.getHierarchyManager().isFolderNode(groupNode)) {
            this.y(builder, groupNode, groupNodeRealizer, nodeGroupDescriptor, withCollapsedEdges);
        } else if (builder.getHierarchyManager().isGroupNode(groupNode)) {
            this.z(builder, groupNode, groupNodeRealizer, nodeGroupDescriptor, withCollapsedEdges);
        }
    }

    private final void y(GraphBuilder<N, E> graphBuilder, Node node, GroupNodeRealizer groupNodeRealizer, NodeGroupDescriptor nodeGroupDescriptor, boolean bl2) {
        graphBuilder.getHierarchyManager().openFolder(node);
        if (groupNodeRealizer != null) {
            groupNodeRealizer.setGroupClosed(false);
        }
        if (nodeGroupDescriptor != null) {
            nodeGroupDescriptor.setClosed(false);
        }
        if (bl2) {
            this.z(graphBuilder, node);
        }
    }

    private final void z(GraphBuilder<N, E> graphBuilder, Node node, GroupNodeRealizer groupNodeRealizer, NodeGroupDescriptor nodeGroupDescriptor, boolean bl2) {
        graphBuilder.getHierarchyManager().closeGroup(node);
        if (groupNodeRealizer != null) {
            NodeLabel nodeLabel = groupNodeRealizer.getLabel();
            groupNodeRealizer.setGroupClosed(true);
            graphBuilder.getGraph().setSize(node, nodeLabel.getWidth(), (double)2 * nodeLabel.getHeight());
        }
        if (nodeGroupDescriptor != null) {
            nodeGroupDescriptor.setClosed(true);
        }
        if (bl2) {
            this.i(graphBuilder, node);
        }
    }

    @NotNull
    public Node groupNodesExternally(@NotNull GraphBuilder<N, E> builder, @NotNull Collection<? extends Node> nodesToGroup, @NotNull NodeGroupDescriptor groupDescriptor) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter(nodesToGroup, (String)"nodesToGroup");
        Intrinsics.checkNotNullParameter((Object)groupDescriptor, (String)"groupDescriptor");
        Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor> map = this.y(builder);
        for (Node node : nodesToGroup) {
            map.put(builder.getNodeIdentity(node), groupDescriptor);
        }
        Map<NodeGroupDescriptor, Node> map2 = this.y(builder, nodesToGroup, false, arg_0 -> GraphGroupingServiceImpl.y(groupDescriptor, arg_0));
        Object v2 = map2.get(groupDescriptor);
        Intrinsics.checkNotNull(v2);
        return (Node)v2;
    }

    public void ungroupNodesExternally(@NotNull GraphBuilder<N, E> builder, @NotNull NodeGroupDescriptor groupDescriptor) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)groupDescriptor, (String)"groupDescriptor");
        Node node = this.getGroupNode(builder, groupDescriptor);
        if (node == null) {
            return;
        }
        List list = NodeCursor.toList((NodeCursor)builder.getHierarchyManager().getChildren(node));
        Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor> map = this.y(builder);
        for (Node node2 : list) {
            map.remove(builder.getNodeIdentity(node2));
            Intrinsics.checkNotNull((Object)node2);
            this.y(builder, node2);
        }
    }

    private final Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor> y(GraphBuilder<N, E> graphBuilder) {
        Map map = (Map)graphBuilder.getUserData(EXTERNAL_GROUPING_KEY);
        if (map == null) {
            map = new HashMap();
            graphBuilder.putUserData(EXTERNAL_GROUPING_KEY, (Object)map);
        }
        return map;
    }

    private static final NodeGroupDescriptor y(GraphBuilder graphBuilder, GraphDataModel graphDataModel, GraphGroupingServiceImpl graphGroupingServiceImpl, Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object n2 = ((GraphBuilderImpl)graphBuilder).getNodeObject(node);
        if (n2 != null) {
            return graphDataModel.getGroup(n2);
        }
        NodeGroupDescriptor nodeGroupDescriptor = ((GraphBuilderImpl)graphBuilder).getGroupNodeObject(node);
        if (nodeGroupDescriptor != null) {
            return graphDataModel.getGroup(nodeGroupDescriptor);
        }
        return graphGroupingServiceImpl.y(graphBuilder).get(((GraphBuilderImpl)graphBuilder).getNodeIdentity(node));
    }

    private static final int z(HierarchyManager hierarchyManager, Pair pair, Pair pair2) {
        return hierarchyManager.getLocalGroupDepth((Node)pair2.getSecond()) - hierarchyManager.getLocalGroupDepth((Node)pair.getSecond());
    }

    private static final int z(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    private static final int y(HierarchyManager hierarchyManager, Pair pair, Pair pair2) {
        return hierarchyManager.getLocalGroupDepth((Node)pair2.getSecond()) - hierarchyManager.getLocalGroupDepth((Node)pair.getSecond());
    }

    private static final int y(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    private static final boolean y(Set set, HierarchyManager hierarchyManager, Node node) {
        return set.contains(node) || hierarchyManager.isNormalNode(node);
    }

    private static final boolean y(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final void y(Set set, HierarchyManager hierarchyManager, GraphGroupingServiceImpl graphGroupingServiceImpl, GraphBuilder graphBuilder, boolean bl2, Node node) {
        if (set.contains(node) && hierarchyManager.isFolderNode(node)) {
            Intrinsics.checkNotNull((Object)node);
            NodeRealizer nodeRealizer = graphBuilder.getGraph().getRealizer(node);
            graphGroupingServiceImpl.y(graphBuilder, node, nodeRealizer instanceof GroupNodeRealizer ? (GroupNodeRealizer)nodeRealizer : null, null, bl2);
        }
    }

    private static final void y(GraphDataMaps graphDataMaps, Set set) {
        graphDataMaps.removeNodes(set);
    }

    private static final void y(GraphBuilder graphBuilder, GraphGroupingServiceImpl graphGroupingServiceImpl, Node node) {
        if (graphBuilder.getHierarchyManager().isFolderNode(node)) {
            Intrinsics.checkNotNull((Object)node);
            graphGroupingServiceImpl.i(graphBuilder, node);
        }
    }

    private static final void z(GraphGroupingServiceImpl graphGroupingServiceImpl, GraphBuilder graphBuilder, CollapsedEdge collapsedEdge, EdgeCursor edgeCursor) {
        Edge edge = edgeCursor.edge();
        Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"edge(...)");
        graphGroupingServiceImpl.y(graphBuilder, collapsedEdge, edge);
    }

    private static final Edge y(GraphBuilder graphBuilder, CollapsedEdge collapsedEdge) {
        HierarchyManager hierarchyManager = graphBuilder.getHierarchyManager();
        Intrinsics.checkNotNull((Object)graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
        Object[] objectArray = new Object[]{collapsedEdge};
        return GraphImplUtil.createCollapsedEdge(hierarchyManager, ((GraphBuilderImpl)graphBuilder).getDataMaps(), collapsedEdge, "", objectArray);
    }

    private static final void y(GraphGroupingServiceImpl graphGroupingServiceImpl, GraphBuilder graphBuilder, CollapsedEdge collapsedEdge, EdgeCursor edgeCursor) {
        Edge edge = edgeCursor.edge();
        Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"edge(...)");
        graphGroupingServiceImpl.y(graphBuilder, collapsedEdge, edge);
    }

    private static final NodeGroupDescriptor y(NodeGroupDescriptor nodeGroupDescriptor, Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"it");
        return nodeGroupDescriptor;
    }

    static {
        Key key = Key.create((String)"com.intellij.openapi.graph.impl.GraphGroupingServiceImpl.EXTERNAL_GROUPING_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EXTERNAL_GROUPING_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/graph/impl/GraphGroupingServiceImpl$Companion;", "", "GraphGroupingServiceImpl$Companion", "()V", "EXTERNAL_GROUPING_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/graph/builder/GraphIdentifiable$Node$Identity;", "Lcom/intellij/openapi/graph/builder/NodeGroupDescriptor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

