/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.impl.LspOpenedFilesService;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\b\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/lsp/impl/LspOpenedFilesService;", "", "project", "Lcom/intellij/openapi/project/Project;", "LspOpenedFilesService", "(Lcom/intellij/openapi/project/Project;)V", "openedFilesToHandle", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "processOpenedFiles", "", "files", "", "y", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspOpenedFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n774#2:110\n865#2,2:111\n1869#2,2:116\n1#3:113\n12970#4,2:114\n*S KotlinDebug\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService\n*L\n42#1:110\n42#1:111,2\n102#1:116,2\n68#1:114,2\n*E\n"})
public final class LspOpenedFilesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<VirtualFile> openedFilesToHandle;

    public LspOpenedFilesService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.openedFilesToHandle = set;
    }

    public final void processOpenedFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (!TrustedProjects.isProjectTrusted((Project)this.project)) {
            return;
        }
        if (!LspServerSupportProvider.Companion.getEP_NAME().hasAnyExtensions()) {
            return;
        }
        Iterable iterable = files;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t2 : iterable2) {
            VirtualFile virtualFile = (VirtualFile)t2;
            boolean bl4 = false;
            if (!virtualFile.isInLocalFileSystem()) continue;
            collection.add(t2);
        }
        List list = (List)collection;
        boolean bl5 = false;
        boolean bl6 = this.openedFilesToHandle.addAll(list);
        if (bl6) {
            this.y();
        }
    }

    private final void y() {
        LspServerManagerImpl lspServerManagerImpl = LspServerManagerImpl.Companion.getInstanceImpl(this.project);
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> LspOpenedFilesService.y(this, lspServerManagerImpl)).coalesceBy(objectArray).expireWith((Disposable)lspServerManagerImpl).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspOpenedFilesService.y(arg_0 -> LspOpenedFilesService.y(this, lspServerManagerImpl, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final scheduleOpenedFilesProcessing.OpenedFilesData y(LspOpenedFilesService lspOpenedFilesService, LspServerManagerImpl lspServerManagerImpl) {
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"com/intellij/platform/lsp/impl/LspOpenedFilesService$scheduleOpenedFilesProcessing$OpenedFilesData", "", "LspOpenedFilesService$scheduleOpenedFilesProcessing$OpenedFilesData", "()V", "handledFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getHandledFiles", "()Ljava/util/Set;", "serversToSendDidOpen", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "getServersToSendDidOpen", "()Lcom/intellij/util/containers/MultiMap;", "newServersToStart", "", "Lkotlin/Pair;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "getNewServersToStart", "()Ljava/util/Collection;", "intellij.platform.lsp.impl"})
        public final class OpenedFilesData {
            private final Set<VirtualFile> handledFiles;
            private final MultiMap<LspServerImpl, VirtualFile> serversToSendDidOpen;
            private final Collection<Pair<LspServerSupportProvider, LspServerDescriptor>> newServersToStart;

            public OpenedFilesData() {
                this.handledFiles = new HashSet<E>();
                this.serversToSendDidOpen = new MultiMap();
                this.newServersToStart = new ArrayList<E>();
            }

            public final Set<VirtualFile> getHandledFiles() {
                return this.handledFiles;
            }

            public final MultiMap<LspServerImpl, VirtualFile> getServersToSendDidOpen() {
                return this.serversToSendDidOpen;
            }

            public final Collection<Pair<LspServerSupportProvider, LspServerDescriptor>> getNewServersToStart() {
                return this.newServersToStart;
            }
        }
        OpenedFilesData openedFilesData = new OpenedFilesData();
        Object object2 = lspOpenedFilesService.openedFilesToHandle;
        synchronized (object2) {
            boolean bl2 = false;
            bl2 = openedFilesData.getHandledFiles().addAll((Collection<VirtualFile>)lspOpenedFilesService.openedFilesToHandle);
        }
        for (Object object2 : LspServerSupportProvider.Companion.getEP_NAME().getExtensionList()) {
            Collection<LspServerImpl> collection = lspServerManagerImpl.getServersForProvider(object2.getClass());
            boolean bl3 = false;
            for (VirtualFile virtualFile : openedFilesData.getHandledFiles()) {
                LspServerDescriptor lspServerDescriptor;
                int n2;
                for (LspServerImpl lspServerImpl : collection) {
                    boolean bl4;
                    block8: {
                        ProgressManager.checkCanceled();
                        VirtualFile[] virtualFileArray = lspServerImpl.getDescriptor().getRoots();
                        boolean bl5 = false;
                        int n3 = virtualFileArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            VirtualFile virtualFile2;
                            VirtualFile virtualFile3 = virtualFile2 = virtualFileArray[n2];
                            boolean bl6 = false;
                            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile3, (VirtualFile)virtualFile, (boolean)true)) continue;
                            bl4 = true;
                            break block8;
                        }
                        bl4 = false;
                    }
                    if (bl4 && lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile)) {
                        bl3 = true;
                    }
                    if (lspServerImpl.getState() != LspServerState.Running || lspServerImpl.isFileOpened$intellij_platform_lsp_impl(virtualFile) || !lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile)) continue;
                    openedFilesData.getServersToSendDidOpen().putValue((Object)lspServerImpl, (Object)virtualFile);
                }
                if (bl3 || !ProjectFileIndex.getInstance((Project)lspOpenedFilesService.project).isInContent(virtualFile)) continue;
                LspServerManagerImpl.LspServerStarterImpl lspServerStarterImpl = new LspServerManagerImpl.LspServerStarterImpl();
                object2.fileOpened(lspOpenedFilesService.project, virtualFile, lspServerStarterImpl);
                if (lspServerStarterImpl.getDescriptor() == null) continue;
                n2 = 0;
                openedFilesData.getNewServersToStart().add((Pair<LspServerSupportProvider, LspServerDescriptor>)TuplesKt.to((Object)object2, (Object)lspServerDescriptor));
            }
        }
        return openedFilesData;
    }

    private static final Unit y(LspOpenedFilesService lspOpenedFilesService, LspServerManagerImpl lspServerManagerImpl, scheduleOpenedFilesProcessing.OpenedFilesData openedFilesData) {
        Intrinsics.checkNotNullParameter((Object)openedFilesData, (String)"data");
        lspOpenedFilesService.openedFilesToHandle.removeAll((Collection)openedFilesData.getHandledFiles());
        if (!openedFilesData.getServersToSendDidOpen().isEmpty()) {
            WriteAction.run(() -> LspOpenedFilesService.y(openedFilesData));
        }
        Iterable iterable = openedFilesData.getNewServersToStart();
        boolean bl2 = false;
        for (Object t2 : iterable) {
            Pair pair = (Pair)t2;
            boolean bl3 = false;
            lspServerManagerImpl.ensureServerStarted(pair.getFirst().getClass(), (LspServerDescriptor)pair.getSecond());
        }
        return Unit.INSTANCE;
    }

    private static final void y(scheduleOpenedFilesProcessing.OpenedFilesData openedFilesData) {
        for (Map.Entry entry : openedFilesData.getServersToSendDidOpen().entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            LspServerImpl lspServerImpl = (LspServerImpl)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            for (VirtualFile virtualFile : collection) {
                Intrinsics.checkNotNull((Object)virtualFile);
                lspServerImpl.sendDidOpenRequest$intellij_platform_lsp_impl(virtualFile);
            }
        }
    }

    private static final void y(Function1 function1, Object object) {
        function1.invoke(object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/lsp/impl/LspOpenedFilesService$Companion;", "", "LspOpenedFilesService$Companion", "()V", "getInstance", "Lcom/intellij/platform/lsp/impl/LspOpenedFilesService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspOpenedFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,109:1\n30#2,2:110\n*S KotlinDebug\n*F\n+ 1 LspOpenedFilesService.kt\ncom/intellij/platform/lsp/impl/LspOpenedFilesService$Companion\n*L\n27#1:110,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LspOpenedFilesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl2 = false;
            Class<LspOpenedFilesService> clazz = LspOpenedFilesService.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (LspOpenedFilesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

