/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.inlayHintColor;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.highlightingCommon.LspCachedHighlighting;
import com.intellij.platform.lsp.impl.inlayHintColor.LspColorInlayHintsProviderKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J-\u0010\u001f\u001a\u00070\n\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006&"}, d2={"Lcom/intellij/platform/lsp/impl/inlayHintColor/LspColorInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "Lcom/intellij/openapi/project/DumbAware;", "LspColorInlayHintsProvider", "()V", "isVisibleInSettings", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "createSettings", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "y", "Lcom/intellij/openapi/util/NlsSafe;", "r", "", "g", "b", "a", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspColorInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspColorInlayHintsProvider.kt\ncom/intellij/platform/lsp/impl/inlayHintColor/LspColorInlayHintsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1374#2:109\n1460#2,5:110\n*S KotlinDebug\n*F\n+ 1 LspColorInlayHintsProvider.kt\ncom/intellij/platform/lsp/impl/inlayHintColor/LspColorInlayHintsProvider\n*L\n50#1:109\n50#1:110,5\n*E\n"})
public final class LspColorInlayHintsProvider
implements InlayHintsProvider<NoSettings>,
DumbAware {
    private final boolean isVisibleInSettings;
    @NotNull
    private final String name;
    @NotNull
    private final SettingsKey<NoSettings> key = LspColorInlayHintsProviderKt.access$getLspColorInlayHintsKey$p();
    @Nullable
    private final String previewText;

    public LspColorInlayHintsProvider() {
        this.name = "LSP-based color hints";
    }

    public boolean isVisibleInSettings() {
        return this.isVisibleInSettings;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return this.key;
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            public JComponent createComponent(ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return new JPanel();
            }
        };
    }

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 instanceof VirtualFileWindow || !virtualFile2.isInLocalFileSystem()) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t2 : iterable2) {
            Object object = (LspServerImpl)t2;
            boolean bl4 = false;
            object = ((LspServerImpl)object).getColorInfos$intellij_platform_lsp_impl(virtualFile2);
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        List list = (List)collection;
        if (list.isEmpty()) {
            return null;
        }
        return new InlayHintsCollector(file, list, this){
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ List<LspCachedHighlighting<org.eclipse.lsp4j.Color>> $colorInfos;
            final /* synthetic */ LspColorInlayHintsProvider this$0;
            {
                this.$file = $file;
                this.$colorInfos = $colorInfos;
                this.this$0 = $receiver;
            }

            public boolean collect(PsiElement element, Editor editor, InlayHintsSink sink) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                if (element != this.$file) {
                    return true;
                }
                int n2 = MathKt.roundToInt((float)((float)12 * JBUIScale.getFontScale((float)editor.getColorsScheme().getEditorFontSize2D())));
                int n3 = JBUI.scale((int)4);
                Color color = editor.getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR);
                PresentationFactory presentationFactory = new PresentationFactory(editor);
                ScaleAwarePresentationFactory scaleAwarePresentationFactory = new ScaleAwarePresentationFactory(editor, presentationFactory);
                for (LspCachedHighlighting<org.eclipse.lsp4j.Color> lspCachedHighlighting : this.$colorInfos) {
                    int n4 = MathKt.roundToInt((double)(lspCachedHighlighting.getHighlightingInfo().getRed() * (double)255));
                    int n5 = MathKt.roundToInt((double)(lspCachedHighlighting.getHighlightingInfo().getGreen() * (double)255));
                    int n6 = MathKt.roundToInt((double)(lspCachedHighlighting.getHighlightingInfo().getBlue() * (double)255));
                    int n7 = MathKt.roundToInt((double)(lspCachedHighlighting.getHighlightingInfo().getAlpha() * (double)255));
                    if (n4 < 0 || n4 > 255 || n5 < 0 || n5 > 255 || n6 < 0 || n6 > 255 || n7 < 0 || n7 > 255) continue;
                    Color color2 = new Color(n4, n5, n6, n7);
                    ColorIcon colorIcon = new ColorIcon(n2, n2, n2, n2, color2, color, n3);
                    InlayPresentation inlayPresentation = (InlayPresentation)presentationFactory.icon((Icon)colorIcon);
                    inlayPresentation = scaleAwarePresentationFactory.lineCentered(inlayPresentation);
                    inlayPresentation = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)scaleAwarePresentationFactory, (InlayPresentation)inlayPresentation, (int)2, (int)2, (int)0, (int)0, (int)24, null);
                    inlayPresentation = presentationFactory.withTooltip(LspColorInlayHintsProvider.access$getTooltip(this.this$0, n4, n5, n6, n7), inlayPresentation);
                    sink.addInlineElement(lspCachedHighlighting.getTextRange().getStartOffset(), false, inlayPresentation, false);
                }
                return true;
            }
        };
    }

    private final String y(int n2, int n3, int n4, int n5) {
        StringBuilder stringBuilder;
        String string = switch (n5) {
            case 255 -> "";
            case 0 -> " / 0";
            default -> " / " + MathKt.roundToInt((double)((double)n5 * 100.0 / 255.0)) + "%";
        };
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        stringBuilder2.append("#");
        String string2 = Integer.toString(n2, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        stringBuilder2.append(StringsKt.padStart((String)string2, (int)2, (char)'0'));
        String string3 = Integer.toString(n3, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        stringBuilder2.append(StringsKt.padStart((String)string3, (int)2, (char)'0'));
        String string4 = Integer.toString(n4, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        stringBuilder2.append(StringsKt.padStart((String)string4, (int)2, (char)'0'));
        if (n5 != 255) {
            String string5 = Integer.toString(n5, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            stringBuilder2.append(StringsKt.padStart((String)string5, (int)2, (char)'0'));
        }
        String string6 = stringBuilder.toString();
        return "rgb(" + n2 + " " + n3 + " " + n4 + string + ")\n" + string6;
    }

    public static final /* synthetic */ String access$getTooltip(LspColorInlayHintsProvider $this, int r2, int g2, int b10, int a2) {
        return $this.y(r2, g2, b10, a2);
    }
}

