/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.timeTracking.TimeTrackingManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import javax.swing.AbstractButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/tasks/timeTracking/TimeTrackingConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cbEnableTimeTracking", "Lcom/intellij/ui/components/JBCheckBox;", "tfTimeTrackingSuspendDelay", "Lcom/intellij/ui/components/JBTextField;", "config", "Lcom/intellij/tasks/timeTracking/TimeTrackingManager$Config;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "reset", "", "isModified", "", "apply", "intellij.tasks.timeTracking"})
final class TimeTrackingConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private Project project;
    private JBCheckBox cbEnableTimeTracking;
    private JBTextField tfTimeTrackingSuspendDelay;
    @NotNull
    private final TimeTrackingManager.Config config;

    public TimeTrackingConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = IdeBundle.message((String)"configurable.TimeTrackingConfigurable.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "settings.tools.timeTracking", "tasks.timeTracking");
        this.project = project;
        this.config = TimeTrackingManager.Companion.getInstance(this.project).getState();
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> TimeTrackingConfigurable.createPanel$lambda$0(this, arg_0));
    }

    public void reset() {
        super.reset();
        JBCheckBox jBCheckBox = this.cbEnableTimeTracking;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEnableTimeTracking");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(this.config.enabled);
        JBTextField jBTextField = this.tfTimeTrackingSuspendDelay;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tfTimeTrackingSuspendDelay");
            jBTextField = null;
        }
        jBTextField.setText(String.valueOf(this.config.suspendDelayInSeconds));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (super.isModified()) return true;
        JBCheckBox jBCheckBox = this.cbEnableTimeTracking;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEnableTimeTracking");
            jBCheckBox = null;
        }
        if (jBCheckBox.isSelected() != this.config.enabled) return true;
        JBTextField jBTextField = this.tfTimeTrackingSuspendDelay;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tfTimeTrackingSuspendDelay");
            jBTextField = null;
        }
        if (Intrinsics.areEqual((Object)jBTextField.getText(), (Object)String.valueOf(this.config.suspendDelayInSeconds))) return false;
        return true;
    }

    public void apply() {
        block4: {
            JBTextField jBTextField;
            super.apply();
            boolean oldTimeTrackingEnabled = this.config.enabled;
            JBCheckBox jBCheckBox = this.cbEnableTimeTracking;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEnableTimeTracking");
                jBCheckBox = null;
            }
            this.config.enabled = jBCheckBox.isSelected();
            if (this.project.isDefault()) {
                return;
            }
            if (this.config.enabled != oldTimeTrackingEnabled) {
                TimeTrackingManager.Companion.getInstance(this.project).updateTimeTrackingToolWindow();
            }
            if ((jBTextField = this.tfTimeTrackingSuspendDelay) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tfTimeTrackingSuspendDelay");
                jBTextField = null;
            }
            String string = jBTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) break block4;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.config.suspendDelayInSeconds = it;
            TimeTrackingManager.Companion.getInstance(this.project).startIdleAlarm();
        }
    }

    private static final Unit createPanel$lambda$0(TimeTrackingConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TimeTrackingConfigurable.createPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        Row row = Panel.group$default((Panel)$this$panel, (String)TaskBundle.message((String)"settings.time.tracking.settings", (Object[])new Object[0]), (boolean)false, arg_0 -> TimeTrackingConfigurable.createPanel$lambda$0$1(this$0, arg_0), (int)2, null);
        JBCheckBox jBCheckBox = this$0.cbEnableTimeTracking;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEnableTimeTracking");
            jBCheckBox = null;
        }
        row.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(TimeTrackingConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TaskBundle.message((String)"settings.enable.time.tracking", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.cbEnableTimeTracking = (JBCheckBox)$this$row.checkBox(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(TimeTrackingConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        String string = TaskBundle.message((String)"settings.suspend.delay", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> TimeTrackingConfigurable.createPanel$lambda$0$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$0(TimeTrackingConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.tfTimeTrackingSuspendDelay = (JBTextField)TextFieldKt.columns((Cell)Row.intTextField$default((Row)$this$row, null, null, (int)3, null), (int)6).gap(RightGap.SMALL).getComponent();
        String string = TaskBundle.message((String)"settings.seconds", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }
}

