/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseElementDataVirtualFileImpl;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.vfs.DatabaseElementVirtualFileContent;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseVirtualFileSystem
extends DummyCachingFileSystem<VirtualFile> {
    private static final Logger LOG = Logger.getInstance(DatabaseVirtualFileSystem.class);
    static final String PROTOCOL = "das";
    private static final String SRC_PREFIX = "src:";
    private static final String PROTOCOL_SEPARATOR = ":/";
    private final ConcurrentMap<String, DatabaseElementVirtualFileContent> myContents = ConcurrentFactoryMap.create(p -> new DatabaseElementVirtualFileContent(), CollectionFactory::createConcurrentWeakValueMap);

    public static DatabaseVirtualFileSystem getDatabaseFileSystem() {
        return (DatabaseVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DatabaseVirtualFileSystem() {
        super(PROTOCOL);
    }

    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(0);
        }
        super.onProjectOpened(project);
        project.getMessageBus().connect().subscribe(DbPsiFacade.TOPIC, o -> this.refreshFiles(project));
    }

    protected String getPresentableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(1);
        }
        if (file instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)file).getPresentablePath();
        }
        return super.getPresentableUrl(file);
    }

    protected VirtualFile findFileByPathInner(@NotNull String path) {
        int separatorIdx;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(2);
        }
        if ((separatorIdx = path.indexOf(PROTOCOL_SEPARATOR)) != -1) {
            return this.migrateOldPath(path, separatorIdx);
        }
        return this.findFileByNewPath(path);
    }

    public static FileDesc parseUrl(@NotNull String url) {
        if (url == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(3);
        }
        int pLen = PROTOCOL.length();
        int sLen = "://".length();
        return url.startsWith(PROTOCOL) && url.regionMatches(pLen, "://", 0, sLen) ? DatabaseVirtualFileSystem.parsePath((CharSequence)new CharSequenceSubSequence((CharSequence)url, pLen + sLen, url.length())) : null;
    }

    private static FileDesc parsePath(@NotNull CharSequence path) {
        int separatorIdx;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(4);
        }
        if ((separatorIdx = StringUtil.indexOf((CharSequence)path, (CharSequence)PROTOCOL_SEPARATOR)) != -1) {
            return DatabaseVirtualFileSystem.parseOldPath(path, separatorIdx);
        }
        return DatabaseVirtualFileSystem.parseNewPath(path);
    }

    private VirtualFile migrateOldPath(@NotNull CharSequence path, int separatorIdx) {
        FileDesc parsed;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(5);
        }
        return (parsed = DatabaseVirtualFileSystem.parseOldPath(path, separatorIdx)) == null ? null : this.findFileByPath(DatabaseVirtualFileSystem.getPath(parsed.dataSourceId, parsed.path, parsed.family, parsed.src));
    }

    private static FileDesc parseOldPath(@NotNull CharSequence path, int separatorIdx) {
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(6);
        }
        int separatorEnd = separatorIdx + PROTOCOL_SEPARATOR.length();
        boolean source = StringUtil.startsWith((CharSequence)path, (CharSequence)SRC_PREFIX);
        int elementTypeStart = source ? SRC_PREFIX.length() : 0;
        int projectIdEnd = StringUtil.indexOf((CharSequence)path, (char)'/', (int)separatorEnd);
        String projectId = path.subSequence(separatorEnd, projectIdEnd).toString();
        int dataSourceEnd = StringUtil.indexOf((CharSequence)path, (char)'/', (int)(projectIdEnd + 1));
        if (dataSourceEnd == -1) {
            return null;
        }
        int nameStart = StringUtil.lastIndexOf((CharSequence)path, (char)'/', (int)0, (int)path.length());
        if (nameStart == -1 || nameStart <= projectIdEnd) {
            return null;
        }
        String name = DatabaseVirtualFileSystem.unescapeSlash((String)path.subSequence(nameStart + 1, path.length()).toString());
        String dataSourceId = path.subSequence(projectIdEnd + 1, nameStart).toString();
        Project project = DatabaseVirtualFileSystem.getDatabaseFileSystem().getProject(projectId);
        if (project == null) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource == null) {
            return null;
        }
        MetaModel meta = DbImplUtilCore.getMetaModel(dataSource);
        ObjectKind kind = meta.findKind(path.subSequence(elementTypeStart, separatorIdx).toString());
        if (kind == null) {
            return null;
        }
        ObjectPath objectPath = (ObjectPath)ObjectPaths.getObjectPaths(meta, name, kind).first();
        if (objectPath == null) {
            return null;
        }
        return new FileDesc(dataSourceId, objectPath, null, source);
    }

    private static FileDesc parseNewPath(@NotNull CharSequence path) {
        boolean src;
        CharSequence subPath;
        JBIterator it;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(7);
        }
        if (!(it = JBIterator.from(DbSrcUtilsCore.splitPath((subPath = (src = StringUtil.endsWith((CharSequence)path, (CharSequence)".sql")) ? path.subSequence(0, path.length() - ".sql".length()) : path).toString()).iterator())).advance()) {
            return null;
        }
        DatabaseCoreUiService uiService = DatabaseCoreUiService.getInstance();
        String dataSourceId = (String)it.current();
        ObjectPath objectPath = null;
        ObjectKind family = null;
        while (it.advance()) {
            ObjectKind kind = uiService.getKindOrFakeKind(DbSrcUtilsCore.unescapeChars((String)it.current()));
            if (kind == null) {
                return null;
            }
            if (!it.advance()) {
                family = kind;
                break;
            }
            String name = (String)it.current();
            int idStart = name.indexOf("@");
            String id = idStart == -1 ? null : DbSrcUtilsCore.unescapeChars(name.substring(idStart + 1));
            name = DbSrcUtilsCore.unescapeChars(id != null ? name.substring(0, idStart) : name);
            objectPath = ObjectPath.create((String)name, (ObjectKind)kind, (boolean)true, (String)id, objectPath);
        }
        return new FileDesc(dataSourceId, objectPath, family, src);
    }

    private VirtualFile findFileByNewPath(@NotNull String path) {
        FileDesc parsed;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(8);
        }
        if ((parsed = DatabaseVirtualFileSystem.parseNewPath(path)) == null) {
            return null;
        }
        DasDataSource dataSource = DatabaseVirtualFileSystem.findDataSource(parsed.dataSourceId);
        if (dataSource == null) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = this.createFile(parsed);
        file.setWritableInner(!(dataSource instanceof LocalDataSource) || !((LocalDataSource)dataSource).isReadOnly());
        return file.shouldBeValid() ? file : null;
    }

    @NotNull
    private DatabaseElementVirtualFileImpl createFile(@NotNull FileDesc parsed) {
        if (parsed == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(9);
        }
        if (parsed.src) {
            String path = DatabaseVirtualFileSystem.getPath(parsed.dataSourceId, parsed.path, parsed.family, true);
            return new DatabaseElementSourceVirtualFileImpl(parsed.dataSourceId, parsed.path, parsed.family, (DatabaseElementVirtualFileContent)this.myContents.get(path));
        }
        return new DatabaseElementDataVirtualFileImpl(parsed.dataSourceId, parsed.path, parsed.family);
    }

    @Nullable
    static DasDataSource findDataSource(@NotNull String id) {
        Project[] projects;
        LocalDataSource res;
        if (id == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(10);
        }
        if ((res = DbSrcUtilsCore.findDataSource(null, id)) != null) {
            return res;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            res = DbSrcUtilsCore.findDataSource(project, id);
            if (res == null) continue;
            return res;
        }
        for (Project project : projects) {
            for (DataSourceManager extension : DataSourceManager.EP_NAME.getExtensions((AreaInstance)project)) {
                if (extension.isMyDataSource(LocalDataSource.class)) continue;
                for (DasDataSource o : extension.getDataSources()) {
                    if (!Objects.equals(o.getUniqueId(), id)) continue;
                    return o;
                }
            }
        }
        return null;
    }

    @NotNull
    public static String getPath(String dataSourceId, ObjectPath path, ObjectKind family, boolean source) {
        StringBuilder builder = new StringBuilder(dataSourceId);
        if (path != null) {
            path.reduce((Object)builder, (b, p) -> {
                b.append("/").append(DbSrcUtilsCore.escapeChars(p.kind.code())).append("/").append(DbSrcUtilsCore.escapeChars(p.name));
                String id = p.getIdentity();
                if (id != null) {
                    b.append("@").append(DbSrcUtilsCore.escapeChars(id));
                }
                return b;
            });
        }
        if (family != null) {
            builder.append("/").append(DbSrcUtilsCore.escapeChars(family.code()));
        }
        if (source) {
            builder.append(".sql");
        }
        String string = builder.toString();
        if (string == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("rename not supported: " + vFile.getUrl());
    }

    protected void cleanup() {
        List events = ContainerUtil.map((Collection)this.getCachedFiles(), f -> new VFileDeleteEvent((Object)this, f));
        if (!events.isEmpty()) {
            WriteAction.run(() -> {
                BulkFileListener listener = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                listener.before(events);
                this.cleanupImpl();
                listener.after(events);
            });
        } else {
            this.cleanupImpl();
        }
    }

    private void cleanupImpl() {
        super.cleanup();
        this.myContents.clear();
    }

    private void refreshFiles(@NotNull Project project) {
        if (project == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(14);
        }
        LinkedHashSet<VirtualFile> removed = new LinkedHashSet<VirtualFile>();
        ArrayList<VFileEvent> events = new ArrayList<VFileEvent>();
        Map map = JBIterable.from(DataSourceStorage.getProjectStorage(project).getDataSources()).toMap(o -> o.getUniqueId(), o -> !o.isReadOnly());
        for (VirtualFile vf : this.getCachedFiles()) {
            Boolean writable;
            DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)vf, DatabaseElementVirtualFileImpl.class));
            if (file == null || (writable = (Boolean)map.get(file.getDataSourceId())) == null) continue;
            if (!file.shouldBeValid()) {
                removed.add(file);
                events.add((VFileEvent)new VFileDeleteEvent((Object)this, (VirtualFile)file));
            }
            if (file.isWritable() == writable.booleanValue()) continue;
            events.add((VFileEvent)new VFilePropertyChangeEvent((Object)this, (VirtualFile)file, "writable", (Object)(writable == false ? 1 : 0), (Object)writable));
        }
        if (!events.isEmpty() || !removed.isEmpty()) {
            try {
                this.sendEvents(events, removed);
            }
            catch (Throwable th) {
                LOG.error(th);
            }
        } else {
            this.clearCache();
        }
    }

    private void sendEvents(@NotNull List<VFileEvent> events, @NotNull Set<VirtualFile> removed) {
        if (events == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(15);
        }
        if (removed == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(16);
        }
        WriteAction.run(() -> {
            BulkFileListener listener = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            listener.before(events);
            this.retainFiles(file -> !removed.contains(file));
            for (VFileEvent event : events) {
                DatabaseElementVirtualFileImpl file2 = (DatabaseElementVirtualFileImpl)Objects.requireNonNull(event.getFile());
                if (!(event instanceof VFilePropertyChangeEvent)) continue;
                file2.setWritableInner((Boolean)((VFilePropertyChangeEvent)event).getNewValue());
            }
            listener.after(events);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsed";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathInner";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "migrateOldPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseOldPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseNewPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNewPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sendEvents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    public static class FileDesc {
        public final String dataSourceId;
        public final ObjectPath path;
        public final ObjectKind family;
        public final boolean src;

        private FileDesc(@NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind family, boolean src) {
            if (dataSourceId == null) {
                FileDesc.$$$reportNull$$$0(0);
            }
            this.dataSourceId = dataSourceId;
            this.path = path;
            this.family = family;
            this.src = src;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/vfs/DatabaseVirtualFileSystem$FileDesc", "<init>"));
        }
    }
}

