/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.run.providers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.dap.PythonDapBundle;
import com.intellij.python.dap.run.providers.DebugpyConfig;
import com.intellij.python.dap.run.providers.DebugpyConfigProvider;
import com.intellij.util.PathUtil;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/python/dap/run/providers/DebugpyConfigProviderBase;", "C", "Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;", "Lcom/intellij/python/dap/run/providers/DebugpyConfigProvider;", "<init>", "()V", "createConfig", "Lcom/intellij/python/dap/run/providers/DebugpyConfig;", "configuration", "(Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;)Lcom/intellij/python/dap/run/providers/DebugpyConfig;", "intellij.python.dap"})
public abstract class DebugpyConfigProviderBase<C extends AbstractPythonRunConfiguration<?>>
implements DebugpyConfigProvider<C> {
    @Override
    @NotNull
    public DebugpyConfig createConfig(@NotNull C configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Sdk sdk = configuration.getSdk();
        if (sdk == null) {
            throw new IllegalArgumentException("Python interpreter is not specified");
        }
        Sdk sdk2 = sdk;
        if (PythonSdkUtil.isRemote((Sdk)sdk2)) {
            throw new ExecutionException(PythonDapBundle.message("pythonDap.run.configuration.remoteSdk.notSupported.error", new Object[0]));
        }
        String string = PathUtil.toSystemDependentName((String)sdk2.getHomePath());
        if (string == null) {
            throw new IllegalArgumentException("Python interpreter path is not specified");
        }
        String pythonPath = string;
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)configuration.getInterpreterOptions());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
        List pythonOptions = list;
        PythonCommandLineState.buildPythonPath(configuration, (boolean)true, (boolean)true);
        String string2 = configuration.getWorkingDirectory();
        Map map = configuration.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvs(...)");
        return new DebugpyConfig(null, pythonPath, pythonOptions, null, string2, map, null, false, false, false, false, null, false, false, false, false, 65481, null);
    }
}

