/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.run.providers.impl;

import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.python.dap.run.DebugpyConfigUtilsKt;
import com.intellij.python.dap.run.ModuleOrProgram;
import com.intellij.python.dap.run.providers.DebugpyConfig;
import com.intellij.python.dap.run.providers.DebugpyConfigProviderBase;
import com.intellij.util.system.OS;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/dap/run/providers/impl/PythonDebugpyConfigProvider;", "Lcom/intellij/python/dap/run/providers/DebugpyConfigProviderBase;", "Lcom/jetbrains/python/run/PythonRunConfiguration;", "<init>", "()V", "supports", "", "configuration", "Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;", "createConfig", "Lcom/intellij/python/dap/run/providers/DebugpyConfig;", "intellij.python.dap"})
public final class PythonDebugpyConfigProvider
extends DebugpyConfigProviderBase<PythonRunConfiguration> {
    @Override
    public boolean supports(@NotNull AbstractPythonRunConfiguration<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return configuration instanceof PythonRunConfiguration;
    }

    @Override
    @NotNull
    public DebugpyConfig createConfig(@NotNull PythonRunConfiguration configuration) {
        ModuleOrProgram moduleOrProgram;
        String targetPath;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        DebugpyConfig config = super.createConfig((AbstractPythonRunConfiguration)configuration);
        if (configuration.isModuleMode()) {
            v0 = configuration.getScriptName();
        } else {
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            v0 = targetPath = ((Object)DebugpyConfigUtilsKt.getProgramPath(project, configuration.getScriptName(), configuration.getWorkingDirectory())).toString();
        }
        if (configuration.isModuleMode()) {
            Intrinsics.checkNotNull((Object)targetPath);
            moduleOrProgram = new ModuleOrProgram.Module(targetPath);
        } else {
            Intrinsics.checkNotNull((Object)targetPath);
            moduleOrProgram = new ModuleOrProgram.Program(targetPath);
        }
        ModuleOrProgram target = moduleOrProgram;
        config.setTarget(target.getPath());
        config.setTransport(OS.CURRENT != OS.Windows || WslPath.Companion.isWslUncPath(targetPath) ? "native" : "tcp");
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)configuration.getScriptParameters());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
        config.setArgs(list);
        return config;
    }
}

