/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells;

import com.intellij.dataspell.jupyter.customCells.sql.metadata.SqlCellMetadata;
import com.intellij.dataspell.jupyter.customCells.sql.metadata.SqlCellMetadataKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.py.environment.stores.JupyterEnvironmentStore;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.debugger.values.DataFrameDebugValue;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087@\u00a2\u0006\u0002\u0010\b\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a!\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0004\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001c\u001a\"\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0001H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"CELL_LOOKUP_OFFSET", "", "findDataFrameInPreviousCells", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "currentInterval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDataFramesFromPythonEnv", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDataFrameValue", "ordinal", "isPandasDataFrameType", "", "expression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "PANDAS_DATA_FRAME_CLASS_FQN", "type", "Lcom/jetbrains/python/psi/types/PyType;", "getLastPsiElement", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/editor/Editor;", "lastLine", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcom/intellij/psi/PsiElement;", "getLastPsiElementImpl", "offset", "intellij.dataspell.jupyter.customCells"})
@SourceDebugExtension(value={"SMAP\nJupyterDSDataFrameExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDSDataFrameExtractor.kt\ncom/intellij/dataspell/jupyter/customCells/JupyterDSDataFrameExtractorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class JupyterDSDataFrameExtractorKt {
    private static final int CELL_LOOKUP_OFFSET = 2;
    @NotNull
    private static final String PANDAS_DATA_FRAME_CLASS_FQN = "pandas.core.frame.DataFrame";

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @RequiresBackgroundThread
    @Nullable
    public static final Object findDataFrameInPreviousCells(@NotNull EditorImpl editor, @NotNull NotebookCellLines.Interval currentInterval, @NotNull Continuation<? super String> $completion) {
        v0 = editor.getProject();
        if (v0 == null) {
            return null;
        }
        project = v0;
        v1 /* !! */  = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)((Editor)editor));
        if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getFile()) == null) ** GOTO lbl-1000
        it = v1 /* !! */ ;
        $i$a$-let-JupyterDSDataFrameExtractorKt$findDataFrameInPreviousCells$pythonVariablesNames$1 = false;
        v2 = JupyterDSDataFrameExtractorKt.getDataFramesFromPythonEnv(project, (VirtualFile)it);
        v1 /* !! */  = v2;
        if (v2 != null) {
            v3 = (String)CollectionsKt.firstOrNull((List)v1 /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        pythonVariablesNames = v3;
        return CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, findDataFrameInPreviousCells$lambda$1(com.intellij.notebooks.visualization.NotebookCellLines$Interval com.intellij.openapi.project.Project com.intellij.openapi.editor.impl.EditorImpl java.lang.String ), ()Ljava/lang/String;)((NotebookCellLines.Interval)currentInterval, (Project)project, (EditorImpl)editor, pythonVariablesNames), $completion);
    }

    @NotNull
    public static final List<String> getDataFramesFromPythonEnv(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        XValueChildrenList xValueChildrenList = JupyterEnvironmentStore.Companion.getInstance(project).getFrameVariables(virtualFile);
        if (xValueChildrenList == null) {
            return CollectionsKt.emptyList();
        }
        XValueChildrenList childList = xValueChildrenList;
        List dataFrames = new ArrayList();
        int size = childList.size();
        for (int i = 0; i < size; ++i) {
            XValue value = childList.getValue(i);
            if (!(value instanceof DataFrameDebugValue)) continue;
            String string = ((DataFrameDebugValue)value).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            dataFrames.add(string);
        }
        return dataFrames;
    }

    private static final String getDataFrameValue(Project project, EditorImpl editor, int ordinal) {
        String string;
        JupyterCell jupyterCell = JupyterEditorExtensionsKt.getJupyterCell((Editor)((Editor)editor), (int)ordinal);
        if (jupyterCell == null) {
            return null;
        }
        JupyterCell cell = jupyterCell;
        JupyterCellType jupyterCellType = cell.getCellTypeProvider().getJupyterCellType();
        if (Intrinsics.areEqual((Object)jupyterCellType, (Object)JupyterCellType.Companion.getSQL())) {
            SqlCellMetadata sqlCellMetadata = SqlCellMetadataKt.getSqlMetadata(cell);
            string = sqlCellMetadata != null ? sqlCellMetadata.getVariableName() : null;
        } else if (Intrinsics.areEqual((Object)jupyterCellType, (Object)JupyterCellType.Companion.getDATA_INPUT())) {
            string = JupyterDataInputCellMetadataKt.getDataInputMetadata((JupyterCell)cell);
            if (string == null || (string = string.getVariableName()) == null) {
                JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata((JupyterCell)cell);
                string = jupyterDataInputCellTableMetadata != null ? jupyterDataInputCellTableMetadata.getVariableName() : null;
            }
        } else {
            if (Intrinsics.areEqual((Object)jupyterCellType, (Object)JupyterCellType.Companion.getCODE())) {
                NotebookCellLines.Interval interval = NotebookVisualizationUiUtilKt.getCellByOrdinal((Editor)((Editor)editor), (int)ordinal);
                PsiElement expr = JupyterDSDataFrameExtractorKt.getLastPsiElement((Editor)editor, interval.getLines().getLast());
                if (expr instanceof PyReferenceExpression && JupyterDSDataFrameExtractorKt.isPandasDataFrameType((PyReferenceExpression)expr, project)) {
                    return ((PyReferenceExpression)expr).getName();
                }
                return null;
            }
            string = null;
        }
        return string;
    }

    private static final boolean isPandasDataFrameType(PyReferenceExpression expression, Project project) {
        TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)project);
        PyType expressionType = context.getType((PyTypedElement)expression);
        return JupyterDSDataFrameExtractorKt.isPandasDataFrameType(expressionType);
    }

    private static final boolean isPandasDataFrameType(PyType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof PyClassType) {
            PyClass pyClass = ((PyClassType)type).getPyClass();
            Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
            PyClass pyClass2 = pyClass;
            String qualifiedName = pyClass2.getQualifiedName();
            return Intrinsics.areEqual((Object)qualifiedName, (Object)PANDAS_DATA_FRAME_CLASS_FQN);
        }
        return false;
    }

    @Nullable
    public static final PsiElement getLastPsiElement(@Nullable Editor editor, @Nullable Integer lastLine) {
        Editor editor2 = editor;
        if (editor2 == null || (editor2 = editor2.getProject()) == null) {
            return null;
        }
        Editor project = editor2;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) {
            return null;
        }
        BackedNotebookVirtualFile virtualFile = backedNotebookVirtualFile;
        Integer n = lastLine;
        if (n == null) {
            return null;
        }
        n.intValue();
        int offset = editor.getDocument().getLineStartOffset(lastLine.intValue());
        return JupyterDSDataFrameExtractorKt.getLastPsiElementImpl((Project)project, (VirtualFile)virtualFile, offset);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private static final PsiElement getLastPsiElementImpl(Project project, VirtualFile virtualFile, int offset) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        PsiElement psiElement = psiFile2.findElementAt(offset);
        if (psiElement == null && (psiElement = PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)psiFile2)) == offset ? psiFile2.findElementAt(offset - 1) : null) == null) {
            return null;
        }
        PsiElement element = psiElement;
        if (!JupyterDSDataFrameExtractorKt.getLastPsiElementImpl$isSpaceOrComment(element)) {
            PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyExpressionStatement.class);
            if (pyExpressionStatement == null) {
                return null;
            }
            element = (PsiElement)pyExpressionStatement;
        }
        while (JupyterDSDataFrameExtractorKt.getLastPsiElementImpl$isSpaceOrComment(element)) {
            if (element.getPrevSibling() != null) continue;
            return null;
        }
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)PyElementTypes.EXPRESSION_STATEMENT) ? element.getFirstChild() : null;
    }

    private static final String findDataFrameInPreviousCells$lambda$1(NotebookCellLines.Interval $currentInterval, Project $project, EditorImpl $editor, String $pythonVariablesNames) {
        int currentCellOrdinal;
        int ordinal = currentCellOrdinal = $currentInterval.getOrdinal() - 1;
        int n = Math.max(0, currentCellOrdinal - 2);
        if (n <= ordinal) {
            while (true) {
                String dfName;
                if ((dfName = JupyterDSDataFrameExtractorKt.getDataFrameValue($project, $editor, ordinal)) != null) {
                    return dfName;
                }
                if (ordinal == n) break;
                --ordinal;
            }
        }
        return $pythonVariablesNames;
    }

    private static final boolean getLastPsiElementImpl$isSpaceOrComment(PsiElement element) {
        return element instanceof PsiWhiteSpace || element instanceof PsiComment;
    }
}

