/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyHelpersDownload
extends RemoteTransfer {
    private static final Logger LOG = Logger.getInstance(PyHelpersDownload.class);

    private PyHelpersDownload(@Nullable Project project, @Nullable Component component, RemoteCredentials credentials, RemoteSdkProperties sdkProperties) {
        super(project, component, RemoteSdkUtil.createHelpersTransferConfig((RemoteCredentials)credentials, (RemoteSdkProperties)sdkProperties));
    }

    private void downloadFromRemote(final List<PathMappingSettings.PathMapping> mappings) {
        String myTitle = PythonRemoteInterpreterBundle.message("python.copying.remote.files", new Object[0]);
        new Task.Backgroundable(this.getProject(), myTitle, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setFraction(0.0);
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                CredentialsDeployable deployable = new CredentialsDeployable();
                PyHelpersDownload.this.getHelpersTransferConfig().createFileTransferConfig(deployable);
                deployable.setId("CopyFromRemote" + String.valueOf(deployable));
                try {
                    RemoteConnection connection = PyHelpersDownload.this.openConnection(this.getTitle(), (Deployable)deployable, indicator);
                    RemoteTransfer.RemoteSdkExecutionContext context = PyHelpersDownload.this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
                    context.setServerSideModification(false);
                    ArrayList<TransferOperation.Copy> operations = new ArrayList<TransferOperation.Copy>();
                    for (PathMappingSettings.PathMapping mapping : mappings) {
                        FileObject source = connection.resolveFile(mapping.getRemoteRoot());
                        FileObject target = DeploymentPathUtils.getLocalFile((String)mapping.getLocalRoot());
                        operations.add(new TransferOperation.Copy(source, target));
                    }
                    PyHelpersDownload.executeOperationsBatch((ProgressIndicator)indicator, (RemoteTransfer.RemoteSdkExecutionContext)context, (List)operations);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
                }
                PyHelpersDownload.this.getHelpersTransferConfig().setHelpersVersionChecked(true);
                snapshot.logResponsivenessSinceCreation("Downloading remote files");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/remoteInterpreter/PyHelpersDownload$1", "run"));
            }
        }.queue();
    }

    private void transferSources(Collection<PyRemoteSourceItem> sourceItems, String localFolder) throws FileSystemException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        CredentialsDeployable deployable = new CredentialsDeployable();
        deployable.setId("DownloadSkeletons" + String.valueOf(deployable));
        this.getHelpersTransferConfig().createFileTransferConfig(deployable);
        RemoteConnection connection = this.openConnection(PythonRemoteInterpreterBundle.message("python.helpers.downloading.remote.skeletons.and.libraries", new Object[0]), (Deployable)deployable, indicator);
        ArrayList<TransferOperation.Copy> transferOperations = new ArrayList<TransferOperation.Copy>();
        for (PyRemoteSourceItem sourceItem : sourceItems) {
            if (!sourceItem.shouldCopy(localFolder)) continue;
            FileObject fileObject = connection.resolveFile(sourceItem.getPath());
            FileObject target = DeploymentPathUtils.getLocalFile((String)sourceItem.getLocalFile(localFolder).getPath());
            transferOperations.add(new TransferOperation.Copy(fileObject, target));
        }
        RemoteTransfer.RemoteSdkExecutionContext context = this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
        context.setServerSideModification(false);
        for (TransferOperation transferOperation : transferOperations) {
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText(transferOperation.getProgressText((ExecutionContext)context));
            transferOperation.execute((ExecutionContext)context);
        }
    }

    public static void downloadFromRemote(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, @NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (credentials == null) {
            PyHelpersDownload.$$$reportNull$$$0(0);
        }
        if (sdkProperties == null) {
            PyHelpersDownload.$$$reportNull$$$0(1);
        }
        if (mappings == null) {
            PyHelpersDownload.$$$reportNull$$$0(2);
        }
        new PyHelpersDownload(project, component, credentials, sdkProperties).downloadFromRemote(mappings);
    }

    public static void transferSources(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, @NotNull Collection<PyRemoteSourceItem> sources, String folder) throws FileSystemException {
        if (credentials == null) {
            PyHelpersDownload.$$$reportNull$$$0(3);
        }
        if (sdkProperties == null) {
            PyHelpersDownload.$$$reportNull$$$0(4);
        }
        if (sources == null) {
            PyHelpersDownload.$$$reportNull$$$0(5);
        }
        new PyHelpersDownload(project, component, credentials, sdkProperties).transferSources(sources, folder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/remoteInterpreter/PyHelpersDownload";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadFromRemote";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "transferSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

