/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/stats/completion/sender/DailyLimitSendingWatcher;", "", "dailyLimit", "", "info", "Lcom/intellij/stats/completion/sender/DailyLimitSendingWatcher$SentDataInfo;", "<init>", "(ILcom/intellij/stats/completion/sender/DailyLimitSendingWatcher$SentDataInfo;)V", "isLimitReached", "", "dataSent", "", "size", "SentDataInfo", "intellij.statsCollector"})
public final class DailyLimitSendingWatcher {
    private final int dailyLimit;
    @NotNull
    private final SentDataInfo info;

    public DailyLimitSendingWatcher(int dailyLimit, @NotNull SentDataInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.dailyLimit = dailyLimit;
        this.info = info;
    }

    public final boolean isLimitReached() {
        return this.info.sentToday(System.currentTimeMillis()) >= this.dailyLimit;
    }

    public final void dataSent(int size) {
        this.info.dataSent(System.currentTimeMillis(), size);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\b&\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u0018\u0010\u000f\u001a\u00020\u0005X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0007X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/intellij/stats/completion/sender/DailyLimitSendingWatcher$SentDataInfo;", "", "<init>", "()V", "sentToday", "", "timestamp", "", "dataSent", "", "bytesCount", "isSameDay", "", "ts1", "ts2", "sentCount", "getSentCount", "()I", "setSentCount", "(I)V", "latestSendingTimestamp", "getLatestSendingTimestamp", "()J", "setLatestSendingTimestamp", "(J)V", "Companion", "DumbInfo", "intellij.statsCollector"})
    public static abstract class SentDataInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMdd");

        public final int sentToday(long timestamp) {
            if (!this.isSameDay(timestamp, this.getLatestSendingTimestamp())) {
                return 0;
            }
            return this.getSentCount();
        }

        public final void dataSent(long timestamp, int bytesCount) {
            this.setSentCount(this.sentToday(timestamp) + bytesCount);
            this.setLatestSendingTimestamp(timestamp);
        }

        private final boolean isSameDay(long ts1, long ts2) {
            return Intrinsics.areEqual((Object)SentDataInfo.isSameDay$asString(ts1), (Object)SentDataInfo.isSameDay$asString(ts2));
        }

        protected abstract int getSentCount();

        protected abstract void setSentCount(int var1);

        protected abstract long getLatestSendingTimestamp();

        protected abstract void setLatestSendingTimestamp(long var1);

        private static final String isSameDay$asString(long $this$isSameDay_u24asString) {
            String string = FORMAT.format(new Date($this$isSameDay_u24asString));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/stats/completion/sender/DailyLimitSendingWatcher$SentDataInfo$Companion;", "", "<init>", "()V", "FORMAT", "Ljava/text/SimpleDateFormat;", "intellij.statsCollector"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/stats/completion/sender/DailyLimitSendingWatcher$SentDataInfo$DumbInfo;", "Lcom/intellij/stats/completion/sender/DailyLimitSendingWatcher$SentDataInfo;", "<init>", "()V", "sentCount", "", "getSentCount", "()I", "setSentCount", "(I)V", "latestSendingTimestamp", "", "getLatestSendingTimestamp", "()J", "setLatestSendingTimestamp", "(J)V", "intellij.statsCollector"})
        public static final class DumbInfo
        extends SentDataInfo {
            private int sentCount;
            private long latestSendingTimestamp;

            @Override
            protected int getSentCount() {
                return this.sentCount;
            }

            @Override
            protected void setSentCount(int n) {
                this.sentCount = n;
            }

            @Override
            protected long getLatestSendingTimestamp() {
                return this.latestSendingTimestamp;
            }

            @Override
            protected void setLatestSendingTimestamp(long l) {
                this.latestSendingTimestamp = l;
            }
        }
    }
}

