/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.tracker;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import com.intellij.completion.ml.util.RelevanceUtil;
import com.intellij.stats.completion.LookupEntryDiff;
import com.intellij.stats.completion.LookupEntryInfo;
import com.intellij.stats.completion.LookupState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c*\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J6\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0002J@\u0010!\u001a\u00020\"*\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e0\u00072\u0006\u0010#\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/stats/completion/tracker/LookupStateManager;", "", "shouldLogElementFeatures", "", "<init>", "(Z)V", "elementToId", "", "", "", "idToEntryInfo", "Lcom/intellij/stats/completion/LookupEntryInfo;", "lookupStringToHash", "currentSessionFactors", "", "update", "Lcom/intellij/stats/completion/LookupState;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "factorsUpdated", "getElementId", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "(Lcom/intellij/codeInsight/lookup/LookupElement;)Ljava/lang/Integer;", "computeSessionFactorsToLog", "factors", "registerElement", "toLookupInfos", "", "computeAnalyticsItemFeatures", "lookupElement", "calculateRelevance", "items", "setFactors", "", "itemId", "getLookupStringHash", "lookupString", "Companion", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nLookupStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupStateManager.kt\ncom/intellij/stats/completion/tracker/LookupStateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,153:1\n774#2:154\n865#2,2:155\n1617#2,9:157\n1869#2:166\n1870#2:168\n1626#2:169\n1869#2,2:170\n774#2:172\n865#2,2:173\n1869#2,2:175\n1563#2:177\n1634#2,3:178\n1222#2,2:181\n1252#2,4:183\n1252#2,4:189\n774#2:193\n865#2,2:194\n1#3:167\n463#4:187\n413#4:188\n488#4,7:200\n216#5,2:196\n216#5,2:198\n*S KotlinDebug\n*F\n+ 1 LookupStateManager.kt\ncom/intellij/stats/completion/tracker/LookupStateManager\n*L\n45#1:154\n45#1:155,2\n47#1:157,9\n47#1:166\n47#1:168\n47#1:169\n48#1:170,2\n52#1:172\n52#1:173,2\n53#1:175,2\n78#1:177\n78#1:178,3\n103#1:181,2\n103#1:183,4\n110#1:189,4\n118#1:193\n118#1:194,2\n47#1:167\n110#1:187\n110#1:188\n141#1:200,7\n125#1:196,2\n126#1:198,2\n*E\n"})
public final class LookupStateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldLogElementFeatures;
    @NotNull
    private final Map<String, Integer> elementToId;
    @NotNull
    private final Map<Integer, LookupEntryInfo> idToEntryInfo;
    @NotNull
    private final Map<String, Integer> lookupStringToHash;
    @NotNull
    private Map<String, String> currentSessionFactors;
    @NotNull
    private static final Set<String> REQUIRED_FACTORS;

    public LookupStateManager(boolean shouldLogElementFeatures) {
        this.shouldLogElementFeatures = shouldLogElementFeatures;
        this.elementToId = new LinkedHashMap();
        this.idToEntryInfo = new LinkedHashMap();
        this.lookupStringToHash = new LinkedHashMap();
        this.currentSessionFactors = MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LookupState update(@NotNull LookupImpl lookup, boolean factorsUpdated) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        List ids = new ArrayList();
        Set newIds = new LinkedHashSet();
        List list = lookup.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List items = list;
        int currentPosition = items.indexOf(lookup.getCurrentItem());
        Map elementToId = new LinkedHashMap();
        for (LookupElement item : items) {
            Intrinsics.checkNotNull((Object)item);
            Integer id = this.getElementId(item);
            if (id == null) {
                id = this.registerElement(item);
                newIds.add(id);
            }
            elementToId.put(LookupElementExtensionsKt.idString((LookupElement)item), id);
            ids.add(id);
        }
        LookupStorage storage = LookupStorage.Companion.get(lookup);
        Object object = storage;
        if (object == null || (object = object.getSessionFactors()) == null || (object = object.getLastUsedCommonFactors()) == null) {
            object = MapsKt.emptyMap();
        }
        Object commonSessionFactors = object;
        Map<String, String> sessionFactorsToLog = this.computeSessionFactorsToLog((Map<String, String>)commonSessionFactors);
        if (factorsUpdated) {
            Iterator $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv2;
            List<LookupEntryInfo> infos = this.toLookupInfos(items, lookup, elementToId);
            Iterable $this$filter$iv2 = infos;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                LookupEntryInfo it = (LookupEntryInfo)element$iv$iv;
                boolean bl = false;
                if (!newIds.contains(it.getId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newInfos = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = infos;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LookupEntryDiff it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                LookupEntryInfo it = (LookupEntryInfo)element$iv$iv;
                boolean bl2 = false;
                LookupEntryInfo lookupEntryInfo = this.idToEntryInfo.get(it.getId());
                if ((lookupEntryInfo != null ? lookupEntryInfo.calculateDiff(it) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List itemsDiff = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = infos;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                LookupEntryInfo it = (LookupEntryInfo)element$iv;
                boolean bl = false;
                this.idToEntryInfo.put(it.getId(), it);
            }
            return new LookupState(ids, newInfos, itemsDiff, currentPosition, sessionFactorsToLog);
        }
        Iterable newInfos = items;
        LookupStateManager lookupStateManager = this;
        boolean $i$f$filter = false;
        void $this$forEach$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LookupElement it = (LookupElement)element$iv$iv;
            boolean bl = false;
            Iterable iterable = newIds;
            Intrinsics.checkNotNull((Object)it);
            if (!CollectionsKt.contains((Iterable)iterable, (Object)this.getElementId(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<LookupEntryInfo> newItems = lookupStateManager.toLookupInfos((List)destination$iv$iv, lookup, elementToId);
        Iterable $this$forEach$iv2 = newItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            LookupEntryInfo it = (LookupEntryInfo)element$iv;
            boolean bl = false;
            this.idToEntryInfo.put(it.getId(), it);
        }
        return new LookupState(ids, newItems, CollectionsKt.emptyList(), currentPosition, sessionFactorsToLog);
    }

    private final Integer getElementId(LookupElement item) {
        String itemString = LookupElementExtensionsKt.idString((LookupElement)item);
        return this.elementToId.get(itemString);
    }

    private final Map<String, String> computeSessionFactorsToLog(Map<String, String> factors) {
        if (Intrinsics.areEqual(factors, this.currentSessionFactors)) {
            return MapsKt.emptyMap();
        }
        this.currentSessionFactors = factors;
        return factors;
    }

    private final int registerElement(LookupElement item) {
        String itemString = LookupElementExtensionsKt.idString((LookupElement)item);
        int newId = this.elementToId.size();
        this.elementToId.put(itemString, newId);
        return newId;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupEntryInfo> toLookupInfos(List<? extends LookupElement> $this$toLookupInfos, LookupImpl lookup, Map<String, Integer> elementToId) {
        void $this$mapTo$iv$iv;
        Map<String, Map<String, String>> item2relevance = this.calculateRelevance(lookup, $this$toLookupInfos);
        Iterable $this$map$iv = $this$toLookupInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String lookupString;
            void lookupElement;
            LookupElement lookupElement2 = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String id = LookupElementExtensionsKt.idString((LookupElement)lookupElement);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement.getLookupString(), (String)"getLookupString(...)");
            int itemHash = this.getLookupStringHash(lookupString);
            collection.add(new LookupEntryInfo(((Number)MapsKt.getValue(elementToId, (Object)id)).intValue(), lookupString.length(), itemHash, (Map)MapsKt.getValue(item2relevance, (Object)id)));
        }
        return (List)destination$iv$iv;
    }

    private final Map<String, String> computeAnalyticsItemFeatures(LookupElement lookupElement) {
        Map features;
        block2: {
            long it;
            features = new LinkedHashMap();
            Long l = (Long)lookupElement.getUserData(LookupElement.LOOKUP_ELEMENT_SHOW_TIMESTAMP_MILLIS);
            if (l != null) {
                it = ((Number)l).longValue();
                boolean bl = false;
                features.put("ml_analytics_timestamp_show", String.valueOf(it));
            }
            Long l2 = (Long)lookupElement.getUserData(BaseCompletionService.LOOKUP_ELEMENT_RESULT_ADD_TIMESTAMP_MILLIS);
            if (l2 != null) {
                it = ((Number)l2).longValue();
                boolean bl = false;
                features.put("ml_analytics_timestamp_add", String.valueOf(it));
            }
            Integer n = (Integer)lookupElement.getUserData(BaseCompletionService.LOOKUP_ELEMENT_RESULT_SET_ORDER);
            if (n == null) break block2;
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            features.put("ml_analytics_to_result_set_add_order", String.valueOf(it2));
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, String>> calculateRelevance(LookupImpl lookup, List<? extends LookupElement> items) {
        void $this$filterTo$iv$iv;
        Iterable factors;
        Map.Entry it;
        Iterator iterator;
        Iterable iterable;
        LookupStorage lookupStorage;
        LookupStorage lookupStorage2 = lookupStorage = LookupStorage.Companion.get(lookup);
        boolean bl = lookupStorage2 != null ? !lookupStorage2.shouldComputeFeatures() : false;
        if (bl) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = items;
            boolean $i$f$associateBy = false;
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(n);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                LookupElement lookupElement = (LookupElement)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                LookupElement it2 = (LookupElement)element$iv$iv;
                String string = LookupElementExtensionsKt.idString((LookupElement)it2);
                boolean bl3 = false;
                Map map2 = MapsKt.emptyMap();
                map.put(string, map2);
            }
            return destination$iv$iv;
        }
        Map result = new LinkedHashMap();
        if (lookupStorage != null) {
            for (LookupElement lookupElement : items) {
                Map map;
                String id = LookupElementExtensionsKt.idString((LookupElement)lookupElement);
                if (lookupStorage.getItemStorage(id).getLastUsedFactors() != null) {
                    void $this$associateByTo$iv$iv$iv;
                    void $this$mapValuesTo$iv$iv;
                    Map $this$mapValues$iv;
                    boolean $i$f$mapValues = false;
                    Map it3 = $this$mapValues$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    iterable = $this$mapValuesTo$iv$iv.entrySet();
                    Map destination$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        iterator = destination$iv$iv$iv;
                        boolean bl4 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        Map map3 = iterator;
                        boolean bl5 = false;
                        String string = it.getValue().toString();
                        map3.put(k, string);
                    }
                    map = destination$iv$iv$iv;
                } else {
                    map = null;
                }
                if ((factors = map) == null) continue;
                this.setFactors(result, id, MapsKt.plus((Map)((Object)factors), this.computeAnalyticsItemFeatures(lookupElement)));
            }
        }
        Iterable iterable3 = items;
        boolean $i$f$filter = false;
        factors = iterable3;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LookupElement it4 = (LookupElement)element$iv$iv;
            boolean bl6 = false;
            if (!(!result.containsKey(LookupElementExtensionsKt.idString((LookupElement)it4)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rest = (List)destination$iv$iv;
        if (!((Collection)rest).isEmpty()) {
            Map map = lookup.getRelevanceObjects((Iterable)rest, false);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getRelevanceObjects(...)");
            Map map4 = map;
            for (LookupElement item : rest) {
                Map map5;
                if ((List)map4.get(item) != null) {
                    Map.Entry element$iv;
                    List objects;
                    boolean bl7 = false;
                    iterable = RelevanceUtil.INSTANCE.asRelevanceMaps(objects);
                    Map relevanceMap = (Map)iterable.component1();
                    Map additionalMap = (Map)iterable.component2();
                    Map features = new LinkedHashMap();
                    Map $this$forEach$iv = relevanceMap;
                    boolean $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = (Map.Entry)iterator.next();
                        boolean bl8 = false;
                        features.put(it.getKey(), it.getValue().toString());
                    }
                    $this$forEach$iv = additionalMap;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = iterator.next();
                        boolean bl9 = false;
                        features.put(it.getKey(), it.getValue().toString());
                    }
                    features.putAll(this.computeAnalyticsItemFeatures(item));
                    map5 = features;
                } else {
                    map5 = MapsKt.emptyMap();
                }
                Map relevanceMap = map5;
                this.setFactors(result, LookupElementExtensionsKt.idString((LookupElement)item), relevanceMap);
            }
        }
        return result;
    }

    private final void setFactors(Map<String, Map<String, String>> $this$setFactors, String itemId, Map<String, String> factors) {
        if (this.shouldLogElementFeatures) {
            $this$setFactors.put(itemId, factors);
        } else {
            Map<String, Map<String, String>> map = $this$setFactors;
            Map<String, String> $this$filterKeys$iv = factors;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl = false;
                if (!REQUIRED_FACTORS.contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map map2 = result$iv;
            map.put(itemId, map2);
        }
    }

    private final int getLookupStringHash(String lookupString) {
        Integer n = this.lookupStringToHash.computeIfAbsent(lookupString, arg_0 -> LookupStateManager.getLookupStringHash$lambda$1(arg_0 -> LookupStateManager.getLookupStringHash$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"computeIfAbsent(...)");
        return ((Number)n).intValue();
    }

    private static final Integer getLookupStringHash$lambda$0(LookupStateManager this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.lookupStringToHash.size();
    }

    private static final Integer getLookupStringHash$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"ml_common_item_class", "position", "result_length", "ml_rank", "kind", "ml_python_kind", "ml_php_element_element_type", "ml_scala_kind", "ml_clangd_kind", "kotlin.kind", "ml_js_kind"};
        REQUIRED_FACTORS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/stats/completion/tracker/LookupStateManager$Companion;", "", "<init>", "()V", "REQUIRED_FACTORS", "", "", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

