/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.fus;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedLongEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthParams;
import com.intellij.jupyter.core.jupyter.connections.auth.hub.JupyterHubAuthParams;
import com.intellij.jupyter.core.jupyter.connections.auth.sagemaker.JupyterSagemakerAuthParams;
import com.intellij.jupyter.core.jupyter.connections.auth.token.JupyterTokenAuthParams;
import com.intellij.jupyter.core.jupyter.connections.client.status.JupyterConnectionStatus;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteServerNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Version;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0015J\b\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u001d\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b,J\u001d\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b0J%\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b5J%\u00106\u001a\u00020\u00172\u0006\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b7R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\"\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010$\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/fus/JupyterConnectionsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "serverKindField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/jupyter/core/jupyter/connections/fus/JupyterConnectionsCollector$ServerKind;", "isManagedField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "isSuccessField", "versionField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/openapi/util/Version;", "loadDuration", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "jupyterSessionStartEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "Ljava/lang/Class;", "", "", "logJupyterSessionStart", "", "sessionClass", "durationMs", "isSuccess", "jupyterClientConnect", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "jupyterRfsConnect", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteServerNode$RemoteJupyterReachabilityStates;", "fileSizeField", "Lcom/intellij/internal/statistic/eventLog/events/RoundedLongEventField;", "jupyterFileUploadEvent", "Lcom/intellij/openapi/fileTypes/FileType;", "jupyterFileDownloadEvent", "getGroup", "getServerKind", "connParams", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "logClientConnect", "result", "Lcom/intellij/jupyter/core/jupyter/connections/client/status/JupyterConnectionStatus;", "logClientConnect$intellij_jupyter_core", "logRfsConnect", "oldStatus", "newStatus", "logRfsConnect$intellij_jupyter_core", "logFsDownload", "fileType", "size", "time", "logFsDownload$intellij_jupyter_core", "logFsUpload", "logFsUpload$intellij_jupyter_core", "ServerKind", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterConnectionsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionsCollector.kt\ncom/intellij/jupyter/core/jupyter/connections/fus/JupyterConnectionsCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,115:1\n261#2,3:116\n261#2,3:119\n261#2,3:122\n*S KotlinDebug\n*F\n+ 1 JupyterConnectionsCollector.kt\ncom/intellij/jupyter/core/jupyter/connections/fus/JupyterConnectionsCollector\n*L\n20#1:116,3\n50#1:119,3\n51#1:122,3\n*E\n"})
public final class JupyterConnectionsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final JupyterConnectionsCollector INSTANCE;
    @NotNull
    private static final EventLogGroup group;
    @NotNull
    private static final EnumEventField<ServerKind> serverKindField;
    @NotNull
    private static final BooleanEventField isManagedField;
    @NotNull
    private static final BooleanEventField isSuccessField;
    @NotNull
    private static final PrimitiveEventField<Version> versionField;
    @NotNull
    private static final LongEventField loadDuration;
    @NotNull
    private static final EventId3<Class<?>, Long, Boolean> jupyterSessionStartEvent;
    @NotNull
    private static final VarargEventId jupyterClientConnect;
    @NotNull
    private static final EventId2<JupyterRemoteServerNode.RemoteJupyterReachabilityStates, JupyterRemoteServerNode.RemoteJupyterReachabilityStates> jupyterRfsConnect;
    @NotNull
    private static final RoundedLongEventField fileSizeField;
    @NotNull
    private static final EventId3<FileType, Long, Long> jupyterFileUploadEvent;
    @NotNull
    private static final EventId3<FileType, Long, Long> jupyterFileDownloadEvent;

    private JupyterConnectionsCollector() {
    }

    public final void logJupyterSessionStart(@Nullable Class<?> sessionClass, long durationMs, boolean isSuccess) {
        long durationInSecondWithRound = durationMs / (long)10000 * (long)10;
        jupyterSessionStartEvent.log(sessionClass, (Object)durationInSecondWithRound, (Object)isSuccess);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return group;
    }

    private final ServerKind getServerKind(JupyterConnectionParameters connParams) {
        JupyterAuthParams jupyterAuthParams = connParams.getAuthParams();
        return jupyterAuthParams instanceof JupyterHubAuthParams ? ServerKind.Hub : (jupyterAuthParams instanceof JupyterTokenAuthParams ? ServerKind.Notebook : (jupyterAuthParams instanceof JupyterSagemakerAuthParams ? ServerKind.SageMaker : ServerKind.UNKNOWN));
    }

    public final void logClientConnect$intellij_jupyter_core(@NotNull JupyterConnectionStatus result2, @NotNull JupyterConnectionParameters connParams) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)connParams, (String)"connParams");
        JupyterServerConfig config = JupyterConnectionSettingsManager.Companion.getInstance().getConfig(connParams.getConfigId());
        boolean isManaged = config instanceof JupyterManagedServerConfig;
        JupyterConnectionStatus.Success success = result2 instanceof JupyterConnectionStatus.Success ? (JupyterConnectionStatus.Success)result2 : null;
        Version version = success != null ? success.getServerVersion() : null;
        boolean isSuccess = result2 instanceof JupyterConnectionStatus.Success;
        EventPair[] eventPairArray = new EventPair[]{new EventPair((EventField)versionField, (Object)version), new EventPair((EventField)isSuccessField, (Object)isSuccess), new EventPair((EventField)isManagedField, (Object)isManaged), new EventPair((EventField)serverKindField, (Object)this.getServerKind(connParams))};
        jupyterClientConnect.log(eventPairArray);
    }

    public final void logRfsConnect$intellij_jupyter_core(@NotNull JupyterRemoteServerNode.RemoteJupyterReachabilityStates oldStatus, @NotNull JupyterRemoteServerNode.RemoteJupyterReachabilityStates newStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)oldStatus), (String)"oldStatus");
        Intrinsics.checkNotNullParameter((Object)((Object)newStatus), (String)"newStatus");
        jupyterRfsConnect.log((Object)oldStatus, (Object)newStatus);
    }

    public final void logFsDownload$intellij_jupyter_core(@NotNull FileType fileType, long size, long time) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        jupyterFileDownloadEvent.log((Object)fileType, (Object)size, (Object)time);
    }

    public final void logFsUpload$intellij_jupyter_core(@NotNull FileType fileType, long size, long time) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        jupyterFileUploadEvent.log((Object)fileType, (Object)size, (Object)time);
    }

    static {
        EventFields $this$iv;
        INSTANCE = new JupyterConnectionsCollector();
        group = new EventLogGroup("jupyter.connections", 10, null, 4, null);
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "server_kind";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        serverKindField = new EnumEventField(name$iv, ServerKind.class, null, transform$iv);
        isManagedField = EventFields.Boolean((String)"managed");
        isSuccessField = EventFields.Boolean((String)"success");
        versionField = EventFields.VersionByObject;
        loadDuration = EventFields.Long$default((String)"duration_second", null, (int)2, null);
        jupyterSessionStartEvent = group.registerEvent("jupyter.session.start", (EventField)EventFields.Class((String)"session_factory"), (EventField)EventFields.Long((String)"start_time_sec", (String)"Duration for session creation in seconds rounded to 10s"), (EventField)EventFields.Boolean((String)"is_success", (String)"Session created successfully"));
        $this$iv = new EventFields[]{versionField, isSuccessField, isManagedField, serverKindField};
        jupyterClientConnect = group.registerVarargEvent("jupyter.client.connect", (EventField[])$this$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "previous";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        EnumEventField enumEventField = new EnumEventField(name$iv, JupyterRemoteServerNode.RemoteJupyterReachabilityStates.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "next";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        jupyterRfsConnect = group.registerEvent("jupyter.rfs.connect", (EventField)enumEventField, (EventField)new EnumEventField(name$iv, JupyterRemoteServerNode.RemoteJupyterReachabilityStates.class, null, transform$iv));
        fileSizeField = EventFields.RoundedLong$default((String)"fileSize", null, (int)2, null);
        jupyterFileUploadEvent = group.registerEvent("jupyter.remote.file.upload", (EventField)EventFields.FileType, (EventField)fileSizeField, (EventField)loadDuration);
        jupyterFileDownloadEvent = group.registerEvent("jupyter.remote.file.download", (EventField)EventFields.FileType, (EventField)fileSizeField, (EventField)loadDuration);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/fus/JupyterConnectionsCollector$ServerKind;", "", "<init>", "(Ljava/lang/String;I)V", "Hub", "Notebook", "SageMaker", "UNKNOWN", "intellij.jupyter.core"})
    public static final class ServerKind
    extends Enum<ServerKind> {
        public static final /* enum */ ServerKind Hub = new ServerKind();
        public static final /* enum */ ServerKind Notebook = new ServerKind();
        public static final /* enum */ ServerKind SageMaker = new ServerKind();
        public static final /* enum */ ServerKind UNKNOWN = new ServerKind();
        private static final /* synthetic */ ServerKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ServerKind[] values() {
            return (ServerKind[])$VALUES.clone();
        }

        public static ServerKind valueOf(String value) {
            return Enum.valueOf(ServerKind.class, value);
        }

        @NotNull
        public static EnumEntries<ServerKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = serverKindArray = new ServerKind[]{ServerKind.Hub, ServerKind.Notebook, ServerKind.SageMaker, ServerKind.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

