/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.ws;

import com.intellij.credentialStore.Credentials;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.message.BytesWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageBase;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterProtocolSchema;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterProtocolSchemaFactory;
import com.intellij.jupyter.core.jupyter.connections.execution.message.StringWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.WebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterSSLWrapper;
import com.intellij.jupyter.core.jupyter.connections.http.proxy.JupyterSystemProxy;
import com.intellij.jupyter.core.jupyter.connections.http.proxy.ProxySettings;
import com.intellij.jupyter.core.jupyter.connections.ws.JupyterWebSocketClient;
import com.intellij.jupyter.core.jupyter.connections.ws.JupyterWebSocketClientClosedException;
import com.intellij.openapi.util.NlsSafe;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u008e\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012M\u0010\r\u001aI\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0014\u0010\u001c\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bJ\u0012\u0010\u001d\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\"\u0010 \u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0014\u0010#\u001a\u00020\f2\n\u0010$\u001a\u00060%j\u0002`&H\u0016J\b\u0010'\u001a\u00020\u0006H\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\fH\u0002J$\u0010,\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000f2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\bH\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RU\u0010\r\u001aI\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/ws/DelegateWebSocketClient;", "Lorg/java_websocket/client/WebSocketClient;", "uri", "Ljava/net/URI;", "headers", "", "", "useSystemProxy", "", "onMessage", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "", "onCloseCallback", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "code", "reason", "remote", "<init>", "(Ljava/net/URI;Ljava/util/Map;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function3;)V", "getUseSystemProxy", "()Z", "continuation", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/CancellableContinuation;", "connect", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "onClose", "message", "Ljava/nio/ByteBuffer;", "onError", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toString", "processMessage", "content", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/WebSocketMessage;", "initProxy", "buildOnCloseMessage", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nDelegateWebSocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegateWebSocketClient.kt\ncom/intellij/jupyter/core/jupyter/connections/ws/DelegateWebSocketClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class DelegateWebSocketClient
extends WebSocketClient {
    private final boolean useSystemProxy;
    @NotNull
    private final Function1<JupyterMessage, Unit> onMessage;
    @NotNull
    private final Function3<Integer, String, Boolean, Unit> onCloseCallback;
    @NotNull
    private final AtomicReference<CancellableContinuation<Integer>> continuation;

    public DelegateWebSocketClient(@NotNull URI uri, @NotNull Map<String, String> headers, boolean useSystemProxy, @NotNull Function1<? super JupyterMessage, Unit> onMessage, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> onCloseCallback) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(onMessage, (String)"onMessage");
        Intrinsics.checkNotNullParameter(onCloseCallback, (String)"onCloseCallback");
        super(uri, headers);
        this.useSystemProxy = useSystemProxy;
        this.onMessage = onMessage;
        this.onCloseCallback = onCloseCallback;
        this.continuation = new AtomicReference<Object>(null);
    }

    public final boolean getUseSystemProxy() {
        return this.useSystemProxy;
    }

    public final void connect(@NotNull CancellableContinuation<? super Integer> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        this.continuation.set(continuation);
        if (Intrinsics.areEqual((Object)this.uri.getScheme(), (Object)"wss")) {
            JupyterSSLWrapper jupyterSSLWrapper = JupyterSSLWrapper.Companion.getInstance();
            String string = this.uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            this.setSocketFactory(jupyterSSLWrapper.sslSocketFactory(string));
        }
        this.initProxy();
        this.connect();
    }

    public void onOpen(@Nullable ServerHandshake handshakedata) {
        block0: {
            CancellableContinuation cancellableContinuation = this.continuation.getAndSet(null);
            if (cancellableContinuation == null) break block0;
            cancellableContinuation.resumeWith(Result.constructor-impl((Object)101));
        }
    }

    public void onClose(int code, @Nullable String reason, boolean remote) {
        block3: {
            Object object;
            this.onCloseCallback.invoke((Object)code, (Object)reason, (Object)remote);
            CancellableContinuation cancellableContinuation = this.continuation.getAndSet(null);
            if (cancellableContinuation == null) break block3;
            DelegateWebSocketClient delegateWebSocketClient = this;
            CancellableContinuation cancellableContinuation2 = cancellableContinuation;
            try {
                MatchResult match;
                Object object2;
                DelegateWebSocketClient $this$onClose_u24lambda_u240 = delegateWebSocketClient;
                boolean bl = false;
                Regex regex = new Regex("Invalid status code received: (\\d+) Status line: .*");
                String string = reason;
                if (string == null) {
                    string = "";
                }
                object = Result.constructor-impl((Object)((object2 = (match = regex.matchEntire((CharSequence)string))) != null && (object2 = (String)object2.getGroupValues().get(1)) != null ? Integer.parseInt((String)object2) : -1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            cancellableContinuation2.resumeWith(object);
        }
    }

    public void onMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        StringWebSocketMessage wsMessage = new StringWebSocketMessage(message);
        this.processMessage(wsMessage);
    }

    public void onMessage(@NotNull ByteBuffer message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        BytesWebSocketMessage wsMessage = new BytesWebSocketMessage(message);
        this.processMessage(wsMessage);
    }

    public void onError(@NotNull Exception exception) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            CancellableContinuation cancellableContinuation = this.continuation.getAndSet(null);
            if (cancellableContinuation == null) break block0;
            cancellableContinuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new JupyterWebSocketClientClosedException(exception.getMessage(), exception))));
        }
    }

    @NotNull
    public String toString() {
        String string = JupyterWebSocketClient.class.getSimpleName();
        String string2 = ((Object)((Object)this)).getClass().getSimpleName();
        URI uRI = this.uri;
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
        return string + "$" + string2 + "(uri=" + JupyterHttpSessionRestUtilsKt.getObfuscated(uRI) + ")@" + System.identityHashCode((Object)this);
    }

    private final void processMessage(WebSocketMessage content) {
        JupyterProtocolSchema protocolSchema = JupyterProtocolSchemaFactory.createSchema$default(JupyterProtocolSchemaFactory.INSTANCE, null, 1, null);
        JupyterMessage message = JupyterMessageBase.Companion.parse(content, protocolSchema);
        this.onMessage.invoke((Object)message);
    }

    private final void initProxy() {
        Object object;
        String string;
        Credentials credentials;
        block10: {
            block9: {
                CharSequence charSequence;
                if (!this.useSystemProxy) {
                    return;
                }
                URI uRI = this.uri;
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
                ProxySettings proxySettings = JupyterSystemProxy.INSTANCE.getIdeaProxySettings(uRI);
                if (proxySettings == null) {
                    return;
                }
                ProxySettings ideaProxySettings = proxySettings;
                this.setProxy(ideaProxySettings.toJavaProxy());
                this.setDnsResolver(null);
                Credentials credentials2 = ideaProxySettings.getCredentials();
                if (credentials2 == null) {
                    return;
                }
                credentials = credentials2;
                string = credentials.getUserName();
                if (string == null) break block9;
                object = string;
                if (StringsKt.isBlank((CharSequence)object)) {
                    boolean bl = false;
                    charSequence = null;
                } else {
                    charSequence = object;
                }
                if ((string = (String)charSequence) != null) break block10;
            }
            return;
        }
        String username = string;
        String string2 = credentials.getPasswordAsString();
        if (string2 == null) {
            return;
        }
        String password = string2;
        Base64.Encoder encoder = Base64.getEncoder();
        object = username + ":" + password;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String auth = encoder.encodeToString(byArray);
        this.addHeader("Proxy-Authorization", "Basic " + auth);
    }

    @Nls
    private final String buildOnCloseMessage(int code, @NlsSafe String reason, boolean remote) {
        String string;
        Object[] objectArray = (Object[])reason;
        if (!(objectArray == null || objectArray.length() == 0)) {
            return reason;
        }
        if (remote) {
            objectArray = new Object[]{String.valueOf(code)};
            string = JupyterBundle.message("jupyter.remote.side.closed.connection.with.code", objectArray);
        } else {
            objectArray = new Object[]{String.valueOf(code)};
            string = JupyterBundle.message("jupyter.local.side.closed.connection.with.code", objectArray);
        }
        return string;
    }
}

