/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterPsiFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterPsiUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.core.api.psi.NotebookPsiCell;
import org.jetbrains.plugins.notebooks.psi.core.api.psi.NotebookPsiFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"J\"\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\u001bJ\u0010\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020'J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010$\u001a\u00020'J\u0010\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020)J\u0010\u0010,\u001a\u0004\u0018\u00010'2\u0006\u0010+\u001a\u00020)J\u0010\u0010-\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020.J\u0010\u0010/\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020'J\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u00102\u001a\u0004\u0018\u0001012\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u0004\u0018\u00010\"2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u00103\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0007\u001a\u00020\bJ3\u00104\u001a\u0004\u0018\u0001H5\"\b\b\u0000\u00105*\u00020\u0001*\u00020\u000b2\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u0001H507H\u0002\u00a2\u0006\u0002\u00108R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020\"0:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lcom/intellij/jupyter/core/jupyter/helper/JupyterHelper;", "", "<init>", "()V", "getCellIntervals", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getSelectedIntervals", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getSelectedInterval", "getHoveredInterval", "getJupyterNotebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getSelectedCells", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "getSelectedCell", "getPsiFile", "Lorg/jetbrains/plugins/notebooks/psi/core/api/psi/NotebookPsiFile;", "getSelectedPsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "getPsiCellByInterval", "interval", "getPsiCell", "jupyterCellIndex", "", "getPsiCells", "psiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getPsiCellByOffset", "virtualFile", "offset", "getJupyterEditorByOriginalVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDocumentByOriginalVirtualFile", "Lcom/intellij/openapi/editor/Document;", "getJupyterEditorByDocument", "document", "getVirtualFileByDocument", "getVirtualFileByPsi", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "getJupyterVirtualFileByOriginalVirtualFile", "getJupyterEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "takeIfJupyterEditor", "getJupyterFile", "firstNotNullOfAllAncestors", "T", "getter", "Lkotlin/Function1;", "(Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "FORCED_NOTEBOOK", "Lcom/intellij/openapi/actionSystem/DataKey;", "getFORCED_NOTEBOOK", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterHelper.kt\ncom/intellij/jupyter/core/jupyter/helper/JupyterHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1617#2,9:187\n1869#2:196\n1870#2:198\n1626#2:199\n543#2,6:201\n1#3:197\n1#3:200\n*S KotlinDebug\n*F\n+ 1 JupyterHelper.kt\ncom/intellij/jupyter/core/jupyter/helper/JupyterHelper\n*L\n77#1:187,9\n77#1:196\n77#1:198\n77#1:199\n116#1:201,6\n77#1:197\n*E\n"})
public final class JupyterHelper {
    @NotNull
    public static final JupyterHelper INSTANCE = new JupyterHelper();
    @NotNull
    private static final DataKey<BackedNotebookVirtualFile> FORCED_NOTEBOOK = DataKey.Companion.create("BackedNotebookVirtualFile");

    private JupyterHelper() {
    }

    @Nullable
    public final List<NotebookCellLines.Interval> getCellIntervals(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!NotebookCellLines.Companion.hasSupport(editor)) {
            return null;
        }
        return NotebookCellLines.Companion.get(editor).getIntervals();
    }

    @Nullable
    public final List<NotebookCellLines.Interval> getSelectedIntervals(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        EditorImpl editorImpl = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl jupyterEditor = editorImpl;
        return this.getSelectedIntervals((Editor)jupyterEditor);
    }

    private final NotebookCellLines.Interval getSelectedInterval(DataContext dataContext) {
        List<NotebookCellLines.Interval> list = this.getSelectedIntervals(dataContext);
        return list != null ? (NotebookCellLines.Interval)CollectionsKt.firstOrNull(list) : null;
    }

    @Nullable
    public final List<NotebookCellLines.Interval> getSelectedIntervals(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorImpl editorImpl = this.takeIfJupyterEditor(editor);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl jupyterEditor = editorImpl;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)jupyterEditor));
        if (notebookCellSelectionModel == null) {
            return null;
        }
        NotebookCellSelectionModel selectionModel = notebookCellSelectionModel;
        return selectionModel.getSelectedCells();
    }

    @Nullable
    public final NotebookCellLines.Interval getHoveredInterval(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorImpl editorImpl = this.takeIfJupyterEditor(editor);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl editorImpl2 = editorImpl;
        DataContext dataContext = editorImpl2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        return this.getHoveredInterval(dataContext2);
    }

    @Nullable
    public final NotebookCellLines.Interval getHoveredInterval(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return NotebookDataContext.INSTANCE.getHoveredInterval(dataContext);
    }

    @Nullable
    public final JupyterNotebook getJupyterNotebook(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        BackedNotebookVirtualFile backedNotebookVirtualFile = this.getJupyterFile(dataContext);
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebookOrNull() : null;
    }

    @Nullable
    public final JupyterNotebook getJupyterNotebook(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        BackedNotebookVirtualFile backedNotebookVirtualFile = this.getJupyterFile(editor);
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebookOrNull() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<JupyterCell> getSelectedCells(@NotNull DataContext dataContext) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        List<NotebookCellLines.Interval> list = this.getSelectedIntervals(dataContext);
        if (list == null) {
            return null;
        }
        List<NotebookCellLines.Interval> intervals = list;
        JupyterNotebook jupyterNotebook = this.getJupyterNotebook(dataContext);
        if (jupyterNotebook == null) {
            return null;
        }
        JupyterNotebook notebook = jupyterNotebook;
        Iterable $this$mapNotNull$iv = intervals;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JupyterCell it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv$iv;
            boolean bl2 = false;
            if (notebook.getCellOrNull(it.getOrdinal()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final JupyterCell getSelectedCell(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        JupyterNotebook jupyterNotebook = this.getJupyterNotebook(dataContext);
        if (jupyterNotebook == null) {
            return null;
        }
        JupyterNotebook notebook = jupyterNotebook;
        return notebook.getCellOrNull(interval2.getOrdinal());
    }

    @Nullable
    public final NotebookPsiFile getPsiFile(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = (NotebookPsiFile)this.firstNotNullOfAllAncestors(dataContext, JupyterHelper::getPsiFile$lambda$0);
        if (object == null) {
            EditorImpl editorImpl = this.getJupyterEditor(dataContext);
            object = editorImpl != null ? JupyterEditorExtensionsKt.getNotebookPsiFileFromProviders((Editor)editorImpl) : null;
        }
        return object;
    }

    @Nullable
    public final JupyterPsiCell getSelectedPsiCell(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        NotebookCellLines.Interval interval = this.getSelectedInterval(dataContext);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        return this.getPsiCellByInterval(dataContext, interval2);
    }

    private final JupyterPsiCell getPsiCellByInterval(DataContext dataContext, NotebookCellLines.Interval interval) {
        EditorImpl editorImpl = this.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl noteEditor = editorImpl;
        int offset = interval.getContentRange((Editor)noteEditor).getStartOffset();
        NotebookPsiFile notebookPsiFile = JupyterEditorExtensionsKt.getNotebookPsiFileFromProviders((Editor)noteEditor);
        NotebookPsiCell psiCell = notebookPsiFile != null ? JupyterPsiFileExtensionsKt.findNotebookPsiCellAt(notebookPsiFile, offset) : null;
        return psiCell instanceof JupyterPsiCell ? (JupyterPsiCell)psiCell : null;
    }

    @Nullable
    public final JupyterPsiCell getPsiCell(@NotNull Editor editor, int jupyterCellIndex) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return JupyterPsiUtils.INSTANCE.getPsiCell(editor, jupyterCellIndex);
    }

    @Nullable
    public final List<JupyterPsiCell> getPsiCells(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return JupyterPsiUtils.INSTANCE.getPsiCells(psiFile);
    }

    @Nullable
    public final List<JupyterPsiCell> getPsiCells(@NotNull Project project, @Nullable BackedNotebookVirtualFile notebookVirtualFile2) {
        List<JupyterPsiCell> list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BackedNotebookVirtualFile backedNotebookVirtualFile = notebookVirtualFile2;
        if (backedNotebookVirtualFile != null) {
            BackedNotebookVirtualFile it = backedNotebookVirtualFile;
            boolean bl = false;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it.getFile());
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile");
            list = INSTANCE.getPsiCells((PsiFile)((JupyterFile)psiFile));
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final JupyterPsiCell getPsiCellByOffset(@NotNull Project project, @Nullable BackedNotebookVirtualFile virtualFile, int offset) {
        JupyterPsiCell jupyterPsiCell;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<JupyterPsiCell> list = this.getPsiCells(project, virtualFile);
        if (list != null) {
            JupyterPsiCell jupyterPsiCell2;
            block3: {
                List<JupyterPsiCell> $this$lastOrNull$iv = list;
                boolean $i$f$lastOrNull = false;
                ListIterator<JupyterPsiCell> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    JupyterPsiCell element$iv;
                    JupyterPsiCell it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it.getTextOffset() <= offset)) continue;
                    jupyterPsiCell2 = element$iv;
                    break block3;
                }
                jupyterPsiCell2 = null;
            }
            jupyterPsiCell = jupyterPsiCell2;
        } else {
            jupyterPsiCell = null;
        }
        return jupyterPsiCell;
    }

    @Nullable
    public final Editor getJupyterEditorByOriginalVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        WeakReference weakReference = (WeakReference)virtualFile.getUserData(JupyterCellLinesExtensionsKt.getJUPYTER_EDITOR_KEY());
        return weakReference != null ? (Editor)weakReference.get() : null;
    }

    @Nullable
    public final Document getDocumentByOriginalVirtualFile(@NotNull VirtualFile virtualFile) {
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Editor editor2 = editor = this.getJupyterEditorByOriginalVirtualFile(virtualFile);
        return editor2 != null ? editor2.getDocument() : null;
    }

    @Nullable
    public final Editor getJupyterEditorByDocument(@NotNull Document document) {
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            editor = INSTANCE.getJupyterEditorByOriginalVirtualFile(it);
        } else {
            editor = null;
        }
        return editor;
    }

    @Nullable
    public final VirtualFile getVirtualFileByDocument(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return FileDocumentManager.getInstance().getFile(document);
    }

    @Nullable
    public final BackedNotebookVirtualFile getVirtualFileByPsi(@NotNull JupyterFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Document document = psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        VirtualFile virtualFile = this.getVirtualFileByDocument(document);
        if (virtualFile == null) {
            virtualFile = psiFile.getVirtualFile();
        }
        VirtualFile virtualFile2 = virtualFile;
        Intrinsics.checkNotNull((Object)virtualFile2);
        return this.getJupyterVirtualFileByOriginalVirtualFile(virtualFile2);
    }

    @Nullable
    public final BackedNotebookVirtualFile getJupyterVirtualFileByOriginalVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
        if (backedNotebookVirtualFile == null) {
            backedNotebookVirtualFile = (BackedNotebookVirtualFile)virtualFile.getUserData(JupyterCellLinesExtensionsKt.getNOTEBOOK_VIRTUAL_FILE_KEY());
        }
        return backedNotebookVirtualFile;
    }

    @Nullable
    public final EditorImpl getJupyterEditor(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        EditorImpl editorImpl = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl notebookEditor = editorImpl;
        if (!JupyterEditorExtensionsKt.isJupyter((Editor)notebookEditor)) {
            return null;
        }
        return notebookEditor;
    }

    private final EditorImpl takeIfJupyterEditor(Editor editor) {
        Editor editor2;
        Editor it = editor2 = editor;
        boolean bl = false;
        Editor editor3 = NotebookCellLines.Companion.hasSupport(it) ? editor2 : null;
        EditorImpl editorImpl = editor3 instanceof EditorImpl ? (EditorImpl)editor3 : null;
        if (editorImpl == null) {
            return null;
        }
        EditorImpl notebookEditor = editorImpl;
        if (!JupyterEditorExtensionsKt.isJupyter((Editor)notebookEditor)) {
            return null;
        }
        return notebookEditor;
    }

    @Nullable
    public final BackedNotebookVirtualFile getJupyterFile(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        BackedNotebookVirtualFile forcedFile = (BackedNotebookVirtualFile)dataContext.getData(FORCED_NOTEBOOK);
        if (forcedFile != null) {
            return forcedFile;
        }
        EditorImpl editorImpl = this.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl editorImpl2 = editorImpl;
        return this.getJupyterFile((Editor)editorImpl2);
    }

    @Nullable
    public final BackedNotebookVirtualFile getJupyterFile(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile documentVirtualFile = virtualFile;
        return BackedNotebookVirtualFile.Companion.takeIfBacked(documentVirtualFile);
    }

    private final <T> T firstNotNullOfAllAncestors(DataContext $this$firstNotNullOfAllAncestors, Function1<? super DataContext, ? extends T> getter) {
        Object object;
        block1: {
            Iterator iterator = SequencesKt.generateSequence((Object)$this$firstNotNullOfAllAncestors, JupyterHelper::firstNotNullOfAllAncestors$lambda$0).iterator();
            while (iterator.hasNext()) {
                Object object2 = getter.invoke(iterator.next());
                if (object2 == null) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public final DataKey<BackedNotebookVirtualFile> getFORCED_NOTEBOOK() {
        return FORCED_NOTEBOOK;
    }

    private static final NotebookPsiFile getPsiFile$lambda$0(DataContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = (PsiFile)PlatformDataKeys.PSI_FILE.getData(it);
        return psiFile != null ? JupyterPsiFileExtensionsKt.getNotebookPsiFileFromProviders(psiFile) : null;
    }

    private static final DataContext firstNotNullOfAllAncestors$lambda$0(DataContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DataContextWrapper ? ((DataContextWrapper)it).getParent() : null;
    }
}

