/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.PuppetResourceInstanceDeclaration;
import com.intellij.lang.puppet.psi.PuppetResourceLikeClassDescription;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PuppetFoldingBuilder
extends CustomFoldingBuilder
implements PuppetTokenTypes {
    private static final TokenSet FOLDABLE_ELEMENTS_WITH_QUOTES = TokenSet.create((IElementType[])new IElementType[]{BRACED_STATEMENTS_BLOCK, PARENTHESIZED_PARAMETERS_LIST_BLOCK, BRACED_SELECTOR_VALUES_BLOCK, BRACED_CASE_OPTS_BLOCK});
    private static final NotNullLazyValue<Map<IElementType, String>> REGION_NAMES_LAZY_MAP = NotNullLazyValue.atomicLazy(() -> {
        HashMap<IElementType, String> result = new HashMap<IElementType, String>();
        result.put(PARENTHESIZED_PARAMETERS_LIST_BLOCK, PuppetBundle.message("puppet.folding.arguments", new Object[0]));
        result.put(BRACED_STATEMENTS_BLOCK, PuppetBundle.message("puppet.folding.code", new Object[0]));
        result.put(HEREDOC_BODY, PuppetBundle.message("puppet.folding.heredoc", new Object[0]));
        result.put(HEREDOC_BODY_QQ, PuppetBundle.message("puppet.folding.heredoc", new Object[0]));
        result.put(RESOURCE_INSTANCE_DECLARATION, PuppetBundle.message("puppet.folding.attributes", new Object[0]));
        result.put(RESOURCE_LIKE_CLASS_DESCRIPTION, PuppetBundle.message("puppet.folding.attributes", new Object[0]));
        result.put(BRACED_SELECTOR_VALUES_BLOCK, PuppetBundle.message("puppet.folding.selector.options", new Object[0]));
        result.put(BRACED_CASE_OPTS_BLOCK, PuppetBundle.message("puppet.folding.case.options", new Object[0]));
        return result;
    });

    protected void buildLanguageFoldRegions(final @NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            PuppetFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PuppetFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            PuppetFoldingBuilder.$$$reportNull$$$0(2);
        }
        root.accept(new PsiElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                FoldingDescriptor descriptor;
                IElementType elementType;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FOLDABLE_ELEMENTS_WITH_QUOTES.contains(elementType = PsiUtilCore.getElementType((PsiElement)element))) {
                    TextRange elementRange = element.getTextRange();
                    if (elementRange.getLength() > 2) {
                        descriptors.add(new FoldingDescriptor(element, TextRange.create((int)(elementRange.getStartOffset() + 1), (int)(elementRange.getEndOffset() - 1))));
                    }
                } else if (elementType == PuppetTokenTypes.HEREDOC_BODY || elementType == PuppetTokenTypes.HEREDOC_BODY_QQ) {
                    TextRange elementRange = element.getTextRange();
                    if (elementRange.getLength() > 1) {
                        descriptors.add(new FoldingDescriptor(element, TextRange.create((int)elementRange.getStartOffset(), (int)(elementRange.getEndOffset() - 1))));
                    }
                } else if ((element instanceof PuppetResourceInstanceDeclaration || element instanceof PuppetResourceLikeClassDescription) && (descriptor = PuppetFoldingBuilder.getResourceInstanceLikeFoldingDescriptor(element)) != null) {
                    descriptors.add(descriptor);
                }
                super.visitElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/puppet/ide/folding/PuppetFoldingBuilder$1", "visitElement"));
            }
        });
    }

    @Nullable
    private static FoldingDescriptor getResourceInstanceLikeFoldingDescriptor(PsiElement element) {
        ASTNode elementNode = element.getNode();
        TextRange nodeRange = elementNode.getTextRange();
        int elementEndOffset = nodeRange.getEndOffset();
        ASTNode colonElement = elementNode.findChildByType(COLON);
        if (colonElement == null) {
            return null;
        }
        int colonOffset = colonElement.getStartOffset();
        return colonOffset < elementEndOffset ? new FoldingDescriptor(element, TextRange.create((int)colonOffset, (int)elementEndOffset)) : null;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            PuppetFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            PuppetFoldingBuilder.$$$reportNull$$$0(4);
        }
        IElementType elementType = PsiUtilCore.getElementType((ASTNode)node);
        String explicitName = (String)((Map)REGION_NAMES_LAZY_MAP.getValue()).get(elementType);
        return explicitName == null ? "..." : explicitName;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PuppetFoldingBuilder.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ide/folding/PuppetFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

