/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Command;
import zmq.Ctx;
import zmq.Msg;
import zmq.Own;
import zmq.SocketBase;
import zmq.io.IEngine;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.pipe.Pipe;
import zmq.pipe.YPipeBase;

public abstract class ZObject {
    private final Ctx ctx;
    private int tid;

    protected ZObject(Ctx ctx, int tid) {
        this.ctx = ctx;
        this.tid = tid;
    }

    protected ZObject(ZObject parent) {
        this(parent.ctx, parent.tid);
    }

    public final int getTid() {
        return this.tid;
    }

    protected final void setTid(int tid) {
        this.tid = tid;
    }

    public final Ctx getCtx() {
        return this.ctx;
    }

    final void processCommand(Command cmd) {
        switch (cmd.type) {
            case ACTIVATE_READ: {
                this.processActivateRead();
                break;
            }
            case ACTIVATE_WRITE: {
                this.processActivateWrite((Long)cmd.arg);
                break;
            }
            case STOP: {
                this.processStop();
                break;
            }
            case PLUG: {
                this.processPlug();
                this.processSeqnum();
                break;
            }
            case OWN: {
                this.processOwn((Own)cmd.arg);
                this.processSeqnum();
                break;
            }
            case ATTACH: {
                this.processAttach((IEngine)cmd.arg);
                this.processSeqnum();
                break;
            }
            case BIND: {
                this.processBind((Pipe)cmd.arg);
                this.processSeqnum();
                break;
            }
            case HICCUP: {
                this.processHiccup((YPipeBase)cmd.arg);
                break;
            }
            case PIPE_TERM: {
                this.processPipeTerm();
                break;
            }
            case PIPE_TERM_ACK: {
                this.processPipeTermAck();
                break;
            }
            case TERM_REQ: {
                this.processTermReq((Own)cmd.arg);
                break;
            }
            case TERM: {
                this.processTerm((Integer)cmd.arg);
                break;
            }
            case TERM_ACK: {
                this.processTermAck();
                break;
            }
            case REAP: {
                this.processReap((SocketBase)cmd.arg);
                break;
            }
            case REAP_ACK: {
                this.processReapAck();
                break;
            }
            case REAPED: {
                this.processReaped();
                break;
            }
            case INPROC_CONNECTED: {
                this.processSeqnum();
                break;
            }
            case CANCEL: {
                this.processCancel();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected final boolean registerEndpoint(String addr, Ctx.Endpoint endpoint) {
        return this.ctx.registerEndpoint(addr, endpoint);
    }

    protected final boolean unregisterEndpoint(String addr, SocketBase socket) {
        return this.ctx.unregisterEndpoint(addr, socket);
    }

    protected final void unregisterEndpoints(SocketBase socket) {
        this.ctx.unregisterEndpoints(socket);
    }

    protected final Ctx.Endpoint findEndpoint(String addr) {
        return this.ctx.findEndpoint(addr);
    }

    protected final void pendConnection(String addr, Ctx.Endpoint endpoint, Pipe[] pipes) {
        this.ctx.pendConnection(addr, endpoint, pipes);
    }

    protected final void connectPending(String addr, SocketBase bindSocket) {
        this.ctx.connectPending(addr, bindSocket);
    }

    protected final void destroySocket(SocketBase socket) {
        this.ctx.destroySocket(socket);
    }

    protected final IOThread chooseIoThread(long affinity) {
        return this.ctx.chooseIoThread(affinity);
    }

    protected final void sendStop() {
        Command cmd = new Command(this, Command.Type.STOP);
        this.ctx.sendCommand(this.tid, cmd);
    }

    protected final void sendPlug(Own destination) {
        this.sendPlug(destination, true);
    }

    protected final void sendPlug(Own destination, boolean incSeqnum) {
        if (incSeqnum) {
            destination.incSeqnum();
        }
        Command cmd = new Command(destination, Command.Type.PLUG);
        this.sendCommand(cmd);
    }

    protected final void sendOwn(Own destination, Own object) {
        destination.incSeqnum();
        Command cmd = new Command(destination, Command.Type.OWN, object);
        this.sendCommand(cmd);
    }

    protected final void sendAttach(SessionBase destination, IEngine engine) {
        this.sendAttach(destination, engine, true);
    }

    protected final void sendAttach(SessionBase destination, IEngine engine, boolean incSeqnum) {
        if (incSeqnum) {
            destination.incSeqnum();
        }
        Command cmd = new Command(destination, Command.Type.ATTACH, engine);
        this.sendCommand(cmd);
    }

    protected final void sendBind(Own destination, Pipe pipe) {
        this.sendBind(destination, pipe, true);
    }

    protected final void sendBind(Own destination, Pipe pipe, boolean incSeqnum) {
        if (incSeqnum) {
            destination.incSeqnum();
        }
        Command cmd = new Command(destination, Command.Type.BIND, pipe);
        this.sendCommand(cmd);
    }

    protected final void sendActivateRead(Pipe destination) {
        Command cmd = new Command(destination, Command.Type.ACTIVATE_READ);
        this.sendCommand(cmd);
    }

    protected final void sendActivateWrite(Pipe destination, long msgsRead) {
        Command cmd = new Command(destination, Command.Type.ACTIVATE_WRITE, msgsRead);
        this.sendCommand(cmd);
    }

    protected final void sendHiccup(Pipe destination, YPipeBase<Msg> pipe) {
        Command cmd = new Command(destination, Command.Type.HICCUP, pipe);
        this.sendCommand(cmd);
    }

    protected final void sendPipeTerm(Pipe destination) {
        Command cmd = new Command(destination, Command.Type.PIPE_TERM);
        this.sendCommand(cmd);
    }

    protected final void sendPipeTermAck(Pipe destination) {
        Command cmd = new Command(destination, Command.Type.PIPE_TERM_ACK);
        this.sendCommand(cmd);
    }

    protected final void sendTermReq(Own destination, Own object) {
        Command cmd = new Command(destination, Command.Type.TERM_REQ, object);
        this.sendCommand(cmd);
    }

    protected final void sendTerm(Own destination, int linger) {
        Command cmd = new Command(destination, Command.Type.TERM, linger);
        this.sendCommand(cmd);
    }

    protected final void sendTermAck(Own destination) {
        Command cmd = new Command(destination, Command.Type.TERM_ACK);
        this.sendCommand(cmd);
    }

    protected final void sendReap(SocketBase socket) {
        Command cmd = new Command(this.ctx.getReaper(), Command.Type.REAP, socket);
        this.sendCommand(cmd);
    }

    protected final void sendReapAck() {
        Command cmd = new Command(this, Command.Type.REAP_ACK);
        this.sendCommand(cmd);
    }

    protected final void sendReaped() {
        Command cmd = new Command(this.ctx.getReaper(), Command.Type.REAPED);
        this.sendCommand(cmd);
    }

    protected final void sendInprocConnected(SocketBase socket) {
        Command cmd = new Command(socket, Command.Type.INPROC_CONNECTED);
        this.sendCommand(cmd);
    }

    protected final void sendDone() {
        Command cmd = new Command(null, Command.Type.DONE);
        this.ctx.sendCommand(0, cmd);
    }

    protected final void sendCancel() {
        Command cmd = new Command(this, Command.Type.CANCEL);
        this.sendCommand(cmd);
    }

    protected void processStop() {
        throw new UnsupportedOperationException();
    }

    protected void processPlug() {
        throw new UnsupportedOperationException();
    }

    protected void processOwn(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void processAttach(IEngine engine) {
        throw new UnsupportedOperationException();
    }

    protected void processBind(Pipe pipe) {
        throw new UnsupportedOperationException();
    }

    protected void processActivateRead() {
        throw new UnsupportedOperationException();
    }

    protected void processActivateWrite(long msgsRead) {
        throw new UnsupportedOperationException();
    }

    protected void processHiccup(YPipeBase<Msg> hiccupPipe) {
        throw new UnsupportedOperationException();
    }

    protected void processPipeTerm() {
        throw new UnsupportedOperationException();
    }

    protected void processPipeTermAck() {
        throw new UnsupportedOperationException();
    }

    protected void processTermReq(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void processTerm(int linger) {
        throw new UnsupportedOperationException();
    }

    protected void processTermAck() {
        throw new UnsupportedOperationException();
    }

    protected void processReap(SocketBase socket) {
        throw new UnsupportedOperationException();
    }

    protected void processReapAck() {
    }

    protected void processReaped() {
        throw new UnsupportedOperationException();
    }

    protected void processSeqnum() {
        throw new UnsupportedOperationException();
    }

    protected void processCancel() {
    }

    private void sendCommand(Command cmd) {
        this.ctx.sendCommand(cmd.destination.getTid(), cmd);
    }
}

