/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleExecutionEditor;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.idea.ActionsBundle;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.HistoryViewNavigator;
import com.intellij.javascript.debugger.console.MessagePrinter;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.WebConsoleFilterForm;
import com.intellij.javascript.debugger.console.WebConsoleHistoryView;
import com.intellij.javascript.debugger.console.WebConsoleSearchSession;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00fb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001d*\u0001$\u0018\u00002\u00020\u00012\u00020\u0002:\u000e\u0099\u0001\u009a\u0001\u009b\u0001\u009c\u0001\u009d\u0001\u009e\u0001\u009f\u0001B=\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010&\u001a\n (*\u0004\u0018\u00010'0'H\u0002J\b\u0010)\u001a\u00020*H\u0016J\u001a\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\"2\b\b\u0002\u0010.\u001a\u00020\"J%\u0010/\u001a\u00020,2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0000\u00a2\u0006\u0002\b6J\u0018\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020:H\u0016J\u001a\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020,2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\b\u0010?\u001a\u00020*H\u0016J\r\u0010@\u001a\u00020*H\u0000\u00a2\u0006\u0002\bAJ\u0013\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0016\u00a2\u0006\u0002\u0010EJ\u000f\u0010F\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\bGJ\u0017\u0010H\u001a\u00020*2\b\u0010I\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\bJJ\r\u0010K\u001a\u00020*H\u0000\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u00020*H\u0002J\u001a\u0010N\u001a\u00020*2\b\b\u0001\u0010O\u001a\u00020,2\u0006\u0010P\u001a\u00020\u0001H\u0002J\u000e\u0010Q\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u001dJ\b\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u00020SH\u0016J\u0010\u0010U\u001a\u00020*2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020*2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\"H\u0016J\b\u0010\\\u001a\u00020\"H\u0016J\b\u0010]\u001a\u00020\"H\u0016J\u0010\u0010^\u001a\u00020*2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020*2\u0006\u0010b\u001a\u00020,H\u0016J\u0010\u0010c\u001a\u00020*2\u0006\u0010d\u001a\u00020eH\u0016J\b\u0010f\u001a\u00020WH\u0016J\b\u0010g\u001a\u00020\"H\u0016J\b\u0010h\u001a\u00020*H\u0016J\u0012\u0010\u0091\u0001\u001a\u00020*2\u0007\u0010\u0092\u0001\u001a\u00020,H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u0014\u00100\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR$\u0010O\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\u0014\u0010o\u001a\u00020p8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bq\u0010rR\u0016\u0010s\u001a\u0004\u0018\u00010t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bu\u0010vR\u0014\u0010w\u001a\u00020x8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010zR\u0014\u0010{\u001a\u00020x8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b|\u0010zR\u0015\u0010}\u001a\u00020~8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u007f\u0010\u0080\u0001R\u0016\u0010\u0081\u0001\u001a\u00020x8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0082\u0001\u0010zR+\u0010\u0084\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u001c\u001a\u00030\u0083\u00018V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R+\u0010\u0089\u0001\u001a\u0004\u0018\u00010,2\b\u0010\u001c\u001a\u0004\u0018\u00010,8V@VX\u0096\u000e\u00a2\u0006\u000e\u001a\u0005\b\u008a\u0001\u0010l\"\u0005\b\u008b\u0001\u0010nR)\u0010\u008c\u0001\u001a\u00020:2\u0006\u0010\u001c\u001a\u00020:8V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001\"\u0006\b\u008f\u0001\u0010\u0090\u0001R)\u0010\u0093\u0001\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\"8V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001\"\u0006\b\u0095\u0001\u0010\u0096\u0001R)\u0010\u0097\u0001\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\"8V@VX\u0096\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0097\u0001\u0010\u0094\u0001\"\u0006\b\u0098\u0001\u0010\u0096\u0001\u00a8\u0006\u00a0\u0001"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView;", "Ljavax/swing/JPanel;", "Lcom/intellij/execution/console/LanguageConsoleView;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "helper", "Lcom/intellij/execution/console/LanguageConsoleImpl$Helper;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "settings", "Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "historyView", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "consolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/execution/console/LanguageConsoleImpl$Helper;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;Lcom/intellij/javascript/debugger/console/ConsolePrinter;)V", "printer", "Lcom/intellij/javascript/debugger/console/MessagePrinter;", "getPrinter$intellij_javascript_debugger_backend", "()Lcom/intellij/javascript/debugger/console/MessagePrinter;", "consoleExecutionEditor", "Lcom/intellij/execution/console/ConsoleExecutionEditor;", "executionPanel", "headerComponent", "Ljava/awt/Component;", "searchSession", "Lcom/intellij/javascript/debugger/console/WebConsoleSearchSession;", "value", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "domPresentationProvider", "getDomPresentationProvider", "()Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "disposed", "", "keyListener", "com/intellij/javascript/debugger/console/WebConsoleView$keyListener$1", "Lcom/intellij/javascript/debugger/console/WebConsoleView$keyListener$1;", "getBorderColor", "Lcom/intellij/ui/Gray;", "kotlin.jvm.PlatformType", "dispose", "", "printInputFromExecutionEditor", "", "scrollToEnd", "clearInputEditor", "printUserInputWithHighlighting", "project", "Lcom/intellij/openapi/project/Project;", "inputEditor", "Lcom/intellij/openapi/editor/Editor;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "printUserInputWithHighlighting$intellij_javascript_debugger_backend", "print", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printHyperlink", "hyperlinkText", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "clear", "doClear", "doClear$intellij_javascript_debugger_backend", "createConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "getHeaderComponent", "getHeaderComponent$intellij_javascript_debugger_backend", "setHeaderComponent", "header", "setHeaderComponent$intellij_javascript_debugger_backend", "searchSessionStopped", "searchSessionStopped$intellij_javascript_debugger_backend", "showFiltersPopup", "createAndShowPopup", "title", "jPanel", "setDOMViewHandler", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "scrollTo", "offset", "", "attachToProcess", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "setOutputPaused", "isOutputPaused", "hasDeferredOutput", "performWhenNoDeferredOutput", "runnable", "Ljava/lang/Runnable;", "setHelpId", "helpId", "addMessageFilter", "filter", "Lcom/intellij/execution/filters/Filter;", "getContentSize", "canPause", "allowHeavyFilters", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "currentEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getCurrentEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "consoleEditor", "getConsoleEditor", "editorDocument", "Lcom/intellij/openapi/editor/Document;", "getEditorDocument", "()Lcom/intellij/openapi/editor/Document;", "historyViewer", "getHistoryViewer", "Lcom/intellij/lang/Language;", "language", "getLanguage", "()Lcom/intellij/lang/Language;", "setLanguage", "(Lcom/intellij/lang/Language;)V", "prompt", "getPrompt", "setPrompt", "promptAttributes", "getPromptAttributes", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "setPromptAttributes", "(Lcom/intellij/execution/ui/ConsoleViewContentType;)V", "setInputText", "inputText", "isEditable", "()Z", "setEditable", "(Z)V", "isConsoleEditorEnabled", "setConsoleEditorEnabled", "OpenDevToolsAction", "SearchAction", "ScrollToTheEndToolbarAction", "ClearAllAction", "FilterAction", "DOMPresentationProvider", "IconHolder", "intellij.javascript.debugger.backend"})
public final class WebConsoleView
extends JPanel
implements LanguageConsoleView {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final LanguageConsoleImpl.Helper helper;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final WebConsoleViewSettings settings;
    @NotNull
    private final WebConsoleHistoryView historyView;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final MessagePrinter printer;
    @NotNull
    private final ConsoleExecutionEditor consoleExecutionEditor;
    @NotNull
    private final JPanel executionPanel;
    @Nullable
    private Component headerComponent;
    @Nullable
    private WebConsoleSearchSession searchSession;
    @Nullable
    private DOMPresentationProvider domPresentationProvider;
    private volatile boolean disposed;
    @NotNull
    private final keyListener.1 keyListener;

    public WebConsoleView(@NotNull CoroutineScope coroutineScope, @NotNull LanguageConsoleImpl.Helper helper2, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull WebConsoleViewSettings settings, @NotNull WebConsoleHistoryView historyView, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)historyView, (String)"historyView");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        super(new BorderLayout());
        this.coroutineScope = coroutineScope;
        this.helper = helper2;
        this.debugProcess = debugProcess;
        this.settings = settings;
        this.historyView = historyView;
        this.consolePrinter = consolePrinter;
        this.printer = this.historyView;
        this.consoleExecutionEditor = new ConsoleExecutionEditor(this.helper);
        this.executionPanel = new JPanel(new BorderLayout());
        this.keyListener = new KeyAdapter(this){
            final /* synthetic */ WebConsoleView this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyTyped(KeyEvent event) {
                if (this.this$0.isConsoleEditorEnabled()) {
                    KeyEvent keyEvent = event;
                    Intrinsics.checkNotNull((Object)keyEvent);
                    if (UIUtil.isReallyTypedEvent((KeyEvent)keyEvent)) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> keyListener.1.keyTyped$lambda$0(this.this$0));
                        WebConsoleView.access$getConsoleExecutionEditor$p(this.this$0).getEditor().processKeyTyped(event);
                    }
                }
            }

            private static final void keyTyped$lambda$0(WebConsoleView this$0) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)WebConsoleView.access$getConsoleExecutionEditor$p(this$0).getEditor().getContentComponent(), true);
            }
        };
        EditorEx editorEx = this.consoleExecutionEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        this.helper.setupEditor(editorEx);
        this.consoleExecutionEditor.initComponent();
        this.consoleExecutionEditor.setPrompt(null);
        this.consoleExecutionEditor.getEditor().getGutter().closeAllAnnotations();
        this.add(this.historyView.getComponent(), "Center");
        this.add((Component)this.executionPanel, "South");
        this.executionPanel.add(this.consoleExecutionEditor.getComponent());
        Icon icon = AllIcons.Debugger.PromptInput;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PromptInput");
        EditorColorsScheme editorColorsScheme = this.consoleExecutionEditor.getCurrentEditor().getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        IconHolder iconHolder = new IconHolder(icon, editorColorsScheme);
        this.executionPanel.add((Component)iconHolder, "West");
        this.executionPanel.setBorder((Border)new CustomLineBorder((Color)this.getBorderColor(), 1, 0, 0, 0));
        this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> WebConsoleView._init_$lambda$0(this, iconHolder, arg_0));
        this.historyView.addKeyListener(this.keyListener);
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.consoleExecutionEditor));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.historyView);
    }

    @NotNull
    public final MessagePrinter getPrinter$intellij_javascript_debugger_backend() {
        return this.printer;
    }

    @Nullable
    public final DOMPresentationProvider getDomPresentationProvider() {
        return this.domPresentationProvider;
    }

    private final Gray getBorderColor() {
        return JBColor.isBright() ? Gray._240 : Gray._58;
    }

    public void dispose() {
        FileEditorManager editorManager;
        this.disposed = true;
        this.historyView.removeKeyListener(this.keyListener);
        this.remove(this.historyView.getComponent());
        if (this.helper.project.isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.helper.project)).isFileOpen(this.helper.virtualFile)) {
            editorManager.closeFile(this.helper.virtualFile);
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, (String)"WebConsoleView disposed", null, (int)2, null);
    }

    @NotNull
    public final String printInputFromExecutionEditor(boolean scrollToEnd, boolean clearInputEditor) {
        EditorEx editor = this.getCurrentEditor();
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        TextRange range = new TextRange(0, document.getTextLength());
        this.printUserInputWithHighlighting$intellij_javascript_debugger_backend(this.getProject(), (Editor)editor, range);
        if (clearInputEditor) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> WebConsoleView.printInputFromExecutionEditor$lambda$0(editor, document));
        }
        if (scrollToEnd) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WebConsoleView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            WebConsoleView.access$getHistoryView$p(this.this$0).scrollToEnd();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return text;
    }

    public static /* synthetic */ String printInputFromExecutionEditor$default(WebConsoleView webConsoleView, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return webConsoleView.printInputFromExecutionEditor(bl, bl2);
    }

    @NotNull
    public final String printUserInputWithHighlighting$intellij_javascript_debugger_backend(@NotNull Project project, @NotNull Editor inputEditor, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)inputEditor, (String)"inputEditor");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        ThreadingAssertions.assertEventDispatchThread();
        String text = null;
        EditorHighlighter highlighter = null;
        if (inputEditor instanceof EditorWindow) {
            PsiFile psiFile = ((EditorWindow)inputEditor).getInjectedFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getInjectedFile(...)");
            PsiFile file = psiFile;
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((VirtualFile)file.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
            highlighter = editorHighlighter;
            String string = InjectedLanguageManager.getInstance((Project)project).getUnescapedText((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnescapedText(...)");
            String fullText = string;
            highlighter.setText((CharSequence)fullText);
            String string2 = textRange.substring(fullText);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            text = string2;
        } else {
            String string = inputEditor.getDocument().getText(textRange);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            text = string;
            EditorHighlighter editorHighlighter = inputEditor.getHighlighter();
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getHighlighter(...)");
            highlighter = editorHighlighter;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, highlighter, text, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ EditorHighlighter $highlighter;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$highlighter = $highlighter;
                this.$text = $text;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ConsolePrinter consolePrinter = WebConsoleView.access$getConsolePrinter$p(this.this$0);
                        Vm vm = WebConsoleView.access$getDebugProcess$p(this.this$0).getActiveOrMainVm();
                        Intrinsics.checkNotNull((Object)vm);
                        this.label = 1;
                        Object object2 = consolePrinter.submitMessage(vm, true, (Function2<? super ConsoleMessageBuilder, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object>(this.$highlighter, this.$text, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ EditorHighlighter $highlighter;
                            final /* synthetic */ String $text;
                            {
                                this.$highlighter = $highlighter;
                                this.$text = $text;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ConsoleMessageBuilder consoleMessageBuilder = (ConsoleMessageBuilder)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$submitMessage;
                                        ResultKt.throwOnFailure((Object)$result);
                                        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.USER_INPUT;
                                        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"USER_INPUT");
                                        ConsoleMessageBuilder.startMessage$default((ConsoleMessageBuilder)$this$submitMessage, consoleViewContentType, MessageType.EVAL_IN, null, 4, null);
                                        if (this.$highlighter instanceof LexerEditorHighlighter) {
                                            ConsoleViewUtil.printWithHighlighting((arg_0, arg_1) -> printUserInputWithHighlighting.1.invokeSuspend$lambda$0((Function2)new Function2<String, ConsoleViewContentType, Unit>((Object)$this$submitMessage){

                                                public final void invoke(String p0, ConsoleViewContentType p1) {
                                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)this.receiver, p0, p1, null, 4, null);
                                                }
                                            }, arg_0, arg_1), (String)this.$text, (SyntaxHighlighter)((LexerEditorHighlighter)this.$highlighter).getSyntaxHighlighter(), null);
                                        } else {
                                            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.USER_INPUT;
                                            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"USER_INPUT");
                                            ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)$this$submitMessage, this.$text, consoleViewContentType2, null, 4, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ConsoleMessageBuilder p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                                $tmp0.invoke(p0, p1);
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return text;
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, text, contentType, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ ConsoleViewContentType $contentType;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$contentType = $contentType;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ConsolePrinter consolePrinter = WebConsoleView.access$getConsolePrinter$p(this.this$0);
                        Vm vm = WebConsoleView.access$getDebugProcess$p(this.this$0).getActiveOrMainVm();
                        Intrinsics.checkNotNull((Object)vm);
                        this.label = 1;
                        Object object2 = ConsolePrinter.submitMessage$default(consolePrinter, vm, false, (Function2)new Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object>(this.$text, this.$contentType, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ String $text;
                            final /* synthetic */ ConsoleViewContentType $contentType;
                            {
                                this.$text = $text;
                                this.$contentType = $contentType;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ConsoleMessageBuilder consoleMessageBuilder = (ConsoleMessageBuilder)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$submitMessage;
                                        ResultKt.throwOnFailure((Object)$result);
                                        ConsoleMessageBuilder.startMessage$default((ConsoleMessageBuilder)$this$submitMessage, null, null, null, 7, null);
                                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)$this$submitMessage, this.$text, this.$contentType, null, 4, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ConsoleMessageBuilder p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this, 2, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkText, (String)"hyperlinkText");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, hyperlinkText, info, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ String $hyperlinkText;
            final /* synthetic */ HyperlinkInfo $info;
            {
                this.this$0 = $receiver;
                this.$hyperlinkText = $hyperlinkText;
                this.$info = $info;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ConsolePrinter consolePrinter = WebConsoleView.access$getConsolePrinter$p(this.this$0);
                        Vm vm = WebConsoleView.access$getDebugProcess$p(this.this$0).getActiveOrMainVm();
                        Intrinsics.checkNotNull((Object)vm);
                        this.label = 1;
                        Object object2 = ConsolePrinter.submitMessage$default(consolePrinter, vm, false, (Function2)new Function2<ConsoleMessageBuilder, Continuation<? super Unit>, Object>(this.$hyperlinkText, this.$info, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ String $hyperlinkText;
                            final /* synthetic */ HyperlinkInfo $info;
                            {
                                this.$hyperlinkText = $hyperlinkText;
                                this.$info = $info;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ConsoleMessageBuilder consoleMessageBuilder = (ConsoleMessageBuilder)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$submitMessage;
                                        ResultKt.throwOnFailure((Object)$result);
                                        ConsoleMessageBuilder.startMessage$default((ConsoleMessageBuilder)$this$submitMessage, null, null, null, 7, null);
                                        $this$submitMessage.addHyperLink(this.$hyperlinkText, this.$info);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ConsoleMessageBuilder p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this, 2, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void clear() {
        this.doClear$intellij_javascript_debugger_backend();
    }

    public final void doClear$intellij_javascript_debugger_backend() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!WebConsoleView.access$getDisposed$p(this.this$0)) {
                            WebConsoleView.access$getHistoryView$p(this.this$0).clear();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray;
        SearchAction searchAction = new SearchAction();
        searchAction.registerCustomShortcutSet(this.getComponent(), (Disposable)this);
        if (ApplicationManager.getApplication().isInternal()) {
            AnAction[] anActionArray2 = new AnAction[]{new ScrollToTheEndToolbarAction(this.historyView), new ClearAllAction(this.coroutineScope, this, this.consolePrinter), new FilterAction(), new OpenDevToolsAction()};
            anActionArray = anActionArray2;
        } else {
            AnAction[] anActionArray3 = new AnAction[]{new ScrollToTheEndToolbarAction(this.historyView), new ClearAllAction(this.coroutineScope, this, this.consolePrinter), new FilterAction()};
            anActionArray = anActionArray3;
        }
        return anActionArray;
    }

    @Nullable
    public final Component getHeaderComponent$intellij_javascript_debugger_backend() {
        return this.headerComponent;
    }

    public final void setHeaderComponent$intellij_javascript_debugger_backend(@Nullable Component header) {
        if (this.headerComponent != null) {
            this.remove(this.headerComponent);
        }
        if (header != null) {
            this.add(header, "North");
        }
        this.revalidate();
        this.repaint();
        this.headerComponent = header;
    }

    public final void searchSessionStopped$intellij_javascript_debugger_backend() {
        this.searchSession = null;
    }

    private final void showFiltersPopup() {
        WebConsoleFilterForm filterForm = new WebConsoleFilterForm();
        filterForm.reset$intellij_javascript_debugger_backend(this.settings);
        filterForm.addListener(new WebConsoleFilterForm.FilterListener(this, filterForm){
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ WebConsoleFilterForm $filterForm;
            {
                this.this$0 = $receiver;
                this.$filterForm = $filterForm;
            }

            public void filtersChanged() {
                WebConsoleView.access$getHistoryView$p(this.this$0).updateFromFilterSettingsUI(this.$filterForm);
            }

            public void filtersResetRequested() {
                WebConsoleView.access$getHistoryView$p(this.this$0).resetAllFilters();
                this.$filterForm.reset$intellij_javascript_debugger_backend(WebConsoleView.access$getSettings$p(this.this$0));
            }
        });
        String string = JSDebuggerBundle.message("js.console.filter.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.createAndShowPopup(string, (JPanel)filterForm.getMainPanel());
    }

    private final void createAndShowPopup(@NlsContexts.PopupTitle String title, JPanel jPanel) {
        Rectangle visibleRect = this.getComponent().getVisibleRect();
        Point topLeft = new Point(this.getComponent().getLocationOnScreen().x + visibleRect.x, this.getComponent().getLocationOnScreen().y + visibleRect.y);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jPanel, null).setProject(this.getProject()).setTitle(title).setMovable(true).setRequestFocus(true).createPopup().show(RelativePoint.fromScreen((Point)topLeft));
    }

    public final void setDOMViewHandler(@NotNull DOMPresentationProvider domPresentationProvider) {
        Intrinsics.checkNotNullParameter((Object)domPresentationProvider, (String)"domPresentationProvider");
        this.domPresentationProvider = domPresentationProvider;
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent = this.consoleExecutionEditor.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    public void scrollTo(int offset) {
        throw new UnsupportedOperationException();
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        throw new UnsupportedOperationException();
    }

    public void setOutputPaused(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
    }

    public void setHelpId(@NotNull String helpId) {
        Intrinsics.checkNotNullParameter((Object)helpId, (String)"helpId");
        throw new UnsupportedOperationException();
    }

    public void addMessageFilter(@NotNull Filter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        throw new UnsupportedOperationException();
    }

    public int getContentSize() {
        return 1;
    }

    public boolean canPause() {
        return false;
    }

    public void allowHeavyFilters() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Project getProject() {
        return this.helper.project;
    }

    @NotNull
    public String getTitle() {
        return this.helper.title;
    }

    public void setTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.helper.title = value;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.consoleExecutionEditor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return virtualFile;
    }

    @Nullable
    public PsiFile getFile() {
        return this.helper.getFileSafe();
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.consoleExecutionEditor.getCurrentEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getCurrentEditor(...)");
        return editorEx;
    }

    @NotNull
    public EditorEx getConsoleEditor() {
        EditorEx editorEx = this.consoleExecutionEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        return editorEx;
    }

    @NotNull
    public Document getEditorDocument() {
        Document document = this.consoleExecutionEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    @NotNull
    public EditorEx getHistoryViewer() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Language getLanguage() {
        PsiFile psiFile = this.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return language;
    }

    public void setLanguage(@NotNull Language value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.helper.setLanguage(value);
    }

    @Nullable
    public String getPrompt() {
        return this.consoleExecutionEditor.getPrompt();
    }

    public void setPrompt(@Nullable String value) {
        this.consoleExecutionEditor.setPrompt(value);
    }

    @NotNull
    public ConsoleViewContentType getPromptAttributes() {
        ConsoleViewContentType consoleViewContentType = this.consoleExecutionEditor.getPromptAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getPromptAttributes(...)");
        return consoleViewContentType;
    }

    public void setPromptAttributes(@NotNull ConsoleViewContentType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.consoleExecutionEditor.setPromptAttributes(value);
    }

    public void setInputText(@NotNull String inputText) {
        Intrinsics.checkNotNullParameter((Object)inputText, (String)"inputText");
        DocumentUtil.writeInRunUndoTransparentAction(() -> WebConsoleView.setInputText$lambda$0(this, inputText));
    }

    public boolean isEditable() {
        return this.consoleExecutionEditor.isEditable();
    }

    public void setEditable(boolean value) {
        this.consoleExecutionEditor.setEditable(value);
    }

    public boolean isConsoleEditorEnabled() {
        return this.executionPanel.isVisible();
    }

    public void setConsoleEditorEnabled(boolean value) {
        if (this.isConsoleEditorEnabled() == value) {
            return;
        }
        if (value) {
            FileEditorManager.getInstance((Project)this.helper.project).closeFile(this.helper.virtualFile);
        }
        this.executionPanel.setVisible(value);
    }

    private static final void _init_$lambda$0(WebConsoleView this$0, IconHolder $iconHolder, EditorColorsScheme newScheme) {
        EditorColorsScheme editorColorsScheme = newScheme;
        if (editorColorsScheme == null) {
            EditorColorsScheme editorColorsScheme2 = EditorColorsManager.getInstance().getGlobalScheme();
            editorColorsScheme = editorColorsScheme2;
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"getGlobalScheme(...)");
        }
        EditorColorsScheme scheme = editorColorsScheme;
        this$0.setBackground(scheme.getDefaultBackground());
        $iconHolder.updateScheme(scheme);
        this$0.executionPanel.setBorder((Border)new CustomLineBorder((Color)this$0.getBorderColor(), 1, 0, 0, 0));
    }

    private static final void printInputFromExecutionEditor$lambda$0(EditorEx $editor, DocumentEx $document) {
        $editor.getDocument().deleteString(0, $document.getTextLength());
    }

    private static final void setInputText$lambda$0(WebConsoleView this$0, String $inputText) {
        this$0.consoleExecutionEditor.getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)$inputText));
    }

    public static final /* synthetic */ ConsolePrinter access$getConsolePrinter$p(WebConsoleView $this) {
        return $this.consolePrinter;
    }

    public static final /* synthetic */ JavaScriptDebugProcess access$getDebugProcess$p(WebConsoleView $this) {
        return $this.debugProcess;
    }

    public static final /* synthetic */ boolean access$getDisposed$p(WebConsoleView $this) {
        return $this.disposed;
    }

    public static final /* synthetic */ ConsoleExecutionEditor access$getConsoleExecutionEditor$p(WebConsoleView $this) {
        return $this.consoleExecutionEditor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$ClearAllAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "consolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/execution/console/LanguageConsoleView;Lcom/intellij/javascript/debugger/console/ConsolePrinter;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.javascript.debugger.backend"})
    private static final class ClearAllAction
    extends DumbAwareAction {
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private final LanguageConsoleView consoleView;
        @NotNull
        private final ConsolePrinter consolePrinter;

        public ClearAllAction(@NotNull CoroutineScope coroutineScope, @NotNull LanguageConsoleView consoleView, @NotNull ConsolePrinter consolePrinter) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
            Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"clear.all.from.console.action.description", (Object[])new Object[0]), AllIcons.Actions.GC);
            this.coroutineScope = coroutineScope;
            this.consoleView = consoleView;
            this.consolePrinter = consolePrinter;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(this.consoleView.getContentSize() > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ClearAllAction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = ClearAllAction.access$getConsolePrinter$p(this.this$0).clear((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ ConsolePrinter access$getConsolePrinter$p(ClearAllAction $this) {
            return $this.consolePrinter;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H&J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\t\u001a\u00020\u0004H&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0004H&J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "", "getNodePresentation", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/navigation/ItemPresentation;", "v", "Lorg/jetbrains/debugger/values/Value;", "hasChildren", "", "node", "getChildren", "", "highlight", "", "hideHighlight", "intellij.javascript.debugger.backend"})
    public static interface DOMPresentationProvider {
        @NotNull
        public Promise<ItemPresentation> getNodePresentation(@NotNull Value var1);

        public boolean hasChildren(@NotNull ItemPresentation var1);

        @NotNull
        public List<ItemPresentation> getChildren(@NotNull ItemPresentation var1);

        public void highlight(@NotNull ItemPresentation var1);

        public void hideHighlight(@NotNull ItemPresentation var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$FilterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "<init>", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.javascript.debugger.backend"})
    private final class FilterAction
    extends DumbAwareAction
    implements Toggleable {
        public FilterAction() {
            super(JSDebuggerBundle.message("js.console.filter.popup", new Object[0]), null, AllIcons.General.Filter);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)WebConsoleView.this.settings.areFiltersApplied());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WebConsoleView.this.showFiltersPopup();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$IconHolder;", "Ljavax/swing/JComponent;", "icon", "Ljavax/swing/Icon;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Ljavax/swing/Icon;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "getIcon", "()Ljavax/swing/Icon;", "getScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "setScheme", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "scaledIcon", "updateScheme", "", "colorsScheme", "scaleIcon", "paint", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "getLineHeight", "", "getFontMetrics", "Ljava/awt/FontMetrics;", "intellij.javascript.debugger.backend"})
    private static final class IconHolder
    extends JComponent {
        @NotNull
        private final Icon icon;
        @NotNull
        private EditorColorsScheme scheme;
        @NotNull
        private Icon scaledIcon;

        public IconHolder(@NotNull Icon icon, @NotNull EditorColorsScheme scheme) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            this.icon = icon;
            this.scheme = scheme;
            this.scaledIcon = this.scaleIcon(this.scheme);
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final EditorColorsScheme getScheme() {
            return this.scheme;
        }

        public final void setScheme(@NotNull EditorColorsScheme editorColorsScheme) {
            Intrinsics.checkNotNullParameter((Object)editorColorsScheme, (String)"<set-?>");
            this.scheme = editorColorsScheme;
        }

        public final void updateScheme(@NotNull EditorColorsScheme colorsScheme) {
            Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
            this.scheme = colorsScheme;
            this.scaledIcon = this.scaleIcon(colorsScheme);
        }

        private final Icon scaleIcon(EditorColorsScheme colorsScheme) {
            return IconUtil.scaleByFont((Icon)this.icon, (Component)this, (float)colorsScheme.getConsoleFontSize());
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Rectangle clip = g.getClipBounds();
            g.setColor(this.scheme.getDefaultBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            this.scaledIcon.paintIcon(null, g, 0, this.getLineHeight() / 2 - this.scaledIcon.getIconHeight() / 2);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(this.scaledIcon.getIconWidth(), this.getLineHeight());
        }

        private final int getLineHeight() {
            FontMetrics fontMetrics = this.getFontMetrics();
            return (int)((float)fontMetrics.getHeight() * this.scheme.getConsoleLineSpacing());
        }

        @NotNull
        public final FontMetrics getFontMetrics() {
            Font font = this.scheme.getFont(EditorFontType.CONSOLE_PLAIN);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font schemeFont = font;
            FontMetrics fontMetrics = this.getFontMetrics(schemeFont);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            return fontMetrics;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$OpenDevToolsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javascript.debugger.backend"})
    private final class OpenDevToolsAction
    extends AnAction {
        public OpenDevToolsAction() {
            this.getTemplatePresentation().setText(JSDebuggerBundle.message("action.JavaScriptDebugger.OpenDevTools.text", new Object[0]));
            this.getTemplatePresentation().setDescription(JSDebuggerBundle.message("action.JavaScriptDebugger.OpenDevTools.description", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Toolwindows.ToolWindowDebugger);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WebConsoleView.this.historyView.openDevtools();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$ScrollToTheEndToolbarAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "historyViewNavigator", "Lcom/intellij/javascript/debugger/console/HistoryViewNavigator;", "<init>", "(Lcom/intellij/javascript/debugger/console/HistoryViewNavigator;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.javascript.debugger.backend"})
    private static final class ScrollToTheEndToolbarAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final HistoryViewNavigator historyViewNavigator;

        public ScrollToTheEndToolbarAction(@NotNull HistoryViewNavigator historyViewNavigator) {
            Intrinsics.checkNotNullParameter((Object)historyViewNavigator, (String)"historyViewNavigator");
            this.historyViewNavigator = historyViewNavigator;
            String message = ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]);
            this.getTemplatePresentation().setDescription(message);
            this.getTemplatePresentation().setText(message);
            this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.historyViewNavigator.isStickToEnd();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.historyViewNavigator.setStickToEnd(state);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$SearchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javascript.debugger.backend"})
    private final class SearchAction
    extends AnAction {
        public SearchAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Find");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (WebConsoleView.this.searchSession == null) {
                WebConsoleView.this.searchSession = new WebConsoleSearchSession(WebConsoleView.this.coroutineScope, WebConsoleView.this, WebConsoleView.this.historyView, WebConsoleView.this.getProject());
            }
        }
    }
}

