/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssConstants;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypeEvaluationUtils;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtilCore;
import com.intellij.psi.css.impl.util.table.CssVendorSpecificPropertyUtil;
import com.intellij.psi.css.util.CssTermTypeUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFunctionImpl
extends CssElementImpl
implements CssFunction {
    private static final Map<String, CssTermType> typeOfStringMap = Map.of("%", CssTermTypes.PERCENTAGE, "string", CssTermTypes.STRING, "number", CssTermTypes.NUMBER, "integer", CssTermTypes.INTEGER, "length", CssTermTypes.LENGTH, "angle", CssTermTypes.ANGLE, "time", CssTermTypes.TIME, "frequency", CssTermTypes.FREQUENCY, "color", CssTermTypes.COLOR, "url", CssTermTypes.URI);

    CssFunctionImpl() {
        super(CssElementTypes.CSS_FUNCTION);
    }

    @NotNull
    public String getName() {
        PsiElement functionNameElement = this.getFunctionNameElement();
        return functionNameElement != null ? functionNameElement.getText() : "";
    }

    @Nullable
    public PsiElement getFunctionNameElement() {
        return this.getToken(CssElementTypes.CSS_FUNCTION_TOKEN);
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            CssFunctionImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssFunctionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssFunction(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public CssTermList getValue() {
        return this.getChildOfType(CssTermList.class);
    }

    @NotNull
    public TextRange getTrimmedValueTextRange() {
        PsiElement lParenthesis = this.getLParenthesis();
        CssTermList termList = this.getValue();
        if (termList != null) {
            TextRange textRange = termList.getTextRange();
            if (textRange == null) {
                CssFunctionImpl.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        int startOffset = lParenthesis != null ? lParenthesis.getTextRange().getStartOffset() : 0;
        PsiElement rParenthesis = this.getRParenthesis();
        int endOffset = rParenthesis != null ? rParenthesis.getTextRange().getEndOffset() : startOffset;
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            CssFunctionImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public TextRange getValueTextRange() {
        PsiElement lParenthesis = this.getLParenthesis();
        int startOffset = lParenthesis != null ? lParenthesis.getTextRange().getEndOffset() : 0;
        CssTermList termList = this.getValue();
        PsiElement rParenthesis = this.getRParenthesis();
        int endOffset = rParenthesis != null ? rParenthesis.getTextRange().getEndOffset() : (termList != null ? termList.getTextRange().getEndOffset() : startOffset);
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            CssFunctionImpl.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Nullable
    public PsiElement getLParenthesis() {
        PsiElement functionNameElement = this.getFunctionNameElement();
        if (functionNameElement == null) {
            return null;
        }
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)functionNameElement);
        return nextVisibleLeaf != null && nextVisibleLeaf.getNode().getElementType() == CssElementTypes.CSS_LPAREN ? nextVisibleLeaf : null;
    }

    @Nullable
    public PsiElement getRParenthesis() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RPAREN) {
            return lastChild;
        }
        return null;
    }

    @NotNull
    public CssTermType getType() {
        CssFunctionDescriptor descriptor;
        CssTermList termList;
        String name = CssVendorSpecificPropertyUtil.getElementNameWithoutVendorPrefix(this.getName());
        String lowercaseName = StringUtil.toLowerCase((String)name);
        if ("env".equals(lowercaseName)) {
            CssTermType cssTermType = CssTermType.AS_NEEDED;
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(5);
            }
            return cssTermType;
        }
        if (CssConstants.TRIG_FUNCTIONS.contains(lowercaseName)) {
            CssTermType cssTermType = CssTermTypes.NUMBER;
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(6);
            }
            return cssTermType;
        }
        if (CssConstants.REVERSE_TRIG_FUNCTIONS.contains(lowercaseName)) {
            CssTermType cssTermType = CssTermTypes.ANGLE;
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(7);
            }
            return cssTermType;
        }
        if ("round".equals(lowercaseName) && (termList = this.getValue()) != null) {
            CssTerm[] terms = termList.getTerms();
            if (termList.getFirstChild() instanceof CssTermList) {
                terms = ((CssTermList)termList.getFirstChild()).getTerms();
            }
            if (terms.length >= 2) {
                terms = (CssTerm[])Arrays.stream(terms).filter(term -> term.getTermType() != CssTermTypes.IDENT).toArray(CssTerm[]::new);
            }
            CssTermType cssTermType = CssTermTypeEvaluationUtils.getCommonTypeForTermList(terms);
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(8);
            }
            return cssTermType;
        }
        if (("mod".equals(lowercaseName) || "rem".equals(lowercaseName)) && (termList = this.getValue()) != null) {
            CssTerm[] terms = termList.getTerms();
            CssTermType cssTermType = CssTermTypeEvaluationUtils.getCommonTypeForTermList(terms);
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(9);
            }
            return cssTermType;
        }
        if (CssConstants.MATH_FUNCTIONS.contains(lowercaseName)) {
            termList = this.getValue();
            if (termList != null) {
                CssTerm firstTerm;
                PsiElement firstChild = termList.getFirstChild();
                if (firstChild instanceof CssTermList) {
                    termList = (CssTermList)firstChild;
                }
                if ((firstTerm = (CssTerm)ArrayUtil.getFirstElement((Object[])termList.getTerms())) != null) {
                    CssTermType cssTermType = firstTerm.getTermType();
                    if (cssTermType == null) {
                        CssFunctionImpl.$$$reportNull$$$0(10);
                    }
                    return cssTermType;
                }
            }
        } else if ("attr".equals(lowercaseName) && (termList = this.getValue()) != null) {
            CssTerm[] terms = termList.getTerms();
            if (terms.length > 1) {
                CssTerm firstTerm = terms[0];
                PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstTerm);
                CssTerm secondTerm = terms[1];
                if (nextVisibleLeaf != null) {
                    if (nextVisibleLeaf.getNode().getElementType() == CssElementTypes.CSS_COMMA) {
                        CssTermType cssTermType = secondTerm.getTermType();
                        if (cssTermType == null) {
                            CssFunctionImpl.$$$reportNull$$$0(11);
                        }
                        return cssTermType;
                    }
                    String typeOfUnit = StringUtil.toLowerCase((String)secondTerm.getText().trim());
                    CssTermType cssTermType = typeOfStringMap.containsKey(typeOfUnit) ? typeOfStringMap.get(typeOfUnit) : CssTermTypeUtil.getTypeBySuffix(typeOfUnit);
                    if (cssTermType == null) {
                        CssFunctionImpl.$$$reportNull$$$0(12);
                    }
                    return cssTermType;
                }
            }
            CssTermType cssTermType = CssTermTypes.STRING;
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(13);
            }
            return cssTermType;
        }
        if ((descriptor = (CssFunctionDescriptor)ContainerUtil.getFirstItem(CssDescriptorsUtilCore.getFunctionDescriptors(name, (PsiElement)this))) != null) {
            CssTermType cssTermType = descriptor.getType();
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(14);
            }
            return cssTermType;
        }
        CssTermType cssTermType = CssTermType.UNKNOWN;
        if (cssTermType == null) {
            CssFunctionImpl.$$$reportNull$$$0(15);
        }
        return cssTermType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssFunctionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssFunctionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedValueTextRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

