/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.visitor;

import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssParameterInfoValueDescriptorsVisitor
extends CssValueDescriptorVisitorImpl {
    @NotNull
    private final StringBuilder myParameterInfoBuilder = new StringBuilder();
    private final HashSet<CssValueDescriptor> myHighlightingDescriptors = new HashSet();
    private final boolean myEscapeXml;
    private final boolean myAddLinksForReferenceValues;
    private int myHighlightingStart = -1;
    private int myHighlightingEnd = -1;

    public CssParameterInfoValueDescriptorsVisitor(@Nullable CssValueDescriptor highlightingDescriptor, boolean escapeXml, boolean addLinksForReferenceValues) {
        this.myEscapeXml = escapeXml;
        this.myAddLinksForReferenceValues = addLinksForReferenceValues;
        for (highlightingDescriptor = CssParameterInfoValueDescriptorsVisitor.adjustHighlightingDescriptor(highlightingDescriptor); highlightingDescriptor != null; highlightingDescriptor = highlightingDescriptor.getParent()) {
            this.myHighlightingDescriptors.add(highlightingDescriptor);
        }
    }

    @NotNull
    public String getParameterInfo() {
        String string = this.myParameterInfoBuilder.toString();
        if (string == null) {
            CssParameterInfoValueDescriptorsVisitor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int getHighlightingStart() {
        return this.myHighlightingStart;
    }

    public int getHighlightingEnd() {
        return this.myHighlightingEnd;
    }

    @Override
    public void visitGroupValue(@NotNull CssGroupValue groupValue) {
        String presentableName;
        if (groupValue == null) {
            CssParameterInfoValueDescriptorsVisitor.$$$reportNull$$$0(1);
        }
        if (this.isHighlightingDescriptor(groupValue)) {
            this.updateHighlightingStart();
        }
        if ((presentableName = groupValue.getPresentableName()).isEmpty()) {
            CssValueDescriptor separator;
            String separatorString;
            boolean withBrackets;
            Collection<CssValueDescriptor> children = groupValue.getChildren();
            Iterator<CssValueDescriptor> childrenIterator = children.iterator();
            CssValueDescriptor parent = groupValue.getParent();
            CssGroupValue.Type groupValueType = groupValue.getType();
            boolean bl = withBrackets = parent != null && children.size() > 1 && (groupValueType != CssGroupValue.Type.ALL || groupValue.getMinOccur() < 1 || groupValue.getMaxOccur() < 1) || groupValue.isCommaSeparated();
            if (withBrackets) {
                this.append("[");
            }
            String string = separatorString = (separator = groupValue.getValuesSeparator()) != null ? separator.getPresentableName() : CssParameterInfoValueDescriptorsVisitor.getDefaultGroupSeparator(groupValueType);
            while (childrenIterator.hasNext()) {
                childrenIterator.next().accept((CssValueDescriptorVisitor)this);
                if (!childrenIterator.hasNext()) continue;
                this.append(separatorString);
            }
            if (withBrackets) {
                this.append("]");
            }
        } else {
            this.append(presentableName);
        }
        this.addExtraQualifiers(groupValue);
        if (this.isHighlightingDescriptor(groupValue)) {
            this.updateHighlightingEnd();
        }
    }

    @Override
    public void visitFunctionValue(@NotNull CssFunctionInvocationValue functionValue) {
        if (functionValue == null) {
            CssParameterInfoValueDescriptorsVisitor.$$$reportNull$$$0(2);
        }
        if (this.myAddLinksForReferenceValues && !"url".equals(functionValue.getFunctionName())) {
            this.myParameterInfoBuilder.append("<a href=\"psi_element://F:").append(functionValue.getId()).append("\">");
            super.visitFunctionValue(functionValue);
            this.myParameterInfoBuilder.append("</a>");
        } else {
            super.visitFunctionValue(functionValue);
        }
    }

    @Override
    public void visitPropertyReferenceValue(@NotNull CssPropertyReferenceValue propertyReferenceValue) {
        if (propertyReferenceValue == null) {
            CssParameterInfoValueDescriptorsVisitor.$$$reportNull$$$0(3);
        }
        if (this.myAddLinksForReferenceValues) {
            this.myParameterInfoBuilder.append("<a href=\"psi_element://P:").append(propertyReferenceValue.getId()).append("\">");
            super.visitPropertyReferenceValue(propertyReferenceValue);
            this.myParameterInfoBuilder.append("</a>");
        } else {
            super.visitPropertyReferenceValue(propertyReferenceValue);
        }
    }

    @Override
    public void visitValue(@NotNull CssValueDescriptor value) {
        if (value == null) {
            CssParameterInfoValueDescriptorsVisitor.$$$reportNull$$$0(4);
        }
        if (this.isHighlightingDescriptor(value)) {
            this.updateHighlightingStart();
        }
        this.append(value.getPresentableName());
        this.addExtraQualifiers(value);
        if (this.isHighlightingDescriptor(value)) {
            this.updateHighlightingEnd();
        }
    }

    private void updateHighlightingStart() {
        if (this.myHighlightingStart < 0 || this.myHighlightingStart < this.myParameterInfoBuilder.length()) {
            this.myHighlightingStart = this.myParameterInfoBuilder.length();
        }
    }

    private void updateHighlightingEnd() {
        if (this.myHighlightingEnd < 0 || this.myHighlightingEnd > this.myParameterInfoBuilder.length()) {
            this.myHighlightingEnd = this.myParameterInfoBuilder.length();
        }
    }

    private boolean isHighlightingDescriptor(CssValueDescriptor value) {
        return ContainerUtil.containsIdentity(this.myHighlightingDescriptors, (Object)value);
    }

    private static String getDefaultGroupSeparator(CssGroupValue.Type groupValueType) {
        if (groupValueType == CssGroupValue.Type.OR) {
            return " | ";
        }
        if (groupValueType == CssGroupValue.Type.ANY) {
            return " || ";
        }
        if (groupValueType == CssGroupValue.Type.AND) {
            return " && ";
        }
        return " ";
    }

    private void addExtraQualifiers(@NotNull CssValueDescriptor value) {
        if (value == null) {
            CssParameterInfoValueDescriptorsVisitor.$$$reportNull$$$0(5);
        }
        int minOccur = value.getMinOccur();
        int maxOccur = value.getMaxOccur();
        if (value.isCommaSeparated()) {
            this.append("#");
        } else if (maxOccur < 1 && minOccur < 1) {
            this.append("*");
        } else if (minOccur == maxOccur && minOccur > 1) {
            this.append("{").append(minOccur).append("}");
        } else if (maxOccur > 1 && minOccur > 0) {
            this.append("{").append(minOccur).append(",").append(maxOccur).append("}");
        } else if (maxOccur < 1) {
            this.append("+");
        } else if (minOccur < 1) {
            this.append("?");
        }
    }

    private StringBuilder append(@NotNull String string) {
        if (string == null) {
            CssParameterInfoValueDescriptorsVisitor.$$$reportNull$$$0(6);
        }
        return this.myParameterInfoBuilder.append(this.myEscapeXml ? XmlStringUtil.escapeString((String)string) : string);
    }

    @Nullable
    private static CssValueDescriptor adjustHighlightingDescriptor(@Nullable CssValueDescriptor descriptor) {
        CssValueDescriptor firstChild;
        CssGroupValue.Type type;
        if (descriptor == null) {
            return null;
        }
        CssValueDescriptor parent = descriptor.getParent();
        while (parent instanceof CssGroupValue && parent.getParent() != null && ((type = ((CssGroupValue)parent).getType()) != CssGroupValue.Type.ALL || (firstChild = (CssValueDescriptor)ContainerUtil.getFirstItem(((CssGroupValue)parent).getChildren())) == descriptor)) {
            descriptor = parent;
            parent = parent.getParent();
        }
        return descriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyReferenceValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitGroupValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitFunctionValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPropertyReferenceValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addExtraQualifiers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

