/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigUtil;
import com.intellij.lang.javascript.flow.flowconfig.FlowModuleMapping;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlowJSConfigImpl
extends UserDataHolderBase
implements FlowJSConfig {
    @NotNull
    private static final Set<String> TAGS = ContainerUtil.newHashSet((Object[])new String[]{"ignore", "include", "version", "options", "libs"});
    private final boolean myIsProjectConfig;
    @NotNull
    private final VirtualFile myConfigDir;
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Collection<String> myIncludedPatterns;
    @NotNull
    private final Collection<String> myIgnoredPatterns;
    @Nullable
    private final FlowModuleMapping myModuleMapping;
    private final NullableLazyValue<PathMatcher> myIncludedRegPattern;
    private final NullableLazyValue<PathMatcher> myIgnoredRegPattern;

    @Nullable
    public static FlowJSConfig getConfig(@NotNull PsiFile psiFile, boolean isProject) {
        if (psiFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile configFile = psiFile.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDir = configFile.getParent();
        if (configDir == null) {
            return null;
        }
        return new FlowJSConfigImpl(configFile, configDir, isProject);
    }

    @NotNull
    private Collection<String> getIgnoredPatterns() {
        return this.getTagOptions("ignore");
    }

    @NotNull
    private Collection<String> getIncludedPatterns() {
        return this.getTagOptions("include");
    }

    private static boolean isCommentLine(@NotNull String line) {
        if (line == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(1);
        }
        boolean isComment = false;
        String lineWithoutWhiteSpaces = line.trim();
        if (lineWithoutWhiteSpaces.charAt(0) == '#') {
            isComment = true;
        }
        return isComment;
    }

    @NotNull
    private static ArrayList<String> removeEmptyLines(String @NotNull [] stringArray) {
        if (stringArray == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(2);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : stringArray) {
            String newLine = line.trim();
            if (newLine.isEmpty()) continue;
            result.add(newLine);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private Collection<String> getTagOptions(@NotNull String requiredTag) {
        if (requiredTag == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(4);
        }
        Document configDocument = FileDocumentManager.getInstance().getDocument(this.myConfigFile);
        HashSet<String> stopTags = new HashSet<String>();
        stopTags.addAll(TAGS);
        stopTags.remove(requiredTag);
        ArrayList<String> collection = new ArrayList<String>();
        if (configDocument == null) {
            ArrayList<String> arrayList = collection;
            if (arrayList == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        if (configDocument.getLineCount() <= 0) {
            ArrayList<String> arrayList = collection;
            if (arrayList == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        String text = configDocument.getText();
        boolean isStart = false;
        String[] textLines = text.split("\n");
        ArrayList<String> textWithoutEmptyLines = FlowJSConfigImpl.removeEmptyLines(textLines);
        String tagLine = "[" + requiredTag + "]";
        for (String line : textWithoutEmptyLines) {
            if (!isStart) {
                if (!line.contains(tagLine)) continue;
                isStart = true;
                continue;
            }
            boolean isAnotherTag = false;
            for (String tag : stopTags) {
                if (!line.contains("[" + tag + "]")) continue;
                isAnotherTag = true;
                break;
            }
            if (isAnotherTag) break;
            if (FlowJSConfigImpl.isCommentLine(line)) continue;
            collection.add(line);
        }
        ArrayList<String> arrayList = collection;
        if (arrayList == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static Pattern createPattern(@Nullable String pattern) {
        if (pattern == null) {
            return null;
        }
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            Logger.getInstance(FlowJSConfigImpl.class).warn("Bad pattern in .flowconfig: " + pattern);
            return null;
        }
    }

    private FlowJSConfigImpl(@NotNull VirtualFile configFile, @NotNull VirtualFile configDir, boolean isProjectConfig) {
        if (configFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(8);
        }
        if (configDir == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(9);
        }
        this.myIncludedRegPattern = new NullableLazyValue<PathMatcher>(){

            @Nullable
            protected PathMatcher compute() {
                if (FlowJSConfigImpl.this.myIncludedPatterns.isEmpty()) {
                    return null;
                }
                return FlowJSConfigUtil.getRegularExpressionForGlobPattern(FlowJSConfigImpl.this.myIncludedPatterns, FlowJSConfigImpl.this.myConfigDir);
            }
        };
        this.myIgnoredRegPattern = new NullableLazyValue<PathMatcher>(){

            @Nullable
            protected PathMatcher compute() {
                if (FlowJSConfigImpl.this.myIgnoredPatterns.isEmpty()) {
                    return null;
                }
                String pattern = FlowJSConfigUtil.getRegularExpression(FlowJSConfigImpl.this.myIgnoredPatterns, FlowJSConfigImpl.this.myConfigDir);
                return FlowJSConfigImpl.convertToPathMatcher(FlowJSConfigImpl.createPattern(pattern));
            }
        };
        this.myConfigDir = configDir;
        this.myConfigFile = configFile;
        this.myIncludedPatterns = this.getIncludedPatterns();
        this.myIgnoredPatterns = this.getIgnoredPatterns();
        this.myIsProjectConfig = isProjectConfig;
        this.myModuleMapping = FlowModuleMapping.parse(configDir, this.getTagOptions("options"));
    }

    @Override
    public boolean isFileIncluded(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(10);
        }
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        String path = file.getCanonicalPath();
        PathMatcher pattern = (PathMatcher)this.myIncludedRegPattern.getValue();
        return VfsUtilCore.isAncestor((VirtualFile)this.getConfigDirectory(), (VirtualFile)file, (boolean)false) || pattern != null && path != null && FlowJSConfigImpl.patternMatches(path, pattern);
    }

    @Override
    public boolean isFileIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(11);
        }
        if (!file.isInLocalFileSystem()) {
            return true;
        }
        String path = file.getCanonicalPath();
        if (this.myIgnoredPatterns.isEmpty()) {
            return false;
        }
        PathMatcher pattern = (PathMatcher)this.myIgnoredRegPattern.getValue();
        if (pattern == null) {
            return false;
        }
        return path != null && FlowJSConfigImpl.patternMatches(path, pattern);
    }

    private static boolean patternMatches(@NotNull String path, @NotNull PathMatcher pattern) {
        if (path == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(12);
        }
        if (pattern == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(13);
        }
        try {
            return pattern.matches(Paths.get(path, new String[0]));
        }
        catch (Throwable t) {
            return false;
        }
    }

    @NotNull
    private MultiMap<String, VirtualFile> getModuleCache(@NotNull Project project) {
        if (project == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(14);
        }
        MultiMap multiMap = (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.buildModuleCache(project), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
        if (multiMap == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(15);
        }
        return multiMap;
    }

    @NotNull
    private MultiMap<String, VirtualFile> buildModuleCache(@NotNull Project project) {
        Condition<VirtualFile> acceptor;
        if (project == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(16);
        }
        Condition<VirtualFile> condition = acceptor = this.myModuleMapping == null ? null : this.myModuleMapping.getFileAcceptor();
        if (acceptor == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(17);
            }
            return multiMap;
        }
        GlobalSearchScope scope = this.isProjectConfig() ? GlobalSearchScope.projectScope((Project)project) : ProjectScope.getLibrariesScope((Project)project);
        DelegatingGlobalSearchScope resultScope = new DelegatingGlobalSearchScope(this, scope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return super.contains(file) && acceptor.value((Object)file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl$3", "contains"));
            }
        };
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(FlowJSConfigService.getService(project).getFiles(FlowJSFileType.INSTANCE, (GlobalSearchScope)resultScope));
        files.addAll(FlowJSConfigService.getService(project).getFiles((FileType)JavaScriptFileType.INSTANCE, (GlobalSearchScope)resultScope));
        if (files.isEmpty()) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(18);
            }
            return multiMap;
        }
        MultiMap map = MultiMap.create();
        for (VirtualFile file : files) {
            map.putValue((Object)this.myModuleMapping.reduceName(file.getName()), (Object)file);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(19);
        }
        return multiMap;
    }

    public static boolean checkPattern(@NotNull String path, @NotNull Pattern pattern) {
        if (path == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(20);
        }
        if (pattern == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(21);
        }
        Matcher m = pattern.matcher(path);
        return m.find();
    }

    @Nullable
    public static PathMatcher convertToPathMatcher(@Nullable Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        return path -> FlowJSConfigImpl.checkPattern(FileUtil.toSystemIndependentName((String)path.toString()), pattern);
    }

    @Override
    public boolean isProjectConfig() {
        return this.myIsProjectConfig;
    }

    @Override
    @Nullable
    public FlowModuleMapping getMapping() {
        return this.myModuleMapping;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> resolveModule(@NotNull Project project, @NotNull String unquotedName) {
        if (project == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(22);
        }
        if (unquotedName == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(23);
        }
        Collection collection = this.getModuleCache(project).get((Object)unquotedName);
        if (collection == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDir;
        if (virtualFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(25);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(26);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 15, 17, 18, 19, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringArray";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredTag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEmptyLines";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleCache";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModuleCache";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModule";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirectory";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCommentLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyLines";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTagOptions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFileIncluded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "patternMatches";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModuleCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildModuleCache";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkPattern";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 15, 17, 18, 19, 24, 25, 26 -> new IllegalStateException(string);
        };
    }
}

