/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.javascript.JavaScriptReferenceSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSElementTypesImpl;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSNamedObjectStub;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSDestructuringPropertyBase<T extends JSDestructuringProperty, StubT extends JSNamedObjectStub<T>>
extends JSStubElementImpl<StubT>
implements JSDestructuringProperty {
    private static final TokenSet PROPERTY_NAME_SEARCH_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.PROPERTY_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COLON}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DOT_DOT_DOT})});

    protected JSDestructuringPropertyBase(ASTNode node) {
        super(node);
    }

    protected JSDestructuringPropertyBase(StubT t, IElementType type) {
        super(t, type);
    }

    @Override
    @Nullable
    public ES6ComputedName getComputedPropertyName() {
        return this.getStubOrPsiChild(JSElementTypesImpl.COMPUTED_NAME);
    }

    @Nullable
    public JSDestructuringPropertyReference getReference() {
        return (JSDestructuringPropertyReference)((Object)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)((Object)this.calcReference()), (Object[])new Object[]{this})));
    }

    @Nullable
    private JSDestructuringPropertyReference calcReference() {
        return ((JavaScriptReferenceSupport)ApplicationManager.getApplication().getService(JavaScriptReferenceSupport.class)).getReference(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDestructuringPropertyBase.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringProperty(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @Nullable
    public JSInitializerOwner getDestructuringElement() {
        return (JSInitializerOwner)JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS);
    }

    @Override
    public boolean isRest() {
        ASTNode childNode = this.getNode().getFirstChildNode();
        return childNode != null && childNode.getElementType() == JSTokenTypes.DOT_DOT_DOT;
    }

    public static ASTNode getDestructuringElement(@NotNull ASTNode destructuringProperty) {
        if (destructuringProperty == null) {
            JSDestructuringPropertyBase.$$$reportNull$$$0(1);
        }
        return destructuringProperty.findChildByType(JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS);
    }

    @Override
    public String getName() {
        JSNamedObjectStub stub = (JSNamedObjectStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = this.getNameTextImpl();
        if (name != null) {
            return StringUtil.unquoteString((String)name);
        }
        return JSPsiImplUtils.getValidNameFromComputedName(this.getComputedPropertyName());
    }

    @Nullable
    protected PsiElement getNameIdentifierForPropertyOrNestedElement() {
        PsiElement identifierName = this.findChildByType(PROPERTY_NAME_SEARCH_SET);
        if (identifierName != null) {
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)identifierName);
            if (elementType == JSTokenTypes.COLON) {
                return null;
            }
            if (elementType == JSTokenTypes.DOT_DOT_DOT) {
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)identifierName);
                if (JSKeywordSets.PROPERTY_NAMES.contains(PsiUtilCore.getElementType((PsiElement)next))) {
                    return next;
                }
                if (next instanceof PsiNameIdentifierOwner) {
                    return ((PsiNameIdentifierOwner)next).getNameIdentifier();
                }
            }
            return identifierName;
        }
        return null;
    }

    @Nullable
    protected abstract String getNameTextImpl();

    public void delete() throws IncorrectOperationException {
        JSDestructuringObject objectPattern = (JSDestructuringObject)ObjectUtils.tryCast((Object)this.getParent(), JSDestructuringObject.class);
        if (objectPattern == null) {
            super.delete();
            return;
        }
        if (objectPattern.getProperties().length == 1) {
            objectPattern.getParent().delete();
        } else {
            JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)this, (PsiElement[])objectPattern.getProperties());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringProperty";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDestructuringElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

