/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerConcurrentMap;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookIntervalPointersEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003*\u0001\u000f\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u00150\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\fH\u0086\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010!\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010$\u001a\u00020\u0017J\u0014\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0(J\b\u0010)\u001a\u00020\u0017H\u0016J\b\u0010*\u001a\u00020&H\u0016R4\u0010\t\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0000 \r*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006+"}, d2={"Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;", "Value", "Lcom/intellij/openapi/util/CheckedDisposable;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/util/messages/MessageBus;Lcom/intellij/openapi/Disposable;)V", "mapReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "kotlin.jvm.PlatformType", "factoryListener", "com/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap$factoryListener$1", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap$factoryListener$1;", "getAllIntervals", "", "getAll", "", "Lkotlin/Pair;", "removePointers", "", "removed", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointersEvent$OnRemoved;", "get", "cellPointer", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;)Ljava/lang/Object;", "cellOrdinal", "", "(I)Ljava/lang/Object;", "set", "value", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Ljava/lang/Object;)V", "remove", "clear", "removeAll", "", "cellPointers", "", "dispose", "isDisposed", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookIntervalPointerConcurrentMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookIntervalPointerConcurrentMap.kt\ncom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class NotebookIntervalPointerConcurrentMap<Value>
implements CheckedDisposable {
    @NotNull
    private final AtomicReference<ConcurrentHashMap<NotebookIntervalPointer, Value>> mapReference;
    @NotNull
    private final factoryListener.1 factoryListener;

    public NotebookIntervalPointerConcurrentMap(@NotNull MessageBus messageBus, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.mapReference = new AtomicReference(new ConcurrentHashMap());
        this.factoryListener = new NotebookIntervalPointerFactory.ChangeListener(this){
            final /* synthetic */ NotebookIntervalPointerConcurrentMap<Value> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onUpdated(NotebookIntervalPointersEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                for (NotebookIntervalPointersEvent.Change change : event.getChanges()) {
                    NotebookIntervalPointersEvent.Change change2 = change;
                    if (change2 instanceof NotebookIntervalPointersEvent.OnRemoved) {
                        NotebookIntervalPointerConcurrentMap.access$removePointers(this.this$0, (NotebookIntervalPointersEvent.OnRemoved)change);
                        continue;
                    }
                    if (change2 instanceof NotebookIntervalPointersEvent.OnEdited || change2 instanceof NotebookIntervalPointersEvent.OnInserted || change2 instanceof NotebookIntervalPointersEvent.OnSwapped) continue;
                    throw new NoWhenBranchMatchedException();
                }
            }
        };
        messageBus.connect(parent).subscribe(NotebookIntervalPointerFactory.ChangeListener.Companion.getTOPIC(), (Object)this.factoryListener);
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
    }

    @NotNull
    public final Set<NotebookIntervalPointer> getAllIntervals() {
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        return concurrentHashMap != null && (concurrentHashMap = (ConcurrentHashMap.KeySetView)concurrentHashMap.keySet()) != null ? (Set)((Object)concurrentHashMap) : SetsKt.emptySet();
    }

    @NotNull
    public final List<Pair<NotebookIntervalPointer, Value>> getAll() {
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        if (concurrentHashMap == null || (concurrentHashMap = MapsKt.toList((Map)concurrentHashMap)) == null) {
            concurrentHashMap = CollectionsKt.emptyList();
        }
        return concurrentHashMap;
    }

    private final void removePointers(NotebookIntervalPointersEvent.OnRemoved removed) {
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        if (concurrentHashMap == null) {
            return;
        }
        ConcurrentHashMap<NotebookIntervalPointer, Value> map = concurrentHashMap;
        for (NotebookIntervalPointersEvent.PointerSnapshot p : removed.getSubsequentPointers()) {
            map.remove(p.getPointer());
        }
    }

    @Nullable
    public final Value get(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        return (Value)(concurrentHashMap != null ? concurrentHashMap.get(cellPointer) : null);
    }

    @Nullable
    public final Value get(int cellOrdinal) {
        Object v2;
        block2: {
            Iterable iterable = this.getAllIntervals();
            for (Object t : iterable) {
                NotebookIntervalPointer it = (NotebookIntervalPointer)t;
                boolean bl = false;
                NotebookCellLines.Interval interval = it.get();
                boolean bl2 = interval != null ? interval.getOrdinal() == cellOrdinal : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        NotebookIntervalPointer notebookIntervalPointer = v2;
        if (notebookIntervalPointer == null) {
            return null;
        }
        NotebookIntervalPointer intervalPointer = notebookIntervalPointer;
        return this.get(intervalPointer);
    }

    public final void set(@NotNull NotebookIntervalPointer cellPointer, Value value) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            if (cellPointer.get() == null) {
                return;
            }
            ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
            if (concurrentHashMap != null) {
                ((Map)concurrentHashMap).put(cellPointer, value);
            }
            if (cellPointer.get() != null) break block3;
            ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap2 = this.mapReference.get();
            if (concurrentHashMap2 != null) {
                concurrentHashMap2.remove(cellPointer);
            }
        }
    }

    @Nullable
    public final Value remove(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        return (Value)(concurrentHashMap != null ? concurrentHashMap.remove(cellPointer) : null);
    }

    public final void clear() {
        block0: {
            Serializable serializable = this.mapReference.get();
            if (serializable == null || (serializable = (ConcurrentHashMap.KeySetView)((ConcurrentHashMap)serializable).keySet()) == null) break block0;
            ((ConcurrentHashMap.CollectionView)serializable).clear();
        }
    }

    public final boolean removeAll(@NotNull Collection<? extends NotebookIntervalPointer> cellPointers) {
        Intrinsics.checkNotNullParameter(cellPointers, (String)"cellPointers");
        Serializable serializable = this.mapReference.get();
        return serializable != null && (serializable = (ConcurrentHashMap.KeySetView)((ConcurrentHashMap)serializable).keySet()) != null ? ((ConcurrentHashMap.KeySetView)serializable).removeAll((Collection)cellPointers) : false;
    }

    public void dispose() {
        this.mapReference.set(null);
    }

    public boolean isDisposed() {
        return this.mapReference.get() == null;
    }

    public static final /* synthetic */ void access$removePointers(NotebookIntervalPointerConcurrentMap $this, NotebookIntervalPointersEvent.OnRemoved removed) {
        $this.removePointers(removed);
    }
}

