/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import com.sixrr.inspectjs.utils.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public final class TrivialConditionalJSInspection
extends JavaScriptInspection {
    private static final TrivialConditionalFix TRIVIAL_CONDITIONAL_FIX = new TrivialConditionalFix();

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSConditionalExpression exp = (JSConditionalExpression)args[0];
        String string = InspectionJSBundle.message("trivial.conditional.error.string", exp.getText(), TrivialConditionalJSInspection.calculateReplacementExpression(exp));
        if (string == null) {
            TrivialConditionalJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String calculateReplacementExpression(JSConditionalExpression exp) {
        JSExpression thenExpression = (JSExpression)exp.getThenBranch();
        JSExpression elseExpression = (JSExpression)exp.getElseBranch();
        JSExpression condition = exp.getCondition();
        if (condition == null) {
            return exp.getText();
        }
        if (TrivialConditionalJSInspection.isFalse(thenExpression) && TrivialConditionalJSInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return ConditionalUtils.castToBoolean(condition);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return TRIVIAL_CONDITIONAL_FIX;
    }

    private static boolean isTrue(JSExpression expression) {
        return BoolUtils.isTrueLiteral(expression);
    }

    private static boolean isFalse(JSExpression expression) {
        return BoolUtils.isFalseLiteral(expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialConditionalJSInspection", "buildErrorString"));
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        public void visitJSConditionalExpression(@NotNull JSConditionalExpression exp) {
            if (exp == null) {
                UnnecessaryConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSConditionalExpression(exp);
            JSExpression condition = exp.getCondition();
            if (condition == null) {
                return;
            }
            JSExpression thenExpression = (JSExpression)exp.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            JSExpression elseExpression = (JSExpression)exp.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (TrivialConditionalJSInspection.isFalse(thenExpression) && TrivialConditionalJSInspection.isTrue(elseExpression) || TrivialConditionalJSInspection.isTrue(thenExpression) && TrivialConditionalJSInspection.isFalse(elseExpression)) {
                this.registerError((PsiElement)exp);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/sixrr/inspectjs/control/TrivialConditionalJSInspection$UnnecessaryConditionalExpressionVisitor", "visitJSConditionalExpression"));
        }
    }

    private static class TrivialConditionalFix
    extends InspectionJSFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                TrivialConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor.getPsiElement();
            String newExpression = TrivialConditionalJSInspection.calculateReplacementExpression(expression);
            TrivialConditionalFix.replaceExpression((JSExpression)expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialConditionalJSInspection$TrivialConditionalFix", "getFamilyName"));
        }
    }
}

