/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.codeInspection.options.CommonOptionPanes;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ConventionInspection
extends JavaScriptInspection {
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    String getRegex() {
        return this.m_regex;
    }

    int getMinLength() {
        return this.m_minLength;
    }

    int getMaxLength() {
        return this.m_maxLength;
    }

    boolean isValid(@NonNls String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (length > this.m_maxLength) {
            return false;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void readSettings(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            ConventionInspection.$$$reportNull$$$0(0);
        }
        super.readSettings(element2);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValueSet("m_regex", value -> {
            try {
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
            catch (PatternSyntaxException ignore) {
                this.m_regex = this.getDefaultRegex();
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
        });
        if (optionController == null) {
            ConventionInspection.$$$reportNull$$$0(1);
        }
        return optionController;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = CommonOptionPanes.conventions((String)"m_minLength", (String)"m_maxLength", (String)"m_regex", (OptRegularComponent[])new OptRegularComponent[0]);
        if (optPane == null) {
            ConventionInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    protected boolean isInvalidName(@NotNull PsiNameIdentifierOwner element2) {
        PsiElement identifier;
        if (element2 == null) {
            ConventionInspection.$$$reportNull$$$0(3);
        }
        if ((identifier = element2.getNameIdentifier()) == null || !PsiTreeUtil.isAncestor((PsiElement)element2, (PsiElement)identifier, (boolean)true)) {
            return false;
        }
        String name = element2.getName();
        if (name == null) {
            return false;
        }
        return !this.isValid(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/naming/ConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/naming/ConventionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

