/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.impl.util.network;

import com.intellij.openapi.diagnostic.Logger;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationCallPipeline;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.reflect.TypeInfo;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0000\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isPortAvailable", "", "port", "", "findFirstFreePort", "startingPort", "allowedHosts", "", "", "installHostValidation", "", "Lio/ktor/server/application/Application;", "isAllowedHost", "host", "isAllowedOrigin", "uri", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/mcpserver/impl/util/network/UtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n67#2,4:109\n67#2,4:113\n67#2,4:117\n57#2:121\n35#2,2:122\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/intellij/mcpserver/impl/util/network/UtilKt\n*L\n92#1:109,4\n100#1:113,4\n105#1:117,4\n15#1:121\n15#1:122,2\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<String> allowedHosts;

    public static final boolean isPortAvailable(int port) {
        boolean bl;
        try {
            new ServerSocket(port, 0, InetAddress.getLoopbackAddress()).close();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static final int findFirstFreePort(int startingPort) {
        int port = startingPort;
        while (!UtilKt.isPortAvailable(port)) {
            if (++port <= 65535) continue;
            throw new IllegalStateException("No free ports available");
        }
        return port;
    }

    public static final void installHostValidation(@NotNull Application $this$installHostValidation) {
        Intrinsics.checkNotNullParameter((Object)$this$installHostValidation, (String)"<this>");
        $this$installHostValidation.intercept(ApplicationCallPipeline.ApplicationPhase.getSetup(), (Function3)new Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object>(null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block18: {
                    block17: {
                        var2_2 = (PipelineContext)this.L$0;
                        var20_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $this$call$iv = $this$intercept;
                                $i$f$getCall = false;
                                hostHeader = ApplicationRequestPropertiesKt.host((ApplicationRequest)((ApplicationRequest)((PipelineCall)$this$call$iv.getContext()).getRequest()));
                                $this$call$iv = $this$intercept;
                                $i$f$getCall = false;
                                origin = ((PipelineCall)$this$call$iv.getContext()).getRequest().getHeaders().get("Origin");
                                $this$call$iv = $this$intercept;
                                $i$f$getCall = false;
                                referer = ((PipelineCall)$this$call$iv.getContext()).getRequest().getHeaders().get("Referer");
                                if (UtilKt.access$isAllowedHost(hostHeader)) break;
                                $this$call$iv = $this$intercept;
                                $i$f$getCall = false;
                                $this$call$iv = (ApplicationCall)((PipelineCall)$this$call$iv.getContext());
                                message$iv = HttpStatusCode.Companion.getForbidden();
                                $i$f$respond = 0;
                                var9_35 = message$iv;
                                var10_38 = $this$respond$iv;
                                $i$f$typeInfo = false;
                                var12_44 = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
                                $i$f$typeOfOrNull = false;
                                try {
                                    var14_50 = Reflection.typeOf(HttpStatusCode.class);
                                }
                                catch (Throwable <unused var>$iv$iv$iv) {
                                    var14_50 = null;
                                }
                                var16_56 = var14_50;
                                var17_59 = var12_44;
                                var18_62 = new TypeInfo(var17_59, var16_56);
                                this.L$0 = $this$intercept;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)hostHeader);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)origin);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)referer);
                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$respond$iv);
                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)message$iv);
                                this.I$0 = $i$f$respond;
                                this.label = 1;
                                v0 = var10_38.respond((Object)var9_35, var18_62, (Continuation)this);
                                if (v0 == var20_3) {
                                    return var20_3;
                                }
                                ** GOTO lbl57
                            }
                            case 1: {
                                $i$f$respond = this.I$0;
                                message$iv = (HttpStatusCode)this.L$5;
                                $this$respond$iv = (ApplicationCall)this.L$4;
                                referer = (String)this.L$3;
                                origin = (String)this.L$2;
                                hostHeader = (String)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl57:
                                // 2 sources

                                $this$intercept.finish();
                                return Unit.INSTANCE;
                            }
                        }
                        if (origin == null || UtilKt.access$isAllowedOrigin(origin)) break block17;
                        $this$trace$iv = UtilKt.access$getLogger$p();
                        $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            var19_65 = $this$trace$iv;
                            $i$a$-trace-UtilKt$installHostValidation$1$1 = false;
                            var19_65.trace("Origin " + origin + " is not a local origin. Disallowed.");
                        }
                        $this$call$iv = $this$intercept;
                        $i$f$getCall = false;
                        $this$call$iv = (ApplicationCall)((PipelineCall)$this$call$iv.getContext());
                        message$iv = HttpStatusCode.Companion.getForbidden();
                        $i$f$respond = 0;
                        var9_36 = message$iv;
                        var10_39 = $this$respond$iv;
                        $i$f$typeInfo = false;
                        var12_45 = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
                        $i$f$typeOfOrNull = false;
                        try {
                            var14_51 = Reflection.typeOf(HttpStatusCode.class);
                        }
                        catch (Throwable <unused var>$iv$iv$iv) {
                            var14_51 = null;
                        }
                        var16_57 = var14_51;
                        var17_60 = var12_45;
                        var18_63 = new TypeInfo(var17_60, var16_57);
                        this.L$0 = $this$intercept;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)hostHeader);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)origin);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)referer);
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$respond$iv);
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)message$iv);
                        this.I$0 = $i$f$respond;
                        this.label = 2;
                        v1 = var10_39.respond((Object)var9_36, var18_63, (Continuation)this);
                        if (v1 == var20_3) {
                            return var20_3;
                        }
                        ** GOTO lbl108
                        {
                            case 2: {
                                $i$f$respond = this.I$0;
                                message$iv = (HttpStatusCode)this.L$5;
                                $this$respond$iv = (ApplicationCall)this.L$4;
                                referer = (String)this.L$3;
                                origin = (String)this.L$2;
                                hostHeader = (String)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl108:
                                // 2 sources

                                $this$intercept.finish();
                                return Unit.INSTANCE;
                            }
                        }
                    }
                    if (referer == null || UtilKt.access$isAllowedOrigin(referer)) break block18;
                    $this$trace$iv = UtilKt.access$getLogger$p();
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var19_66 = $this$trace$iv;
                        $i$a$-trace-UtilKt$installHostValidation$1$2 = false;
                        var19_66.trace("Referer " + referer + " is not a local origin. Disallowed.");
                    }
                    $this$call$iv = $this$intercept;
                    $i$f$getCall = false;
                    $this$call$iv = (ApplicationCall)((PipelineCall)$this$call$iv.getContext());
                    message$iv = HttpStatusCode.Companion.getForbidden();
                    $i$f$respond = 0;
                    var9_37 = message$iv;
                    var10_40 = $this$respond$iv;
                    $i$f$typeInfo = false;
                    var12_46 = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
                    $i$f$typeOfOrNull = false;
                    try {
                        var14_52 = Reflection.typeOf(HttpStatusCode.class);
                    }
                    catch (Throwable <unused var>$iv$iv$iv) {
                        var14_52 = null;
                    }
                    var16_58 = var14_52;
                    var17_61 = var12_46;
                    var18_64 = new TypeInfo(var17_61, var16_58);
                    this.L$0 = $this$intercept;
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)hostHeader);
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)origin);
                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)referer);
                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$respond$iv);
                    this.L$5 = SpillingKt.nullOutSpilledVariable((Object)message$iv);
                    this.I$0 = $i$f$respond;
                    this.label = 3;
                    v2 = var10_40.respond((Object)var9_37, var18_64, (Continuation)this);
                    if (v2 == var20_3) {
                        return var20_3;
                    }
                    ** GOTO lbl160
                    {
                        case 3: {
                            $i$f$respond = this.I$0;
                            message$iv = (HttpStatusCode)this.L$5;
                            $this$respond$iv = (ApplicationCall)this.L$4;
                            referer = (String)this.L$3;
                            origin = (String)this.L$2;
                            hostHeader = (String)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl160:
                            // 2 sources

                            $this$intercept.finish();
                            return Unit.INSTANCE;
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(PipelineContext<Unit, PipelineCall> p1, Unit p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final boolean isAllowedHost(String host) {
        String hostname = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)host, (char)':', null, (int)2, null))).toString();
        if (allowedHosts.contains(hostname)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Host " + host + " is allowed by list of allowed hosts");
            }
            return true;
        }
        return false;
    }

    private static final boolean isAllowedOrigin(String uri) {
        boolean bl;
        try {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Checking origin " + uri + " against allowed hosts...");
            }
            URL url = new URL(uri);
            String string = url.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            bl = UtilKt.isAllowedHost(string);
        }
        catch (Exception exception) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("Origin " + uri + " is not a valid URL. Disallowed.");
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isAllowedHost(String host) {
        return UtilKt.isAllowedHost(host);
    }

    public static final /* synthetic */ boolean access$isAllowedOrigin(String uri) {
        return UtilKt.isAllowedOrigin(uri);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UtilKt.logger = logger;
        Object[] objectArray = new String[]{"127.0.0.1", "localhost", "::1", "[::1]"};
        allowedHosts = SetsKt.setOf((Object[])objectArray);
    }
}

