"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var helpers_1 = require("../../helpers");
var config_1 = require("../../config");
var Layout_1 = __importDefault(require("./Layout"));
var Error_1 = require("../Error/Error");
var AsyncApiComponent = (function (_super) {
    __extends(AsyncApiComponent, _super);
    function AsyncApiComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            asyncapi: undefined,
            error: undefined,
        };
        var parsedSpec = helpers_1.SpecificationHelpers.retrieveParsedSpec(props.schema);
        if (parsedSpec) {
            _this.state = { asyncapi: parsedSpec };
        }
        return _this;
    }
    AsyncApiComponent.prototype.componentDidMount = function () {
        if (!this.state.asyncapi) {
            this.updateState(this.props.schema);
        }
    };
    AsyncApiComponent.prototype.componentDidUpdate = function (prevProps) {
        var oldSchema = prevProps.schema;
        var newSchema = this.props.schema;
        if (oldSchema !== newSchema) {
            this.updateState(newSchema);
        }
    };
    AsyncApiComponent.prototype.render = function () {
        var _a;
        var _b = this.props, config = _b.config, propError = _b.error;
        var _c = this.state, asyncapi = _c.asyncapi, stateError = _c.error;
        var error = propError !== null && propError !== void 0 ? propError : stateError;
        var concatenatedConfig = __assign(__assign(__assign({}, config_1.defaultConfig), config), { show: __assign(__assign({}, config_1.defaultConfig.show), (!!config && config.show)), expand: __assign(__assign({}, config_1.defaultConfig.expand), (!!config && config.expand)), sidebar: __assign(__assign({}, config_1.defaultConfig.sidebar), (!!config && config.sidebar)), extensions: __assign(__assign({}, config_1.defaultConfig.extensions), (!!config && config.extensions)) });
        if (!asyncapi) {
            if (!error) {
                return null;
            }
            return (((_a = concatenatedConfig.show) === null || _a === void 0 ? void 0 : _a.errors) && (react_1.default.createElement("section", { className: "aui-root" },
                react_1.default.createElement(Error_1.Error, { error: error }))));
        }
        return react_1.default.createElement(Layout_1.default, { asyncapi: asyncapi, config: concatenatedConfig });
    };
    AsyncApiComponent.prototype.updateState = function (schema) {
        var parsedSpec = helpers_1.SpecificationHelpers.retrieveParsedSpec(schema);
        if (!parsedSpec) {
            this.setState({ asyncapi: undefined });
            return;
        }
        this.setState({ asyncapi: parsedSpec });
    };
    return AsyncApiComponent;
}(react_1.Component));
exports.default = AsyncApiComponent;
//# sourceMappingURL=Standalone.js.map