/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.language;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.LanguageWithVariant;
import ai.grazie.nlp.langs.utils.NamesKt;
import ai.grazie.nlp.phonetics.metaphone.DoubleMetaphone;
import ai.grazie.nlp.phonetics.metaphone.RussianMetaphone;
import ai.grazie.nlp.utils.normalization.Normalizer;
import ai.grazie.nlp.utils.normalization.StripAccentsNormalizer;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.dictionary.rule.IgnoreRuleDictionary;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.suggestion.filter.SuggestionFilter;
import ai.grazie.spell.suggestion.filter.feature.RadiusSuggestionFilter;
import ai.grazie.spell.suggestion.ranker.AsciiRanker;
import ai.grazie.spell.suggestion.ranker.CasingSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.DamerauLevenshteinSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.FrequencySuggestionRanker;
import ai.grazie.spell.suggestion.ranker.JaroWinklerSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.LinearAggregatingSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.PhoneticSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import ai.grazie.spell.utils.DictionaryResources;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013BS\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0015J\b\u0010%\u001a\u00020\u0000H\u0007J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\t\u0010*\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u0015\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u00c6\u0003J]\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u00c6\u0001J\u0013\u0010.\u001a\u00020\u00112\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010\f\u001a\u0004\u0018\u00010\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010$\u00a8\u00064"}, d2={"Lai/grazie/spell/language/LanguageModel;", "", "language", "Lai/grazie/nlp/langs/LanguageWithVariant;", "words", "Lai/grazie/spell/lists/WordListWithFrequency;", "rules", "Lai/grazie/spell/dictionary/RuleDictionary;", "ranker", "Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "filter", "Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "normalizer", "Lai/grazie/nlp/utils/normalization/Normalizer;", "isAlien", "Lkotlin/Function1;", "", "", "<init>", "(Lai/grazie/nlp/langs/LanguageWithVariant;Lai/grazie/spell/lists/WordListWithFrequency;Lai/grazie/spell/dictionary/RuleDictionary;Lai/grazie/spell/suggestion/ranker/SuggestionRanker;Lai/grazie/spell/suggestion/filter/SuggestionFilter;Lai/grazie/nlp/utils/normalization/Normalizer;Lkotlin/jvm/functions/Function1;)V", "Lai/grazie/nlp/langs/Language;", "(Lai/grazie/nlp/langs/Language;Lai/grazie/spell/lists/WordListWithFrequency;Lai/grazie/spell/dictionary/RuleDictionary;Lai/grazie/spell/suggestion/ranker/SuggestionRanker;Lai/grazie/spell/suggestion/filter/SuggestionFilter;Lai/grazie/nlp/utils/normalization/Normalizer;Lkotlin/jvm/functions/Function1;)V", "getLanguage", "()Lai/grazie/nlp/langs/LanguageWithVariant;", "getWords", "()Lai/grazie/spell/lists/WordListWithFrequency;", "getRules", "()Lai/grazie/spell/dictionary/RuleDictionary;", "getRanker", "()Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "getFilter", "()Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "getNormalizer$annotations", "()V", "getNormalizer", "()Lai/grazie/nlp/utils/normalization/Normalizer;", "()Lkotlin/jvm/functions/Function1;", "strippingAccents", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nLanguageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageModel.kt\nai/grazie/spell/language/LanguageModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class LanguageModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageWithVariant language;
    @NotNull
    private final WordListWithFrequency words;
    @NotNull
    private final RuleDictionary rules;
    @NotNull
    private final SuggestionRanker ranker;
    @NotNull
    private final SuggestionFilter filter;
    @Nullable
    private final Normalizer normalizer;
    @NotNull
    private final Function1<String, Boolean> isAlien;
    @NotNull
    private static final Set<Language> predefinedLanguages;

    public LanguageModel(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency words, @NotNull RuleDictionary rules, @NotNull SuggestionRanker ranker, @NotNull SuggestionFilter filter2, @Nullable Normalizer normalizer, @NotNull Function1<? super String, Boolean> isAlien) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
        this.language = language;
        this.words = words;
        this.rules = rules;
        this.ranker = ranker;
        this.filter = filter2;
        this.normalizer = normalizer;
        this.isAlien = isAlien;
    }

    public /* synthetic */ LanguageModel(LanguageWithVariant languageWithVariant, WordListWithFrequency wordListWithFrequency, RuleDictionary ruleDictionary, SuggestionRanker suggestionRanker, SuggestionFilter suggestionFilter, Normalizer normalizer, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            suggestionRanker = Companion.getRanker(languageWithVariant.getBase(), wordListWithFrequency);
        }
        if ((n & 0x20) != 0) {
            normalizer = null;
        }
        this(languageWithVariant, wordListWithFrequency, ruleDictionary, suggestionRanker, suggestionFilter, normalizer, (Function1<? super String, Boolean>)function1);
    }

    @NotNull
    public final LanguageWithVariant getLanguage() {
        return this.language;
    }

    @NotNull
    public final WordListWithFrequency getWords() {
        return this.words;
    }

    @NotNull
    public final RuleDictionary getRules() {
        return this.rules;
    }

    @NotNull
    public final SuggestionRanker getRanker() {
        return this.ranker;
    }

    @NotNull
    public final SuggestionFilter getFilter() {
        return this.filter;
    }

    @Nullable
    public final Normalizer getNormalizer() {
        return this.normalizer;
    }

    @Deprecated(message="Use TextSpeller instead of accent-stripping normalizers")
    public static /* synthetic */ void getNormalizer$annotations() {
    }

    @NotNull
    public final Function1<String, Boolean> isAlien() {
        return this.isAlien;
    }

    @Deprecated(message="Use the constructor with LanguageWithVariant")
    public LanguageModel(@NotNull Language language, @NotNull WordListWithFrequency words, @NotNull RuleDictionary rules, @NotNull SuggestionRanker ranker, @NotNull SuggestionFilter filter2, @Nullable Normalizer normalizer, @NotNull Function1<? super String, Boolean> isAlien) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
        this(new LanguageWithVariant(language, null, 2, null), words, rules, ranker, filter2, normalizer, isAlien);
    }

    public /* synthetic */ LanguageModel(Language language, WordListWithFrequency wordListWithFrequency, RuleDictionary ruleDictionary, SuggestionRanker suggestionRanker, SuggestionFilter suggestionFilter, Normalizer normalizer, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            suggestionRanker = Companion.getRanker(language, wordListWithFrequency);
        }
        if ((n & 0x20) != 0) {
            normalizer = null;
        }
        this(language, wordListWithFrequency, ruleDictionary, suggestionRanker, suggestionFilter, normalizer, (Function1<? super String, Boolean>)function1);
    }

    @Deprecated(message="Use TextSpeller instead of accent-stripping normalizers")
    @NotNull
    public final LanguageModel strippingAccents() {
        if (!(this.normalizer == null)) {
            boolean bl = false;
            String string = "The normalizer is already set to " + this.normalizer;
            throw new IllegalArgumentException(string.toString());
        }
        return LanguageModel.copy$default(this, null, null, null, null, null, new StripAccentsNormalizer(), null, 95, null);
    }

    @NotNull
    public final LanguageWithVariant component1() {
        return this.language;
    }

    @NotNull
    public final WordListWithFrequency component2() {
        return this.words;
    }

    @NotNull
    public final RuleDictionary component3() {
        return this.rules;
    }

    @NotNull
    public final SuggestionRanker component4() {
        return this.ranker;
    }

    @NotNull
    public final SuggestionFilter component5() {
        return this.filter;
    }

    @Nullable
    public final Normalizer component6() {
        return this.normalizer;
    }

    @NotNull
    public final Function1<String, Boolean> component7() {
        return this.isAlien;
    }

    @NotNull
    public final LanguageModel copy(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency words, @NotNull RuleDictionary rules, @NotNull SuggestionRanker ranker, @NotNull SuggestionFilter filter2, @Nullable Normalizer normalizer, @NotNull Function1<? super String, Boolean> isAlien) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
        return new LanguageModel(language, words, rules, ranker, filter2, normalizer, isAlien);
    }

    public static /* synthetic */ LanguageModel copy$default(LanguageModel languageModel, LanguageWithVariant languageWithVariant, WordListWithFrequency wordListWithFrequency, RuleDictionary ruleDictionary, SuggestionRanker suggestionRanker, SuggestionFilter suggestionFilter, Normalizer normalizer, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            languageWithVariant = languageModel.language;
        }
        if ((n & 2) != 0) {
            wordListWithFrequency = languageModel.words;
        }
        if ((n & 4) != 0) {
            ruleDictionary = languageModel.rules;
        }
        if ((n & 8) != 0) {
            suggestionRanker = languageModel.ranker;
        }
        if ((n & 0x10) != 0) {
            suggestionFilter = languageModel.filter;
        }
        if ((n & 0x20) != 0) {
            normalizer = languageModel.normalizer;
        }
        if ((n & 0x40) != 0) {
            function1 = languageModel.isAlien;
        }
        return languageModel.copy(languageWithVariant, wordListWithFrequency, ruleDictionary, suggestionRanker, suggestionFilter, normalizer, function1);
    }

    @NotNull
    public String toString() {
        return "LanguageModel(language=" + this.language + ", words=" + this.words + ", rules=" + this.rules + ", ranker=" + this.ranker + ", filter=" + this.filter + ", normalizer=" + this.normalizer + ", isAlien=" + this.isAlien + ")";
    }

    public int hashCode() {
        int result2 = this.language.hashCode();
        result2 = result2 * 31 + this.words.hashCode();
        result2 = result2 * 31 + this.rules.hashCode();
        result2 = result2 * 31 + this.ranker.hashCode();
        result2 = result2 * 31 + this.filter.hashCode();
        result2 = result2 * 31 + (this.normalizer == null ? 0 : this.normalizer.hashCode());
        result2 = result2 * 31 + this.isAlien.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LanguageModel)) {
            return false;
        }
        LanguageModel languageModel = (LanguageModel)other;
        if (!Intrinsics.areEqual((Object)this.language, (Object)languageModel.language)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.words, (Object)languageModel.words)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rules, (Object)languageModel.rules)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ranker, (Object)languageModel.ranker)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filter, (Object)languageModel.filter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.normalizer, (Object)languageModel.normalizer)) {
            return false;
        }
        return Intrinsics.areEqual(this.isAlien, languageModel.isAlien);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LanguageModel load(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency hunspell2, int tooShortLength, boolean disableFiltering) {
        return Companion.load(language, hunspell2, tooShortLength, disableFiltering);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LanguageModel load(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency hunspell2, int tooShortLength) {
        return Companion.load(language, hunspell2, tooShortLength);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LanguageModel load(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency hunspell2) {
        return Companion.load(language, hunspell2);
    }

    static {
        Language[] languageArray = new Language[]{Language.ENGLISH, Language.GERMAN, Language.RUSSIAN, Language.UKRAINIAN};
        predefinedLanguages = SetsKt.setOf((Object[])languageArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/grazie/spell/language/LanguageModel$Companion;", "", "<init>", "()V", "predefinedLanguages", "", "Lai/grazie/nlp/langs/Language;", "load", "Lai/grazie/spell/language/LanguageModel;", "language", "Lai/grazie/nlp/langs/LanguageWithVariant;", "hunspell", "Lai/grazie/spell/lists/WordListWithFrequency;", "tooShortLength", "", "disableFiltering", "", "defaultFilter", "Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "getRanker", "Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LanguageModel load(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency hunspell2, int tooShortLength, boolean disableFiltering) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)hunspell2, (String)"hunspell");
            if (!predefinedLanguages.contains((Object)language.getBase())) {
                throw new IllegalStateException(("Language " + NamesKt.getEnglishName(language.getBase()) + " does not have a predefined language model").toString());
            }
            SuggestionFilter filter2 = disableFiltering ? (SuggestionFilter)SuggestionFilter.None.INSTANCE : this.defaultFilter(language.getBase());
            IgnoreRuleDictionary ignoreRules = IgnoreRuleDictionary.Companion.standard(tooShortLength);
            RuleDictionary replacingRules = DictionaryResources.INSTANCE.getReplacingRules("/rule/" + language.getBase().getIso());
            RuleDictionary[] ruleDictionaryArray = new RuleDictionary[]{ignoreRules, replacingRules};
            return new LanguageModel(language, hunspell2, (RuleDictionary)new RuleDictionary.Aggregated(ruleDictionaryArray), null, filter2, null, arg_0 -> Companion.load$lambda$0(language, arg_0), 40, null);
        }

        public static /* synthetic */ LanguageModel load$default(Companion companion, LanguageWithVariant languageWithVariant, WordListWithFrequency wordListWithFrequency, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 2;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            return companion.load(languageWithVariant, wordListWithFrequency, n, bl);
        }

        @NotNull
        public final SuggestionFilter defaultFilter(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            return switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                case 1 -> new RadiusSuggestionFilter(0.05);
                case 2 -> new RadiusSuggestionFilter(0.15);
                case 3 -> new RadiusSuggestionFilter(0.03);
                case 4 -> new RadiusSuggestionFilter(0.05);
                default -> SuggestionFilter.None.INSTANCE;
            };
        }

        @NotNull
        public final SuggestionRanker getRanker(@NotNull Language language, @NotNull WordListWithFrequency hunspell2) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)hunspell2, (String)"hunspell");
            return switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                case 1 -> {
                    Pair[] var3_3 = new Pair[]{TuplesKt.to((Object)new JaroWinklerSuggestionRanker(), (Object)0.43), TuplesKt.to((Object)new DamerauLevenshteinSuggestionRanker(), (Object)0.2), TuplesKt.to((Object)new PhoneticSuggestionRanker(new DoubleMetaphone()), (Object)0.11), TuplesKt.to((Object)new FrequencySuggestionRanker(hunspell2), (Object)0.23), TuplesKt.to((Object)new CasingSuggestionRanker(), (Object)0.05)};
                    yield new LinearAggregatingSuggestionRanker(var3_3);
                }
                case 2 -> {
                    Pair[] var3_4 = new Pair[]{TuplesKt.to((Object)new JaroWinklerSuggestionRanker(), (Object)0.19), TuplesKt.to((Object)new DamerauLevenshteinSuggestionRanker(), (Object)0.31), TuplesKt.to((Object)new PhoneticSuggestionRanker(RussianMetaphone.INSTANCE), (Object)0.35), TuplesKt.to((Object)new FrequencySuggestionRanker(hunspell2), (Object)0.13), TuplesKt.to((Object)new CasingSuggestionRanker(), (Object)0.05)};
                    yield new LinearAggregatingSuggestionRanker(var3_4);
                }
                case 3 -> {
                    Pair[] var3_5 = new Pair[]{TuplesKt.to((Object)new JaroWinklerSuggestionRanker(), (Object)0.23), TuplesKt.to((Object)new DamerauLevenshteinSuggestionRanker(), (Object)0.25), TuplesKt.to((Object)new PhoneticSuggestionRanker(new DoubleMetaphone()), (Object)0.3), TuplesKt.to((Object)new FrequencySuggestionRanker(hunspell2), (Object)0.3), TuplesKt.to((Object)new CasingSuggestionRanker(), (Object)0.05), TuplesKt.to((Object)new AsciiRanker(), (Object)0.05)};
                    yield new LinearAggregatingSuggestionRanker(var3_5);
                }
                case 4 -> {
                    Pair[] var3_6 = new Pair[]{TuplesKt.to((Object)new FrequencySuggestionRanker(hunspell2), (Object)0.58), TuplesKt.to((Object)new CasingSuggestionRanker(), (Object)0.05)};
                    yield new LinearAggregatingSuggestionRanker(var3_6);
                }
                default -> throw new IllegalStateException(("Language " + NamesKt.getEnglishName(language) + " has no ranker").toString());
            };
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LanguageModel load(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency hunspell2, int tooShortLength) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)hunspell2, (String)"hunspell");
            return ai.grazie.spell.language.LanguageModel$Companion.load$default(this, language, hunspell2, tooShortLength, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LanguageModel load(@NotNull LanguageWithVariant language, @NotNull WordListWithFrequency hunspell2) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)hunspell2, (String)"hunspell");
            return ai.grazie.spell.language.LanguageModel$Companion.load$default(this, language, hunspell2, 0, false, 12, null);
        }

        private static final boolean load$lambda$0(LanguageWithVariant $language, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !$language.getBase().getAlphabet().matchAny(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Language.values().length];
                try {
                    nArray[Language.ENGLISH.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Language.RUSSIAN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Language.GERMAN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Language.UKRAINIAN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

