/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleSourceHighlighter;
import com.jetbrains.python.console.PyConsoleStartFolding;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PyTargetedCodeExecutor;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.actions.CommandQueueListener;
import com.jetbrains.python.console.completion.PythonConsoleAutopopupBlockingHandler;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.console.pythonCommandQueue.PythonCommandQueuePanel;
import com.jetbrains.python.debugger.PyDebugValueDescriptor;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.testing.PyTestsSharedKt;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PythonConsoleView
extends LanguageConsoleImpl
implements ObservableConsoleView,
PyCodeExecutor,
PyTargetedCodeExecutor {
    public static final Key<Boolean> CONSOLE_KEY = new Key("PYDEV_CONSOLE_KEY");
    private static final Key<Map<Integer, Integer>> COUNTER_LINE_NUMBER = new Key("PYDEV_COUNTER_LINE_NUMBER");
    private static final Logger LOG = Logger.getInstance(PythonConsoleView.class);
    private final boolean myTestMode;
    private PythonConsoleExecuteActionHandler myExecuteActionHandler;
    private PyConsoleSourceHighlighter mySourceHighlighter;
    private boolean myIsIPythonOutput;
    private final PyHighlighter myPyHighlighter;
    private boolean myHyperlink;
    private XStandaloneVariablesView mySplitView;
    private final ActionCallback myInitialized = new ActionCallback();
    private boolean isShowVars;
    @Nullable
    private String mySdkHomePath;
    private PydevConsoleRunner myRunner;
    private final Map<String, Map<String, PyDebugValueDescriptor>> myDescriptorsCache = Maps.newConcurrentMap();
    private final PythonCommandQueuePanel myCommandQueuePanel = new PythonCommandQueuePanel(this);
    private JBPopup myCommandQueue;
    private Dimension commandQueueDimension;
    private boolean isShowQueue;
    private ActionToolbar myToolbar;
    private boolean myIsToolwindowHorizontal = true;
    @Nullable
    private TargetEnvironment myTargetEnvironment;
    private final PsiFile myHistoryPsiFile = new PyExpressionCodeFragmentImpl(this.getProject(), "dummy.py", (CharSequence)"", true);

    public PsiFile getHistoryPsiFile() {
        return this.myHistoryPsiFile;
    }

    @NotNull
    private static LanguageConsoleImpl.Helper createHelper(@NotNull Project project, String title) {
        if (project == null) {
            PythonConsoleView.$$$reportNull$$$0(0);
        }
        return new LanguageConsoleImpl.Helper(project, Objects.requireNonNull(PsiUtilCore.getVirtualFile((PsiElement)new PyExpressionCodeFragmentImpl(project, title + ".py", (CharSequence)"", true))));
    }

    public PythonConsoleView(Project project, String title, @Nullable Sdk sdk2, boolean testMode) {
        super(PythonConsoleView.createHelper(project, title));
        PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)this.getVirtualFile());
        if (psiFile instanceof PyExpressionCodeFragmentImpl) {
            PyExpressionCodeFragmentImpl codeFragment = (PyExpressionCodeFragmentImpl)psiFile;
            codeFragment.setContext((PsiElement)this.myHistoryPsiFile);
        }
        this.getConsoleEditor().setFile(this.getVirtualFile());
        this.myTestMode = testMode;
        this.isShowVars = PyConsoleOptions.getInstance(project).isShowVariableByDefault();
        VirtualFile virtualFile = this.getVirtualFile();
        PythonLanguageLevelPusher.specifyFileLanguageLevel((VirtualFile)virtualFile, (LanguageLevel)PySdkUtil.getLanguageLevelForSdk((Sdk)sdk2));
        virtualFile.putUserData(CONSOLE_KEY, (Object)true);
        if (PyConsoleOptions.getInstance(this.getProject()).isRuntimeCodeCompletion()) {
            this.getConsoleEditor().putUserData(PythonConsoleAutopopupBlockingHandler.REPL_KEY, new Object());
        }
        this.getHistoryViewer().putUserData(ConsoleViewUtil.EDITOR_IS_CONSOLE_HISTORY_VIEW, (Object)true);
        this.getHistoryViewer().putUserData(COUNTER_LINE_NUMBER, new HashMap());
        super.setPrompt(null);
        this.setUpdateFoldingsEnabled(false);
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (sdk2 != null) {
            PythonSdkFlavor sdkFlavor = PythonSdkFlavor.getFlavor((Sdk)sdk2);
            if (sdkFlavor != null) {
                languageLevel = sdkFlavor.getLanguageLevel(sdk2);
            }
            this.mySdkHomePath = sdk2.getHomePath();
        }
        this.myPyHighlighter = new PyHighlighter(languageLevel);
        this.addToolwindowPositionListener(project);
    }

    public void setCommandQueueTitle(String title) {
        if (this.myCommandQueue != null) {
            this.myCommandQueue.setCaption(PyBundle.message("python.console.command.queue.add.title", title));
        }
    }

    public void setConsoleCommunication(ConsoleCommunication communication) {
        this.getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY, (Object)communication);
        if (this.isShowVars && communication instanceof PydevConsoleCommunication) {
            this.myIsToolwindowHorizontal = PythonConsoleView.isToolwindowHorizontal(PythonConsoleToolWindow.getInstance(this.getProject()).getToolWindow());
            this.showVariables((PydevConsoleCommunication)communication);
        }
        if (communication instanceof PydevConsoleCommunication || communication instanceof PythonDebugConsoleCommunication) {
            this.myCommandQueuePanel.setCommunication(communication);
        }
        this.addCommandQueuePanelListener(communication);
    }

    public void addCommandQueuePanelListener(ConsoleCommunication communication) {
        ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).addListener(communication, new CommandQueueListener(){

            @Override
            public void removeCommand(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ConsoleCommunication.ConsoleCodeFragment command) {
                if (command == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> PythonConsoleView.this.myCommandQueuePanel.removeCommand(command));
            }

            @Override
            public void addCommand(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ConsoleCommunication.ConsoleCodeFragment command) {
                if (command == null) {
                    1.$$$reportNull$$$0(1);
                }
                PythonConsoleView.this.myCommandQueuePanel.addCommand(command);
            }

            @Override
            public void removeAll() {
                PythonConsoleView.this.myCommandQueuePanel.removeAllCommands();
            }

            @Override
            public void disableConsole() {
                PythonConsoleView.this.myCommandQueuePanel.removeAllCommands();
                PythonConsoleView.this.isShowQueue = false;
                PythonConsoleView.this.restoreQueueWindow(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "command";
                objectArray2[1] = "com/jetbrains/python/console/PythonConsoleView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCommand";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    private PyConsoleStartFolding createConsoleFolding(boolean addOnce) {
        PyConsoleStartFolding startFolding = new PyConsoleStartFolding(this, addOnce);
        this.myExecuteActionHandler.getConsoleCommunication().addCommunicationListener((ConsoleCommunicationListener)startFolding);
        Editor editor2 = this.getEditor();
        if (editor2 == null) {
            return null;
        }
        editor2.getDocument().addDocumentListener((DocumentListener)startFolding);
        ((FoldingModelEx)editor2.getFoldingModel()).addListener((FoldingListener)startFolding, (Disposable)this);
        return startFolding;
    }

    public void addConsoleFolding(boolean isDebugConsole, boolean addOnce) {
        try {
            if (isDebugConsole && this.myExecuteActionHandler != null && this.getEditor() != null) {
                PyConsoleStartFolding folding = this.createConsoleFolding(addOnce);
                if (folding != null) {
                    folding.setStartLineOffset(this.getEditor().getDocument().getTextLength());
                    folding.setNumberOfCommandToStop(2);
                }
            } else {
                this.myInitialized.doWhenDone(() -> this.createConsoleFolding(addOnce));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public void setExecutionHandler(@NotNull PythonConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            PythonConsoleView.$$$reportNull$$$0(1);
        }
        this.myExecuteActionHandler = consoleExecuteActionHandler;
    }

    public PythonConsoleExecuteActionHandler getExecuteActionHandler() {
        return this.myExecuteActionHandler;
    }

    public void setConsoleEnabled(boolean flag) {
        if (this.myExecuteActionHandler != null) {
            this.myExecuteActionHandler.setEnabled(flag);
        } else {
            this.myInitialized.doWhenDone(() -> this.myExecuteActionHandler.setEnabled(flag));
        }
    }

    public void inputRequested() {
        ConsoleCommunication consoleCommunication;
        if (this.myExecuteActionHandler != null && (consoleCommunication = this.myExecuteActionHandler.getConsoleCommunication()) instanceof PythonDebugConsoleCommunication) {
            consoleCommunication.notifyInputRequested();
        }
    }

    public void inputReceived() {
        if (this.myExecuteActionHandler != null) {
            this.myExecuteActionHandler.getConsoleCommunication().notifyInputReceived();
        }
    }

    public void requestFocus() {
        this.myInitialized.doWhenDone(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getConsoleEditor().getContentComponent(), true));
    }

    @Override
    public void executeCode(@Nullable String code, @Nullable Editor editor2) {
        this.myInitialized.doWhenDone(() -> this.executeCodeImpl(code));
    }

    private void executeCodeImpl(final @Nullable String code) {
        if (code != null) {
            if (PyConsoleUtil.isCommandQueueEnabled(this.getProject())) {
                this.executeInConsole(code);
            } else {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, PyBundle.message("console.executing.code.in.console", new Object[0]), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        while (!(PythonConsoleView.this.myExecuteActionHandler.isEnabled() && PythonConsoleView.this.myExecuteActionHandler.canExecuteNow() || indicator.isCanceled())) {
                            TimeoutUtil.sleep((long)300L);
                        }
                        if (!indicator.isCanceled()) {
                            PythonConsoleView.this.executeInConsole(code);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PythonConsoleView$2", "run"));
                    }
                });
            }
        } else {
            this.requestFocus();
        }
    }

    public void executeInConsole(@NotNull String code) {
        if (code == null) {
            PythonConsoleView.$$$reportNull$$$0(2);
        }
        CountDownLatch latch = new CountDownLatch(1);
        TransactionGuard.submitTransaction((Disposable)this, () -> {
            String codeToExecute = code.endsWith("\n") || this.myExecuteActionHandler.checkSingleLine(code) ? code : code + "\n";
            DocumentEx document = this.getConsoleEditor().getDocument();
            String oldText = document.getText();
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.setInputText(codeToExecute);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument((Document)document);
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile((Document)document);
                if (psiFile != null) {
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> CodeStyleManager.getInstance((Project)this.getProject()).adjustLineIndent(psiFile, new TextRange(0, psiFile.getTextLength())));
                }
                int oldOffset = this.getConsoleEditor().getCaretModel().getOffset();
                this.getConsoleEditor().getCaretModel().moveToOffset(document.getTextLength());
                this.myExecuteActionHandler.runExecuteAction((LanguageConsoleView)this);
                if (!StringUtil.isEmpty((String)oldText)) {
                    ApplicationManager.getApplication().runWriteAction(() -> this.setInputText(oldText));
                    this.getConsoleEditor().getCaretModel().moveToOffset(oldOffset);
                }
            });
            latch.countDown();
        });
        try {
            latch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void executeStatement(@NotNull String statement, @NotNull Key<?> attributes) {
        if (statement == null) {
            PythonConsoleView.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            PythonConsoleView.$$$reportNull$$$0(4);
        }
        this.print(statement, this.outputTypeForAttributes(attributes));
        this.myExecuteActionHandler.processLine(statement);
    }

    public void printText(String text, ConsoleViewContentType outputType) {
        super.print(text, outputType);
    }

    public void print(@NotNull String text, @NotNull Key<?> attributes) {
        if (text == null) {
            PythonConsoleView.$$$reportNull$$$0(5);
        }
        if (attributes == null) {
            PythonConsoleView.$$$reportNull$$$0(6);
        }
        this.print(text, this.outputTypeForAttributes(attributes));
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType outputType) {
        if (text == null) {
            PythonConsoleView.$$$reportNull$$$0(7);
        }
        if (outputType == null) {
            PythonConsoleView.$$$reportNull$$$0(8);
        }
        if (this.myTestMode) {
            text = PyTestsSharedKt.processTCMessage(text);
        }
        this.detectIPython(text);
        if (PyConsoleUtil.detectIPythonEnd(text)) {
            this.myIsIPythonOutput = false;
            this.mySourceHighlighter = null;
        } else if (PyConsoleUtil.detectIPythonStart(text)) {
            this.myIsIPythonOutput = true;
        } else if (this.mySourceHighlighter == null || outputType == ConsoleViewContentType.ERROR_OUTPUT) {
            if (this.myHyperlink) {
                this.printHyperlink(text, outputType);
            } else {
                super.print(text, outputType);
            }
            this.myHyperlink = this.detectHyperlink(text);
            if (this.mySourceHighlighter == null && this.myIsIPythonOutput && PyConsoleUtil.detectSourcePrinting(text)) {
                this.mySourceHighlighter = new PyConsoleSourceHighlighter(this, this.myPyHighlighter);
            }
        } else {
            try {
                this.mySourceHighlighter.printHighlightedSource(text);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void detectIPython(String text) {
        VirtualFile file = this.getVirtualFile();
        if (PyConsoleUtil.detectIPythonImported(text)) {
            PyConsoleUtil.markIPython(file);
            PythonConsoleExecuteActionHandler handler = this.getExecuteActionHandler();
            if (handler != null) {
                handler.updateConsoleState();
            }
        }
        if (PyConsoleUtil.detectIPythonAutomagicOn(text)) {
            PyConsoleUtil.setIPythonAutomagic(file, true);
        }
        if (PyConsoleUtil.detectIPythonAutomagicOff(text)) {
            PyConsoleUtil.setIPythonAutomagic(file, false);
        }
    }

    private boolean detectHyperlink(@NotNull String text) {
        if (text == null) {
            PythonConsoleView.$$$reportNull$$$0(9);
        }
        return this.myIsIPythonOutput && text.startsWith("File:");
    }

    private void printHyperlink(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            PythonConsoleView.$$$reportNull$$$0(10);
        }
        if (contentType == null) {
            PythonConsoleView.$$$reportNull$$$0(11);
        }
        if (!StringUtil.isEmpty((String)text)) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(text.trim());
            if (vFile != null) {
                OpenFileHyperlinkInfo hyperlink = new OpenFileHyperlinkInfo(this.getProject(), vFile, -1);
                super.printHyperlink(text, (HyperlinkInfo)hyperlink);
            } else {
                super.print(text, contentType);
            }
        }
    }

    @NotNull
    public ConsoleViewContentType outputTypeForAttributes(@NotNull Key<?> attributes) {
        if (attributes == null) {
            PythonConsoleView.$$$reportNull$$$0(12);
        }
        ConsoleViewContentType outputType = attributes == ProcessOutputTypes.STDERR ? ConsoleViewContentType.ERROR_OUTPUT : (attributes == ProcessOutputTypes.SYSTEM ? ConsoleViewContentType.SYSTEM_OUTPUT : ConsoleViewContentType.getConsoleViewType(attributes));
        ConsoleViewContentType consoleViewContentType = outputType;
        if (consoleViewContentType == null) {
            PythonConsoleView.$$$reportNull$$$0(13);
        }
        return consoleViewContentType;
    }

    public void setSdk(Sdk sdk2) {
        this.getFile().putCopyableUserData(PydevConsoleRunner.CONSOLE_SDK, (Object)sdk2);
    }

    public void showVariables(PydevConsoleCommunication consoleCommunication) {
        Project project = this.getProject();
        PyStackFrame stackFrame = new PyStackFrame(project, consoleCommunication, new PyStackFrameInfo("", "", "", null), null);
        stackFrame.restoreChildrenDescriptors(this.myDescriptorsCache);
        final XStandaloneVariablesView view = new XStandaloneVariablesView(project, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider(), (XStackFrame)stackFrame);
        consoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            public void commandExecuted(boolean more) {
                view.rebuildView();
            }

            public void inputRequested() {
            }
        });
        this.mySplitView = view;
        JBScrollPane scrollPane = (JBScrollPane)SwingUtilities.getAncestorOfClass(JBScrollPane.class, this.mySplitView.getMainComponent());
        if (scrollPane != null) {
            scrollPane.setBorder((Border)JBUI.Borders.empty());
        }
        Disposer.register((Disposable)this, (Disposable)view);
        this.splitWindow();
        consoleCommunication.notifyViewCreated(view);
    }

    public void setTargetEnvironment(@NotNull TargetEnvironment targetEnvironment2) {
        if (targetEnvironment2 == null) {
            PythonConsoleView.$$$reportNull$$$0(14);
        }
        this.myTargetEnvironment = targetEnvironment2;
    }

    @Override
    public void executeCode(@NotNull Function<TargetEnvironment, String> code) {
        if (code == null) {
            PythonConsoleView.$$$reportNull$$$0(15);
        }
        this.myInitialized.doWhenDone(() -> {
            TargetEnvironment targetEnvironment2 = this.myTargetEnvironment;
            if (targetEnvironment2 == null) {
                throw new IllegalStateException("Execution environment must be initialized");
            }
            String codeValue = (String)code.apply(targetEnvironment2);
            this.executeCodeImpl(codeValue);
        });
    }

    private static boolean isToolwindowHorizontal(ToolWindow toolWindow) {
        return toolWindow.getAnchor() == ToolWindowAnchor.BOTTOM || toolWindow.getAnchor() == ToolWindowAnchor.TOP;
    }

    private void addToolwindowPositionListener(final Project project) {
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow consoleToolWindow;
                if (toolWindowManager == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (PythonConsoleView.this.myIsToolwindowHorizontal != PythonConsoleView.isToolwindowHorizontal(consoleToolWindow = PythonConsoleToolWindow.getInstance(project).getToolWindow())) {
                    boolean bl = PythonConsoleView.this.myIsToolwindowHorizontal = !PythonConsoleView.this.myIsToolwindowHorizontal;
                    if (PythonConsoleView.this.isShowVars) {
                        PythonConsoleView.this.restoreWindow();
                        ConsoleCommunication communication = (ConsoleCommunication)PythonConsoleView.this.getFile().getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY);
                        if (communication instanceof PydevConsoleCommunication) {
                            PythonConsoleView.this.showVariables((PydevConsoleCommunication)communication);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/jetbrains/python/console/PythonConsoleView$4", "stateChanged"));
            }
        });
    }

    public void showQueue() {
        EditorEx editor2;
        JBPopupListener listener2 = new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                PythonConsoleView.this.isShowQueue = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/console/PythonConsoleView$5", "onClosed"));
            }
        };
        String commandQueueName = PythonConsoleView.getConsoleDisplayName(this.getProject());
        this.myCommandQueue = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myCommandQueuePanel, null).setMovable(true).setResizable(true).setShowShadow(true).setCancelOnClickOutside(false).setTitle(PyBundle.message("python.console.command.queue.add.title", commandQueueName != null ? commandQueueName : "Python Console")).setCancelButton((IconButton)new MinimizeButton(IdeBundle.message((String)"tooltip.hide", (Object[])new Object[0]))).addListener(listener2).setBorderColor(JBColor.background()).setCancelOnOtherWindowOpen(true).createPopup();
        TitlePanel title = (TitlePanel)((AbstractPopup)this.myCommandQueue).getTitle();
        title.getLabel().setForeground(JBColor.foreground());
        title.setActive(true);
        ((AbstractPopup)this.myCommandQueue).addResizeListener(this::commandQueueWasResized, (Disposable)this);
        if (this.commandQueueDimension != null) {
            this.myCommandQueue.setSize(this.commandQueueDimension);
        }
        if (UIUtil.isShowing((Component)(editor2 = this.getConsoleEditor()).getContentComponent())) {
            this.myCommandQueue.showInBestPositionFor((Editor)this.getConsoleEditor());
        }
        Disposer.register((Disposable)this, (Disposable)this.myCommandQueue);
    }

    private void commandQueueWasResized() {
        this.commandQueueDimension = this.myCommandQueue.getSize();
    }

    @NotNull
    protected JComponent createCenterComponent() {
        JComponent centerComponent = super.createCenterComponent();
        this.getHistoryViewer().getSettings().setAdditionalLinesCount(0);
        this.getHistoryViewer().getSettings().setUseSoftWraps(false);
        this.getConsoleEditor().getGutterComponentEx().setBackground(this.getConsoleEditor().getBackgroundColor());
        this.getConsoleEditor().getGutterComponentEx().revalidate();
        this.getConsoleEditor().getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.getConsoleEditor().getBackgroundColor());
        JComponent jComponent = centerComponent;
        if (jComponent == null) {
            PythonConsoleView.$$$reportNull$$$0(16);
        }
        return jComponent;
    }

    private void splitWindow() {
        Component console = this.getComponent(0);
        this.removeAll();
        JBSplitter p = new JBSplitter(!this.myIsToolwindowHorizontal, 0.6666667f);
        p.setFirstComponent((JComponent)console);
        p.setSecondComponent(this.mySplitView.getPanel());
        p.setShowDividerControls(true);
        p.setHonorComponentsMinimumSize(true);
        this.add((Component)p, "Center");
        this.validate();
        this.repaint();
    }

    public void restoreQueueWindow(boolean removeCommand) {
        if (this.myCommandQueue != null) {
            ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)this.myCommandQueue));
        }
        if (removeCommand) {
            ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).removeCommand((ConsoleCommunication)this.myRunner.getPydevConsoleCommunication(), true);
        }
    }

    public void restoreWindow() {
        Component component = this.getComponent(0);
        if (this.mySplitView != null && component instanceof JBSplitter) {
            JBSplitter pane = (JBSplitter)component;
            this.removeAll();
            Disposer.dispose((Disposable)this.mySplitView);
            this.mySplitView = null;
            this.add(pane.getFirstComponent(), "Center");
            this.validate();
            this.repaint();
        }
    }

    @Nullable
    public String getSdkHomePath() {
        return this.mySdkHomePath;
    }

    public boolean isInitialized() {
        return this.myInitialized.isDone();
    }

    public void initialized() {
        this.myInitialized.setDone();
    }

    public boolean isShowVars() {
        return this.isShowVars;
    }

    public void setShowVars(boolean showVars) {
        this.isShowVars = showVars;
    }

    public boolean isShowQueue() {
        return this.isShowQueue;
    }

    public void setShowQueue(boolean showQueue) {
        this.isShowQueue = showQueue;
    }

    public void setRunner(PydevConsoleRunner runner) {
        this.myRunner = runner;
    }

    public PydevConsoleRunner getRunner() {
        return this.myRunner;
    }

    @TestOnly
    @Nullable
    public XDebuggerTreeNode getDebuggerTreeRootNode() {
        return this.mySplitView.getTree().getRoot();
    }

    public void dispose() {
        ConsoleCommunication communication;
        super.dispose();
        if (!this.getProject().isDisposed() && (communication = (ConsoleCommunication)this.getFile().getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY)) != null) {
            ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).removeListener(communication);
        }
        EditorEx editor2 = this.myCommandQueuePanel.getQueueEditor();
        this.commandQueueDimension = null;
        if (!editor2.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)editor2);
        }
    }

    public void setToolbar(ActionToolbar toolbar) {
        this.myToolbar = toolbar;
    }

    public ActionToolbar getToolbar() {
        return this.myToolbar;
    }

    @Nullable
    private static String getConsoleDisplayName(@NotNull Project project) {
        ToolWindow window;
        Content content;
        if (project == null) {
            PythonConsoleView.$$$reportNull$$$0(17);
        }
        if ((content = (window = PythonConsoleToolWindow.getInstance(project).getToolWindow()).getContentManager().getSelectedContent()) == null) {
            return null;
        }
        return content.getDisplayName();
    }

    public void storeExecutionCounterLineNumber(int counter, int lineNumber) {
        Map counterMap = (Map)this.getHistoryViewer().getUserData(COUNTER_LINE_NUMBER);
        if (counterMap != null) {
            counterMap.put(counter, lineNumber);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleExecuteActionHandler";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PythonConsoleView";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PythonConsoleView";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "outputTypeForAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHelper";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setExecutionHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeInConsole";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeStatement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "detectHyperlink";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "outputTypeForAttributes";
                break;
            }
            case 13: 
            case 16: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTargetEnvironment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeCode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDisplayName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 16 -> new IllegalStateException(string);
        };
    }
}

