/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLocalPositionConverter
implements PyPositionConverter {
    private static final String[] EGG_EXTENSIONS = new String[]{".egg", ".zip"};

    @NotNull
    public PySourcePosition create(@NotNull String file, int line) {
        if (file == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(0);
        }
        PySourcePosition pySourcePosition = this.convertPythonToFrame(file, line);
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(1);
        }
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertPythonToFrame(@NotNull String filePath, int line) {
        File file;
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(2);
        }
        if ((file = new File(filePath)).exists()) {
            return new PyLocalSourcePosition(file.getPath(), line);
        }
        return new PyRemoteSourcePosition(filePath, line);
    }

    @NotNull
    public PySourcePosition convertFrameToPython(@NotNull PySourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(3);
        }
        PySourcePosition pySourcePosition = position;
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(4);
        }
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(5);
        }
        PySourcePosition pySourcePosition = this.convertToPython(PyLocalPositionConverter.convertFilePath(position.getFile().getPath()), PyLocalPositionConverter.convertLocalLineToRemote(position.getFile(), position.getLine()));
        if (pySourcePosition == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(6);
        }
        return pySourcePosition;
    }

    @NotNull
    protected PySourcePosition convertToPython(@NotNull String filePath, int line) {
        if (filePath == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(7);
        }
        return new PyLocalSourcePosition(filePath, line);
    }

    protected static int convertLocalLineToRemote(VirtualFile file, int l) {
        return (Integer)ReadAction.compute(() -> {
            int line = l;
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null) {
                while (PyDebugSupportUtils.isContinuationLine(document, line)) {
                    ++line;
                }
            }
            return line + 1;
        });
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, String frameName) {
        if (position == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(8);
        }
        return PyLocalPositionConverter.createXSourcePosition(this.getVirtualFile(position.getFile()), position.getLine());
    }

    public PySignature convertSignature(PySignature signature) {
        return signature;
    }

    public VirtualFile getVirtualFile(String path2) {
        VirtualFile vFile = this.getLocalFileSystem().findFileByPath(path2);
        if (vFile == null) {
            vFile = PyLocalPositionConverter.findEggEntry(this.getLocalFileSystem(), path2);
        }
        return vFile;
    }

    protected VirtualFileSystem getLocalFileSystem() {
        return LocalFileSystem.getInstance();
    }

    @Nullable
    public static VirtualFile findEggEntry(@NotNull VirtualFileSystem virtualFileSystem, @NotNull String file) {
        String jarPath;
        VirtualFile jarFile;
        String ext;
        if (virtualFileSystem == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PyLocalPositionConverter.$$$reportNull$$$0(10);
        }
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1 && (jarFile = virtualFileSystem.findFileByPath(jarPath = file.substring(0, ind + 4))) != null) {
            String innerPath = file.substring(ind + 4);
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
            if (jarRoot != null) {
                return jarRoot.findFileByRelativePath(innerPath);
            }
        }
        return null;
    }

    private static String convertFilePath(String file) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file.indexOf((ext = stringArray[i]) + "!")) == -1; ++i) {
        }
        if (ind != -1) {
            return file.substring(0, ind + 4) + file.substring(ind + 5);
        }
        return file;
    }

    private static String winNormCase(String file) {
        String ext;
        int ind = -1;
        String[] stringArray = EGG_EXTENSIONS;
        int n = stringArray.length;
        for (int i = 0; i < n && (ind = file.indexOf(ext = stringArray[i])) == -1; ++i) {
        }
        if (ind != -1) {
            return StringUtil.toLowerCase((String)file.substring(0, ind + 4)) + file.substring(ind + 4);
        }
        return StringUtil.toLowerCase((String)file);
    }

    @Nullable
    public static XSourcePosition createXSourcePosition(@Nullable VirtualFile vFile, int line) {
        if (vFile != null) {
            return XDebuggerUtil.getInstance().createPosition(vFile, PyLocalPositionConverter.convertRemoteLineToLocal(vFile, line));
        }
        return null;
    }

    private static int convertRemoteLineToLocal(VirtualFile vFile, int line) {
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        --line;
        if (document != null) {
            while (PyDebugSupportUtils.isContinuationLine(document, line - 1)) {
                --line;
            }
        }
        return line;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyLocalPositionConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFrameToPython";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPython";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertPythonToFrame";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertFrameToPython";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToPython";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPython";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findEggEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6 -> new IllegalStateException(string);
        };
    }

    protected static class PyLocalSourcePosition
    extends PySourcePosition {
        public PyLocalSourcePosition(String file, int line) {
            super(file, line);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows) {
                file = PyLocalPositionConverter.winNormCase(file);
            }
            return super.normalize(file);
        }
    }

    protected static class PyRemoteSourcePosition
    extends PySourcePosition {
        public PyRemoteSourcePosition(String file, int line) {
            super(file, line);
        }

        protected String normalize(@Nullable String file) {
            if (file == null) {
                return null;
            }
            if (SystemInfo.isWindows && PyRemoteSourcePosition.isWindowsPath((String)file)) {
                file = PyLocalPositionConverter.winNormCase(file);
            }
            return super.normalize(file);
        }
    }
}

