/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements.inspections.tools;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageName;
import com.jetbrains.python.packaging.common.PythonOutdatedPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.RequirementsFile;
import com.jetbrains.python.requirements.RequirementsInspectionVisitor;
import com.jetbrains.python.requirements.inspections.quickfixes.UpdateAllRequirementQuickFix;
import com.jetbrains.python.requirements.inspections.quickfixes.UpdateRequirementQuickFix;
import com.jetbrains.python.requirements.psi.Requirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/requirements/inspections/tools/OutdatedRequirementInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/jetbrains/python/requirements/RequirementsInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isDumbAware", "intellij.python.community.impl"})
public final class OutdatedRequirementInspection
extends LocalInspectionTool {
    @NotNull
    public RequirementsInspectionVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new RequirementsInspectionVisitor(holder, session){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ LocalInspectionToolSession $session;
            {
                this.$holder = $holder;
                this.$session = $session;
                super($holder, $session);
            }

            /*
             * WARNING - void declaration
             */
            public void visitRequirementsFile(RequirementsFile requirementsFile) {
                void $this$forEach$iv;
                Object requirement;
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)requirementsFile), (String)"requirementsFile");
                List<Requirement> requirements = requirementsFile.requirements();
                PsiFile psiFile = this.$session.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                PsiFile psiFile2 = psiFile;
                Sdk sdk2 = PackageUtilsKt.getPythonSdk(psiFile2);
                if (sdk2 == null) {
                    return;
                }
                Sdk sdk3 = sdk2;
                Project project = psiFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project, sdk3);
                Map outdatedPackages = MapsKt.toMap(packageManager.listOutdatedPackagesSnapshot());
                if (outdatedPackages.isEmpty()) {
                    return;
                }
                Iterable $this$mapNotNull$iv = requirements;
                boolean $i$f$mapNotNull22 = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    requirement = (Object[])element$iv$iv;
                    boolean bl2 = false;
                    String packageName = PyPackageName.Companion.normalizePackageName(requirement.getDisplayName());
                    if ((outdatedPackages.keySet().contains(packageName) ? TuplesKt.to((Object)packageName, (Object)requirement) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Map outdatedRequirements = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                Object $i$f$mapNotNull22 = new UpdateAllRequirementQuickFix(outdatedRequirements.keySet());
                UpdateAllRequirementQuickFix it = $i$f$mapNotNull22;
                boolean bl = false;
                UpdateAllRequirementQuickFix updateAllRequirementQuickFix = outdatedRequirements.size() > 1 ? $i$f$mapNotNull22 : null;
                $i$f$mapNotNull22 = outdatedRequirements;
                iterable = this.$holder;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    String description;
                    void $this$toTypedArray$iv;
                    PythonOutdatedPackage outdatedPackage;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator2.next();
                    boolean bl4 = false;
                    String name2 = (String)entry.getKey();
                    Requirement requirement2 = (Requirement)entry.getValue();
                    if ((PythonOutdatedPackage)outdatedPackages.get(name2) == null) continue;
                    requirement = new Object[]{requirement2.getDisplayName(), outdatedPackage.getVersion(), outdatedPackage.getLatestVersion()};
                    Intrinsics.checkNotNullExpressionValue((Object)PyBundle.message("python.sdk.inspection.message.version.outdated.latest", requirement), (String)"message(...)");
                    requirement = new LocalQuickFix[]{updateAllRequirementQuickFix, new UpdateRequirementQuickFix(name2)};
                    requirement = CollectionsKt.listOfNotNull((Object[])requirement);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    LocalQuickFix[] fixes = thisCollection$iv.toArray(new LocalQuickFix[0]);
                    iterable.registerProblem(requirement2, description, ProblemHighlightType.WEAK_WARNING, Arrays.copyOf(fixes, fixes.length));
                }
            }
        };
    }

    public boolean isDumbAware() {
        return true;
    }
}

