/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.data.input;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.dataspell.jupyter.customCells.JupyterCustomCellsBundle;
import com.intellij.dataspell.jupyter.customCells.data.input.JupyterXlsDropHandlerKt;
import com.intellij.dataspell.jupyter.customCells.data.input.PythonDataframeVariableNameSuggester;
import com.intellij.jupyter.core.editor.handlers.CsvDropUtilKt;
import com.intellij.jupyter.core.editor.handlers.DataframeVariableNameSuggester;
import com.intellij.jupyter.core.editor.handlers.LanguageTableDataFileDropHandler;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.lang.Language;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonLanguage;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/data/input/JupyterCsvDropHandler;", "Lcom/intellij/jupyter/core/editor/handlers/LanguageTableDataFileDropHandler;", "<init>", "()V", "nameSuggester", "Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "getNameSuggester", "()Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "generateCellCode", "", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "intellij.dataspell.jupyter.customCells"})
public final class JupyterCsvDropHandler
extends LanguageTableDataFileDropHandler {
    public JupyterCsvDropHandler() {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pythonLanguage, (String)"getInstance(...)");
        Object[] objectArray = new String[]{"csv", "tsv"};
        super((Language)pythonLanguage, JupyterCustomCellsBundle.message("jupyter.drop.csv.command", new Object[0]), SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public DataframeVariableNameSuggester getNameSuggester() {
        return PythonDataframeVariableNameSuggester.INSTANCE;
    }

    @NotNull
    public String generateCellCode(@NotNull TableDataFileDropHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(context.absoluteFilePath());
        CsvFormat csvFormat = DatabaseCoreUiService.getInstance().getCsvFormat(context.getProjectOrNull(), file, true);
        if (csvFormat == null) {
            CsvFormat csvFormat2;
            Character c = CsvDropUtilKt.guessCsvSeparator((File)new File(context.absoluteFilePath()));
            if (c != null) {
                char csvSeparator = c.charValue();
                boolean bl = false;
                CsvRecordFormat recordFormat = new CsvRecordFormat("", "", null, CollectionsKt.emptyList(), CsvRecordFormat.QuotationPolicy.AS_NEEDED, String.valueOf(csvSeparator), "\n", false);
                csvFormat2 = new CsvFormat(recordFormat, recordFormat, false);
            } else {
                csvFormat2 = null;
            }
            csvFormat = csvFormat2;
        }
        List args = new ArrayList();
        if (csvFormat != null) {
            Charset charset;
            Collection collection = args;
            String string = csvFormat.dataRecord.valueSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueSeparator");
            collection.add("sep=" + JupyterXlsDropHandlerKt.pyStr(string));
            if (!Intrinsics.areEqual((Object)csvFormat.dataRecord.recordSeparator, (Object)"\n")) {
                collection = args;
                String string2 = csvFormat.dataRecord.recordSeparator;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"recordSeparator");
                collection.add("lineterminator=" + JupyterXlsDropHandlerKt.pyStr(string2));
            }
            if (csvFormat.headerRecord == null) {
                ((Collection)args).add("header=None");
            }
            if (csvFormat.dataRecord.nullText != null) {
                collection = args;
                String string3 = csvFormat.dataRecord.nullText;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nullText");
                collection.add("na_values=[" + JupyterXlsDropHandlerKt.pyStr(string3) + "]");
            }
            List list = csvFormat.dataRecord.quotes;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"quotes");
            if (!((Collection)list).isEmpty()) {
                collection = args;
                String string4 = ((CsvRecordFormat.Quotes)csvFormat.dataRecord.quotes.get((int)0)).leftQuote;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"leftQuote");
                collection.add("quotechar=" + JupyterXlsDropHandlerKt.pyStr(string4));
            }
            VirtualFile virtualFile = file;
            Charset charset2 = charset = virtualFile != null ? virtualFile.getCharset() : null;
            if (charset != null && !Intrinsics.areEqual((Object)charset, (Object)StandardCharsets.UTF_8)) {
                Collection csvSeparator = args;
                String string5 = charset.name();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name(...)");
                csvSeparator.add("encoding=" + JupyterXlsDropHandlerKt.pyStr(string5));
            }
        }
        String csvPath = context.resolveFilePath();
        String string = context.getDataframeName();
        if (string == null) {
            string = this.getNameSuggester().createDataframeName(context.getProjectOrNull(), context.getDataFileNameWithoutExtension());
        }
        String dfName = string;
        return StringsKt.trimIndent((String)("\n      import pandas as pd\n      " + dfName + " = pd.read_csv('" + csvPath + "'" + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)"", null, null, (int)0, null, JupyterCsvDropHandler::generateCellCode$lambda$1, (int)30, null) + ")\n      " + dfName + "\n    "));
    }

    private static final CharSequence generateCellCode$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ", " + it;
    }
}

