/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion.common;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.platform.trialPromotion.common.TrialPromotionBundle;
import com.intellij.platform.trialPromotion.common.TrialStateService;
import com.intellij.platform.trialPromotion.common.TrialStateUtils;
import com.intellij.platform.trialPromotion.common.TrialWidgetColorState;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.PlatformUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0001\u001a\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u001a\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001fH\u0002\u001a\u001a\u0010+\u001a\u0004\u0018\u00010\u001f2\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\"$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00198B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\"(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\"$\u0010%\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018\u00a8\u0006."}, d2={"calculateProgress", "Lcom/intellij/platform/trialPromotion/common/TrialStateService$Progress;", "unlockSubscriptionMessage", "", "Lorg/jetbrains/annotations/Nls;", "DAYS_WITHOUT_LICENSE_FOR_TRIAL", "", "LAST_AVAILABILITY_CHECK_KEY", "LAST_AVAILABILITY_STATE_KEY", "LAST_STATE_KEY", "LAST_COLOR_CLICKED_KEY", "ALERT_REMAINED_DAYS", "EXPIRING_REMAINED_DAYS", "TOOLTIP_TRIAL_AVAILABLE_ID", "TOOLTIP_TRIAL_STARTED_ID", "TOOLTIP_REMAINED_DAYS_ID", "TOOLTIP_EXPIRING_DAYS_ID", "TOOLTIP_GRACE_DAYS_ID", "value", "", "lastTrialAvailability", "getLastTrialAvailability", "()Z", "setLastTrialAvailability", "(Z)V", "", "lastTrialAvailabilityCheckTimestamp", "getLastTrialAvailabilityCheckTimestamp", "()J", "setLastTrialAvailabilityCheckTimestamp", "(J)V", "Lcom/intellij/platform/trialPromotion/common/TrialStateService$TrialState;", "lastTrialState", "getLastTrialState", "()Lcom/intellij/platform/trialPromotion/common/TrialStateService$TrialState;", "setLastTrialState", "(Lcom/intellij/platform/trialPromotion/common/TrialStateService$TrialState;)V", "lastColorStateClicked", "getLastColorStateClicked", "setLastColorStateClicked", "getColorState", "Lcom/intellij/platform/trialPromotion/common/TrialWidgetColorState;", "trialState", "getTrialState", "progress", "paidSubscriptionActive", "intellij.platform.trialPromotion.common"})
public final class TrialStateServiceKt {
    private static final int DAYS_WITHOUT_LICENSE_FOR_TRIAL = 120;
    @NotNull
    private static final String LAST_AVAILABILITY_CHECK_KEY = "trial.state.last.availability.check";
    @NotNull
    private static final String LAST_AVAILABILITY_STATE_KEY = "trial.state.last.availability.state";
    @NotNull
    private static final String LAST_STATE_KEY = "trial.state.last.state";
    @NotNull
    private static final String LAST_COLOR_CLICKED_KEY = "trial.state.last.color.state.clicked";
    private static final int ALERT_REMAINED_DAYS = 7;
    private static final int EXPIRING_REMAINED_DAYS = 1;
    @NotNull
    private static final String TOOLTIP_TRIAL_AVAILABLE_ID = "trial.state.widget.trial.available.got.it.id";
    @NotNull
    public static final String TOOLTIP_TRIAL_STARTED_ID = "trial.state.widget.trial.started.got.it.id";
    @NotNull
    public static final String TOOLTIP_REMAINED_DAYS_ID = "trial.state.widget.remained.days.got.it.id";
    @NotNull
    public static final String TOOLTIP_EXPIRING_DAYS_ID = "trial.state.widget.expiring.got.it.id";
    @NotNull
    private static final String TOOLTIP_GRACE_DAYS_ID = "trial.state.widget.grace.got.it.id";

    @VisibleForTesting
    @NotNull
    public static final TrialStateService.Progress calculateProgress() {
        int n;
        int grace = TrialStateUtils.INSTANCE.getGracePeriodDays();
        int trialLengthDays = TrialStateUtils.INSTANCE.getTrialLengthDays();
        Object object = LicensingFacade.getInstance();
        Instant expirationDate = object != null && (object = ((LicensingFacade)object).expirationDate) != null ? ((Date)object).toInstant() : null;
        Instant now = Instant.now();
        if (expirationDate == null) {
            n = -grace;
        } else {
            int diff = (int)ChronoUnit.DAYS.between(now, expirationDate);
            n = expirationDate.isAfter(now) ? Math.min(trialLengthDays, diff + 1) : Math.max(diff, -grace);
        }
        int daysRemaining = n;
        return new TrialStateService.Progress(daysRemaining, grace);
    }

    @NotNull
    public static final String unlockSubscriptionMessage() {
        Object[] objectArray = new Object[]{PlatformUtils.isPyCharm() ? "Pro" : "Ultimate"};
        return TrialPromotionBundle.INSTANCE.message("trial.state.free", objectArray);
    }

    private static final boolean getLastTrialAvailability() {
        return PropertiesComponent.getInstance().getBoolean(LAST_AVAILABILITY_STATE_KEY);
    }

    private static final void setLastTrialAvailability(boolean value) {
        PropertiesComponent.getInstance().setValue(LAST_AVAILABILITY_STATE_KEY, String.valueOf(value));
    }

    private static final long getLastTrialAvailabilityCheckTimestamp() {
        return PropertiesComponent.getInstance().getLong(LAST_AVAILABILITY_CHECK_KEY, 0L);
    }

    private static final void setLastTrialAvailabilityCheckTimestamp(long value) {
        PropertiesComponent.getInstance().setValue(LAST_AVAILABILITY_CHECK_KEY, String.valueOf(value));
    }

    private static final TrialStateService.TrialState getLastTrialState() {
        TrialStateService.TrialState trialState;
        String string = PropertiesComponent.getInstance().getValue(LAST_STATE_KEY);
        if (string != null) {
            TrialStateService.TrialState trialState2;
            String it = string;
            boolean bl = false;
            try {
                trialState2 = TrialStateService.TrialState.valueOf(it);
            }
            catch (Exception exception) {
                trialState2 = null;
            }
            trialState = trialState2;
        } else {
            trialState = null;
        }
        return trialState;
    }

    private static final void setLastTrialState(TrialStateService.TrialState value) {
        TrialStateService.TrialState trialState = value;
        PropertiesComponent.getInstance().setValue(LAST_STATE_KEY, trialState != null ? trialState.name() : null);
    }

    private static final boolean getLastColorStateClicked() {
        return PropertiesComponent.getInstance().getBoolean(LAST_COLOR_CLICKED_KEY, false);
    }

    private static final void setLastColorStateClicked(boolean value) {
        PropertiesComponent.getInstance().setValue(LAST_COLOR_CLICKED_KEY, value);
    }

    private static final TrialWidgetColorState getColorState(TrialStateService.TrialState trialState) {
        return switch (WhenMappings.$EnumSwitchMapping$0[trialState.ordinal()]) {
            case 1 -> TrialWidgetColorState.DEFAULT;
            case 2 -> TrialWidgetColorState.PROGRESS;
            case 3, 4, 5 -> TrialWidgetColorState.ACTIVE_OR_AVAILABLE;
            case 6, 7, 8 -> TrialWidgetColorState.ALERT;
            case 9 -> TrialWidgetColorState.EXPIRING;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final TrialStateService.TrialState getTrialState(TrialStateService.Progress progress, boolean paidSubscriptionActive) {
        int daysRemaining = TrialStateService.Progress.daysRemaining$default(progress, false, 1, null);
        TrialStateService service = TrialStateService.Companion.getInstance();
        boolean isFreeMode = PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
        return ((Boolean)service.getTrialRequestInProgress().getValue()).booleanValue() ? TrialStateService.TrialState.TRIAL_REQUEST_IN_PROGRESS : (isFreeMode ? (((Boolean)service.getTrialError().getValue()).booleanValue() ? TrialStateService.TrialState.TRIAL_ERROR : (((Boolean)service.getTrialAvailable().getValue()).booleanValue() ? TrialStateService.TrialState.TRIAL_AVAILABLE : TrialStateService.TrialState.FREE)) : (daysRemaining > 7 ? TrialStateService.TrialState.ACTIVE : (daysRemaining > 1 ? TrialStateService.TrialState.ALERT : (daysRemaining > 0 ? TrialStateService.TrialState.EXPIRING : (progress.isGrace() && paidSubscriptionActive ? TrialStateService.TrialState.SUBSCRIPTION_GRACE : (progress.isGrace() ? TrialStateService.TrialState.TRIAL_GRACE : null))))));
    }

    public static final /* synthetic */ TrialStateService.TrialState access$getLastTrialState() {
        return TrialStateServiceKt.getLastTrialState();
    }

    public static final /* synthetic */ long access$getLastTrialAvailabilityCheckTimestamp() {
        return TrialStateServiceKt.getLastTrialAvailabilityCheckTimestamp();
    }

    public static final /* synthetic */ void access$setLastTrialAvailability(boolean value) {
        TrialStateServiceKt.setLastTrialAvailability(value);
    }

    public static final /* synthetic */ void access$setLastTrialAvailabilityCheckTimestamp(long value) {
        TrialStateServiceKt.setLastTrialAvailabilityCheckTimestamp(value);
    }

    public static final /* synthetic */ boolean access$getLastTrialAvailability() {
        return TrialStateServiceKt.getLastTrialAvailability();
    }

    public static final /* synthetic */ TrialStateService.TrialState access$getTrialState(TrialStateService.Progress progress, boolean paidSubscriptionActive) {
        return TrialStateServiceKt.getTrialState(progress, paidSubscriptionActive);
    }

    public static final /* synthetic */ TrialWidgetColorState access$getColorState(TrialStateService.TrialState trialState) {
        return TrialStateServiceKt.getColorState(trialState);
    }

    public static final /* synthetic */ void access$setLastColorStateClicked(boolean value) {
        TrialStateServiceKt.setLastColorStateClicked(value);
    }

    public static final /* synthetic */ void access$setLastTrialState(TrialStateService.TrialState value) {
        TrialStateServiceKt.setLastTrialState(value);
    }

    public static final /* synthetic */ boolean access$getLastColorStateClicked() {
        return TrialStateServiceKt.getLastColorStateClicked();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrialStateService.TrialState.values().length];
            try {
                nArray[TrialStateService.TrialState.FREE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.TRIAL_REQUEST_IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.TRIAL_AVAILABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.TRIAL_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.ACTIVE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.ALERT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.SUBSCRIPTION_GRACE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.TRIAL_GRACE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrialStateService.TrialState.EXPIRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

