/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.variables.converter;

import com.intellij.dataspell.jupyter.customCells.variables.codegen.GenerateCodeKt;
import com.intellij.dataspell.jupyter.customCells.variables.utils.JupyterVariableCellUtilsKt;
import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/variables/converter/JupyterVariableConvertToCodeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.dataspell.jupyter.customCells.variables"})
final class JupyterVariableConvertToCodeAction
extends AnAction {
    private JupyterVariableConvertToCodeAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval selectedInterval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (selectedInterval == null || !JupyterVariableCellUtilsKt.isVariableCell(selectedInterval)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor((DataContext)dataContext2);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JupyterCell jupyterCell = notebookFile.getNotebook().getCellOrNull(interval2.getOrdinal());
        if (jupyterCell == null) {
            return;
        }
        JupyterCell cell = jupyterCell;
        String string = GenerateCodeKt.generateCode(cell);
        if (string == null) {
            string = "";
        }
        String cellText = string;
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper cellLinesHelper = notebookCellLinesEditHelper;
        String string2 = NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)cellLinesHelper, (String)cellText, (CellType)CellType.CODE, null, (int)4, null);
        if (string2 == null) {
            return;
        }
        String newCell = string2;
        WriteCommandAction.writeCommandAction((Project)project2).withName(e.getPresentation().getText()).run(() -> JupyterVariableConvertToCodeAction.actionPerformed$lambda$0(editor, newCell, interval2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final void actionPerformed$lambda$0(EditorImpl $editor, String $newCell, NotebookCellLines.Interval $interval) {
        NotebookCellConverter.Companion.replaceCellWithUndoSupport((Editor)$editor, $newCell, $interval, NotebookCellLines.Companion.get((Editor)$editor));
    }
}

