/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007JC\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadJson;", "", "<init>", "()V", "testConnection", "", "url", "", "headers", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadJsonXz", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "downloadByUrl", "Lkotlin/Result;", "downloadByUrl-BWLJW6A", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;Ljava/lang/String;Ljava/util/Map;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "avoidCaching", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDownloadJson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadJson.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadJson\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 SharedIndexesNetwork.kt\ncom/intellij/indexing/shared/download/SharedIndexesNetworkKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,112:1\n42#2,3:113\n13#3,41:116\n216#4,2:157\n216#4,2:159\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadJson.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadJson\n*L\n56#1:113,3\n79#1:116,41\n29#1:157,2\n85#1:159,2\n*E\n"})
public final class SharedIndexDownloadJson {
    @NotNull
    public static final SharedIndexDownloadJson INSTANCE = new SharedIndexDownloadJson();

    private SharedIndexDownloadJson() {
    }

    @VisibleForTesting
    public final boolean testConnection(@NotNull String url, @NotNull Map<String, String> headers, @NotNull ProgressIndicator indicator) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                indicator.checkCanceled();
                HttpRequests.request((String)url).productNameAsUserAgent().accept("application/octet-stream, application/xz, application/x-xz").tuner(arg_0 -> SharedIndexDownloadJson.testConnection$lambda$0(headers, arg_0)).throwStatusCodeException(true).connect(SharedIndexDownloadJson::testConnection$lambda$1);
            }
            catch (HttpRequests.HttpStatusException e) {
                return false;
            }
            finally {
                if (e.getStatusCode() < 400) break block4;
            }
        }
        return true;
    }

    @VisibleForTesting
    @Nullable
    public final ObjectNode downloadJsonXz(@NotNull SharedIndexLookupRequest request, @NotNull String url, @NotNull ProgressIndicator indicator) {
        Throwable exception;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Checking " + url + " for " + request + "...");
        boolean $i$f$service = false;
        Object[] serviceClass$iv = SharedIndexAuthHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Map<String, String> headers = ((SharedIndexAuthHolder)object).resolveHeaders(url, request, indicator);
        serviceClass$iv = new String[]{this.avoidCaching(url), url};
        List urls = CollectionsKt.listOf((Object[])serviceClass$iv);
        Result lastResult = null;
        for (String _url : urls) {
            Object result = this.downloadByUrl-BWLJW6A(request, _url, headers, indicator);
            if ((Result.isFailure-impl((Object)result) ? null : result) != null) {
                return (ObjectNode)(Result.isFailure-impl((Object)result) ? null : result);
            }
            lastResult = Result.box-impl((Object)result);
        }
        Result result = lastResult;
        Throwable throwable = exception = result != null ? Result.exceptionOrNull-impl((Object)result.unbox-impl()) : null;
        if (exception != null) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().warn(exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Object downloadByUrl-BWLJW6A(SharedIndexLookupRequest request, String url, Map<String, String> headers, ProgressIndicator indicator) {
        byte[] byArray;
        Object url$iv;
        Object object;
        block35: {
            void request$iv;
            object = request;
            url$iv = url;
            boolean $i$f$handleHttpDownloadExceptions = false;
            try {
                boolean bl = false;
                byArray = HttpRequests.request((String)url).productNameAsUserAgent().accept("application/octet-stream, application/xz, application/x-xz").tuner(arg_0 -> SharedIndexDownloadJson.downloadByUrl_BWLJW6A$lambda$0$0(headers, arg_0)).throwStatusCodeException(true).readBytes(indicator);
                break block35;
            }
            catch (ConnectException e$iv) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot connect to the host for " + (String)url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
            }
            catch (UnknownHostException e$iv) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot resolve host for " + (String)url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
            }
            catch (SocketTimeoutException e$iv) {
                if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + (String)url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + ".", (Throwable)e$iv);
                } else {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + (String)url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + ".");
                }
            }
            catch (HttpRequests.HttpStatusException e$iv) {
                if (e$iv.getStatusCode() < 500) {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No data available for " + (String)url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                } else {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().info("No data available for " + (String)url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                }
            }
            catch (IOException e$iv) {
                if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                    Serializable serializable;
                    Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                    String string = e$iv.getMessage();
                    if (string != null) {
                        serializable = (Serializable)((Object)string);
                    } else {
                        Throwable throwable = e$iv.getCause();
                        String string2 = throwable != null ? throwable.getMessage() : null;
                        serializable = string2 != null ? (Serializable)((Object)string2) : (Serializable)e$iv.getClass();
                    }
                    logger.warn("Failed to download " + (String)url$iv + " for " + request$iv + ". Error: " + serializable, (Throwable)e$iv);
                } else {
                    Serializable serializable;
                    Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                    String string = e$iv.getMessage();
                    if (string != null) {
                        serializable = (Serializable)((Object)string);
                    } else {
                        Throwable throwable = e$iv.getCause();
                        String string3 = throwable != null ? throwable.getMessage() : null;
                        serializable = string3 != null ? (Serializable)((Object)string3) : (Serializable)e$iv.getClass();
                    }
                    logger.warn("Failed to download " + (String)url$iv + " for " + request$iv + ". Error: " + serializable);
                }
            }
            catch (Throwable t$iv) {
                Serializable serializable;
                if (t$iv instanceof ControlFlowException) {
                    throw t$iv;
                }
                Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                Class<?> clazz = t$iv.getClass();
                String string = t$iv.getMessage();
                if (string != null) {
                    serializable = (Serializable)((Object)string);
                } else {
                    Throwable throwable = t$iv.getCause();
                    String string4 = throwable != null ? throwable.getMessage() : null;
                    serializable = string4 != null ? (Serializable)((Object)string4) : (Serializable)t$iv.getClass();
                }
                logger.warn("Failed to download " + (String)url$iv + " due " + clazz + " for " + request$iv + ". Error: " + serializable);
            }
            byArray = null;
        }
        if (byArray == null) {
            return Result.constructor-impl(null);
        }
        byte[] rawDataXZ = byArray;
        try {
            byte[] byArray2;
            object = new ByteArrayInputStream(rawDataXZ);
            url$iv = null;
            try {
                byte[] byArray3;
                ByteArrayInputStream input = (ByteArrayInputStream)object;
                boolean bl = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                Throwable throwable = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl2 = false;
                    byArray3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                byArray2 = byArray3;
            }
            catch (Throwable throwable) {
                url$iv = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)url$iv);
            }
            object = byArray2;
        }
        catch (Throwable e) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Error("Failed to unpack data from " + url + " for " + request + ". " + e.getMessage(), e)));
        }
        Object rawData = object;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree((byte[])rawData);
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            object = Result.constructor-impl((Object)((ObjectNode)jsonNode));
        }
        catch (Throwable e) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Error("Failed to read JSON from " + url + " for " + request + ". " + e.getMessage(), e)));
        }
        return object;
    }

    private final String avoidCaching(String url) {
        return url + "?timestamp=" + System.currentTimeMillis();
    }

    private static final void testConnection$lambda$0(Map $headers, URLConnection tuner) {
        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
        Map $this$forEach$iv = $headers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            tuner.addRequestProperty(k, v);
        }
    }

    private static final Integer testConnection$lambda$1(HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getReader().read();
    }

    private static final void downloadByUrl_BWLJW6A$lambda$0$0(Map $headers, URLConnection tuner) {
        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
        Map $this$forEach$iv = $headers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            tuner.addRequestProperty(k, v);
        }
    }
}

