/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgGeneratedParser;
import com.intellij.sql.dialects.postgres.PgGeneratedParserUtil;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgParserBase
extends SqlParser {
    private final boolean myPlSql;
    private boolean myUnderPl;

    public PgParserBase(SqlLanguageDialectEx dialect, boolean pl) {
        super(dialect);
        this.myPlSql = pl;
    }

    public boolean isPlSql() {
        return this.myPlSql || this.myUnderPl;
    }

    public void parseLight(IElementType root, PsiBuilder initialBuilder) {
        PsiElement element = SqlLazyElementTypeImpl.getContextElement((PsiBuilder)initialBuilder);
        PgDialectBase dialect = (PgDialectBase)((Object)ObjectUtils.tryCast((Object)this.getLanguage(), PgDialectBase.class));
        this.myUnderPl = dialect != null && element != null && PgDialectBase.inPl(element);
        super.parseLight(root, initialBuilder);
    }

    public boolean parseReferenceExpression(PsiBuilder builder, SqlReferenceElementType refType) {
        if (refType == SQL_OPERATOR_REFERENCE) {
            return PgGeneratedParserUtil.anyOperatorRef(builder, 0) || super.parseReferenceExpression(builder, refType);
        }
        return super.parseReferenceExpression(builder, refType);
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first2) {
        boolean result;
        IElementType type = builder.getTokenType();
        boolean bl = result = type == SQL_STRING_TOKEN || SqlGeneratedParserUtil.isExternalParameterFirst((IElementType)type) || this.getVariableType(builder) == SQL_PARAMETER_REFERENCE;
        if (result && !first2) {
            result = false;
            int i2 = -1;
            while (true) {
                IElementType token;
                if ((token = builder.rawLookup(i2)) == null || SqlTokens.COMMENT_TOKENS.contains(token)) {
                    return false;
                }
                if (!SqlTokens.WS_TOKENS.contains(token)) break;
                if (StringUtil.contains((CharSequence)builder.getOriginalText(), (int)builder.rawTokenTypeStart(i2), (int)builder.rawTokenTypeStart(i2 + 1), (char)'\n')) {
                    result = true;
                }
                --i2;
            }
        }
        return result;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)PG_PSQL_BACKSLASH)) {
            return this.parsePsqlMetaCommand(builder, level);
        }
        if (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SqlTokens.SQL_RAW_INPUT)) {
            return this.parseCopyCommandInput(builder, level);
        }
        return false;
    }

    private boolean parseCopyCommandInput(PsiBuilder builder, int level) {
        if (!SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SqlTokens.SQL_RAW_INPUT)) {
            return false;
        }
        PsiBuilder.Marker mark = builder.mark();
        PsiBuilder.Marker mark2 = builder.mark();
        builder.advanceLexer();
        mark2.done((IElementType)SqlCompositeElementTypes.SQL_INJECTABLE_RAW_INPUT);
        mark.done((IElementType)PgElementTypes.Misc.PG_PSQL_META_COMMAND);
        SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SqlCommonTokens.PG_COPY_TERMINATOR);
        this.statementSeparatorParsed(builder);
        return true;
    }

    private boolean parsePsqlMetaCommand(PsiBuilder builder, int level) {
        if (!SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)PG_PSQL_BACKSLASH)) {
            return false;
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.rawLookup(0) == PG_PSQL_BACKSLASH) {
            builder.advanceLexer();
        } else {
            SqlGeneratedParserUtil.parseAsTree((PsiBuilder)builder, (int)level, (IElementType)SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, (boolean)true, (GeneratedParserUtilBase.Parser)GeneratedParserUtilBase.TOKEN_ADVANCER, (GeneratedParserUtilBase.Parser)new GeneratedParserUtilBase.Parser(this){

                public boolean parse(PsiBuilder builder, int level) {
                    return !SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SqlCommonTokens.PG_PSQL_BACKSLASH) && !SqlParserUtil.endsWithNewLine((PsiBuilder)builder);
                }
            });
        }
        mark.done((IElementType)PgElementTypes.Misc.PG_PSQL_META_COMMAND);
        this.statementSeparatorParsed(builder);
        return true;
    }

    public boolean consumeUnderscoreAndCharSpec(PsiBuilder builder) {
        return false;
    }

    public boolean mergeOperatorWithQuestionMark(PsiBuilder builder) {
        PsiLanguageInjectionHost host = InjectedLanguageUtilBase.findInjectionHost((PsiElement)((PsiElement)builder.getUserData(FileContextUtil.CONTAINING_FILE_KEY)));
        return host == null;
    }

    protected boolean parsingOperatorsAsIdentifier() {
        return false;
    }

    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        if (this.getVariableType(builder) == SQL_PARAMETER_REFERENCE) {
            return this.parseParameterReferenceInner(builder, (IElementType)SQL_PARAMETER_REFERENCE);
        }
        return super.parseExternalParameterImpl(builder, checkStart, checkEnd);
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result = SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_CUSTOM_LQUOTE) ? this.parseStringLiteralInner(builder) : super.consumeCustomParameterReference(builder);
        return result;
    }

    @Nullable
    protected String adjustBuiltinParensPolicy(@Nullable String policy, @NotNull PsiBuilder builder, boolean plain) {
        if (builder == null) {
            PgParserBase.$$$reportNull$$$0(0);
        }
        String parens = policy;
        if (!plain && "prohibited".equals(parens)) {
            parens = "required";
        }
        return super.adjustBuiltinParensPolicy(parens, builder, plain);
    }

    public boolean parseFunctionParametersStart(PsiBuilder builder, int level, BuiltinFunction definition) {
        boolean ignored = SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)PgTypes.PG_ALL) || SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)PgTypes.PG_DISTINCT);
        return true;
    }

    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        PsiBuilder.Marker mark = builder.mark();
        boolean result = this.parseReferenceExpression(builder, true, SQL_ARGUMENT_REFERENCE);
        if (result && !(result = SqlParserUtil.consumeToken((PsiBuilder)builder, (boolean)true, (IElementType)SqlCommonTokens.SQL_OP_ASSIGN))) {
            result = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (String)"=>");
        }
        if (result) {
            mark.drop();
        } else {
            mark.rollbackTo();
        }
        return result;
    }

    public boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        if (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)PG_PSQL_BACKSLASH)) {
            this.statementSeparatorParsed(builder);
            return false;
        }
        return super.statementRecover(builder, level, prefixParser);
    }

    public boolean argumentListRecover(PsiBuilder builder, int level) {
        return GeneratedParserUtilBase.nextTokenIsSmart((PsiBuilder)builder, (IElementType)PgTypes.PG_ORDER);
    }

    @Nullable
    public abstract IElementType getLazyCodeBlockType();

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return PgGeneratedParser.table_opt_column_list(builder, level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/postgres/PgParserBase", "adjustBuiltinParensPolicy"));
    }
}

