/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.collection.BitVectorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0086\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007Jf\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u0019H\u0082\bJ\b\u0010\u001f\u001a\u00020 H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Landroidx/compose/runtime/collection/BitVector;", "", "<init>", "()V", "data", "", "size", "", "getSize", "()I", "get", "", "index", "set", "", "value", "nextSet", "nextClear", "setRange", "start", "end", "forEachChunkInRange", "startIndex", "endIndex", "action", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "chunkNumber", "startInChunk", "endInChunk", "toString", "", "Companion", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBitVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitVector.kt\nandroidx/compose/runtime/collection/BitVector\n+ 2 BitVector.kt\nandroidx/compose/runtime/collection/BitVectorKt\n*L\n1#1,136:1\n105#1,12:141\n105#1,12:153\n105#1,12:165\n30#2:137\n26#2,2:138\n23#2:140\n*S KotlinDebug\n*F\n+ 1 BitVector.kt\nandroidx/compose/runtime/collection/BitVector\n*L\n62#1:141,12\n75#1:153,12\n94#1:165,12\n47#1:137\n58#1:138,2\n58#1:140\n*E\n"})
public final class BitVector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public long[] data = new long[2];
    public static final int $stable = 8;
    private static final int BITS_PER_CHUNK = 64;
    private static final int BITS_PER_CHUNK_SHIFT = 6;

    public final int getSize() {
        return this.data.length << 6;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean get(int index) {
        void $this$getBit$iv;
        int address = index >>> 6;
        int bit = index & 0x3F;
        long l = this.data[address];
        int index$iv = bit;
        boolean $i$f$getBit = false;
        return ($this$getBit$iv & 1L << index$iv) != 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int index, boolean value) {
        void $this$setBit$iv;
        void index$iv;
        long bits;
        int address = index >>> 6;
        long[] values = this.data;
        if (address >= values.length) {
            this.data = values = BitVectorKt.access$reallocate(values, address);
        }
        long l = bits = values[address];
        int n = index & 0x3F;
        boolean value$iv = value;
        boolean $i$f$setBit = false;
        long mask$iv = 1L << index$iv;
        boolean $this$toInt$iv$iv = value$iv;
        boolean $i$f$toInt = false;
        values[address] = $this$setBit$iv & (mask$iv ^ 0xFFFFFFFFFFFFFFFFL) | -((long)($this$toInt$iv$iv ? 1 : 0)) & mask$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final int nextSet(int index) {
        void startIndex$iv;
        BitVector bitVector = this;
        int n = index;
        int endIndex$iv = this.getSize();
        boolean $i$f$forEachChunkInRange = false;
        void startChunk$iv = startIndex$iv >> 6;
        void chunk$iv = startChunk$iv;
        int endChunk$iv = endIndex$iv - 1 >> 6;
        if (chunk$iv <= endChunk$iv) {
            while (true) {
                void endInChunk;
                void startInChunk;
                void chunkStartIndex$iv = chunk$iv << 6;
                void chunkEndIndex$iv = chunkStartIndex$iv + 64;
                int n2 = Math.min(endIndex$iv, (int)chunkEndIndex$iv) - chunkStartIndex$iv;
                int n3 = Math.max((int)startIndex$iv, (int)chunkStartIndex$iv) - chunkStartIndex$iv;
                void chunk = chunk$iv;
                boolean bl = false;
                long maskedBitsToCheck = this.data[chunk] >> startInChunk & -1L << 64 - endInChunk;
                int chunkClearIndex = Long.numberOfTrailingZeros(maskedBitsToCheck);
                if (chunkClearIndex < 64) {
                    return chunkClearIndex + (chunk << 6) + startInChunk;
                }
                if (chunk$iv == endChunk$iv) break;
                ++chunk$iv;
            }
        }
        return this.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public final int nextClear(int index) {
        void startIndex$iv;
        BitVector bitVector = this;
        int n = index;
        int endIndex$iv = this.getSize();
        boolean $i$f$forEachChunkInRange = false;
        void startChunk$iv = startIndex$iv >> 6;
        void chunk$iv = startChunk$iv;
        int endChunk$iv = endIndex$iv - 1 >> 6;
        if (chunk$iv <= endChunk$iv) {
            while (true) {
                void endInChunk;
                void startInChunk;
                void chunkStartIndex$iv = chunk$iv << 6;
                void chunkEndIndex$iv = chunkStartIndex$iv + 64;
                int n2 = Math.min(endIndex$iv, (int)chunkEndIndex$iv) - chunkStartIndex$iv;
                int n3 = Math.max((int)startIndex$iv, (int)chunkStartIndex$iv) - chunkStartIndex$iv;
                void chunk = chunk$iv;
                boolean bl = false;
                long maskedBitsToCheck = this.data[chunk] >> startInChunk & -1L << 64 - endInChunk;
                int chunkClearIndex = Long.numberOfTrailingZeros(maskedBitsToCheck ^ 0xFFFFFFFFFFFFFFFFL);
                if (chunkClearIndex < 64) {
                    return chunkClearIndex + (chunk << 6) + startInChunk;
                }
                if (chunk$iv == endChunk$iv) break;
                ++chunk$iv;
            }
        }
        return this.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public final void setRange(int start, int end) {
        void startIndex$iv;
        int endAddress = end >>> 6;
        long[] values = this.data;
        if (endAddress >= values.length) {
            this.data = values = BitVectorKt.access$reallocate(values, endAddress);
        }
        BitVector bitVector = this;
        int n = start;
        int endIndex$iv = end;
        boolean $i$f$forEachChunkInRange = false;
        void startChunk$iv = startIndex$iv >> 6;
        void chunk$iv = startChunk$iv;
        int endChunk$iv = endIndex$iv - 1 >> 6;
        if (chunk$iv <= endChunk$iv) {
            while (true) {
                void startInChunk;
                void endInChunk;
                void chunkStartIndex$iv = chunk$iv << 6;
                void chunkEndIndex$iv = chunkStartIndex$iv + 64;
                int n2 = Math.min(endIndex$iv, (int)chunkEndIndex$iv) - chunkStartIndex$iv;
                int n3 = Math.max((int)startIndex$iv, (int)chunkStartIndex$iv) - chunkStartIndex$iv;
                void chunk = chunk$iv;
                boolean bl = false;
                long bitsToSet = -1L >>> 64 - endInChunk & -1L << startInChunk;
                this.data[chunk] = this.data[chunk] | bitsToSet;
                if (chunk$iv == endChunk$iv) break;
                ++chunk$iv;
            }
        }
    }

    private final void forEachChunkInRange(int startIndex, int endIndex, Function3<? super Integer, ? super Integer, ? super Integer, Unit> action) {
        boolean $i$f$forEachChunkInRange = false;
        int startChunk = startIndex >> 6;
        int chunk = startChunk;
        int endChunk = endIndex - 1 >> 6;
        if (chunk <= endChunk) {
            while (true) {
                int chunkStartIndex = chunk << 6;
                int chunkEndIndex = chunkStartIndex + 64;
                action.invoke((Object)chunk, (Object)(Math.max(startIndex, chunkStartIndex) - chunkStartIndex), (Object)(Math.min(endIndex, chunkEndIndex) - chunkStartIndex));
                if (chunk == endChunk) break;
                ++chunk;
            }
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean first = true;
        $this$toString_u24lambda_u243.append("BitVector [");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!first) {
                $this$toString_u24lambda_u243.append(", ");
            }
            first = false;
            $this$toString_u24lambda_u243.append(i);
        }
        $this$toString_u24lambda_u243.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/collection/BitVector$Companion;", "", "<init>", "()V", "BITS_PER_CHUNK", "", "BITS_PER_CHUNK_SHIFT", "runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

