/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiCountTokensRequest;
import dev.langchain4j.model.googleai.GeminiCountTokensResponse;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiPart;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAiGeminiTokenizer
implements Tokenizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleAiGeminiTokenizer.class);
    private final GeminiService geminiService;
    private final String modelName;
    private final String apiKey;
    private final Integer maxRetries;

    GoogleAiGeminiTokenizer(String modelName, String apiKey, Boolean logRequestsAndResponses, Duration timeout, Integer maxRetries) {
        this.modelName = ValidationUtils.ensureNotBlank(modelName, "modelName");
        this.apiKey = ValidationUtils.ensureNotBlank(apiKey, "apiKey");
        this.maxRetries = Utils.getOrDefault(maxRetries, 3);
        this.geminiService = new GeminiService(Utils.getOrDefault(logRequestsAndResponses, false) != false ? log : null, timeout != null ? timeout : Duration.ofSeconds(60L));
    }

    @Override
    public int estimateTokenCountInText(String text) {
        return this.estimateTokenCountInMessages(Collections.singletonList(UserMessage.from(text)));
    }

    @Override
    public int estimateTokenCountInMessage(ChatMessage message) {
        return this.estimateTokenCountInMessages(Collections.singletonList(message));
    }

    @Override
    public int estimateTokenCountInToolExecutionRequests(Iterable<ToolExecutionRequest> toolExecutionRequests) {
        LinkedList<ToolExecutionRequest> allToolRequests = new LinkedList<ToolExecutionRequest>();
        toolExecutionRequests.forEach(allToolRequests::add);
        return this.estimateTokenCountInMessage(AiMessage.from(allToolRequests));
    }

    @Override
    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        LinkedList<ChatMessage> allMessages = new LinkedList<ChatMessage>();
        messages.forEach(allMessages::add);
        List<GeminiContent> geminiContentList = PartsAndContentsMapper.fromMessageToGContent(allMessages, null);
        GeminiCountTokensRequest countTokensRequest = new GeminiCountTokensRequest();
        countTokensRequest.setContents(geminiContentList);
        return this.estimateTokenCount(countTokensRequest);
    }

    @Override
    public int estimateTokenCountInToolSpecifications(Iterable<ToolSpecification> toolSpecifications) {
        LinkedList<ToolSpecification> allTools = new LinkedList<ToolSpecification>();
        toolSpecifications.forEach(allTools::add);
        GeminiContent dummyContent = GeminiContent.builder().parts(Collections.singletonList(GeminiPart.builder().text("Dummy content").build())).build();
        GeminiCountTokensRequest countTokensRequestWithDummyContent = new GeminiCountTokensRequest();
        countTokensRequestWithDummyContent.setGenerateContentRequest(GeminiGenerateContentRequest.builder().model("models/" + this.modelName).contents(Collections.singletonList(dummyContent)).tools(FunctionMapper.fromToolSepcsToGTool(allTools, false)).build());
        return this.estimateTokenCount(countTokensRequestWithDummyContent) - 2;
    }

    private int estimateTokenCount(GeminiCountTokensRequest countTokensRequest) {
        GeminiCountTokensResponse countTokensResponse = RetryUtils.withRetry(() -> this.geminiService.countTokens(this.modelName, this.apiKey, countTokensRequest), this.maxRetries);
        return countTokensResponse.getTotalTokens();
    }

    @Generated
    public static GoogleAiGeminiTokenizerBuilder builder() {
        return new GoogleAiGeminiTokenizerBuilder();
    }

    @Generated
    public static class GoogleAiGeminiTokenizerBuilder {
        @Generated
        private String modelName;
        @Generated
        private String apiKey;
        @Generated
        private Boolean logRequestsAndResponses;
        @Generated
        private Duration timeout;
        @Generated
        private Integer maxRetries;

        @Generated
        GoogleAiGeminiTokenizerBuilder() {
        }

        @Generated
        public GoogleAiGeminiTokenizerBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public GoogleAiGeminiTokenizerBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public GoogleAiGeminiTokenizerBuilder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        @Generated
        public GoogleAiGeminiTokenizerBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public GoogleAiGeminiTokenizerBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public GoogleAiGeminiTokenizer build() {
            return new GoogleAiGeminiTokenizer(this.modelName, this.apiKey, this.logRequestsAndResponses, this.timeout, this.maxRetries);
        }

        @Generated
        public String toString() {
            return "GoogleAiGeminiTokenizer.GoogleAiGeminiTokenizerBuilder(modelName=" + this.modelName + ", apiKey=" + this.apiKey + ", logRequestsAndResponses=" + this.logRequestsAndResponses + ", timeout=" + String.valueOf(this.timeout) + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

